/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qhttpresponseheader_wrapper.h"

// Extra includes
#include <QList>
#include <QPair>
#include <qhttp.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QHttpResponseHeaderWrapper::QHttpResponseHeaderWrapper() : QHttpResponseHeader() {
    // ... middle
}

QHttpResponseHeaderWrapper::QHttpResponseHeaderWrapper(const QString & str) : QHttpResponseHeader(str) {
    // ... middle
}

QHttpResponseHeaderWrapper::QHttpResponseHeaderWrapper(int code, const QString & text, int majorVer, int minorVer) : QHttpResponseHeader(code, text, majorVer, minorVer) {
    // ... middle
}

int QHttpResponseHeaderWrapper::majorVersion() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "majorVersion"));
    if (py_override.isNull()) {
        return this->QHttpResponseHeader::majorVersion();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHttpResponseHeader.majorVersion");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QHttpResponseHeaderWrapper::minorVersion() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minorVersion"));
    if (py_override.isNull()) {
        return this->QHttpResponseHeader::minorVersion();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHttpResponseHeader.minorVersion");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QHttpResponseHeaderWrapper::parseLine(const QString & line, int number)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parseLine"));
    if (py_override.isNull()) {
        return this->QHttpResponseHeader::parseLine(line, number);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oi)",
        Shiboken::Converter<QString& >::toPython(line),
        number
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHttpResponseHeader.parseLine");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QString QHttpResponseHeaderWrapper::toString() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "toString"));
    if (py_override.isNull()) {
        return this->QHttpResponseHeader::toString();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHttpResponseHeader.toString");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

QHttpResponseHeaderWrapper::~QHttpResponseHeaderWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQHttpResponseHeader_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QHttpResponseHeaderWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QHttpResponseHeader", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QHttpResponseHeader()
        cptr = new QHttpResponseHeaderWrapper();
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QHttpResponseHeader(int,QString,int,int)
            cptr = new QHttpResponseHeaderWrapper(cpp_arg0);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // QHttpResponseHeader(int,QString,int,int)
                cptr = new QHttpResponseHeaderWrapper(cpp_arg0, *cpp_arg1);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // QHttpResponseHeader(int,QString,int,int)
                    cptr = new QHttpResponseHeaderWrapper(cpp_arg0, *cpp_arg1, cpp_arg2);
                } else if (PyNumber_Check(pyargs[3])) {
                    int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                    // QHttpResponseHeader(int,QString,int,int)
                    cptr = new QHttpResponseHeaderWrapper(cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                } else goto SbkQHttpResponseHeader_Init_TypeError;
            } else goto SbkQHttpResponseHeader_Init_TypeError;
        } else goto SbkQHttpResponseHeader_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QHttpResponseHeader(QString)
        cptr = new QHttpResponseHeaderWrapper(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QHttpResponseHeader& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QHttpResponseHeader > cpp_arg0_auto_ptr;
        QHttpResponseHeader* cpp_arg0 = Shiboken::Converter<QHttpResponseHeader* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QHttpResponseHeader& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QHttpResponseHeader >(cpp_arg0);
        // QHttpResponseHeader(QHttpResponseHeader)
        cptr = new QHttpResponseHeaderWrapper(*cpp_arg0);
    } else goto SbkQHttpResponseHeader_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQHttpResponseHeader_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQHttpResponseHeader_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtNetwork.QHttpResponseHeader", "PySide.QtCore.QString", "int, PySide.QtCore.QString = QString(), int = 1, int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttpResponseHeader", overloads);
        return -1;
}

static PyObject*
SbkQHttpResponseHeaderFunc_majorVersion(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // majorVersion()const
    QHttpResponseHeader* cppSelf = Shiboken::Converter<QHttpResponseHeader* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHttpResponseHeader::majorVersion();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpResponseHeaderFunc_minorVersion(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minorVersion()const
    QHttpResponseHeader* cppSelf = Shiboken::Converter<QHttpResponseHeader* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHttpResponseHeader::minorVersion();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpResponseHeaderFunc_parseLine(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "parseLine", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // parseLine(QString,int)
        QHttpResponseHeader* cppSelf = Shiboken::Converter<QHttpResponseHeader* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QHttpResponseHeader::parseLine(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQHttpResponseHeaderFunc_parseLine_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHttpResponseHeaderFunc_parseLine_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttpResponseHeader.parseLine", overloads);
        return 0;
}

static PyObject*
SbkQHttpResponseHeaderFunc_reasonPhrase(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // reasonPhrase()const
    QHttpResponseHeader* cppSelf = Shiboken::Converter<QHttpResponseHeader* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QHttpResponseHeader::reasonPhrase();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpResponseHeaderFunc_setStatusLine(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setStatusLine", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setStatusLine(int,QString,int,int)
            QHttpResponseHeader* cppSelf = Shiboken::Converter<QHttpResponseHeader* >::toCpp((PyObject*)self);
            cppSelf->QHttpResponseHeader::setStatusLine(cpp_arg0);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // setStatusLine(int,QString,int,int)
                QHttpResponseHeader* cppSelf = Shiboken::Converter<QHttpResponseHeader* >::toCpp((PyObject*)self);
                cppSelf->QHttpResponseHeader::setStatusLine(cpp_arg0, *cpp_arg1);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // setStatusLine(int,QString,int,int)
                    QHttpResponseHeader* cppSelf = Shiboken::Converter<QHttpResponseHeader* >::toCpp((PyObject*)self);
                    cppSelf->QHttpResponseHeader::setStatusLine(cpp_arg0, *cpp_arg1, cpp_arg2);
                } else if (PyNumber_Check(pyargs[3])) {
                    int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                    // setStatusLine(int,QString,int,int)
                    QHttpResponseHeader* cppSelf = Shiboken::Converter<QHttpResponseHeader* >::toCpp((PyObject*)self);
                    cppSelf->QHttpResponseHeader::setStatusLine(cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                } else goto SbkQHttpResponseHeaderFunc_setStatusLine_TypeError;
            } else goto SbkQHttpResponseHeaderFunc_setStatusLine_TypeError;
        } else goto SbkQHttpResponseHeaderFunc_setStatusLine_TypeError;
    } else goto SbkQHttpResponseHeaderFunc_setStatusLine_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHttpResponseHeaderFunc_setStatusLine_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString = QString(), int = 1, int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttpResponseHeader.setStatusLine", overloads);
        return 0;
}

static PyObject*
SbkQHttpResponseHeaderFunc_statusCode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // statusCode()const
    QHttpResponseHeader* cppSelf = Shiboken::Converter<QHttpResponseHeader* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHttpResponseHeader::statusCode();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpResponseHeaderFunc_toString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toString()const
    QHttpResponseHeader* cppSelf = Shiboken::Converter<QHttpResponseHeader* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QHttpResponseHeader::toString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQHttpResponseHeader_methods[] = {
    {"majorVersion", (PyCFunction)SbkQHttpResponseHeaderFunc_majorVersion, METH_NOARGS},
    {"minorVersion", (PyCFunction)SbkQHttpResponseHeaderFunc_minorVersion, METH_NOARGS},
    {"parseLine", (PyCFunction)SbkQHttpResponseHeaderFunc_parseLine, METH_VARARGS},
    {"reasonPhrase", (PyCFunction)SbkQHttpResponseHeaderFunc_reasonPhrase, METH_NOARGS},
    {"setStatusLine", (PyCFunction)SbkQHttpResponseHeaderFunc_setStatusLine, METH_VARARGS},
    {"statusCode", (PyCFunction)SbkQHttpResponseHeaderFunc_statusCode, METH_NOARGS},
    {"toString", (PyCFunction)SbkQHttpResponseHeaderFunc_toString, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQHttpResponseHeader_ObjCopierFunc(const void* ptr){
    return new QHttpResponseHeaderWrapper(*reinterpret_cast<const QHttpResponseHeader*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQHttpResponseHeader_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QHttpResponseHeader",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QHttpResponseHeaderWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQHttpResponseHeader_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQHttpResponseHeader_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQHttpResponseHeader_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QHttpResponseHeader(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QHTTPRESPONSEHEADER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQHttpResponseHeader_Type);

    SbkQHttpResponseHeader_Type.super.ht_type.tp_base = SbkPySide_QtNetworkTypes[SBK_QHTTPHEADER_IDX];
    // Fill type discovery information
    SbkQHttpResponseHeader_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtNetworkTypes[SBK_QHTTPHEADER_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQHttpResponseHeader_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQHttpResponseHeader_Type));
    PyModule_AddObject(module, "QHttpResponseHeader",
        ((PyObject*)&SbkQHttpResponseHeader_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QHttpResponseHeader >("QHttpResponseHeader");
    Shiboken::TypeResolver::createValueTypeResolver<QHttpResponseHeader >(typeid(QHttpResponseHeader).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

