/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qhttprequestheader_wrapper.h"

// Extra includes
#include <QList>
#include <QPair>
#include <qhttp.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QHttpRequestHeaderWrapper::QHttpRequestHeaderWrapper() : QHttpRequestHeader() {
    // ... middle
}

QHttpRequestHeaderWrapper::QHttpRequestHeaderWrapper(const QString & method, const QString & path, int majorVer, int minorVer) : QHttpRequestHeader(method, path, majorVer, minorVer) {
    // ... middle
}

QHttpRequestHeaderWrapper::QHttpRequestHeaderWrapper(const QString & str) : QHttpRequestHeader(str) {
    // ... middle
}

int QHttpRequestHeaderWrapper::majorVersion() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "majorVersion"));
    if (py_override.isNull()) {
        return this->QHttpRequestHeader::majorVersion();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHttpRequestHeader.majorVersion");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QHttpRequestHeaderWrapper::minorVersion() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minorVersion"));
    if (py_override.isNull()) {
        return this->QHttpRequestHeader::minorVersion();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHttpRequestHeader.minorVersion");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QHttpRequestHeaderWrapper::parseLine(const QString & line, int number)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parseLine"));
    if (py_override.isNull()) {
        return this->QHttpRequestHeader::parseLine(line, number);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oi)",
        Shiboken::Converter<QString& >::toPython(line),
        number
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHttpRequestHeader.parseLine");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QString QHttpRequestHeaderWrapper::toString() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "toString"));
    if (py_override.isNull()) {
        return this->QHttpRequestHeader::toString();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHttpRequestHeader.toString");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

QHttpRequestHeaderWrapper::~QHttpRequestHeaderWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQHttpRequestHeader_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QHttpRequestHeaderWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QHttpRequestHeader", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QHttpRequestHeader()
        cptr = new QHttpRequestHeaderWrapper();
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QHttpRequestHeader(QString)
            cptr = new QHttpRequestHeaderWrapper(*cpp_arg0);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // QHttpRequestHeader(QString,QString,int,int)
                cptr = new QHttpRequestHeaderWrapper(*cpp_arg0, *cpp_arg1);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // QHttpRequestHeader(QString,QString,int,int)
                    cptr = new QHttpRequestHeaderWrapper(*cpp_arg0, *cpp_arg1, cpp_arg2);
                } else if (PyNumber_Check(pyargs[3])) {
                    int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                    // QHttpRequestHeader(QString,QString,int,int)
                    cptr = new QHttpRequestHeaderWrapper(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                } else goto SbkQHttpRequestHeader_Init_TypeError;
            } else goto SbkQHttpRequestHeader_Init_TypeError;
        } else goto SbkQHttpRequestHeader_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QHttpRequestHeader& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QHttpRequestHeader > cpp_arg0_auto_ptr;
        QHttpRequestHeader* cpp_arg0 = Shiboken::Converter<QHttpRequestHeader* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QHttpRequestHeader& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QHttpRequestHeader >(cpp_arg0);
        // QHttpRequestHeader(QHttpRequestHeader)
        cptr = new QHttpRequestHeaderWrapper(*cpp_arg0);
    } else goto SbkQHttpRequestHeader_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQHttpRequestHeader_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQHttpRequestHeader_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtNetwork.QHttpRequestHeader", "PySide.QtCore.QString, PySide.QtCore.QString, int = 1, int = 1", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttpRequestHeader", overloads);
        return -1;
}

static PyObject*
SbkQHttpRequestHeaderFunc_majorVersion(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // majorVersion()const
    QHttpRequestHeader* cppSelf = Shiboken::Converter<QHttpRequestHeader* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHttpRequestHeader::majorVersion();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpRequestHeaderFunc_method(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // method()const
    QHttpRequestHeader* cppSelf = Shiboken::Converter<QHttpRequestHeader* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QHttpRequestHeader::method();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpRequestHeaderFunc_minorVersion(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minorVersion()const
    QHttpRequestHeader* cppSelf = Shiboken::Converter<QHttpRequestHeader* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHttpRequestHeader::minorVersion();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpRequestHeaderFunc_parseLine(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "parseLine", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // parseLine(QString,int)
        QHttpRequestHeader* cppSelf = Shiboken::Converter<QHttpRequestHeader* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QHttpRequestHeader::parseLine(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQHttpRequestHeaderFunc_parseLine_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHttpRequestHeaderFunc_parseLine_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttpRequestHeader.parseLine", overloads);
        return 0;
}

static PyObject*
SbkQHttpRequestHeaderFunc_path(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // path()const
    QHttpRequestHeader* cppSelf = Shiboken::Converter<QHttpRequestHeader* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QHttpRequestHeader::path();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpRequestHeaderFunc_setRequest(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setRequest", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // setRequest(QString,QString,int,int)
            QHttpRequestHeader* cppSelf = Shiboken::Converter<QHttpRequestHeader* >::toCpp((PyObject*)self);
            cppSelf->QHttpRequestHeader::setRequest(*cpp_arg0, *cpp_arg1);
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // setRequest(QString,QString,int,int)
                QHttpRequestHeader* cppSelf = Shiboken::Converter<QHttpRequestHeader* >::toCpp((PyObject*)self);
                cppSelf->QHttpRequestHeader::setRequest(*cpp_arg0, *cpp_arg1, cpp_arg2);
            } else if (PyNumber_Check(pyargs[3])) {
                int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                // setRequest(QString,QString,int,int)
                QHttpRequestHeader* cppSelf = Shiboken::Converter<QHttpRequestHeader* >::toCpp((PyObject*)self);
                cppSelf->QHttpRequestHeader::setRequest(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
            } else goto SbkQHttpRequestHeaderFunc_setRequest_TypeError;
        } else goto SbkQHttpRequestHeaderFunc_setRequest_TypeError;
    } else goto SbkQHttpRequestHeaderFunc_setRequest_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHttpRequestHeaderFunc_setRequest_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, int = 1, int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttpRequestHeader.setRequest", overloads);
        return 0;
}

static PyObject*
SbkQHttpRequestHeaderFunc_toString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toString()const
    QHttpRequestHeader* cppSelf = Shiboken::Converter<QHttpRequestHeader* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QHttpRequestHeader::toString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQHttpRequestHeader_methods[] = {
    {"majorVersion", (PyCFunction)SbkQHttpRequestHeaderFunc_majorVersion, METH_NOARGS},
    {"method", (PyCFunction)SbkQHttpRequestHeaderFunc_method, METH_NOARGS},
    {"minorVersion", (PyCFunction)SbkQHttpRequestHeaderFunc_minorVersion, METH_NOARGS},
    {"parseLine", (PyCFunction)SbkQHttpRequestHeaderFunc_parseLine, METH_VARARGS},
    {"path", (PyCFunction)SbkQHttpRequestHeaderFunc_path, METH_NOARGS},
    {"setRequest", (PyCFunction)SbkQHttpRequestHeaderFunc_setRequest, METH_VARARGS},
    {"toString", (PyCFunction)SbkQHttpRequestHeaderFunc_toString, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQHttpRequestHeader_ObjCopierFunc(const void* ptr){
    return new QHttpRequestHeaderWrapper(*reinterpret_cast<const QHttpRequestHeader*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQHttpRequestHeader_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QHttpRequestHeader",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QHttpRequestHeaderWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQHttpRequestHeader_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQHttpRequestHeader_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQHttpRequestHeader_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QHttpRequestHeader(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QHTTPREQUESTHEADER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQHttpRequestHeader_Type);

    SbkQHttpRequestHeader_Type.super.ht_type.tp_base = SbkPySide_QtNetworkTypes[SBK_QHTTPHEADER_IDX];
    // Fill type discovery information
    SbkQHttpRequestHeader_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtNetworkTypes[SBK_QHTTPHEADER_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQHttpRequestHeader_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQHttpRequestHeader_Type));
    PyModule_AddObject(module, "QHttpRequestHeader",
        ((PyObject*)&SbkQHttpRequestHeader_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QHttpRequestHeader >("QHttpRequestHeader");
    Shiboken::TypeResolver::createValueTypeResolver<QHttpRequestHeader >(typeid(QHttpRequestHeader).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

