/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtnetwork_python.h"

#include "qhttp_wrapper.h"

// Extra includes
#include <QList>
#include <qauthenticator.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qhttp.h>
#include <qiodevice.h>
#include <qnetworkproxy.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsslerror.h>
#include <qstring.h>
#include <qtcpsocket.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QHttpWrapper::QHttpWrapper(QObject * parent) : QHttp(parent), m_metaObject(0) {
    // ... middle
}

QHttpWrapper::QHttpWrapper(const QString & hostname, QHttp::ConnectionMode mode, quint16 port, QObject * parent) : QHttp(hostname, mode, port, parent), m_metaObject(0) {
    // ... middle
}

QHttpWrapper::QHttpWrapper(const QString & hostname, quint16 port, QObject * parent) : QHttp(hostname, port, parent), m_metaObject(0) {
    // ... middle
}

void QHttpWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QHttpWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHttpWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QHttpWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QHttpWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHttp.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QHttpWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHttp.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QHttpWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QHttpWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QHttp::staticMetaObject);
}
    return m_metaObject;
}

int QHttpWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QHttp::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QHttpWrapper::~QHttpWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQHttp_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QHttpWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QHttp", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QHttp(QObject*)
        cptr = new QHttpWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QHttp(QString,quint16,QObject*)
            cptr = new QHttpWrapper(*cpp_arg0);
            Shiboken::setParent(pyargs[2], self);
        } else if (PyNumber_Check(pyargs[1])) {
            quint16 cpp_arg1 = Shiboken::Converter<quint16 >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QHttp(QString,quint16,QObject*)
                cptr = new QHttpWrapper(*cpp_arg0, cpp_arg1);
                Shiboken::setParent(pyargs[2], self);
            } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QObject* cpp_arg2 = Shiboken::Converter<QObject* >::toCpp(pyargs[2]);
                // QHttp(QString,quint16,QObject*)
                cptr = new QHttpWrapper(*cpp_arg0, cpp_arg1, cpp_arg2);
                Shiboken::setParent(pyargs[2], self);
            } else goto SbkQHttp_Init_TypeError;
        } else if (Shiboken::Converter<QHttp::ConnectionMode >::isConvertible(pyargs[1])) {
            QHttp::ConnectionMode cpp_arg1 = Shiboken::Converter<QHttp::ConnectionMode >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QHttp(QString,QHttp::ConnectionMode,quint16,QObject*)
                cptr = new QHttpWrapper(*cpp_arg0, cpp_arg1);
                Shiboken::setParent(pyargs[3], self);
            } else if (PyNumber_Check(pyargs[2])) {
                quint16 cpp_arg2 = Shiboken::Converter<quint16 >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // QHttp(QString,QHttp::ConnectionMode,quint16,QObject*)
                    cptr = new QHttpWrapper(*cpp_arg0, cpp_arg1, cpp_arg2);
                    Shiboken::setParent(pyargs[3], self);
                } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return -1;
                    QObject* cpp_arg3 = Shiboken::Converter<QObject* >::toCpp(pyargs[3]);
                    // QHttp(QString,QHttp::ConnectionMode,quint16,QObject*)
                    cptr = new QHttpWrapper(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    Shiboken::setParent(pyargs[3], self);
                } else goto SbkQHttp_Init_TypeError;
            } else goto SbkQHttp_Init_TypeError;
        } else goto SbkQHttp_Init_TypeError;
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QHttp(QObject*)
        cptr = new QHttpWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQHttp_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQHttp_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQHttp_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", "PySide.QtCore.QString, PySide.QtNetwork.QHttp.ConnectionMode, unsigned short = 0, PySide.QtCore.QObject = None", "PySide.QtCore.QString, unsigned short = 80, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttp", overloads);
        return -1;
}

static PyObject*
SbkQHttpFunc_abort(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // abort()
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    cppSelf->QHttp::abort();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQHttpFunc_bytesAvailable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesAvailable()const
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QHttp::bytesAvailable();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpFunc_clearPendingRequests(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearPendingRequests()
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    cppSelf->QHttp::clearPendingRequests();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQHttpFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // close()
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHttp::close();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpFunc_currentDestinationDevice(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentDestinationDevice()const
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    QIODevice * cpp_result = cppSelf->QHttp::currentDestinationDevice();
    py_result = Shiboken::Converter<QIODevice* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpFunc_currentId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentId()const
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHttp::currentId();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpFunc_currentRequest(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentRequest()const
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    QHttpRequestHeader cpp_result = cppSelf->QHttp::currentRequest();
    py_result = Shiboken::Converter<QHttpRequestHeader >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpFunc_currentSourceDevice(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentSourceDevice()const
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    QIODevice * cpp_result = cppSelf->QHttp::currentSourceDevice();
    py_result = Shiboken::Converter<QIODevice* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    QHttp::Error cpp_result = cppSelf->QHttp::error();
    py_result = Shiboken::Converter<QHttp::Error >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QHttp::errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpFunc_get(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "get", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // get(QString,QIODevice*)
            QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QHttp::get(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (Shiboken::Converter<QIODevice* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QIODevice* cpp_arg1 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[1]);
            // get(QString,QIODevice*)
            QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QHttp::get(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else goto SbkQHttpFunc_get_TypeError;
    } else goto SbkQHttpFunc_get_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHttpFunc_get_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QIODevice = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttp.get", overloads);
        return 0;
}

static PyObject*
SbkQHttpFunc_hasPendingRequests(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasPendingRequests()const
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QHttp::hasPendingRequests();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpFunc_head(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // head(QString)
        QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QHttp::head(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQHttpFunc_head_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHttpFunc_head_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHttp.head", overloads);
        return 0;
}

static PyObject*
SbkQHttpFunc_ignoreSslErrors(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // ignoreSslErrors()
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    cppSelf->QHttp::ignoreSslErrors();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQHttpFunc_lastResponse(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastResponse()const
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    QHttpResponseHeader cpp_result = cppSelf->QHttp::lastResponse();
    py_result = Shiboken::Converter<QHttpResponseHeader >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpFunc_post(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "post", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            if (numArgs == 2) {
                // post(QString,QByteArray,QIODevice*)
                QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QHttp::post(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else if (Shiboken::Converter<QIODevice* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QIODevice* cpp_arg2 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[2]);
                // post(QString,QByteArray,QIODevice*)
                QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QHttp::post(*cpp_arg0, *cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else goto SbkQHttpFunc_post_TypeError;
        } else if (Shiboken::Converter<QIODevice* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QIODevice* cpp_arg1 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // post(QString,QIODevice*,QIODevice*)
                QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QHttp::post(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else if (Shiboken::Converter<QIODevice* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QIODevice* cpp_arg2 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[2]);
                // post(QString,QIODevice*,QIODevice*)
                QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QHttp::post(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else goto SbkQHttpFunc_post_TypeError;
        } else goto SbkQHttpFunc_post_TypeError;
    } else goto SbkQHttpFunc_post_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHttpFunc_post_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QIODevice, PySide.QtCore.QIODevice = None", "PySide.QtCore.QString, PySide.QtCore.QByteArray, PySide.QtCore.QIODevice = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttp.post", overloads);
        return 0;
}

static PyObject*
SbkQHttpFunc_read(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // read(char*,qint64)
        QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - read_wrapper - START
        char _data[cpp_arg0];
        qint64 _size = cppSelf->read(_data, cpp_arg0);
        if (_size > 0)
        py_result = Shiboken::Converter<QByteArray >::toPython(QByteArray(_data, _size));
        else
        py_result = Shiboken::Converter<QByteArray >::toPython(QByteArray());
        // TEMPLATE - read_wrapper - END
        
        // End of code injection


    } else goto SbkQHttpFunc_read_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHttpFunc_read_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHttp.read", overloads);
        return 0;
}

static PyObject*
SbkQHttpFunc_readAll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // readAll()
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    QByteArray cpp_result = cppSelf->QHttp::readAll();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHttpFunc_request(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "request", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QHttpRequestHeader& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QHttpRequestHeader > cpp_arg0_auto_ptr;
        QHttpRequestHeader* cpp_arg0 = Shiboken::Converter<QHttpRequestHeader* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QHttpRequestHeader& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QHttpRequestHeader >(cpp_arg0);
        if (numArgs == 1) {
            // request(QHttpRequestHeader,QIODevice*,QIODevice*)
            QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QHttp::request(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            if (numArgs == 2) {
                // request(QHttpRequestHeader,QByteArray,QIODevice*)
                QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QHttp::request(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else if (Shiboken::Converter<QIODevice* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QIODevice* cpp_arg2 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[2]);
                // request(QHttpRequestHeader,QByteArray,QIODevice*)
                QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QHttp::request(*cpp_arg0, *cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else goto SbkQHttpFunc_request_TypeError;
        } else if (Shiboken::Converter<QIODevice* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QIODevice* cpp_arg1 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // request(QHttpRequestHeader,QIODevice*,QIODevice*)
                QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QHttp::request(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else if (Shiboken::Converter<QIODevice* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QIODevice* cpp_arg2 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[2]);
                // request(QHttpRequestHeader,QIODevice*,QIODevice*)
                QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QHttp::request(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else goto SbkQHttpFunc_request_TypeError;
        } else goto SbkQHttpFunc_request_TypeError;
    } else goto SbkQHttpFunc_request_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHttpFunc_request_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QHttpRequestHeader, PySide.QtCore.QIODevice = None, PySide.QtCore.QIODevice = None", "PySide.QtNetwork.QHttpRequestHeader, PySide.QtCore.QByteArray, PySide.QtCore.QIODevice = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttp.request", overloads);
        return 0;
}

static PyObject*
SbkQHttpFunc_setHost(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setHost", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setHost(QString,quint16)
            QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QHttp::setHost(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            quint16 cpp_arg1 = Shiboken::Converter<quint16 >::toCpp(pyargs[1]);
            // setHost(QString,quint16)
            QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QHttp::setHost(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (Shiboken::Converter<QHttp::ConnectionMode >::isConvertible(pyargs[1])) {
            QHttp::ConnectionMode cpp_arg1 = Shiboken::Converter<QHttp::ConnectionMode >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setHost(QString,QHttp::ConnectionMode,quint16)
                QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QHttp::setHost(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else if (PyNumber_Check(pyargs[2])) {
                quint16 cpp_arg2 = Shiboken::Converter<quint16 >::toCpp(pyargs[2]);
                // setHost(QString,QHttp::ConnectionMode,quint16)
                QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QHttp::setHost(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else goto SbkQHttpFunc_setHost_TypeError;
        } else goto SbkQHttpFunc_setHost_TypeError;
    } else goto SbkQHttpFunc_setHost_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHttpFunc_setHost_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtNetwork.QHttp.ConnectionMode, unsigned short = 0", "PySide.QtCore.QString, unsigned short = 80", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttp.setHost", overloads);
        return 0;
}

static PyObject*
SbkQHttpFunc_setProxy(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setProxy", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // setProxy(QString,int,QString,QString)
            QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QHttp::setProxy(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            if (numArgs == 3) {
                // setProxy(QString,int,QString,QString)
                QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QHttp::setProxy(*cpp_arg0, cpp_arg1, *cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                std::auto_ptr<QString > cpp_arg3_auto_ptr;
                QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
                if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
                    cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
                // setProxy(QString,int,QString,QString)
                QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QHttp::setProxy(*cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else goto SbkQHttpFunc_setProxy_TypeError;
        } else goto SbkQHttpFunc_setProxy_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QNetworkProxy& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QNetworkProxy > cpp_arg0_auto_ptr;
        QNetworkProxy* cpp_arg0 = Shiboken::Converter<QNetworkProxy* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QNetworkProxy& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QNetworkProxy >(cpp_arg0);
        // setProxy(QNetworkProxy)
        QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QHttp::setProxy(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQHttpFunc_setProxy_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHttpFunc_setProxy_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkProxy", "PySide.QtCore.QString, int, PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttp.setProxy", overloads);
        return 0;
}

static PyObject*
SbkQHttpFunc_setSocket(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTcpSocket* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTcpSocket* cpp_arg0 = Shiboken::Converter<QTcpSocket* >::toCpp(arg);
        // setSocket(QTcpSocket*)
        QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QHttp::setSocket(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQHttpFunc_setSocket_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHttpFunc_setSocket_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QTcpSocket", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHttp.setSocket", overloads);
        return 0;
}

static PyObject*
SbkQHttpFunc_setUser(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setUser", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setUser(QString,QString)
            QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QHttp::setUser(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // setUser(QString,QString)
            QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QHttp::setUser(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else goto SbkQHttpFunc_setUser_TypeError;
    } else goto SbkQHttpFunc_setUser_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHttpFunc_setUser_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHttp.setUser", overloads);
        return 0;
}

static PyObject*
SbkQHttpFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    QHttp* cppSelf = Shiboken::Converter<QHttp* >::toCpp((PyObject*)self);
    QHttp::State cpp_result = cppSelf->QHttp::state();
    py_result = Shiboken::Converter<QHttp::State >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQHttp_methods[] = {
    {"abort", (PyCFunction)SbkQHttpFunc_abort, METH_NOARGS},
    {"bytesAvailable", (PyCFunction)SbkQHttpFunc_bytesAvailable, METH_NOARGS},
    {"clearPendingRequests", (PyCFunction)SbkQHttpFunc_clearPendingRequests, METH_NOARGS},
    {"close", (PyCFunction)SbkQHttpFunc_close, METH_NOARGS},
    {"currentDestinationDevice", (PyCFunction)SbkQHttpFunc_currentDestinationDevice, METH_NOARGS},
    {"currentId", (PyCFunction)SbkQHttpFunc_currentId, METH_NOARGS},
    {"currentRequest", (PyCFunction)SbkQHttpFunc_currentRequest, METH_NOARGS},
    {"currentSourceDevice", (PyCFunction)SbkQHttpFunc_currentSourceDevice, METH_NOARGS},
    {"error", (PyCFunction)SbkQHttpFunc_error, METH_NOARGS},
    {"errorString", (PyCFunction)SbkQHttpFunc_errorString, METH_NOARGS},
    {"get", (PyCFunction)SbkQHttpFunc_get, METH_VARARGS},
    {"hasPendingRequests", (PyCFunction)SbkQHttpFunc_hasPendingRequests, METH_NOARGS},
    {"head", (PyCFunction)SbkQHttpFunc_head, METH_O},
    {"ignoreSslErrors", (PyCFunction)SbkQHttpFunc_ignoreSslErrors, METH_NOARGS},
    {"lastResponse", (PyCFunction)SbkQHttpFunc_lastResponse, METH_NOARGS},
    {"post", (PyCFunction)SbkQHttpFunc_post, METH_VARARGS},
    {"read", (PyCFunction)SbkQHttpFunc_read, METH_O},
    {"readAll", (PyCFunction)SbkQHttpFunc_readAll, METH_NOARGS},
    {"request", (PyCFunction)SbkQHttpFunc_request, METH_VARARGS},
    {"setHost", (PyCFunction)SbkQHttpFunc_setHost, METH_VARARGS},
    {"setProxy", (PyCFunction)SbkQHttpFunc_setProxy, METH_VARARGS},
    {"setSocket", (PyCFunction)SbkQHttpFunc_setSocket, METH_O},
    {"setUser", (PyCFunction)SbkQHttpFunc_setUser, METH_VARARGS},
    {"state", (PyCFunction)SbkQHttpFunc_state, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQHttp_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QHttp",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QHttpWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQHttp_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQHttp_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtNetwork_QHttp_Error_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QHttp_Error_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QHttp_Error_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Error",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QHttp_Error_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QHttp_Error_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QHttp_Error_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QHttp_ConnectionMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QHttp_ConnectionMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QHttp_ConnectionMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ConnectionMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QHttp_ConnectionMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QHttp_ConnectionMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QHttp_ConnectionMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QHttp_State_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QHttp_State_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QHttp_State_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "State",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QHttp_State_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QHttp_State_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QHttp_State_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QHttp(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QHTTP_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQHttp_Type);

    SbkQHttp_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQHttp_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQHttp_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQHttp_Type));
    PyModule_AddObject(module, "QHttp",
        ((PyObject*)&SbkQHttp_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Error
    SbkPySide_QtNetworkTypes[SBK_QHTTP_ERROR_IDX] = &SbkPySide_QtNetwork_QHttp_Error_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QHttp_Error_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QHttp_Error_Type);
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
            "Error",((PyObject*)&SbkPySide_QtNetwork_QHttp_Error_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_Error_Type,
        (long) QHttp::NoError, "NoError");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_Error_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_Error_Type,
        (long) QHttp::UnknownError, "UnknownError");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "UnknownError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_Error_Type.tp_dict,
        "UnknownError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_Error_Type,
        (long) QHttp::HostNotFound, "HostNotFound");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "HostNotFound", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_Error_Type.tp_dict,
        "HostNotFound", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_Error_Type,
        (long) QHttp::ConnectionRefused, "ConnectionRefused");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "ConnectionRefused", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_Error_Type.tp_dict,
        "ConnectionRefused", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_Error_Type,
        (long) QHttp::UnexpectedClose, "UnexpectedClose");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "UnexpectedClose", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_Error_Type.tp_dict,
        "UnexpectedClose", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_Error_Type,
        (long) QHttp::InvalidResponseHeader, "InvalidResponseHeader");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "InvalidResponseHeader", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_Error_Type.tp_dict,
        "InvalidResponseHeader", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_Error_Type,
        (long) QHttp::WrongContentLength, "WrongContentLength");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "WrongContentLength", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_Error_Type.tp_dict,
        "WrongContentLength", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_Error_Type,
        (long) QHttp::Aborted, "Aborted");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "Aborted", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_Error_Type.tp_dict,
        "Aborted", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_Error_Type,
        (long) QHttp::AuthenticationRequiredError, "AuthenticationRequiredError");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "AuthenticationRequiredError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_Error_Type.tp_dict,
        "AuthenticationRequiredError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_Error_Type,
        (long) QHttp::ProxyAuthenticationRequiredError, "ProxyAuthenticationRequiredError");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "ProxyAuthenticationRequiredError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_Error_Type.tp_dict,
        "ProxyAuthenticationRequiredError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QHttp::Error");

    // init enum class: ConnectionMode
    SbkPySide_QtNetworkTypes[SBK_QHTTP_CONNECTIONMODE_IDX] = &SbkPySide_QtNetwork_QHttp_ConnectionMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QHttp_ConnectionMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QHttp_ConnectionMode_Type);
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
            "ConnectionMode",((PyObject*)&SbkPySide_QtNetwork_QHttp_ConnectionMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_ConnectionMode_Type,
        (long) QHttp::ConnectionModeHttp, "ConnectionModeHttp");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "ConnectionModeHttp", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_ConnectionMode_Type.tp_dict,
        "ConnectionModeHttp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_ConnectionMode_Type,
        (long) QHttp::ConnectionModeHttps, "ConnectionModeHttps");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "ConnectionModeHttps", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_ConnectionMode_Type.tp_dict,
        "ConnectionModeHttps", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QHttp::ConnectionMode");

    // init enum class: State
    SbkPySide_QtNetworkTypes[SBK_QHTTP_STATE_IDX] = &SbkPySide_QtNetwork_QHttp_State_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QHttp_State_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QHttp_State_Type);
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
            "State",((PyObject*)&SbkPySide_QtNetwork_QHttp_State_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_State_Type,
        (long) QHttp::Unconnected, "Unconnected");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "Unconnected", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_State_Type.tp_dict,
        "Unconnected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_State_Type,
        (long) QHttp::HostLookup, "HostLookup");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "HostLookup", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_State_Type.tp_dict,
        "HostLookup", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_State_Type,
        (long) QHttp::Connecting, "Connecting");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "Connecting", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_State_Type.tp_dict,
        "Connecting", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_State_Type,
        (long) QHttp::Sending, "Sending");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "Sending", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_State_Type.tp_dict,
        "Sending", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_State_Type,
        (long) QHttp::Reading, "Reading");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "Reading", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_State_Type.tp_dict,
        "Reading", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_State_Type,
        (long) QHttp::Connected, "Connected");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "Connected", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_State_Type.tp_dict,
        "Connected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHttp_State_Type,
        (long) QHttp::Closing, "Closing");
    PyDict_SetItemString(SbkQHttp_Type.super.ht_type.tp_dict,
        "Closing", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHttp_State_Type.tp_dict,
        "Closing", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QHttp::State");

    Shiboken::TypeResolver::createObjectTypeResolver<QHttp >("QHttp*");
    Shiboken::TypeResolver::createObjectTypeResolver<QHttp >(typeid(QHttp).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

