/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qx11info_wrapper.h"

// Extra includes
#include <qpaintdevice.h>
#include <qx11info_x11.h>

using namespace Shiboken;

static int
SbkQX11Info_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QX11Info* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QX11Info", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QX11Info()
        cptr = new QX11Info();
    } else if (numArgs == 1 && Shiboken::Converter<QX11Info& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QX11Info* cpp_arg0 = Shiboken::Converter<QX11Info* >::toCpp(pyargs[0]);
        // QX11Info(QX11Info)
        cptr = new QX11Info(*cpp_arg0);
    } else goto SbkQX11Info_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQX11Info_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQX11Info_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QX11Info", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QX11Info", overloads);
        return -1;
}

static PyObject*
SbkQX11InfoFunc_appCells(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // appCells(int)
        int cpp_result = QX11Info::appCells();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // appCells(int)
        int cpp_result = QX11Info::appCells(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQX11InfoFunc_appCells_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQX11InfoFunc_appCells_TypeError:
        const char* overloads[] = {"int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QX11Info.appCells", overloads);
        return 0;
}

static PyObject*
SbkQX11InfoFunc_appClass(PyObject* self)
{
    PyObject* py_result = 0;

    // appClass()
    const char * cpp_result = QX11Info::appClass();
    py_result = Shiboken::Converter<const char * >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQX11InfoFunc_appColormap(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // appColormap(int)
        Qt::HANDLE cpp_result = QX11Info::appColormap();
        py_result = Shiboken::Converter<Qt::HANDLE >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // appColormap(int)
        Qt::HANDLE cpp_result = QX11Info::appColormap(cpp_arg0);
        py_result = Shiboken::Converter<Qt::HANDLE >::toPython(cpp_result);
    } else goto SbkQX11InfoFunc_appColormap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQX11InfoFunc_appColormap_TypeError:
        const char* overloads[] = {"int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QX11Info.appColormap", overloads);
        return 0;
}

static PyObject*
SbkQX11InfoFunc_appDefaultColormap(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // appDefaultColormap(int)
        bool cpp_result = QX11Info::appDefaultColormap();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // appDefaultColormap(int)
        bool cpp_result = QX11Info::appDefaultColormap(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQX11InfoFunc_appDefaultColormap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQX11InfoFunc_appDefaultColormap_TypeError:
        const char* overloads[] = {"int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QX11Info.appDefaultColormap", overloads);
        return 0;
}

static PyObject*
SbkQX11InfoFunc_appDefaultVisual(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // appDefaultVisual(int)
        bool cpp_result = QX11Info::appDefaultVisual();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // appDefaultVisual(int)
        bool cpp_result = QX11Info::appDefaultVisual(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQX11InfoFunc_appDefaultVisual_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQX11InfoFunc_appDefaultVisual_TypeError:
        const char* overloads[] = {"int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QX11Info.appDefaultVisual", overloads);
        return 0;
}

static PyObject*
SbkQX11InfoFunc_appDepth(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // appDepth(int)
        int cpp_result = QX11Info::appDepth();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // appDepth(int)
        int cpp_result = QX11Info::appDepth(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQX11InfoFunc_appDepth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQX11InfoFunc_appDepth_TypeError:
        const char* overloads[] = {"int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QX11Info.appDepth", overloads);
        return 0;
}

static PyObject*
SbkQX11InfoFunc_appDpiX(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // appDpiX(int)
        int cpp_result = QX11Info::appDpiX();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // appDpiX(int)
        int cpp_result = QX11Info::appDpiX(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQX11InfoFunc_appDpiX_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQX11InfoFunc_appDpiX_TypeError:
        const char* overloads[] = {"int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QX11Info.appDpiX", overloads);
        return 0;
}

static PyObject*
SbkQX11InfoFunc_appDpiY(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // appDpiY(int)
        int cpp_result = QX11Info::appDpiY();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // appDpiY(int)
        int cpp_result = QX11Info::appDpiY(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQX11InfoFunc_appDpiY_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQX11InfoFunc_appDpiY_TypeError:
        const char* overloads[] = {"int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QX11Info.appDpiY", overloads);
        return 0;
}

static PyObject*
SbkQX11InfoFunc_appRootWindow(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // appRootWindow(int)
        Qt::HANDLE cpp_result = QX11Info::appRootWindow();
        py_result = Shiboken::Converter<Qt::HANDLE >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // appRootWindow(int)
        Qt::HANDLE cpp_result = QX11Info::appRootWindow(cpp_arg0);
        py_result = Shiboken::Converter<Qt::HANDLE >::toPython(cpp_result);
    } else goto SbkQX11InfoFunc_appRootWindow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQX11InfoFunc_appRootWindow_TypeError:
        const char* overloads[] = {"int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QX11Info.appRootWindow", overloads);
        return 0;
}

static PyObject*
SbkQX11InfoFunc_appScreen(PyObject* self)
{
    PyObject* py_result = 0;

    // appScreen()
    int cpp_result = QX11Info::appScreen();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQX11InfoFunc_appTime(PyObject* self)
{
    PyObject* py_result = 0;

    // appTime()
    unsigned long cpp_result = QX11Info::appTime();
    py_result = Shiboken::Converter<unsigned long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQX11InfoFunc_appUserTime(PyObject* self)
{
    PyObject* py_result = 0;

    // appUserTime()
    unsigned long cpp_result = QX11Info::appUserTime();
    py_result = Shiboken::Converter<unsigned long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQX11InfoFunc_cells(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cells()const
    QX11Info* cppSelf = Shiboken::Converter<QX11Info* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QX11Info::cells();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQX11InfoFunc_cloneX11Data(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintDevice* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintDevice* cpp_arg0 = Shiboken::Converter<QPaintDevice* >::toCpp(arg);
        // cloneX11Data(const QPaintDevice*)
        QX11Info* cppSelf = Shiboken::Converter<QX11Info* >::toCpp((PyObject*)self);
        cppSelf->QX11Info::cloneX11Data(cpp_arg0);
    } else goto SbkQX11InfoFunc_cloneX11Data_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQX11InfoFunc_cloneX11Data_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QX11Info.cloneX11Data", overloads);
        return 0;
}

static PyObject*
SbkQX11InfoFunc_colormap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // colormap()const
    QX11Info* cppSelf = Shiboken::Converter<QX11Info* >::toCpp((PyObject*)self);
    Qt::HANDLE cpp_result = cppSelf->QX11Info::colormap();
    py_result = Shiboken::Converter<Qt::HANDLE >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQX11InfoFunc_copyX11Data(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintDevice* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintDevice* cpp_arg0 = Shiboken::Converter<QPaintDevice* >::toCpp(arg);
        // copyX11Data(const QPaintDevice*)
        QX11Info* cppSelf = Shiboken::Converter<QX11Info* >::toCpp((PyObject*)self);
        cppSelf->QX11Info::copyX11Data(cpp_arg0);
    } else goto SbkQX11InfoFunc_copyX11Data_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQX11InfoFunc_copyX11Data_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QX11Info.copyX11Data", overloads);
        return 0;
}

static PyObject*
SbkQX11InfoFunc_defaultColormap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultColormap()const
    QX11Info* cppSelf = Shiboken::Converter<QX11Info* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QX11Info::defaultColormap();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQX11InfoFunc_defaultVisual(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultVisual()const
    QX11Info* cppSelf = Shiboken::Converter<QX11Info* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QX11Info::defaultVisual();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQX11InfoFunc_depth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // depth()const
    QX11Info* cppSelf = Shiboken::Converter<QX11Info* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QX11Info::depth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQX11InfoFunc_isCompositingManagerRunning(PyObject* self)
{
    PyObject* py_result = 0;

    // isCompositingManagerRunning()
    bool cpp_result = QX11Info::isCompositingManagerRunning();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQX11InfoFunc_screen(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // screen()const
    QX11Info* cppSelf = Shiboken::Converter<QX11Info* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QX11Info::screen();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQX11InfoFunc_setAppDpiX(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setAppDpiX", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setAppDpiX(int,int)
        QX11Info::setAppDpiX(cpp_arg0, cpp_arg1);
    } else goto SbkQX11InfoFunc_setAppDpiX_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQX11InfoFunc_setAppDpiX_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QX11Info.setAppDpiX", overloads);
        return 0;
}

static PyObject*
SbkQX11InfoFunc_setAppDpiY(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setAppDpiY", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setAppDpiY(int,int)
        QX11Info::setAppDpiY(cpp_arg0, cpp_arg1);
    } else goto SbkQX11InfoFunc_setAppDpiY_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQX11InfoFunc_setAppDpiY_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QX11Info.setAppDpiY", overloads);
        return 0;
}

static PyObject*
SbkQX11InfoFunc_setAppTime(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        unsigned long cpp_arg0 = Shiboken::Converter<unsigned long >::toCpp(arg);
        // setAppTime(ulong)
        QX11Info::setAppTime(cpp_arg0);
    } else goto SbkQX11InfoFunc_setAppTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQX11InfoFunc_setAppTime_TypeError:
        const char* overloads[] = {"unsigned long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QX11Info.setAppTime", overloads);
        return 0;
}

static PyObject*
SbkQX11InfoFunc_setAppUserTime(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        unsigned long cpp_arg0 = Shiboken::Converter<unsigned long >::toCpp(arg);
        // setAppUserTime(ulong)
        QX11Info::setAppUserTime(cpp_arg0);
    } else goto SbkQX11InfoFunc_setAppUserTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQX11InfoFunc_setAppUserTime_TypeError:
        const char* overloads[] = {"unsigned long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QX11Info.setAppUserTime", overloads);
        return 0;
}

static PyMethodDef SbkQX11Info_methods[] = {
    {"appCells", (PyCFunction)SbkQX11InfoFunc_appCells, METH_NOARGS|METH_O|METH_STATIC},
    {"appClass", (PyCFunction)SbkQX11InfoFunc_appClass, METH_NOARGS|METH_STATIC},
    {"appColormap", (PyCFunction)SbkQX11InfoFunc_appColormap, METH_NOARGS|METH_O|METH_STATIC},
    {"appDefaultColormap", (PyCFunction)SbkQX11InfoFunc_appDefaultColormap, METH_NOARGS|METH_O|METH_STATIC},
    {"appDefaultVisual", (PyCFunction)SbkQX11InfoFunc_appDefaultVisual, METH_NOARGS|METH_O|METH_STATIC},
    {"appDepth", (PyCFunction)SbkQX11InfoFunc_appDepth, METH_NOARGS|METH_O|METH_STATIC},
    {"appDpiX", (PyCFunction)SbkQX11InfoFunc_appDpiX, METH_NOARGS|METH_O|METH_STATIC},
    {"appDpiY", (PyCFunction)SbkQX11InfoFunc_appDpiY, METH_NOARGS|METH_O|METH_STATIC},
    {"appRootWindow", (PyCFunction)SbkQX11InfoFunc_appRootWindow, METH_NOARGS|METH_O|METH_STATIC},
    {"appScreen", (PyCFunction)SbkQX11InfoFunc_appScreen, METH_NOARGS|METH_STATIC},
    {"appTime", (PyCFunction)SbkQX11InfoFunc_appTime, METH_NOARGS|METH_STATIC},
    {"appUserTime", (PyCFunction)SbkQX11InfoFunc_appUserTime, METH_NOARGS|METH_STATIC},
    {"cells", (PyCFunction)SbkQX11InfoFunc_cells, METH_NOARGS},
    {"cloneX11Data", (PyCFunction)SbkQX11InfoFunc_cloneX11Data, METH_O},
    {"colormap", (PyCFunction)SbkQX11InfoFunc_colormap, METH_NOARGS},
    {"copyX11Data", (PyCFunction)SbkQX11InfoFunc_copyX11Data, METH_O},
    {"defaultColormap", (PyCFunction)SbkQX11InfoFunc_defaultColormap, METH_NOARGS},
    {"defaultVisual", (PyCFunction)SbkQX11InfoFunc_defaultVisual, METH_NOARGS},
    {"depth", (PyCFunction)SbkQX11InfoFunc_depth, METH_NOARGS},
    {"isCompositingManagerRunning", (PyCFunction)SbkQX11InfoFunc_isCompositingManagerRunning, METH_NOARGS|METH_STATIC},
    {"screen", (PyCFunction)SbkQX11InfoFunc_screen, METH_NOARGS},
    {"setAppDpiX", (PyCFunction)SbkQX11InfoFunc_setAppDpiX, METH_VARARGS|METH_STATIC},
    {"setAppDpiY", (PyCFunction)SbkQX11InfoFunc_setAppDpiY, METH_VARARGS|METH_STATIC},
    {"setAppTime", (PyCFunction)SbkQX11InfoFunc_setAppTime, METH_O|METH_STATIC},
    {"setAppUserTime", (PyCFunction)SbkQX11InfoFunc_setAppUserTime, METH_O|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQX11Info_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QX11Info",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QX11Info >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQX11Info_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQX11Info_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QX11Info(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QX11INFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQX11Info_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQX11Info_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQX11Info_Type));
    PyModule_AddObject(module, "QX11Info",
        ((PyObject*)&SbkQX11Info_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QX11Info >("QX11Info");
    Shiboken::TypeResolver::createValueTypeResolver<QX11Info >(typeid(QX11Info).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

