/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef PyMODINIT_FUNC  /* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif

#include <Python.h>
#include <shiboken.h>
#include "pyside_qtgui_python.h"

#include "/usr/include/QtGui/qrgb.h"
#include "/usr/include/QtGui/qvector2d.h"
#include "/usr/include/QtGui/qaccessible2.h"

    // Begin code injection
    
    PyObject* moduleQtGui;
    
    // End of code injection

// Global functions ------------------------------------------------------------
static PyObject*
SbkQtGuiModule_qAccessibleActionCastHelper(PyObject* self)
{

    // qAccessibleActionCastHelper()
    qAccessibleActionCastHelper();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQtGuiModule_qAccessibleImageCastHelper(PyObject* self)
{

    // qAccessibleImageCastHelper()
    qAccessibleImageCastHelper();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQtGuiModule_qAlpha(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // qAlpha(uint)
        int cpp_result = qAlpha(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQtGuiModule_qAlpha_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQtGuiModule_qAlpha_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qAlpha", overloads);
        return 0;
}

static PyObject*
SbkQtGuiModule_qBlue(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // qBlue(uint)
        int cpp_result = qBlue(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQtGuiModule_qBlue_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQtGuiModule_qBlue_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qBlue", overloads);
        return 0;
}

static PyObject*
SbkQtGuiModule_qFuzzyCompare(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "qFuzzyCompare", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QMatrix& >::isConvertible(pyargs[0]) && Shiboken::Converter<QMatrix& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QMatrix* cpp_arg1 = Shiboken::Converter<QMatrix* >::toCpp(pyargs[1]);
        // qFuzzyCompare(QMatrix,QMatrix)
        bool cpp_result = qFuzzyCompare(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (numArgs == 2 && Shiboken::Converter<QTransform& >::isConvertible(pyargs[0]) && Shiboken::Converter<QTransform& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QTransform* cpp_arg1 = Shiboken::Converter<QTransform* >::toCpp(pyargs[1]);
        // qFuzzyCompare(QTransform,QTransform)
        bool cpp_result = qFuzzyCompare(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (numArgs == 2 && Shiboken::Converter<QQuaternion& >::isConvertible(pyargs[0]) && Shiboken::Converter<QQuaternion& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QQuaternion* cpp_arg0 = Shiboken::Converter<QQuaternion* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QQuaternion* cpp_arg1 = Shiboken::Converter<QQuaternion* >::toCpp(pyargs[1]);
        // qFuzzyCompare(QQuaternion,QQuaternion)
        bool cpp_result = qFuzzyCompare(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (numArgs == 2 && Shiboken::Converter<QMatrix4x4& >::isConvertible(pyargs[0]) && Shiboken::Converter<QMatrix4x4& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QMatrix4x4 > cpp_arg0_auto_ptr;
        QMatrix4x4* cpp_arg0 = Shiboken::Converter<QMatrix4x4* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QMatrix4x4& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QMatrix4x4 > cpp_arg1_auto_ptr;
        QMatrix4x4* cpp_arg1 = Shiboken::Converter<QMatrix4x4* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QMatrix4x4& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_arg1);
        // qFuzzyCompare(QMatrix4x4,QMatrix4x4)
        bool cpp_result = qFuzzyCompare(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (numArgs == 2 && Shiboken::Converter<QVector2D& >::isConvertible(pyargs[0]) && Shiboken::Converter<QVector2D& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QVector2D* cpp_arg0 = Shiboken::Converter<QVector2D* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QVector2D* cpp_arg1 = Shiboken::Converter<QVector2D* >::toCpp(pyargs[1]);
        // qFuzzyCompare(QVector2D,QVector2D)
        bool cpp_result = qFuzzyCompare(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (numArgs == 2 && Shiboken::Converter<QVector3D& >::isConvertible(pyargs[0]) && Shiboken::Converter<QVector3D& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVector3D > cpp_arg0_auto_ptr;
        QVector3D* cpp_arg0 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QVector3D& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVector3D > cpp_arg1_auto_ptr;
        QVector3D* cpp_arg1 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVector3D& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg1);
        // qFuzzyCompare(QVector3D,QVector3D)
        bool cpp_result = qFuzzyCompare(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (numArgs == 2 && Shiboken::Converter<QVector4D& >::isConvertible(pyargs[0]) && Shiboken::Converter<QVector4D& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVector4D > cpp_arg0_auto_ptr;
        QVector4D* cpp_arg0 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QVector4D& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVector4D > cpp_arg1_auto_ptr;
        QVector4D* cpp_arg1 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVector4D& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg1);
        // qFuzzyCompare(QVector4D,QVector4D)
        bool cpp_result = qFuzzyCompare(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQtGuiModule_qFuzzyCompare_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQtGuiModule_qFuzzyCompare_TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector2D, PySide.QtGui.QVector2D", "PySide.QtGui.QMatrix4x4, PySide.QtGui.QMatrix4x4", "PySide.QtGui.QQuaternion, PySide.QtGui.QQuaternion", "PySide.QtGui.QVector4D, PySide.QtGui.QVector4D", "PySide.QtGui.QVector3D, PySide.QtGui.QVector3D", "PySide.QtGui.QTransform, PySide.QtGui.QTransform", "PySide.QtGui.QMatrix, PySide.QtGui.QMatrix", 0};
        Shiboken::setErrorAboutWrongArguments(args, "qFuzzyCompare", overloads);
        return 0;
}

static PyObject*
SbkQtGuiModule_qGray(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQtGuiModule_qGray_TypeError;

    if (!PyArg_UnpackTuple(args, "qGray", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // qGray(int,int,int)
        int cpp_result = qGray(cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(pyargs[0]);
        // qGray(uint)
        int cpp_result = qGray(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQtGuiModule_qGray_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQtGuiModule_qGray_TypeError:
        const char* overloads[] = {"unsigned int", "int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "qGray", overloads);
        return 0;
}

static PyObject*
SbkQtGuiModule_qGreen(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // qGreen(uint)
        int cpp_result = qGreen(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQtGuiModule_qGreen_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQtGuiModule_qGreen_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qGreen", overloads);
        return 0;
}

static PyObject*
SbkQtGuiModule_qIsGray(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // qIsGray(uint)
        bool cpp_result = qIsGray(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQtGuiModule_qIsGray_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQtGuiModule_qIsGray_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qIsGray", overloads);
        return 0;
}

static PyObject*
SbkQtGuiModule_qRed(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // qRed(uint)
        int cpp_result = qRed(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQtGuiModule_qRed_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQtGuiModule_qRed_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qRed", overloads);
        return 0;
}

static PyObject*
SbkQtGuiModule_qRgb(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "qRgb", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // qRgb(int,int,int)
        unsigned int cpp_result = qRgb(cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    } else goto SbkQtGuiModule_qRgb_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQtGuiModule_qRgb_TypeError:
        const char* overloads[] = {"int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "qRgb", overloads);
        return 0;
}

static PyObject*
SbkQtGuiModule_qRgba(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "qRgba", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // qRgba(int,int,int,int)
        unsigned int cpp_result = qRgba(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    } else goto SbkQtGuiModule_qRgba_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQtGuiModule_qRgba_TypeError:
        const char* overloads[] = {"int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "qRgba", overloads);
        return 0;
}


static PyMethodDef QtGui_methods[] = {
    {"qAccessibleActionCastHelper", (PyCFunction)SbkQtGuiModule_qAccessibleActionCastHelper, METH_NOARGS},
    {"qAccessibleImageCastHelper", (PyCFunction)SbkQtGuiModule_qAccessibleImageCastHelper, METH_NOARGS},
    {"qAlpha", (PyCFunction)SbkQtGuiModule_qAlpha, METH_O},
    {"qBlue", (PyCFunction)SbkQtGuiModule_qBlue, METH_O},
    {"qFuzzyCompare", (PyCFunction)SbkQtGuiModule_qFuzzyCompare, METH_VARARGS},
    {"qGray", (PyCFunction)SbkQtGuiModule_qGray, METH_VARARGS},
    {"qGreen", (PyCFunction)SbkQtGuiModule_qGreen, METH_O},
    {"qIsGray", (PyCFunction)SbkQtGuiModule_qIsGray, METH_O},
    {"qRed", (PyCFunction)SbkQtGuiModule_qRed, METH_O},
    {"qRgb", (PyCFunction)SbkQtGuiModule_qRgb, METH_VARARGS},
    {"qRgba", (PyCFunction)SbkQtGuiModule_qRgba, METH_VARARGS},
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
extern "C" PyAPI_FUNC(void) init_QMatrix2x4(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMatrix2x3(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMatrix2x2(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMatrix3x4(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMatrix3x3(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMatrix3x2(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMatrix4x3(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMatrix4x2(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QItemEditorFactory(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QIconEngine(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTreeWidgetItemIterator(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTileRules(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFontMetricsF(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QItemSelection(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QKeySequence(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStringListModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextOption(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QBrush(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QX11Info(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextInlineObject(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QInputContextFactory(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPictureIO(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QToolTip(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPrinterInfo(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextLine(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QUndoCommand(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGestureRecognizer(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextFragment(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDataWidgetMapper(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QClipboard(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAction(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QActionGroup(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QButtonGroup(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsEffect(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsColorizeEffect(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsOpacityEffect(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsBlurEffect(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSystemTrayIcon(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleFactory(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPolygonF(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QKeyEventTransition(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMouseEventTransition(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextObject(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextFrame(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTreeWidgetItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QValidator(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextLength(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QImageReader(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPaintEngineState(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWidgetAction(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPolygon(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsAnchor(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QColor(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGesture(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTableWidgetItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QCompleter(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDropEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QClipboardEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWindowStateChangeEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QCloseEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QIconDragEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFileOpenEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QShortcutEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QShowEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStatusTipEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QHideEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QHelpEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QActionEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPinchGesture(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPainterPathStroker(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QShortcut(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QRegExpValidator(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QRegion(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsItemAnimation(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QResizeEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractItemDelegate(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QItemDelegate(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyledItemDelegate(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QLayoutItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWidgetItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QLayout(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStackedLayout(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPixmapCache(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSound(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextBlock(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMoveEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPaintEngine(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QBoxLayout(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QVBoxLayout(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QHBoxLayout(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QImageWriter(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStandardItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextDocumentFragment(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPen(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextDocument(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractTextDocumentLayout(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextLayout(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDrag(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsPixmapItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QIcon(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsItemGroup(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractGraphicsShapeItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsRectItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsSimpleTextItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsEllipseItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsPolygonItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPaintDevice(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPixmap(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPicture(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QInputEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTabletEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMouseEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTouchEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSwipeGesture(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDragLeaveEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFileSystemModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStandardItemModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QProxyModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QImageIOHandler(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFormLayout(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSyntaxHighlighter(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFontInfo(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOption(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionRubberBand(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleHintReturn(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleHintReturnVariant(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleHintReturnMask(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionProgressBar(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionProgressBarV2(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionFrame(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionFrameV2(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionFrameV3(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionTabWidgetFrame(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionButton(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionHeader(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionDockWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionDockWidgetV2(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionToolBar(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionTabBarBase(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionTabBarBaseV2(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionToolBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionTab(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionTabV2(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionTabV3(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTableWidgetSelectionRange(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsDropShadowEffect(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGradient(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QConicalGradient(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QRadialGradient(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPrintEngine(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsPathItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDragMoveEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDragEnterEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QHoverEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDoubleValidator(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPaintEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPalette(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyle(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QCommonStyle(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMotifStyle(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QCDEStyle(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWindowsStyle(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPlastiqueStyle(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsTransform(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsRotation(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsScale(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionGraphicsItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QVector3D(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionMenuItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QVector2D(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPanGesture(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWizardPage(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSizeGrip(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTabBar(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTabWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMainWindow(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFocusFrame(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMenu(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractSlider(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDial(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDialogButtonBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QRubberBand(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFrame(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSplitter(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QLCDNumber(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractScrollArea(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDockWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractButton(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QCheckBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QScrollArea(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QCalendarWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractSpinBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMdiArea(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStackedWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMdiSubWindow(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QLabel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QScrollBar(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPrintPreviewWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWorkspace(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSplashScreen(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSlider(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDesktopWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPainter(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStylePainter(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGroupBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSplitterHandle(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStatusBar(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QToolBar(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QLineEdit(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionComplex(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionTitleBar(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionSlider(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionGroupBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionSizeGrip(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionSpinBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionToolButton(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionComboBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionFocusRect(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionToolBoxV2(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsSceneEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsSceneResizeEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsSceneWheelEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsSceneDragDropEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsSceneHelpEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsSceneMouseEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsSceneHoverEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsSceneMoveEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsSceneContextMenuEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QInputMethodEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSpinBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QInputContext(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDesktopServices(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSessionManager(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFocusEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsObject(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsTextItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPlainTextDocumentLayout(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextBlockGroup(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextList(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QItemSelectionRange(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFontMetrics(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QIntValidator(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QItemEditorCreatorBase(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QContextMenuEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDoubleSpinBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QRadioButton(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWheelEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractItemView(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QColumnView(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTableView(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTreeView(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QListView(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QListWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QUndoView(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QHeaderView(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QVector4D(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QToolBarChangeEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QCursor(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPushButton(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QCommandLinkButton(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsLineItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDirModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTreeWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTransform(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QIconEngineV2(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QLinearGradient(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QCleanlooksStyle(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFont(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsScene(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsView(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionViewItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionViewItemV2(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionViewItemV3(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QStyleOptionViewItemV4(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWhatsThisClickedEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPrinter(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGridLayout(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSizePolicy(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSpacerItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QProgressBar(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QListWidgetItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QQuaternion(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMatrix4x4(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMatrix(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPainterPath(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWhatsThis(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QComboBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFontComboBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QToolButton(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDialog(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QErrorMessage(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QProgressDialog(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QColorDialog(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWizard(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPrintPreviewDialog(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractPrintDialog(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPrintDialog(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractPageSetupDialog(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPageSetupDialog(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFileIconProvider(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QApplication(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTableWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsLayoutItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsProxyWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsLayout(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsAnchorLayout(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsGridLayout(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsLinearLayout(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QToolBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextFormat(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextBlockFormat(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextListFormat(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextFrameFormat(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextTableFormat(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextCharFormat(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextImageFormat(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextTableCellFormat(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDateTimeEdit(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTimeEdit(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDateEdit(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextBlockUserData(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QItemSelectionModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMovie(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextTable(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QUndoGroup(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFileDialog(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QInputDialog(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGtkStyle(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QUndoStack(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextCursor(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QPlainTextEdit(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QImage(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QBitmap(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFontDatabase(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QKeyEvent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMessageBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextEdit(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextBrowser(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMenuBar(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextTableCell(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTextObjectInterface(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractProxyModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSortFilterProxyModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFontDialog(PyObject* module);

PyTypeObject** SbkPySide_QtGuiTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

// Module initialization ------------------------------------------------------------
// Extended Converters
static bool ExtendedIsConvertible_PySide_QtCore_QVariant(PyObject* pyobj)
{
    return SbkQBrush_Check(pyobj)
         || SbkQTextLength_Check(pyobj)
         || SbkQPolygon_Check(pyobj)
         || SbkQColor_Check(pyobj)
         || SbkQRegion_Check(pyobj)
         || SbkQPen_Check(pyobj)
         || SbkQIcon_Check(pyobj)
         || SbkQPixmap_Check(pyobj)
         || SbkQPalette_Check(pyobj)
         || SbkQVector3D_Check(pyobj)
         || SbkQVector2D_Check(pyobj)
         || SbkQVector4D_Check(pyobj)
         || SbkQCursor_Check(pyobj)
         || SbkQTransform_Check(pyobj)
         || SbkQFont_Check(pyobj)
         || SbkQSizePolicy_Check(pyobj)
         || SbkQQuaternion_Check(pyobj)
         || SbkQMatrix4x4_Check(pyobj)
         || SbkQMatrix_Check(pyobj)
         || SbkQTextFormat_Check(pyobj)
         || SbkQTextBlockFormat_Check(pyobj)
         || SbkQTextListFormat_Check(pyobj)
         || SbkQTextFrameFormat_Check(pyobj)
         || SbkQTextTableFormat_Check(pyobj)
         || SbkQTextCharFormat_Check(pyobj)
         || SbkQTextImageFormat_Check(pyobj)
         || SbkQTextTableCellFormat_Check(pyobj)
         || SbkQImage_Check(pyobj)
         || SbkQBitmap_Check(pyobj);
}
static void* ExtendedToCpp_PySide_QtCore_QVariant(PyObject* pyobj)
{
    void* cptr = 0;
    if (SbkQBrush_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QBrush >::toCpp(pyobj));
    else if (SbkQTextLength_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QTextLength >::toCpp(pyobj));
    else if (SbkQPolygon_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QPolygon >::toCpp(pyobj));
    else if (SbkQColor_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QColor >::toCpp(pyobj));
    else if (SbkQRegion_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QRegion >::toCpp(pyobj));
    else if (SbkQPen_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QPen >::toCpp(pyobj));
    else if (SbkQIcon_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QIcon >::toCpp(pyobj));
    else if (SbkQPixmap_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QPixmap >::toCpp(pyobj));
    else if (SbkQPalette_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QPalette >::toCpp(pyobj));
    else if (SbkQVector3D_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QVector3D >::toCpp(pyobj));
    else if (SbkQVector2D_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QVector2D >::toCpp(pyobj));
    else if (SbkQVector4D_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QVector4D >::toCpp(pyobj));
    else if (SbkQCursor_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QCursor >::toCpp(pyobj));
    else if (SbkQTransform_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QTransform >::toCpp(pyobj));
    else if (SbkQFont_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QFont >::toCpp(pyobj));
    else if (SbkQSizePolicy_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QSizePolicy >::toCpp(pyobj));
    else if (SbkQQuaternion_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QQuaternion >::toCpp(pyobj));
    else if (SbkQMatrix4x4_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QMatrix4x4 >::toCpp(pyobj));
    else if (SbkQMatrix_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QMatrix >::toCpp(pyobj));
    else if (SbkQTextFormat_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QTextFormat >::toCpp(pyobj));
    else if (SbkQTextBlockFormat_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QTextBlockFormat >::toCpp(pyobj));
    else if (SbkQTextListFormat_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QTextListFormat >::toCpp(pyobj));
    else if (SbkQTextFrameFormat_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QTextFrameFormat >::toCpp(pyobj));
    else if (SbkQTextTableFormat_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QTextTableFormat >::toCpp(pyobj));
    else if (SbkQTextCharFormat_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QTextCharFormat >::toCpp(pyobj));
    else if (SbkQTextImageFormat_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QTextImageFormat >::toCpp(pyobj));
    else if (SbkQTextTableCellFormat_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QTextTableCellFormat >::toCpp(pyobj));
    else if (SbkQImage_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QImage >::toCpp(pyobj));
    else if (SbkQBitmap_Check(pyobj))
        cptr = new QVariant(Shiboken::Converter<QBitmap >::toCpp(pyobj));
    return cptr;
}

static bool ExtendedIsConvertible_PySide_QtCore_QString(PyObject* pyobj)
{
    return SbkQKeySequence_Check(pyobj);
}
static void* ExtendedToCpp_PySide_QtCore_QString(PyObject* pyobj)
{
    void* cptr = 0;
    if (SbkQKeySequence_Check(pyobj))
        cptr = new QString(Shiboken::Converter<QKeySequence >::toCpp(pyobj));
    return cptr;
}


extern "C" {

SHIBOKEN_QTGUI_API PyMODINIT_FUNC
initQtGui()
{

    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("QtGui", QtGui_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_QtGui_IDX_COUNT];
    SbkPySide_QtGuiTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QMatrix2x4(module);
    init_QMatrix2x3(module);
    init_QMatrix2x2(module);
    init_QMatrix3x4(module);
    init_QMatrix3x3(module);
    init_QMatrix3x2(module);
    init_QMatrix4x3(module);
    init_QMatrix4x2(module);
    init_QItemEditorFactory(module);
    init_QIconEngine(module);
    init_QTreeWidgetItemIterator(module);
    init_QTileRules(module);
    init_QFontMetricsF(module);
    init_QItemSelection(module);
    init_QKeySequence(module);
    init_QStringListModel(module);
    init_QTextOption(module);
    init_QBrush(module);
    init_QX11Info(module);
    init_QTextInlineObject(module);
    init_QInputContextFactory(module);
    init_QPictureIO(module);
    init_QToolTip(module);
    init_QPrinterInfo(module);
    init_QTextLine(module);
    init_QUndoCommand(module);
    init_QGestureRecognizer(module);
    init_QTextFragment(module);
    init_QDataWidgetMapper(module);
    init_QClipboard(module);
    init_QAction(module);
    init_QActionGroup(module);
    init_QButtonGroup(module);
    init_QGraphicsEffect(module);
    init_QGraphicsColorizeEffect(module);
    init_QGraphicsOpacityEffect(module);
    init_QGraphicsBlurEffect(module);
    init_QSystemTrayIcon(module);
    init_QStyleFactory(module);
    init_QPolygonF(module);
    init_QKeyEventTransition(module);
    init_QMouseEventTransition(module);
    init_QTextObject(module);
    init_QTextFrame(module);
    init_QTreeWidgetItem(module);
    init_QValidator(module);
    init_QTextLength(module);
    init_QImageReader(module);
    init_QPaintEngineState(module);
    init_QWidgetAction(module);
    init_QPolygon(module);
    init_QGraphicsAnchor(module);
    init_QColor(module);
    init_QGesture(module);
    init_QTableWidgetItem(module);
    init_QCompleter(module);
    init_QDropEvent(module);
    init_QClipboardEvent(module);
    init_QWindowStateChangeEvent(module);
    init_QCloseEvent(module);
    init_QIconDragEvent(module);
    init_QFileOpenEvent(module);
    init_QShortcutEvent(module);
    init_QShowEvent(module);
    init_QStatusTipEvent(module);
    init_QHideEvent(module);
    init_QHelpEvent(module);
    init_QActionEvent(module);
    init_QPinchGesture(module);
    init_QPainterPathStroker(module);
    init_QShortcut(module);
    init_QRegExpValidator(module);
    init_QRegion(module);
    init_QGraphicsItemAnimation(module);
    init_QResizeEvent(module);
    init_QAbstractItemDelegate(module);
    init_QItemDelegate(module);
    init_QStyledItemDelegate(module);
    init_QLayoutItem(module);
    init_QWidgetItem(module);
    init_QLayout(module);
    init_QStackedLayout(module);
    init_QPixmapCache(module);
    init_QSound(module);
    init_QTextBlock(module);
    init_QMoveEvent(module);
    init_QPaintEngine(module);
    init_QBoxLayout(module);
    init_QVBoxLayout(module);
    init_QHBoxLayout(module);
    init_QImageWriter(module);
    init_QStandardItem(module);
    init_QTextDocumentFragment(module);
    init_QPen(module);
    init_QTextDocument(module);
    init_QAbstractTextDocumentLayout(module);
    init_QTextLayout(module);
    init_QDrag(module);
    init_QGraphicsItem(module);
    init_QGraphicsPixmapItem(module);
    init_QIcon(module);
    init_QGraphicsItemGroup(module);
    init_QAbstractGraphicsShapeItem(module);
    init_QGraphicsRectItem(module);
    init_QGraphicsSimpleTextItem(module);
    init_QGraphicsEllipseItem(module);
    init_QGraphicsPolygonItem(module);
    init_QPaintDevice(module);
    init_QPixmap(module);
    init_QPicture(module);
    init_QInputEvent(module);
    init_QTabletEvent(module);
    init_QMouseEvent(module);
    init_QTouchEvent(module);
    init_QSwipeGesture(module);
    init_QDragLeaveEvent(module);
    init_QFileSystemModel(module);
    init_QStandardItemModel(module);
    init_QProxyModel(module);
    init_QImageIOHandler(module);
    init_QFormLayout(module);
    init_QSyntaxHighlighter(module);
    init_QFontInfo(module);
    init_QStyleOption(module);
    init_QStyleOptionRubberBand(module);
    init_QStyleHintReturn(module);
    init_QStyleHintReturnVariant(module);
    init_QStyleHintReturnMask(module);
    init_QStyleOptionProgressBar(module);
    init_QStyleOptionProgressBarV2(module);
    init_QStyleOptionFrame(module);
    init_QStyleOptionFrameV2(module);
    init_QStyleOptionFrameV3(module);
    init_QStyleOptionTabWidgetFrame(module);
    init_QStyleOptionButton(module);
    init_QStyleOptionHeader(module);
    init_QStyleOptionDockWidget(module);
    init_QStyleOptionDockWidgetV2(module);
    init_QStyleOptionToolBar(module);
    init_QStyleOptionTabBarBase(module);
    init_QStyleOptionTabBarBaseV2(module);
    init_QStyleOptionToolBox(module);
    init_QStyleOptionTab(module);
    init_QStyleOptionTabV2(module);
    init_QStyleOptionTabV3(module);
    init_QTableWidgetSelectionRange(module);
    init_QGraphicsDropShadowEffect(module);
    init_QGradient(module);
    init_QConicalGradient(module);
    init_QRadialGradient(module);
    init_QPrintEngine(module);
    init_QGraphicsPathItem(module);
    init_QDragMoveEvent(module);
    init_QDragEnterEvent(module);
    init_QHoverEvent(module);
    init_QDoubleValidator(module);
    init_QPaintEvent(module);
    init_QPalette(module);
    init_QStyle(module);
    init_QCommonStyle(module);
    init_QMotifStyle(module);
    init_QCDEStyle(module);
    init_QWindowsStyle(module);
    init_QPlastiqueStyle(module);
    init_QGraphicsTransform(module);
    init_QGraphicsRotation(module);
    init_QGraphicsScale(module);
    init_QStyleOptionGraphicsItem(module);
    init_QVector3D(module);
    init_QStyleOptionMenuItem(module);
    init_QVector2D(module);
    init_QPanGesture(module);
    init_QWidget(module);
    init_QWizardPage(module);
    init_QSizeGrip(module);
    init_QTabBar(module);
    init_QTabWidget(module);
    init_QMainWindow(module);
    init_QFocusFrame(module);
    init_QMenu(module);
    init_QAbstractSlider(module);
    init_QDial(module);
    init_QDialogButtonBox(module);
    init_QRubberBand(module);
    init_QFrame(module);
    init_QSplitter(module);
    init_QLCDNumber(module);
    init_QAbstractScrollArea(module);
    init_QDockWidget(module);
    init_QAbstractButton(module);
    init_QCheckBox(module);
    init_QScrollArea(module);
    init_QCalendarWidget(module);
    init_QAbstractSpinBox(module);
    init_QMdiArea(module);
    init_QStackedWidget(module);
    init_QMdiSubWindow(module);
    init_QLabel(module);
    init_QScrollBar(module);
    init_QPrintPreviewWidget(module);
    init_QWorkspace(module);
    init_QSplashScreen(module);
    init_QSlider(module);
    init_QDesktopWidget(module);
    init_QPainter(module);
    init_QStylePainter(module);
    init_QGroupBox(module);
    init_QSplitterHandle(module);
    init_QStatusBar(module);
    init_QToolBar(module);
    init_QLineEdit(module);
    init_QStyleOptionComplex(module);
    init_QStyleOptionTitleBar(module);
    init_QStyleOptionSlider(module);
    init_QStyleOptionGroupBox(module);
    init_QStyleOptionSizeGrip(module);
    init_QStyleOptionSpinBox(module);
    init_QStyleOptionToolButton(module);
    init_QStyleOptionComboBox(module);
    init_QStyleOptionFocusRect(module);
    init_QStyleOptionToolBoxV2(module);
    init_QGraphicsSceneEvent(module);
    init_QGraphicsSceneResizeEvent(module);
    init_QGraphicsSceneWheelEvent(module);
    init_QGraphicsSceneDragDropEvent(module);
    init_QGraphicsSceneHelpEvent(module);
    init_QGraphicsSceneMouseEvent(module);
    init_QGraphicsSceneHoverEvent(module);
    init_QGraphicsSceneMoveEvent(module);
    init_QGraphicsSceneContextMenuEvent(module);
    init_QInputMethodEvent(module);
    init_QSpinBox(module);
    init_QInputContext(module);
    init_QDesktopServices(module);
    init_QSessionManager(module);
    init_QFocusEvent(module);
    init_QGraphicsObject(module);
    init_QGraphicsTextItem(module);
    init_QPlainTextDocumentLayout(module);
    init_QTextBlockGroup(module);
    init_QTextList(module);
    init_QItemSelectionRange(module);
    init_QFontMetrics(module);
    init_QIntValidator(module);
    init_QItemEditorCreatorBase(module);
    init_QContextMenuEvent(module);
    init_QDoubleSpinBox(module);
    init_QRadioButton(module);
    init_QWheelEvent(module);
    init_QAbstractItemView(module);
    init_QColumnView(module);
    init_QTableView(module);
    init_QTreeView(module);
    init_QListView(module);
    init_QListWidget(module);
    init_QUndoView(module);
    init_QHeaderView(module);
    init_QVector4D(module);
    init_QToolBarChangeEvent(module);
    init_QCursor(module);
    init_QPushButton(module);
    init_QCommandLinkButton(module);
    init_QTextItem(module);
    init_QGraphicsLineItem(module);
    init_QDirModel(module);
    init_QTreeWidget(module);
    init_QTransform(module);
    init_QIconEngineV2(module);
    init_QLinearGradient(module);
    init_QCleanlooksStyle(module);
    init_QFont(module);
    init_QGraphicsScene(module);
    init_QGraphicsView(module);
    init_QStyleOptionViewItem(module);
    init_QStyleOptionViewItemV2(module);
    init_QStyleOptionViewItemV3(module);
    init_QStyleOptionViewItemV4(module);
    init_QWhatsThisClickedEvent(module);
    init_QPrinter(module);
    init_QGridLayout(module);
    init_QSizePolicy(module);
    init_QSpacerItem(module);
    init_QProgressBar(module);
    init_QListWidgetItem(module);
    init_QQuaternion(module);
    init_QMatrix4x4(module);
    init_QMatrix(module);
    init_QPainterPath(module);
    init_QWhatsThis(module);
    init_QComboBox(module);
    init_QFontComboBox(module);
    init_QToolButton(module);
    init_QDialog(module);
    init_QErrorMessage(module);
    init_QProgressDialog(module);
    init_QColorDialog(module);
    init_QWizard(module);
    init_QPrintPreviewDialog(module);
    init_QAbstractPrintDialog(module);
    init_QPrintDialog(module);
    init_QAbstractPageSetupDialog(module);
    init_QPageSetupDialog(module);
    init_QFileIconProvider(module);
    init_QApplication(module);
    init_QTableWidget(module);
    init_QGraphicsLayoutItem(module);
    init_QGraphicsWidget(module);
    init_QGraphicsProxyWidget(module);
    init_QGraphicsLayout(module);
    init_QGraphicsAnchorLayout(module);
    init_QGraphicsGridLayout(module);
    init_QGraphicsLinearLayout(module);
    init_QToolBox(module);
    init_QTextFormat(module);
    init_QTextBlockFormat(module);
    init_QTextListFormat(module);
    init_QTextFrameFormat(module);
    init_QTextTableFormat(module);
    init_QTextCharFormat(module);
    init_QTextImageFormat(module);
    init_QTextTableCellFormat(module);
    init_QDateTimeEdit(module);
    init_QTimeEdit(module);
    init_QDateEdit(module);
    init_QTextBlockUserData(module);
    init_QItemSelectionModel(module);
    init_QMovie(module);
    init_QTextTable(module);
    init_QUndoGroup(module);
    init_QFileDialog(module);
    init_QInputDialog(module);
    init_QGtkStyle(module);
    init_QUndoStack(module);
    init_QTextCursor(module);
    init_QPlainTextEdit(module);
    init_QImage(module);
    init_QBitmap(module);
    init_QFontDatabase(module);
    init_QKeyEvent(module);
    init_QMessageBox(module);
    init_QTextEdit(module);
    init_QTextBrowser(module);
    init_QMenuBar(module);
    init_QTextTableCell(module);
    init_QTextObjectInterface(module);
    init_QAbstractProxyModel(module);
    init_QSortFilterProxyModel(module);
    init_QFontDialog(module);

    // Initialize extended Converters
    Shiboken::SbkBaseWrapperType* shiboType;

    // Extended implicit conversions for PySide.QtCore.QVariant
    shiboType = reinterpret_cast<Shiboken::SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QVARIANT_IDX]);
    shiboType->ext_isconvertible = ExtendedIsConvertible_PySide_QtCore_QVariant;
    shiboType->ext_tocpp = ExtendedToCpp_PySide_QtCore_QVariant;

    // Extended implicit conversions for PySide.QtCore.QString
    shiboType = reinterpret_cast<Shiboken::SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QSTRING_IDX]);
    shiboType->ext_isconvertible = ExtendedIsConvertible_PySide_QtCore_QString;
    shiboType->ext_tocpp = ExtendedToCpp_PySide_QtCore_QString;


    // Initialize namespaces as uninstantiable classes in the type system

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: glue/qtgui_qapp.cpp]
    // Init qApp macro to None.
    Py_INCREF(Py_None);
    PyModule_AddObject(module, "qApp", Py_None);
    moduleQtGui = module;
    
    // END of custom code block [file: glue/qtgui_qapp.cpp]
    // ========================================================================
    
    // End of code injection

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtGui");
    }
}

} // extern "C"


