/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtexttablecellformat_wrapper.h"

// Extra includes
#include <QMap>
#include <QVector>
#include <qbrush.h>
#include <qcolor.h>
#include <qfont.h>
#include <qpen.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qtextformat.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTextTableCellFormatWrapper::QTextTableCellFormatWrapper() : QTextTableCellFormat() {
    // ... middle
}

QTextTableCellFormatWrapper::QTextTableCellFormatWrapper(const QTextFormat & fmt) : QTextTableCellFormat(fmt) {
    // ... middle
}

QTextTableCellFormatWrapper::~QTextTableCellFormatWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQTextTableCellFormat_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextTableCellFormatWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextTableCellFormat", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextTableCellFormat()
        cptr = new QTextTableCellFormatWrapper();
    } else if (numArgs == 1 && Shiboken::Converter<QTextFormat& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextFormat* cpp_arg0 = Shiboken::Converter<QTextFormat* >::toCpp(pyargs[0]);
        // QTextTableCellFormat(QTextFormat)
        cptr = new QTextTableCellFormatWrapper(*cpp_arg0);
    } else goto SbkQTextTableCellFormat_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextTableCellFormat_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTextTableCellFormat_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextTableCellFormat", overloads);
        return -1;
}

static PyObject*
SbkQTextTableCellFormatFunc_bottomPadding(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bottomPadding()const
    QTextTableCellFormat* cppSelf = Shiboken::Converter<QTextTableCellFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextTableCellFormat::bottomPadding();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextTableCellFormatFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QTextTableCellFormat* cppSelf = Shiboken::Converter<QTextTableCellFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextTableCellFormat::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextTableCellFormatFunc_leftPadding(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // leftPadding()const
    QTextTableCellFormat* cppSelf = Shiboken::Converter<QTextTableCellFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextTableCellFormat::leftPadding();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextTableCellFormatFunc_rightPadding(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rightPadding()const
    QTextTableCellFormat* cppSelf = Shiboken::Converter<QTextTableCellFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextTableCellFormat::rightPadding();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextTableCellFormatFunc_setBottomPadding(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setBottomPadding(qreal)
        QTextTableCellFormat* cppSelf = Shiboken::Converter<QTextTableCellFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextTableCellFormat::setBottomPadding(cpp_arg0);
    } else goto SbkQTextTableCellFormatFunc_setBottomPadding_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableCellFormatFunc_setBottomPadding_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTableCellFormat.setBottomPadding", overloads);
        return 0;
}

static PyObject*
SbkQTextTableCellFormatFunc_setLeftPadding(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setLeftPadding(qreal)
        QTextTableCellFormat* cppSelf = Shiboken::Converter<QTextTableCellFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextTableCellFormat::setLeftPadding(cpp_arg0);
    } else goto SbkQTextTableCellFormatFunc_setLeftPadding_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableCellFormatFunc_setLeftPadding_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTableCellFormat.setLeftPadding", overloads);
        return 0;
}

static PyObject*
SbkQTextTableCellFormatFunc_setPadding(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setPadding(qreal)
        QTextTableCellFormat* cppSelf = Shiboken::Converter<QTextTableCellFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextTableCellFormat::setPadding(cpp_arg0);
    } else goto SbkQTextTableCellFormatFunc_setPadding_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableCellFormatFunc_setPadding_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTableCellFormat.setPadding", overloads);
        return 0;
}

static PyObject*
SbkQTextTableCellFormatFunc_setRightPadding(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setRightPadding(qreal)
        QTextTableCellFormat* cppSelf = Shiboken::Converter<QTextTableCellFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextTableCellFormat::setRightPadding(cpp_arg0);
    } else goto SbkQTextTableCellFormatFunc_setRightPadding_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableCellFormatFunc_setRightPadding_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTableCellFormat.setRightPadding", overloads);
        return 0;
}

static PyObject*
SbkQTextTableCellFormatFunc_setTopPadding(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setTopPadding(qreal)
        QTextTableCellFormat* cppSelf = Shiboken::Converter<QTextTableCellFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextTableCellFormat::setTopPadding(cpp_arg0);
    } else goto SbkQTextTableCellFormatFunc_setTopPadding_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableCellFormatFunc_setTopPadding_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTableCellFormat.setTopPadding", overloads);
        return 0;
}

static PyObject*
SbkQTextTableCellFormatFunc_topPadding(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // topPadding()const
    QTextTableCellFormat* cppSelf = Shiboken::Converter<QTextTableCellFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextTableCellFormat::topPadding();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTextTableCellFormat_methods[] = {
    {"bottomPadding", (PyCFunction)SbkQTextTableCellFormatFunc_bottomPadding, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQTextTableCellFormatFunc_isValid, METH_NOARGS},
    {"leftPadding", (PyCFunction)SbkQTextTableCellFormatFunc_leftPadding, METH_NOARGS},
    {"rightPadding", (PyCFunction)SbkQTextTableCellFormatFunc_rightPadding, METH_NOARGS},
    {"setBottomPadding", (PyCFunction)SbkQTextTableCellFormatFunc_setBottomPadding, METH_O},
    {"setLeftPadding", (PyCFunction)SbkQTextTableCellFormatFunc_setLeftPadding, METH_O},
    {"setPadding", (PyCFunction)SbkQTextTableCellFormatFunc_setPadding, METH_O},
    {"setRightPadding", (PyCFunction)SbkQTextTableCellFormatFunc_setRightPadding, METH_O},
    {"setTopPadding", (PyCFunction)SbkQTextTableCellFormatFunc_setTopPadding, METH_O},
    {"topPadding", (PyCFunction)SbkQTextTableCellFormatFunc_topPadding, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQTextTableCellFormat_ObjCopierFunc(const void* ptr){
    return new QTextTableCellFormatWrapper(*reinterpret_cast<const QTextTableCellFormat*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextTableCellFormat_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextTableCellFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTextTableCellFormatWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextTableCellFormat_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextTableCellFormat_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQTextTableCellFormat_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QTextTableCellFormat(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextTableCellFormat_Type);

    SbkQTextTableCellFormat_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX];
    // Fill type discovery information
    SbkQTextTableCellFormat_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTextTableCellFormat_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextTableCellFormat_Type));
    PyModule_AddObject(module, "QTextTableCellFormat",
        ((PyObject*)&SbkQTextTableCellFormat_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QTextTableCellFormat >("QTextTableCellFormat");
    Shiboken::TypeResolver::createValueTypeResolver<QTextTableCellFormat >(typeid(QTextTableCellFormat).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

