/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextlayout_wrapper.h"
#include "qtextlayout_formatrange_wrapper.h"

// Extra includes
#include <QList>
#include <QTextLayout>
#include <QTextOption>
#include <QVector>
#include <qfont.h>
#include <qpaintdevice.h>
#include <qpainter.h>
#include <qpoint.h>
#include <qrect.h>
#include <qstring.h>
#include <qtextlayout.h>
#include <qtextobject.h>
#include <qtextoption.h>

using namespace Shiboken;

static int
SbkQTextLayout_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextLayout* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QTextLayout", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QTextLayout()
        cptr = new QTextLayout();
    } else if (numArgs == 1 && Shiboken::Converter<QTextBlock& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextBlock* cpp_arg0 = Shiboken::Converter<QTextBlock* >::toCpp(pyargs[0]);
        // QTextLayout(QTextBlock)
        cptr = new QTextLayout(*cpp_arg0);
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QTextLayout(QString)
            cptr = new QTextLayout(*cpp_arg0);
        } else if (Shiboken::Converter<QFont& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QFont > cpp_arg1_auto_ptr;
            QFont* cpp_arg1 = Shiboken::Converter<QFont* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QFont& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QFont >(cpp_arg1);
            if (numArgs == 2) {
                // QTextLayout(QString,QFont,QPaintDevice*)
                cptr = new QTextLayout(*cpp_arg0, *cpp_arg1);
            } else if (Shiboken::Converter<QPaintDevice* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QPaintDevice* cpp_arg2 = Shiboken::Converter<QPaintDevice* >::toCpp(pyargs[2]);
                // QTextLayout(QString,QFont,QPaintDevice*)
                cptr = new QTextLayout(*cpp_arg0, *cpp_arg1, cpp_arg2);
            } else goto SbkQTextLayout_Init_TypeError;
        } else goto SbkQTextLayout_Init_TypeError;
    } else goto SbkQTextLayout_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextLayout_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTextLayout_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtGui.QFont, PySide.QtGui.QPaintDevice = None", "PySide.QtGui.QTextBlock", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextLayout", overloads);
        return -1;
}

static PyObject*
SbkQTextLayoutFunc_additionalFormats(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // additionalFormats()const
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    QList<QTextLayout::FormatRange > cpp_result = cppSelf->QTextLayout::additionalFormats();
    py_result = Shiboken::Converter<QList<QTextLayout::FormatRange > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextLayoutFunc_beginLayout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // beginLayout()
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    cppSelf->QTextLayout::beginLayout();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextLayoutFunc_boundingRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // boundingRect()const
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QTextLayout::boundingRect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextLayoutFunc_cacheEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cacheEnabled()const
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextLayout::cacheEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextLayoutFunc_clearAdditionalFormats(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearAdditionalFormats()
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    cppSelf->QTextLayout::clearAdditionalFormats();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextLayoutFunc_clearLayout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearLayout()
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    cppSelf->QTextLayout::clearLayout();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextLayoutFunc_createLine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // createLine()
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    QTextLine cpp_result = cppSelf->QTextLayout::createLine();
    py_result = Shiboken::Converter<QTextLine >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextLayoutFunc_draw(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "draw", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QPointF& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
        QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
        if (numArgs == 2) {
            // draw(QPainter*,QPointF,QVector<QTextLayout::FormatRange>,QRectF)const
            QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
            cppSelf->QTextLayout::draw(cpp_arg0, *cpp_arg1);
        } else if (Shiboken::Converter<QVector<QTextLayout::FormatRange >  >::isConvertible(pyargs[2])) {
            QVector<QTextLayout::FormatRange >  cpp_arg2 = Shiboken::Converter<QVector<QTextLayout::FormatRange >  >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // draw(QPainter*,QPointF,QVector<QTextLayout::FormatRange>,QRectF)const
                QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
                cppSelf->QTextLayout::draw(cpp_arg0, *cpp_arg1, cpp_arg2);
            } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                std::auto_ptr<QRectF > cpp_arg3_auto_ptr;
                QRectF* cpp_arg3 = Shiboken::Converter<QRectF* >::toCpp(pyargs[3]);
                if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[3]))
                    cpp_arg3_auto_ptr = std::auto_ptr<QRectF >(cpp_arg3);
                // draw(QPainter*,QPointF,QVector<QTextLayout::FormatRange>,QRectF)const
                QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
                cppSelf->QTextLayout::draw(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3);
            } else goto SbkQTextLayoutFunc_draw_TypeError;
        } else goto SbkQTextLayoutFunc_draw_TypeError;
    } else goto SbkQTextLayoutFunc_draw_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLayoutFunc_draw_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QPointF, list = QVector< QTextLayout.FormatRange >(), PySide.QtCore.QRectF = QRectF()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextLayout.draw", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_drawCursor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawCursor", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QPointF& >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
        QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // drawCursor(QPainter*,QPointF,int)const
            QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
            cppSelf->QTextLayout::drawCursor(cpp_arg0, *cpp_arg1, cpp_arg2);
        } else if (numArgs == 4 && PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // drawCursor(QPainter*,QPointF,int,int)const
            QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
            cppSelf->QTextLayout::drawCursor(cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
        } else goto SbkQTextLayoutFunc_drawCursor_TypeError;
    } else goto SbkQTextLayoutFunc_drawCursor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLayoutFunc_drawCursor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QPointF, int", "PySide.QtGui.QPainter, PySide.QtCore.QPointF, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextLayout.drawCursor", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_endLayout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endLayout()
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    cppSelf->QTextLayout::endLayout();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextLayoutFunc_font(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // font()const
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    QFont cpp_result = cppSelf->QTextLayout::font();
    py_result = Shiboken::Converter<QFont >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextLayoutFunc_isValidCursorPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // isValidCursorPosition(int)const
        QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTextLayout::isValidCursorPosition(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTextLayoutFunc_isValidCursorPosition_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextLayoutFunc_isValidCursorPosition_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextLayout.isValidCursorPosition", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_lineAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // lineAt(int)const
        QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
        QTextLine cpp_result = cppSelf->QTextLayout::lineAt(cpp_arg0);
        py_result = Shiboken::Converter<QTextLine >::toPython(cpp_result);
    } else goto SbkQTextLayoutFunc_lineAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextLayoutFunc_lineAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextLayout.lineAt", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_lineCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineCount()const
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextLayout::lineCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextLayoutFunc_lineForTextPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // lineForTextPosition(int)const
        QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
        QTextLine cpp_result = cppSelf->QTextLayout::lineForTextPosition(cpp_arg0);
        py_result = Shiboken::Converter<QTextLine >::toPython(cpp_result);
    } else goto SbkQTextLayoutFunc_lineForTextPosition_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextLayoutFunc_lineForTextPosition_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextLayout.lineForTextPosition", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_maximumWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumWidth()const
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextLayout::maximumWidth();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextLayoutFunc_minimumWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumWidth()const
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextLayout::minimumWidth();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextLayoutFunc_nextCursorPosition(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "nextCursorPosition", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // nextCursorPosition(int,QTextLayout::CursorMode)const
            QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QTextLayout::nextCursorPosition(cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (Shiboken::Converter<QTextLayout::CursorMode >::isConvertible(pyargs[1])) {
            QTextLayout::CursorMode cpp_arg1 = Shiboken::Converter<QTextLayout::CursorMode >::toCpp(pyargs[1]);
            // nextCursorPosition(int,QTextLayout::CursorMode)const
            QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QTextLayout::nextCursorPosition(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else goto SbkQTextLayoutFunc_nextCursorPosition_TypeError;
    } else goto SbkQTextLayoutFunc_nextCursorPosition_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextLayoutFunc_nextCursorPosition_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QTextLayout.CursorMode = SkipCharacters", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextLayout.nextCursorPosition", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_position(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // position()const
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QTextLayout::position();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextLayoutFunc_preeditAreaPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // preeditAreaPosition()const
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextLayout::preeditAreaPosition();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextLayoutFunc_preeditAreaText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // preeditAreaText()const
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextLayout::preeditAreaText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextLayoutFunc_previousCursorPosition(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "previousCursorPosition", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // previousCursorPosition(int,QTextLayout::CursorMode)const
            QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QTextLayout::previousCursorPosition(cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (Shiboken::Converter<QTextLayout::CursorMode >::isConvertible(pyargs[1])) {
            QTextLayout::CursorMode cpp_arg1 = Shiboken::Converter<QTextLayout::CursorMode >::toCpp(pyargs[1]);
            // previousCursorPosition(int,QTextLayout::CursorMode)const
            QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QTextLayout::previousCursorPosition(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else goto SbkQTextLayoutFunc_previousCursorPosition_TypeError;
    } else goto SbkQTextLayoutFunc_previousCursorPosition_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextLayoutFunc_previousCursorPosition_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QTextLayout.CursorMode = SkipCharacters", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextLayout.previousCursorPosition", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_setAdditionalFormats(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QTextLayout::FormatRange >  >::isConvertible(arg)) {
        QList<QTextLayout::FormatRange >  cpp_arg0 = Shiboken::Converter<QList<QTextLayout::FormatRange >  >::toCpp(arg);
        // setAdditionalFormats(QList<QTextLayout::FormatRange>)
        QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
        cppSelf->QTextLayout::setAdditionalFormats(cpp_arg0);
    } else goto SbkQTextLayoutFunc_setAdditionalFormats_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLayoutFunc_setAdditionalFormats_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextLayout.setAdditionalFormats", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_setCacheEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setCacheEnabled(bool)
        QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
        cppSelf->QTextLayout::setCacheEnabled(cpp_arg0);
    } else goto SbkQTextLayoutFunc_setCacheEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLayoutFunc_setCacheEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextLayout.setCacheEnabled", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_setFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setFlags(int)
        QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
        cppSelf->QTextLayout::setFlags(cpp_arg0);
    } else goto SbkQTextLayoutFunc_setFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLayoutFunc_setFlags_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextLayout.setFlags", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_setFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!Shiboken::Converter<QFont& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // setFont(QFont)
        QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
        cppSelf->QTextLayout::setFont(*cpp_arg0);
    } else goto SbkQTextLayoutFunc_setFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLayoutFunc_setFont_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextLayout.setFont", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_setPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setPosition(QPointF)
        QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
        cppSelf->QTextLayout::setPosition(*cpp_arg0);
    } else goto SbkQTextLayoutFunc_setPosition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLayoutFunc_setPosition_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextLayout.setPosition", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_setPreeditArea(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPreeditArea", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setPreeditArea(int,QString)
        QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
        cppSelf->QTextLayout::setPreeditArea(cpp_arg0, *cpp_arg1);
    } else goto SbkQTextLayoutFunc_setPreeditArea_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLayoutFunc_setPreeditArea_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextLayout.setPreeditArea", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_setText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setText(QString)
        QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
        cppSelf->QTextLayout::setText(*cpp_arg0);
    } else goto SbkQTextLayoutFunc_setText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLayoutFunc_setText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextLayout.setText", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_setTextOption(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextOption& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QTextOption > cpp_arg0_auto_ptr;
        QTextOption* cpp_arg0 = Shiboken::Converter<QTextOption* >::toCpp(arg);
        if (!Shiboken::Converter<QTextOption& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QTextOption >(cpp_arg0);
        // setTextOption(QTextOption)
        QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
        cppSelf->QTextLayout::setTextOption(*cpp_arg0);
    } else goto SbkQTextLayoutFunc_setTextOption_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLayoutFunc_setTextOption_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextOption", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextLayout.setTextOption", overloads);
        return 0;
}

static PyObject*
SbkQTextLayoutFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextLayout::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextLayoutFunc_textOption(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textOption()const
    QTextLayout* cppSelf = Shiboken::Converter<QTextLayout* >::toCpp((PyObject*)self);
    QTextOption cpp_result = cppSelf->QTextLayout::textOption();
    py_result = Shiboken::Converter<QTextOption >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTextLayout_methods[] = {
    {"additionalFormats", (PyCFunction)SbkQTextLayoutFunc_additionalFormats, METH_NOARGS},
    {"beginLayout", (PyCFunction)SbkQTextLayoutFunc_beginLayout, METH_NOARGS},
    {"boundingRect", (PyCFunction)SbkQTextLayoutFunc_boundingRect, METH_NOARGS},
    {"cacheEnabled", (PyCFunction)SbkQTextLayoutFunc_cacheEnabled, METH_NOARGS},
    {"clearAdditionalFormats", (PyCFunction)SbkQTextLayoutFunc_clearAdditionalFormats, METH_NOARGS},
    {"clearLayout", (PyCFunction)SbkQTextLayoutFunc_clearLayout, METH_NOARGS},
    {"createLine", (PyCFunction)SbkQTextLayoutFunc_createLine, METH_NOARGS},
    {"draw", (PyCFunction)SbkQTextLayoutFunc_draw, METH_VARARGS},
    {"drawCursor", (PyCFunction)SbkQTextLayoutFunc_drawCursor, METH_VARARGS},
    {"endLayout", (PyCFunction)SbkQTextLayoutFunc_endLayout, METH_NOARGS},
    {"font", (PyCFunction)SbkQTextLayoutFunc_font, METH_NOARGS},
    {"isValidCursorPosition", (PyCFunction)SbkQTextLayoutFunc_isValidCursorPosition, METH_O},
    {"lineAt", (PyCFunction)SbkQTextLayoutFunc_lineAt, METH_O},
    {"lineCount", (PyCFunction)SbkQTextLayoutFunc_lineCount, METH_NOARGS},
    {"lineForTextPosition", (PyCFunction)SbkQTextLayoutFunc_lineForTextPosition, METH_O},
    {"maximumWidth", (PyCFunction)SbkQTextLayoutFunc_maximumWidth, METH_NOARGS},
    {"minimumWidth", (PyCFunction)SbkQTextLayoutFunc_minimumWidth, METH_NOARGS},
    {"nextCursorPosition", (PyCFunction)SbkQTextLayoutFunc_nextCursorPosition, METH_VARARGS},
    {"position", (PyCFunction)SbkQTextLayoutFunc_position, METH_NOARGS},
    {"preeditAreaPosition", (PyCFunction)SbkQTextLayoutFunc_preeditAreaPosition, METH_NOARGS},
    {"preeditAreaText", (PyCFunction)SbkQTextLayoutFunc_preeditAreaText, METH_NOARGS},
    {"previousCursorPosition", (PyCFunction)SbkQTextLayoutFunc_previousCursorPosition, METH_VARARGS},
    {"setAdditionalFormats", (PyCFunction)SbkQTextLayoutFunc_setAdditionalFormats, METH_O},
    {"setCacheEnabled", (PyCFunction)SbkQTextLayoutFunc_setCacheEnabled, METH_O},
    {"setFlags", (PyCFunction)SbkQTextLayoutFunc_setFlags, METH_O},
    {"setFont", (PyCFunction)SbkQTextLayoutFunc_setFont, METH_O},
    {"setPosition", (PyCFunction)SbkQTextLayoutFunc_setPosition, METH_O},
    {"setPreeditArea", (PyCFunction)SbkQTextLayoutFunc_setPreeditArea, METH_VARARGS},
    {"setText", (PyCFunction)SbkQTextLayoutFunc_setText, METH_O},
    {"setTextOption", (PyCFunction)SbkQTextLayoutFunc_setTextOption, METH_O},
    {"text", (PyCFunction)SbkQTextLayoutFunc_text, METH_NOARGS},
    {"textOption", (PyCFunction)SbkQTextLayoutFunc_textOption, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextLayout_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextLayout",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTextLayout >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextLayout_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextLayout_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QTextLayout_CursorMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextLayout_CursorMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextLayout_CursorMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CursorMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextLayout_CursorMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextLayout_CursorMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTextLayout_CursorMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QTextLayout_FormatRange(PyObject*);
PyAPI_FUNC(void)
init_QTextLayout(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTLAYOUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextLayout_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextLayout_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextLayout_Type));
    PyModule_AddObject(module, "QTextLayout",
        ((PyObject*)&SbkQTextLayout_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: CursorMode
    SbkPySide_QtGuiTypes[SBK_QTEXTLAYOUT_CURSORMODE_IDX] = &SbkPySide_QtGui_QTextLayout_CursorMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextLayout_CursorMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextLayout_CursorMode_Type);
    PyDict_SetItemString(SbkQTextLayout_Type.super.ht_type.tp_dict,
            "CursorMode",((PyObject*)&SbkPySide_QtGui_QTextLayout_CursorMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextLayout_CursorMode_Type,
        (long) QTextLayout::SkipCharacters, "SkipCharacters");
    PyDict_SetItemString(SbkQTextLayout_Type.super.ht_type.tp_dict,
        "SkipCharacters", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextLayout_CursorMode_Type.tp_dict,
        "SkipCharacters", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextLayout_CursorMode_Type,
        (long) QTextLayout::SkipWords, "SkipWords");
    PyDict_SetItemString(SbkQTextLayout_Type.super.ht_type.tp_dict,
        "SkipWords", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextLayout_CursorMode_Type.tp_dict,
        "SkipWords", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextLayout::CursorMode");

    Shiboken::TypeResolver::createObjectTypeResolver<QTextLayout >("QTextLayout*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTextLayout >(typeid(QTextLayout).name());
    init_QTextLayout_FormatRange(SbkQTextLayout_Type.super.ht_type.tp_dict);
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

