/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qtextedit_wrapper.h"
#include "qtextedit_extraselection_wrapper.h"

// Extra includes
#include <QList>
#include <QTextCursor>
#include <QTextEdit>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcolor.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qmenu.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qprinter.h>
#include <qrect.h>
#include <qregion.h>
#include <qscrollbar.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qtextcursor.h>
#include <qtextdocument.h>
#include <qtextedit.h>
#include <qtextformat.h>
#include <qurl.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTextEditWrapper::QTextEditWrapper(QWidget * parent) : QTextEdit(parent), m_metaObject(0) {
    // ... middle
}

QTextEditWrapper::QTextEditWrapper(const QString & text, QWidget * parent) : QTextEdit(text, parent), m_metaObject(0) {
    // ... middle
}

void QTextEditWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QActionEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QTextEditWrapper::canInsertFromMimeData(const QMimeData * source) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canInsertFromMimeData"));
    if (py_override.isNull()) {
        return this->QTextEdit::canInsertFromMimeData(source);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMimeData* >::toPython(source)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextEdit.canInsertFromMimeData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTextEditWrapper::changeEvent(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::changeEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTextEditWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::contextMenuEvent(QContextMenuEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::contextMenuEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QContextMenuEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QMimeData * QTextEditWrapper::createMimeDataFromSelection() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createMimeDataFromSelection"));
    if (py_override.isNull()) {
        return this->QTextEdit::createMimeDataFromSelection();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMimeData* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextEdit.createMimeDataFromSelection");
        return 0        ;
    }
    QMimeData* cpp_result(Shiboken::Converter<QMimeData* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QTextEditWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QTextEditWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextEdit.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTextEditWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::dragEnterEvent(QDragEnterEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::dragEnterEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragEnterEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::dragLeaveEvent(QDragLeaveEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::dragLeaveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragLeaveEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::dragMoveEvent(QDragMoveEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::dragMoveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragMoveEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::dropEvent(QDropEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::dropEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDropEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QTextEditWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QTextEdit::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextEdit.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QTextEditWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextEdit.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTextEditWrapper::focusInEvent(QFocusEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::focusInEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QTextEditWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QTextEdit::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextEdit.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTextEditWrapper::focusOutEvent(QFocusEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::focusOutEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QTextEditWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextEdit.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTextEditWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTextEditWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QTextEditWrapper::inputMethodQuery(Qt::InputMethodQuery property) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QTextEdit::inputMethodQuery(property);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(property)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextEdit.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QTextEditWrapper::insertFromMimeData(const QMimeData * source)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "insertFromMimeData"));
    if (py_override.isNull()) {
        return this->QTextEdit::insertFromMimeData(source);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMimeData* >::toPython(source)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::keyPressEvent(QKeyEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::keyPressEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::keyReleaseEvent(QKeyEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::keyReleaseEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QTextEditWrapper::loadResource(int type, const QUrl & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "loadResource"));
    if (py_override.isNull()) {
        return this->QTextEdit::loadResource(type, name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iO)",
        type,
        Shiboken::Converter<QUrl& >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextEdit.loadResource");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

int QTextEditWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextEdit.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QTextEditWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextEdit.minimumSizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QTextEditWrapper::mouseDoubleClickEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::mouseDoubleClickEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::mouseMoveEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::mouseMoveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::mousePressEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::mousePressEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::mouseReleaseEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::mouseReleaseEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QTextEditWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextEdit.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QTextEditWrapper::paintEvent(QPaintEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::paintEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::resizeEvent(QResizeEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::resizeEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QResizeEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::scrollContentsBy(int dx, int dy)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollContentsBy"));
    if (py_override.isNull()) {
        return this->QTextEdit::scrollContentsBy(dx, dy);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        dx,
        dy
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextEditWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QTextEditWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextEdit.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QTextEditWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTabletEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTextEditWrapper::timerEvent(QTimerEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::timerEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QTextEditWrapper::viewportEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewportEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::viewportEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextEdit.viewportEvent");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

void QTextEditWrapper::wheelEvent(QWheelEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QTextEdit::wheelEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWheelEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QTextEditWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QTextEdit::staticMetaObject);
}
    return m_metaObject;
}

int QTextEditWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QTextEdit::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QTextEditWrapper::~QTextEditWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQTextEdit_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextEditWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QTextEdit", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QTextEdit(QWidget*)
        cptr = new QTextEditWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QTextEdit(QString,QWidget*)
            cptr = new QTextEditWrapper(*cpp_arg0);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            // QTextEdit(QString,QWidget*)
            cptr = new QTextEditWrapper(*cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQTextEdit_Init_TypeError;
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QTextEdit(QWidget*)
        cptr = new QTextEditWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQTextEdit_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextEdit_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTextEdit_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", "PySide.QtCore.QString, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextEdit", overloads);
        return -1;
}

static PyObject*
SbkQTextEditFunc_acceptRichText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // acceptRichText()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextEdit::acceptRichText();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_alignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alignment()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QTextEdit::alignment();
    py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_anchorAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // anchorAt(QPoint)const
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTextEdit::anchorAt(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQTextEditFunc_anchorAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextEditFunc_anchorAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.anchorAt", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_append(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // append(QString)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::append(*cpp_arg0);
    } else goto SbkQTextEditFunc_append_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_append_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.append", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_autoFormatting(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // autoFormatting()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QFlags<QTextEdit::AutoFormattingFlag> cpp_result = cppSelf->QTextEdit::autoFormatting();
    py_result = Shiboken::Converter<QFlags<QTextEdit::AutoFormattingFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_canInsertFromMimeData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QMimeData* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMimeData* cpp_arg0 = Shiboken::Converter<QMimeData* >::toCpp(arg);
        // canInsertFromMimeData(const QMimeData*)const
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTextEdit::canInsertFromMimeData(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTextEditFunc_canInsertFromMimeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextEditFunc_canInsertFromMimeData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMimeData", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.canInsertFromMimeData", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_canPaste(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canPaste()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextEdit::canPaste();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::changeEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.changeEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QTextEdit::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextEditFunc_contextMenuEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QContextMenuEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QContextMenuEvent* cpp_arg0 = Shiboken::Converter<QContextMenuEvent* >::toCpp(arg);
        // contextMenuEvent(QContextMenuEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::contextMenuEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_contextMenuEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_contextMenuEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QContextMenuEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.contextMenuEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_copy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // copy()
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QTextEdit::copy();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextEditFunc_createMimeDataFromSelection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // createMimeDataFromSelection()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QMimeData * cpp_result = cppSelf->QTextEdit::createMimeDataFromSelection();
    py_result = Shiboken::Converter<QMimeData* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_createStandardContextMenu(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // createStandardContextMenu()
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        QMenu * cpp_result = cppSelf->QTextEdit::createStandardContextMenu();
        py_result = Shiboken::Converter<QMenu* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // createStandardContextMenu(QPoint)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        QMenu * cpp_result = cppSelf->QTextEdit::createStandardContextMenu(*cpp_arg0);
        py_result = Shiboken::Converter<QMenu* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTextEditFunc_createStandardContextMenu_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextEditFunc_createStandardContextMenu_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.createStandardContextMenu", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_currentCharFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentCharFormat()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QTextCharFormat cpp_result = cppSelf->QTextEdit::currentCharFormat();
    py_result = Shiboken::Converter<QTextCharFormat >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_currentFont(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentFont()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QFont cpp_result = cppSelf->QTextEdit::currentFont();
    py_result = Shiboken::Converter<QFont >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_cursorForPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // cursorForPosition(QPoint)const
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        QTextCursor cpp_result = cppSelf->QTextEdit::cursorForPosition(*cpp_arg0);
        py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
    } else goto SbkQTextEditFunc_cursorForPosition_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextEditFunc_cursorForPosition_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.cursorForPosition", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_cursorRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // cursorRect()const
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QTextEdit::cursorRect();
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else if (Shiboken::Converter<QTextCursor& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCursor* cpp_arg0 = Shiboken::Converter<QTextCursor* >::toCpp(arg);
        // cursorRect(QTextCursor)const
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QTextEdit::cursorRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else goto SbkQTextEditFunc_cursorRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextEditFunc_cursorRect_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QTextCursor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.cursorRect", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_cursorWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cursorWidth()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextEdit::cursorWidth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_cut(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // cut()
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QTextEdit::cut();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextEditFunc_document(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // document()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QTextDocument * cpp_result = cppSelf->QTextEdit::document();
    py_result = Shiboken::Converter<QTextDocument* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_documentTitle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentTitle()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextEdit::documentTitle();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_dragEnterEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragEnterEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragEnterEvent* cpp_arg0 = Shiboken::Converter<QDragEnterEvent* >::toCpp(arg);
        // dragEnterEvent(QDragEnterEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::dragEnterEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_dragEnterEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_dragEnterEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragEnterEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.dragEnterEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_dragLeaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragLeaveEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragLeaveEvent* cpp_arg0 = Shiboken::Converter<QDragLeaveEvent* >::toCpp(arg);
        // dragLeaveEvent(QDragLeaveEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::dragLeaveEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_dragLeaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_dragLeaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragLeaveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.dragLeaveEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_dragMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragMoveEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragMoveEvent* cpp_arg0 = Shiboken::Converter<QDragMoveEvent* >::toCpp(arg);
        // dragMoveEvent(QDragMoveEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::dragMoveEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_dragMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_dragMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragMoveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.dragMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_dropEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDropEvent* cpp_arg0 = Shiboken::Converter<QDropEvent* >::toCpp(arg);
        // dropEvent(QDropEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::dropEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_dropEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_dropEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.dropEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_ensureCursorVisible(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // ensureCursorVisible()
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QTextEdit::ensureCursorVisible();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextEditFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTextEdit::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTextEditFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextEditFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.event", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_extraSelections(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // extraSelections()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QList<QTextEdit::ExtraSelection > cpp_result = cppSelf->QTextEdit::extraSelections();
    py_result = Shiboken::Converter<QList<QTextEdit::ExtraSelection > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_find(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "find", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // find(QString,QFlags<QTextDocument::FindFlag>)
            QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QTextEdit::find(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (SbkPySide_QtGui_QTextDocument_FindFlag_Check(pyargs[1])) {
            QFlags<QTextDocument::FindFlag> cpp_arg1 = Shiboken::Converter<QFlags<QTextDocument::FindFlag> >::toCpp(pyargs[1]);
            // find(QString,QFlags<QTextDocument::FindFlag>)
            QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QTextEdit::find(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQTextEditFunc_find_TypeError;
    } else goto SbkQTextEditFunc_find_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextEditFunc_find_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtGui.QTextDocument.FindFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextEdit.find", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_focusInEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusInEvent(QFocusEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::focusInEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_focusInEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_focusInEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.focusInEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_focusNextPrevChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // focusNextPrevChild(bool)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTextEdit::focusNextPrevChild(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTextEditFunc_focusNextPrevChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextEditFunc_focusNextPrevChild_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.focusNextPrevChild", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_focusOutEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusOutEvent(QFocusEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::focusOutEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_focusOutEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_focusOutEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.focusOutEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_fontFamily(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontFamily()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextEdit::fontFamily();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_fontItalic(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontItalic()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextEdit::fontItalic();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_fontPointSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontPointSize()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextEdit::fontPointSize();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_fontUnderline(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontUnderline()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextEdit::fontUnderline();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_fontWeight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontWeight()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextEdit::fontWeight();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_inputMethodEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QInputMethodEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QInputMethodEvent* cpp_arg0 = Shiboken::Converter<QInputMethodEvent* >::toCpp(arg);
        // inputMethodEvent(QInputMethodEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::inputMethodEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_inputMethodEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_inputMethodEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputMethodEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.inputMethodEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_inputMethodQuery(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::InputMethodQuery >::isConvertible(arg)) {
        Qt::InputMethodQuery cpp_arg0 = Shiboken::Converter<Qt::InputMethodQuery >::toCpp(arg);
        // inputMethodQuery(Qt::InputMethodQuery)const
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QTextEdit::inputMethodQuery(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQTextEditFunc_inputMethodQuery_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextEditFunc_inputMethodQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.InputMethodQuery", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.inputMethodQuery", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_insertFromMimeData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMimeData* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMimeData* cpp_arg0 = Shiboken::Converter<QMimeData* >::toCpp(arg);
        // insertFromMimeData(const QMimeData*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::insertFromMimeData(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQTextEditFunc_insertFromMimeData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_insertFromMimeData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMimeData", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.insertFromMimeData", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_insertHtml(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // insertHtml(QString)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::insertHtml(*cpp_arg0);
    } else goto SbkQTextEditFunc_insertHtml_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_insertHtml_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.insertHtml", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_insertPlainText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // insertPlainText(QString)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::insertPlainText(*cpp_arg0);
    } else goto SbkQTextEditFunc_insertPlainText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_insertPlainText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.insertPlainText", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_isReadOnly(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isReadOnly()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextEdit::isReadOnly();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_isUndoRedoEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isUndoRedoEnabled()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextEdit::isUndoRedoEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::keyPressEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.keyPressEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_keyReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyReleaseEvent(QKeyEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::keyReleaseEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_keyReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_keyReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.keyReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_lineWrapColumnOrWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineWrapColumnOrWidth()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextEdit::lineWrapColumnOrWidth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_lineWrapMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineWrapMode()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QTextEdit::LineWrapMode cpp_result = cppSelf->QTextEdit::lineWrapMode();
    py_result = Shiboken::Converter<QTextEdit::LineWrapMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_loadResource(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "loadResource", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QUrl& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
        QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QUrl& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
        // loadResource(int,QUrl)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QTextEdit::loadResource(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQTextEditFunc_loadResource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextEditFunc_loadResource_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextEdit.loadResource", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_mergeCurrentCharFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCharFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCharFormat* cpp_arg0 = Shiboken::Converter<QTextCharFormat* >::toCpp(arg);
        // mergeCurrentCharFormat(QTextCharFormat)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::mergeCurrentCharFormat(*cpp_arg0);
    } else goto SbkQTextEditFunc_mergeCurrentCharFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_mergeCurrentCharFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.mergeCurrentCharFormat", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_mouseDoubleClickEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseDoubleClickEvent(QMouseEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::mouseDoubleClickEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_mouseDoubleClickEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_mouseDoubleClickEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.mouseDoubleClickEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QMouseEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::mouseMoveEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.mouseMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::mousePressEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.mousePressEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::mouseReleaseEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_moveCursor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "moveCursor", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QTextCursor::MoveOperation >::isConvertible(pyargs[0])) {
        QTextCursor::MoveOperation cpp_arg0 = Shiboken::Converter<QTextCursor::MoveOperation >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // moveCursor(QTextCursor::MoveOperation,QTextCursor::MoveMode)
            QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
            cppSelf->QTextEdit::moveCursor(cpp_arg0);
        } else if (Shiboken::Converter<QTextCursor::MoveMode >::isConvertible(pyargs[1])) {
            QTextCursor::MoveMode cpp_arg1 = Shiboken::Converter<QTextCursor::MoveMode >::toCpp(pyargs[1]);
            // moveCursor(QTextCursor::MoveOperation,QTextCursor::MoveMode)
            QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
            cppSelf->QTextEdit::moveCursor(cpp_arg0, cpp_arg1);
        } else goto SbkQTextEditFunc_moveCursor_TypeError;
    } else goto SbkQTextEditFunc_moveCursor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_moveCursor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCursor.MoveOperation, PySide.QtGui.QTextCursor.MoveMode = QTextCursor.MoveAnchor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextEdit.moveCursor", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_overwriteMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // overwriteMode()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextEdit::overwriteMode();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::paintEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.paintEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_paste(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // paste()
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QTextEdit::paste();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextEditFunc_print_(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrinter* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPrinter* cpp_arg0 = Shiboken::Converter<QPrinter* >::toCpp(arg);
        // print(QPrinter*)const
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::print(cpp_arg0);
    } else goto SbkQTextEditFunc_print__TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_print__TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.print_", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_redo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // redo()
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QTextEdit::redo();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextEditFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::resizeEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.resizeEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_scrollContentsBy(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollContentsBy", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // scrollContentsBy(int,int)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::scrollContentsBy(cpp_arg0, cpp_arg1);
    } else goto SbkQTextEditFunc_scrollContentsBy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_scrollContentsBy_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextEdit.scrollContentsBy", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_scrollToAnchor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // scrollToAnchor(QString)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::scrollToAnchor(*cpp_arg0);
    } else goto SbkQTextEditFunc_scrollToAnchor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_scrollToAnchor_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.scrollToAnchor", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_selectAll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // selectAll()
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QTextEdit::selectAll();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextEditFunc_setAcceptRichText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAcceptRichText(bool)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setAcceptRichText(cpp_arg0);
    } else goto SbkQTextEditFunc_setAcceptRichText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setAcceptRichText_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setAcceptRichText", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(arg)) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(arg);
        // setAlignment(QFlags<Qt::AlignmentFlag>)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setAlignment(cpp_arg0);
    } else goto SbkQTextEditFunc_setAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setAlignment", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setAutoFormatting(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_Check(arg)) {
        QFlags<QTextEdit::AutoFormattingFlag> cpp_arg0 = Shiboken::Converter<QFlags<QTextEdit::AutoFormattingFlag> >::toCpp(arg);
        // setAutoFormatting(QFlags<QTextEdit::AutoFormattingFlag>)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setAutoFormatting(cpp_arg0);
    } else goto SbkQTextEditFunc_setAutoFormatting_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setAutoFormatting_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextEdit.AutoFormatting", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setAutoFormatting", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setCurrentCharFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCharFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCharFormat* cpp_arg0 = Shiboken::Converter<QTextCharFormat* >::toCpp(arg);
        // setCurrentCharFormat(QTextCharFormat)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setCurrentCharFormat(*cpp_arg0);
    } else goto SbkQTextEditFunc_setCurrentCharFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setCurrentCharFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setCurrentCharFormat", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setCurrentFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!Shiboken::Converter<QFont& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // setCurrentFont(QFont)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setCurrentFont(*cpp_arg0);
    } else goto SbkQTextEditFunc_setCurrentFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setCurrentFont_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setCurrentFont", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setCursorWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCursorWidth(int)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setCursorWidth(cpp_arg0);
    } else goto SbkQTextEditFunc_setCursorWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setCursorWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setCursorWidth", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setDocument(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextDocument* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextDocument* cpp_arg0 = Shiboken::Converter<QTextDocument* >::toCpp(arg);
        // setDocument(QTextDocument*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setDocument(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQTextEditFunc_setDocument_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setDocument_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextDocument", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setDocument", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setDocumentTitle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDocumentTitle(QString)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setDocumentTitle(*cpp_arg0);
    } else goto SbkQTextEditFunc_setDocumentTitle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setDocumentTitle_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setDocumentTitle", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setExtraSelections(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QTextEdit::ExtraSelection >  >::isConvertible(arg)) {
        QList<QTextEdit::ExtraSelection >  cpp_arg0 = Shiboken::Converter<QList<QTextEdit::ExtraSelection >  >::toCpp(arg);
        // setExtraSelections(QList<QTextEdit::ExtraSelection>)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setExtraSelections(cpp_arg0);
    } else goto SbkQTextEditFunc_setExtraSelections_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setExtraSelections_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setExtraSelections", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setFontFamily(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFontFamily(QString)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setFontFamily(*cpp_arg0);
    } else goto SbkQTextEditFunc_setFontFamily_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setFontFamily_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setFontFamily", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setFontItalic(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFontItalic(bool)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setFontItalic(cpp_arg0);
    } else goto SbkQTextEditFunc_setFontItalic_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setFontItalic_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setFontItalic", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setFontPointSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setFontPointSize(qreal)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setFontPointSize(cpp_arg0);
    } else goto SbkQTextEditFunc_setFontPointSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setFontPointSize_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setFontPointSize", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setFontUnderline(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFontUnderline(bool)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setFontUnderline(cpp_arg0);
    } else goto SbkQTextEditFunc_setFontUnderline_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setFontUnderline_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setFontUnderline", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setFontWeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setFontWeight(int)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setFontWeight(cpp_arg0);
    } else goto SbkQTextEditFunc_setFontWeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setFontWeight_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setFontWeight", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setHtml(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setHtml(QString)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setHtml(*cpp_arg0);
    } else goto SbkQTextEditFunc_setHtml_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setHtml_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setHtml", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setLineWrapColumnOrWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setLineWrapColumnOrWidth(int)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setLineWrapColumnOrWidth(cpp_arg0);
    } else goto SbkQTextEditFunc_setLineWrapColumnOrWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setLineWrapColumnOrWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setLineWrapColumnOrWidth", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setLineWrapMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextEdit::LineWrapMode >::isConvertible(arg)) {
        QTextEdit::LineWrapMode cpp_arg0 = Shiboken::Converter<QTextEdit::LineWrapMode >::toCpp(arg);
        // setLineWrapMode(QTextEdit::LineWrapMode)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setLineWrapMode(cpp_arg0);
    } else goto SbkQTextEditFunc_setLineWrapMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setLineWrapMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextEdit.LineWrapMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setLineWrapMode", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setOverwriteMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setOverwriteMode(bool)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setOverwriteMode(cpp_arg0);
    } else goto SbkQTextEditFunc_setOverwriteMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setOverwriteMode_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setOverwriteMode", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setPlainText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPlainText(QString)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setPlainText(*cpp_arg0);
    } else goto SbkQTextEditFunc_setPlainText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setPlainText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setPlainText", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setReadOnly(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setReadOnly(bool)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setReadOnly(cpp_arg0);
    } else goto SbkQTextEditFunc_setReadOnly_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setReadOnly_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setReadOnly", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setTabChangesFocus(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setTabChangesFocus(bool)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setTabChangesFocus(cpp_arg0);
    } else goto SbkQTextEditFunc_setTabChangesFocus_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setTabChangesFocus_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setTabChangesFocus", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setTabStopWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setTabStopWidth(int)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setTabStopWidth(cpp_arg0);
    } else goto SbkQTextEditFunc_setTabStopWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setTabStopWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setTabStopWidth", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setText(QString)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setText(*cpp_arg0);
    } else goto SbkQTextEditFunc_setText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setText", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setTextBackgroundColor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QColor& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(arg);
        if (!Shiboken::Converter<QColor& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // setTextBackgroundColor(QColor)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setTextBackgroundColor(*cpp_arg0);
    } else goto SbkQTextEditFunc_setTextBackgroundColor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setTextBackgroundColor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setTextBackgroundColor", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setTextColor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QColor& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(arg);
        if (!Shiboken::Converter<QColor& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // setTextColor(QColor)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setTextColor(*cpp_arg0);
    } else goto SbkQTextEditFunc_setTextColor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setTextColor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setTextColor", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setTextCursor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCursor& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCursor* cpp_arg0 = Shiboken::Converter<QTextCursor* >::toCpp(arg);
        // setTextCursor(QTextCursor)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setTextCursor(*cpp_arg0);
    } else goto SbkQTextEditFunc_setTextCursor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setTextCursor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCursor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setTextCursor", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setTextInteractionFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_TextInteractionFlag_Check(arg)) {
        QFlags<Qt::TextInteractionFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::TextInteractionFlag> >::toCpp(arg);
        // setTextInteractionFlags(QFlags<Qt::TextInteractionFlag>)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setTextInteractionFlags(cpp_arg0);
    } else goto SbkQTextEditFunc_setTextInteractionFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setTextInteractionFlags_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.TextInteractionFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setTextInteractionFlags", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setUndoRedoEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setUndoRedoEnabled(bool)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setUndoRedoEnabled(cpp_arg0);
    } else goto SbkQTextEditFunc_setUndoRedoEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setUndoRedoEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setUndoRedoEnabled", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_setWordWrapMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextOption::WrapMode >::isConvertible(arg)) {
        QTextOption::WrapMode cpp_arg0 = Shiboken::Converter<QTextOption::WrapMode >::toCpp(arg);
        // setWordWrapMode(QTextOption::WrapMode)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::setWordWrapMode(cpp_arg0);
    } else goto SbkQTextEditFunc_setWordWrapMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_setWordWrapMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextOption.WrapMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.setWordWrapMode", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_showEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QShowEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QShowEvent* cpp_arg0 = Shiboken::Converter<QShowEvent* >::toCpp(arg);
        // showEvent(QShowEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::showEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_showEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_showEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QShowEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.showEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_tabChangesFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabChangesFocus()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextEdit::tabChangesFocus();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_tabStopWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabStopWidth()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextEdit::tabStopWidth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_textBackgroundColor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textBackgroundColor()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QColor cpp_result = cppSelf->QTextEdit::textBackgroundColor();
    py_result = Shiboken::Converter<QColor >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_textColor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textColor()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QColor cpp_result = cppSelf->QTextEdit::textColor();
    py_result = Shiboken::Converter<QColor >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_textCursor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textCursor()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QTextCursor cpp_result = cppSelf->QTextEdit::textCursor();
    py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_textInteractionFlags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textInteractionFlags()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QFlags<Qt::TextInteractionFlag> cpp_result = cppSelf->QTextEdit::textInteractionFlags();
    py_result = Shiboken::Converter<QFlags<Qt::TextInteractionFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_timerEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimerEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTimerEvent* cpp_arg0 = Shiboken::Converter<QTimerEvent* >::toCpp(arg);
        // timerEvent(QTimerEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::timerEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_timerEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_timerEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimerEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.timerEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_toHtml(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toHtml()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextEdit::toHtml();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_toPlainText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toPlainText()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextEdit::toPlainText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_undo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // undo()
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QTextEdit::undo();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextEditFunc_wheelEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWheelEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWheelEvent* cpp_arg0 = Shiboken::Converter<QWheelEvent* >::toCpp(arg);
        // wheelEvent(QWheelEvent*)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::wheelEvent(cpp_arg0);
    } else goto SbkQTextEditFunc_wheelEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_wheelEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWheelEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.wheelEvent", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_wordWrapMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // wordWrapMode()const
    QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
    QTextOption::WrapMode cpp_result = cppSelf->QTextEdit::wordWrapMode();
    py_result = Shiboken::Converter<QTextOption::WrapMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextEditFunc_zoomIn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // zoomIn(int)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::zoomIn();
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // zoomIn(int)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::zoomIn(cpp_arg0);
    } else goto SbkQTextEditFunc_zoomIn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_zoomIn_TypeError:
        const char* overloads[] = {"int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.zoomIn", overloads);
        return 0;
}

static PyObject*
SbkQTextEditFunc_zoomOut(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // zoomOut(int)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::zoomOut();
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // zoomOut(int)
        QTextEdit* cppSelf = Shiboken::Converter<QTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QTextEdit::zoomOut(cpp_arg0);
    } else goto SbkQTextEditFunc_zoomOut_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextEditFunc_zoomOut_TypeError:
        const char* overloads[] = {"int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextEdit.zoomOut", overloads);
        return 0;
}

static PyMethodDef SbkQTextEdit_methods[] = {
    {"acceptRichText", (PyCFunction)SbkQTextEditFunc_acceptRichText, METH_NOARGS},
    {"alignment", (PyCFunction)SbkQTextEditFunc_alignment, METH_NOARGS},
    {"anchorAt", (PyCFunction)SbkQTextEditFunc_anchorAt, METH_O},
    {"append", (PyCFunction)SbkQTextEditFunc_append, METH_O},
    {"autoFormatting", (PyCFunction)SbkQTextEditFunc_autoFormatting, METH_NOARGS},
    {"canInsertFromMimeData", (PyCFunction)SbkQTextEditFunc_canInsertFromMimeData, METH_O},
    {"canPaste", (PyCFunction)SbkQTextEditFunc_canPaste, METH_NOARGS},
    {"changeEvent", (PyCFunction)SbkQTextEditFunc_changeEvent, METH_O},
    {"clear", (PyCFunction)SbkQTextEditFunc_clear, METH_NOARGS},
    {"contextMenuEvent", (PyCFunction)SbkQTextEditFunc_contextMenuEvent, METH_O},
    {"copy", (PyCFunction)SbkQTextEditFunc_copy, METH_NOARGS},
    {"createMimeDataFromSelection", (PyCFunction)SbkQTextEditFunc_createMimeDataFromSelection, METH_NOARGS},
    {"createStandardContextMenu", (PyCFunction)SbkQTextEditFunc_createStandardContextMenu, METH_NOARGS|METH_O},
    {"currentCharFormat", (PyCFunction)SbkQTextEditFunc_currentCharFormat, METH_NOARGS},
    {"currentFont", (PyCFunction)SbkQTextEditFunc_currentFont, METH_NOARGS},
    {"cursorForPosition", (PyCFunction)SbkQTextEditFunc_cursorForPosition, METH_O},
    {"cursorRect", (PyCFunction)SbkQTextEditFunc_cursorRect, METH_NOARGS|METH_O},
    {"cursorWidth", (PyCFunction)SbkQTextEditFunc_cursorWidth, METH_NOARGS},
    {"cut", (PyCFunction)SbkQTextEditFunc_cut, METH_NOARGS},
    {"document", (PyCFunction)SbkQTextEditFunc_document, METH_NOARGS},
    {"documentTitle", (PyCFunction)SbkQTextEditFunc_documentTitle, METH_NOARGS},
    {"dragEnterEvent", (PyCFunction)SbkQTextEditFunc_dragEnterEvent, METH_O},
    {"dragLeaveEvent", (PyCFunction)SbkQTextEditFunc_dragLeaveEvent, METH_O},
    {"dragMoveEvent", (PyCFunction)SbkQTextEditFunc_dragMoveEvent, METH_O},
    {"dropEvent", (PyCFunction)SbkQTextEditFunc_dropEvent, METH_O},
    {"ensureCursorVisible", (PyCFunction)SbkQTextEditFunc_ensureCursorVisible, METH_NOARGS},
    {"event", (PyCFunction)SbkQTextEditFunc_event, METH_O},
    {"extraSelections", (PyCFunction)SbkQTextEditFunc_extraSelections, METH_NOARGS},
    {"find", (PyCFunction)SbkQTextEditFunc_find, METH_VARARGS},
    {"focusInEvent", (PyCFunction)SbkQTextEditFunc_focusInEvent, METH_O},
    {"focusNextPrevChild", (PyCFunction)SbkQTextEditFunc_focusNextPrevChild, METH_O},
    {"focusOutEvent", (PyCFunction)SbkQTextEditFunc_focusOutEvent, METH_O},
    {"fontFamily", (PyCFunction)SbkQTextEditFunc_fontFamily, METH_NOARGS},
    {"fontItalic", (PyCFunction)SbkQTextEditFunc_fontItalic, METH_NOARGS},
    {"fontPointSize", (PyCFunction)SbkQTextEditFunc_fontPointSize, METH_NOARGS},
    {"fontUnderline", (PyCFunction)SbkQTextEditFunc_fontUnderline, METH_NOARGS},
    {"fontWeight", (PyCFunction)SbkQTextEditFunc_fontWeight, METH_NOARGS},
    {"inputMethodEvent", (PyCFunction)SbkQTextEditFunc_inputMethodEvent, METH_O},
    {"inputMethodQuery", (PyCFunction)SbkQTextEditFunc_inputMethodQuery, METH_O},
    {"insertFromMimeData", (PyCFunction)SbkQTextEditFunc_insertFromMimeData, METH_O},
    {"insertHtml", (PyCFunction)SbkQTextEditFunc_insertHtml, METH_O},
    {"insertPlainText", (PyCFunction)SbkQTextEditFunc_insertPlainText, METH_O},
    {"isReadOnly", (PyCFunction)SbkQTextEditFunc_isReadOnly, METH_NOARGS},
    {"isUndoRedoEnabled", (PyCFunction)SbkQTextEditFunc_isUndoRedoEnabled, METH_NOARGS},
    {"keyPressEvent", (PyCFunction)SbkQTextEditFunc_keyPressEvent, METH_O},
    {"keyReleaseEvent", (PyCFunction)SbkQTextEditFunc_keyReleaseEvent, METH_O},
    {"lineWrapColumnOrWidth", (PyCFunction)SbkQTextEditFunc_lineWrapColumnOrWidth, METH_NOARGS},
    {"lineWrapMode", (PyCFunction)SbkQTextEditFunc_lineWrapMode, METH_NOARGS},
    {"loadResource", (PyCFunction)SbkQTextEditFunc_loadResource, METH_VARARGS},
    {"mergeCurrentCharFormat", (PyCFunction)SbkQTextEditFunc_mergeCurrentCharFormat, METH_O},
    {"mouseDoubleClickEvent", (PyCFunction)SbkQTextEditFunc_mouseDoubleClickEvent, METH_O},
    {"mouseMoveEvent", (PyCFunction)SbkQTextEditFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQTextEditFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQTextEditFunc_mouseReleaseEvent, METH_O},
    {"moveCursor", (PyCFunction)SbkQTextEditFunc_moveCursor, METH_VARARGS},
    {"overwriteMode", (PyCFunction)SbkQTextEditFunc_overwriteMode, METH_NOARGS},
    {"paintEvent", (PyCFunction)SbkQTextEditFunc_paintEvent, METH_O},
    {"paste", (PyCFunction)SbkQTextEditFunc_paste, METH_NOARGS},
    {"print_", (PyCFunction)SbkQTextEditFunc_print_, METH_O},
    {"redo", (PyCFunction)SbkQTextEditFunc_redo, METH_NOARGS},
    {"resizeEvent", (PyCFunction)SbkQTextEditFunc_resizeEvent, METH_O},
    {"scrollContentsBy", (PyCFunction)SbkQTextEditFunc_scrollContentsBy, METH_VARARGS},
    {"scrollToAnchor", (PyCFunction)SbkQTextEditFunc_scrollToAnchor, METH_O},
    {"selectAll", (PyCFunction)SbkQTextEditFunc_selectAll, METH_NOARGS},
    {"setAcceptRichText", (PyCFunction)SbkQTextEditFunc_setAcceptRichText, METH_O},
    {"setAlignment", (PyCFunction)SbkQTextEditFunc_setAlignment, METH_O},
    {"setAutoFormatting", (PyCFunction)SbkQTextEditFunc_setAutoFormatting, METH_O},
    {"setCurrentCharFormat", (PyCFunction)SbkQTextEditFunc_setCurrentCharFormat, METH_O},
    {"setCurrentFont", (PyCFunction)SbkQTextEditFunc_setCurrentFont, METH_O},
    {"setCursorWidth", (PyCFunction)SbkQTextEditFunc_setCursorWidth, METH_O},
    {"setDocument", (PyCFunction)SbkQTextEditFunc_setDocument, METH_O},
    {"setDocumentTitle", (PyCFunction)SbkQTextEditFunc_setDocumentTitle, METH_O},
    {"setExtraSelections", (PyCFunction)SbkQTextEditFunc_setExtraSelections, METH_O},
    {"setFontFamily", (PyCFunction)SbkQTextEditFunc_setFontFamily, METH_O},
    {"setFontItalic", (PyCFunction)SbkQTextEditFunc_setFontItalic, METH_O},
    {"setFontPointSize", (PyCFunction)SbkQTextEditFunc_setFontPointSize, METH_O},
    {"setFontUnderline", (PyCFunction)SbkQTextEditFunc_setFontUnderline, METH_O},
    {"setFontWeight", (PyCFunction)SbkQTextEditFunc_setFontWeight, METH_O},
    {"setHtml", (PyCFunction)SbkQTextEditFunc_setHtml, METH_O},
    {"setLineWrapColumnOrWidth", (PyCFunction)SbkQTextEditFunc_setLineWrapColumnOrWidth, METH_O},
    {"setLineWrapMode", (PyCFunction)SbkQTextEditFunc_setLineWrapMode, METH_O},
    {"setOverwriteMode", (PyCFunction)SbkQTextEditFunc_setOverwriteMode, METH_O},
    {"setPlainText", (PyCFunction)SbkQTextEditFunc_setPlainText, METH_O},
    {"setReadOnly", (PyCFunction)SbkQTextEditFunc_setReadOnly, METH_O},
    {"setTabChangesFocus", (PyCFunction)SbkQTextEditFunc_setTabChangesFocus, METH_O},
    {"setTabStopWidth", (PyCFunction)SbkQTextEditFunc_setTabStopWidth, METH_O},
    {"setText", (PyCFunction)SbkQTextEditFunc_setText, METH_O},
    {"setTextBackgroundColor", (PyCFunction)SbkQTextEditFunc_setTextBackgroundColor, METH_O},
    {"setTextColor", (PyCFunction)SbkQTextEditFunc_setTextColor, METH_O},
    {"setTextCursor", (PyCFunction)SbkQTextEditFunc_setTextCursor, METH_O},
    {"setTextInteractionFlags", (PyCFunction)SbkQTextEditFunc_setTextInteractionFlags, METH_O},
    {"setUndoRedoEnabled", (PyCFunction)SbkQTextEditFunc_setUndoRedoEnabled, METH_O},
    {"setWordWrapMode", (PyCFunction)SbkQTextEditFunc_setWordWrapMode, METH_O},
    {"showEvent", (PyCFunction)SbkQTextEditFunc_showEvent, METH_O},
    {"tabChangesFocus", (PyCFunction)SbkQTextEditFunc_tabChangesFocus, METH_NOARGS},
    {"tabStopWidth", (PyCFunction)SbkQTextEditFunc_tabStopWidth, METH_NOARGS},
    {"textBackgroundColor", (PyCFunction)SbkQTextEditFunc_textBackgroundColor, METH_NOARGS},
    {"textColor", (PyCFunction)SbkQTextEditFunc_textColor, METH_NOARGS},
    {"textCursor", (PyCFunction)SbkQTextEditFunc_textCursor, METH_NOARGS},
    {"textInteractionFlags", (PyCFunction)SbkQTextEditFunc_textInteractionFlags, METH_NOARGS},
    {"timerEvent", (PyCFunction)SbkQTextEditFunc_timerEvent, METH_O},
    {"toHtml", (PyCFunction)SbkQTextEditFunc_toHtml, METH_NOARGS},
    {"toPlainText", (PyCFunction)SbkQTextEditFunc_toPlainText, METH_NOARGS},
    {"undo", (PyCFunction)SbkQTextEditFunc_undo, METH_NOARGS},
    {"wheelEvent", (PyCFunction)SbkQTextEditFunc_wheelEvent, METH_O},
    {"wordWrapMode", (PyCFunction)SbkQTextEditFunc_wordWrapMode, METH_NOARGS},
    {"zoomIn", (PyCFunction)SbkQTextEditFunc_zoomIn, METH_NOARGS|METH_O},
    {"zoomOut", (PyCFunction)SbkQTextEditFunc_zoomOut, METH_NOARGS|METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQTextEditSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QTextEdit* me = reinterpret_cast<QTextEdit*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX]))
        return static_cast<QAbstractScrollArea*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QFRAME_IDX]))
        return static_cast<QFrame*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextEdit_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextEdit",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTextEditWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextEdit_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextEdit_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQTextEditSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

PyObject*
SbkPySide_QtGui_QTextEdit_AutoFormattingFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextEdit::AutoFormatting >::toPython(
        ((QTextEdit::AutoFormatting) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QTextEdit::AutoFormatting >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextEdit_AutoFormattingFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextEdit::AutoFormatting >::toPython(
        ((QTextEdit::AutoFormatting) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QTextEdit::AutoFormatting >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextEdit_AutoFormattingFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextEdit::AutoFormatting >::toPython(
        ((QTextEdit::AutoFormatting) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QTextEdit::AutoFormatting >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextEdit_AutoFormattingFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextEdit::AutoFormatting >::toPython(
        ~ Shiboken::Converter< QTextEdit::AutoFormatting >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QTextEdit_AutoFormattingFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QTextEdit_AutoFormattingFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QTextEdit_AutoFormattingFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QTextEdit_AutoFormattingFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AutoFormattingFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextEdit_AutoFormatting_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextEdit_AutoFormatting_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AutoFormatting",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextEdit_AutoFormatting_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTextEdit_AutoFormatting_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QTextEdit_AutoFormatting_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QTextEdit_LineWrapMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextEdit_LineWrapMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextEdit_LineWrapMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "LineWrapMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextEdit_LineWrapMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextEdit_LineWrapMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTextEdit_LineWrapMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QTextEdit_ExtraSelection(PyObject*);
PyAPI_FUNC(void)
init_QTextEdit(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTEDIT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextEdit_Type);

    SbkQTextEdit_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX];
    SbkQTextEdit_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQTextEdit_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTextEdit_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextEdit_Type));
    PyModule_AddObject(module, "QTextEdit",
        ((PyObject*)&SbkQTextEdit_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: AutoFormattingFlag
    SbkPySide_QtGuiTypes[SBK_QTEXTEDIT_AUTOFORMATTINGFLAG_IDX] = &SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_Type);
    PyDict_SetItemString(SbkQTextEdit_Type.super.ht_type.tp_dict,
            "AutoFormattingFlag",((PyObject*)&SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_Type));

    // init flags class: QFlags<QTextEdit::AutoFormattingFlag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTEDIT_AUTOFORMATTINGFLAG__IDX] = &SbkPySide_QtGui_QTextEdit_AutoFormatting_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextEdit_AutoFormatting_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextEdit_AutoFormatting_Type);
    PyDict_SetItemString(SbkQTextEdit_Type.super.ht_type.tp_dict,
            "AutoFormatting",((PyObject*)&SbkPySide_QtGui_QTextEdit_AutoFormatting_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_Type,
        (long) QTextEdit::AutoNone, "AutoNone");
    PyDict_SetItemString(SbkQTextEdit_Type.super.ht_type.tp_dict,
        "AutoNone", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_Type.tp_dict,
        "AutoNone", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_Type,
        (long) QTextEdit::AutoBulletList, "AutoBulletList");
    PyDict_SetItemString(SbkQTextEdit_Type.super.ht_type.tp_dict,
        "AutoBulletList", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_Type.tp_dict,
        "AutoBulletList", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_Type,
        (long) QTextEdit::AutoAll, "AutoAll");
    PyDict_SetItemString(SbkQTextEdit_Type.super.ht_type.tp_dict,
        "AutoAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextEdit_AutoFormattingFlag_Type.tp_dict,
        "AutoAll", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextEdit::AutoFormattingFlag");

    // init enum class: LineWrapMode
    SbkPySide_QtGuiTypes[SBK_QTEXTEDIT_LINEWRAPMODE_IDX] = &SbkPySide_QtGui_QTextEdit_LineWrapMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextEdit_LineWrapMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextEdit_LineWrapMode_Type);
    PyDict_SetItemString(SbkQTextEdit_Type.super.ht_type.tp_dict,
            "LineWrapMode",((PyObject*)&SbkPySide_QtGui_QTextEdit_LineWrapMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextEdit_LineWrapMode_Type,
        (long) QTextEdit::NoWrap, "NoWrap");
    PyDict_SetItemString(SbkQTextEdit_Type.super.ht_type.tp_dict,
        "NoWrap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextEdit_LineWrapMode_Type.tp_dict,
        "NoWrap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextEdit_LineWrapMode_Type,
        (long) QTextEdit::WidgetWidth, "WidgetWidth");
    PyDict_SetItemString(SbkQTextEdit_Type.super.ht_type.tp_dict,
        "WidgetWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextEdit_LineWrapMode_Type.tp_dict,
        "WidgetWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextEdit_LineWrapMode_Type,
        (long) QTextEdit::FixedPixelWidth, "FixedPixelWidth");
    PyDict_SetItemString(SbkQTextEdit_Type.super.ht_type.tp_dict,
        "FixedPixelWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextEdit_LineWrapMode_Type.tp_dict,
        "FixedPixelWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextEdit_LineWrapMode_Type,
        (long) QTextEdit::FixedColumnWidth, "FixedColumnWidth");
    PyDict_SetItemString(SbkQTextEdit_Type.super.ht_type.tp_dict,
        "FixedColumnWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextEdit_LineWrapMode_Type.tp_dict,
        "FixedColumnWidth", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextEdit::LineWrapMode");

    Shiboken::TypeResolver::createObjectTypeResolver<QTextEdit >("QTextEdit*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTextEdit >(typeid(QTextEdit).name());
    init_QTextEdit_ExtraSelection(SbkQTextEdit_Type.super.ht_type.tp_dict);
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

