/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qtextdocument_wrapper.h"

// Extra includes
#include <QList>
#include <QTextBlock>
#include <QTextCursor>
#include <QTextFormat>
#include <QVector>
#include <qabstracttextdocumentlayout.h>
#include <qbytearray.h>
#include <qchar.h>
#include <qcoreevent.h>
#include <qfont.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qrect.h>
#include <qregexp.h>
#include <qsize.h>
#include <qstring.h>
#include <qtextcursor.h>
#include <qtextdocument.h>
#include <qtextformat.h>
#include <qtextobject.h>
#include <qtextoption.h>
#include <qthread.h>
#include <qurl.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTextDocumentWrapper::QTextDocumentWrapper(QObject * parent) : QTextDocument(parent), m_metaObject(0) {
    // ... middle
}

QTextDocumentWrapper::QTextDocumentWrapper(const QString & text, QObject * parent) : QTextDocument(text, parent), m_metaObject(0) {
    // ... middle
}

void QTextDocumentWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTextDocumentWrapper::clear()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "clear"));
    if (py_override.isNull()) {
        return this->QTextDocument::clear();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextDocumentWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QTextObject * QTextDocumentWrapper::createObject(const QTextFormat & f)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createObject"));
    if (py_override.isNull()) {
        return this->QTextDocument::createObject(f);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTextFormat& >::toPython(f)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QTextObject* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextDocument.createObject");
        return 0        ;
    }
    QTextObject* cpp_result(Shiboken::Converter<QTextObject* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QTextDocumentWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTextDocumentWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QTextDocumentWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextDocument.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QTextDocumentWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextDocument.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

QVariant QTextDocumentWrapper::loadResource(int type, const QUrl & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "loadResource"));
    if (py_override.isNull()) {
        return this->QTextDocument::loadResource(type, name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iO)",
        type,
        Shiboken::Converter<QUrl& >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextDocument.loadResource");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QTextDocumentWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QTextDocumentWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QTextDocument::staticMetaObject);
}
    return m_metaObject;
}

int QTextDocumentWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QTextDocument::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QTextDocumentWrapper::~QTextDocumentWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQTextDocument_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextDocumentWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QTextDocument", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QTextDocument(QObject*)
        cptr = new QTextDocumentWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QTextDocument(QString,QObject*)
            cptr = new QTextDocumentWrapper(*cpp_arg0);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QTextDocument(QString,QObject*)
            cptr = new QTextDocumentWrapper(*cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQTextDocument_Init_TypeError;
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QTextDocument(QObject*)
        cptr = new QTextDocumentWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQTextDocument_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextDocument_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTextDocument_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", "PySide.QtCore.QString, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextDocument", overloads);
        return -1;
}

static PyObject*
SbkQTextDocumentFunc_addResource(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addResource", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QUrl& >::isConvertible(pyargs[1]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
        QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QUrl& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg2_auto_ptr;
        QVariant* cpp_arg2 = Shiboken::Converter<QVariant* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QVariant >(cpp_arg2);
        // addResource(int,QUrl,QVariant)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::addResource(cpp_arg0, *cpp_arg1, *cpp_arg2);
    } else goto SbkQTextDocumentFunc_addResource_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_addResource_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QUrl, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextDocument.addResource", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_adjustSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // adjustSize()
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    cppSelf->QTextDocument::adjustSize();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextDocumentFunc_allFormats(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // allFormats()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    QVector<QTextFormat > cpp_result = cppSelf->QTextDocument::allFormats();
    py_result = Shiboken::Converter<QVector<QTextFormat > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_availableRedoSteps(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // availableRedoSteps()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextDocument::availableRedoSteps();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_availableUndoSteps(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // availableUndoSteps()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextDocument::availableUndoSteps();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_begin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // begin()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    QTextBlock cpp_result = cppSelf->QTextDocument::begin();
    py_result = Shiboken::Converter<QTextBlock >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_blockCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blockCount()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextDocument::blockCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_characterAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // characterAt(int)const
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QChar cpp_result = cppSelf->QTextDocument::characterAt(cpp_arg0);
        py_result = Shiboken::Converter<QChar >::toPython(cpp_result);
    } else goto SbkQTextDocumentFunc_characterAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFunc_characterAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.characterAt", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_characterCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // characterCount()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextDocument::characterCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    cppSelf->QTextDocument::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextDocumentFunc_clone(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // clone(QObject*)const
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QTextDocument * cpp_result = cppSelf->QTextDocument::clone();
        py_result = Shiboken::Converter<QTextDocument* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (Shiboken::Converter<QObject* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // clone(QObject*)const
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QTextDocument * cpp_result = cppSelf->QTextDocument::clone(cpp_arg0);
        py_result = Shiboken::Converter<QTextDocument* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTextDocumentFunc_clone_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFunc_clone_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.clone", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_createObject(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextFormat* cpp_arg0 = Shiboken::Converter<QTextFormat* >::toCpp(arg);
        // createObject(QTextFormat)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QTextObject * cpp_result = cppSelf->QTextDocument::createObject(*cpp_arg0);
        py_result = Shiboken::Converter<QTextObject* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTextDocumentFunc_createObject_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFunc_createObject_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.createObject", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_defaultFont(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultFont()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    QFont cpp_result = cppSelf->QTextDocument::defaultFont();
    py_result = Shiboken::Converter<QFont >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_defaultStyleSheet(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultStyleSheet()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextDocument::defaultStyleSheet();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_defaultTextOption(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultTextOption()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    QTextOption cpp_result = cppSelf->QTextDocument::defaultTextOption();
    py_result = Shiboken::Converter<QTextOption >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_documentLayout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentLayout()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    QAbstractTextDocumentLayout * cpp_result = cppSelf->QTextDocument::documentLayout();
    py_result = Shiboken::Converter<QAbstractTextDocumentLayout* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_documentMargin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentMargin()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextDocument::documentMargin();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_drawContents(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "drawContents", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QPainter* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // drawContents(QPainter*,QRectF)
            QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
            cppSelf->QTextDocument::drawContents(cpp_arg0);
        } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QRectF > cpp_arg1_auto_ptr;
            QRectF* cpp_arg1 = Shiboken::Converter<QRectF* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QRectF >(cpp_arg1);
            // drawContents(QPainter*,QRectF)
            QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
            cppSelf->QTextDocument::drawContents(cpp_arg0, *cpp_arg1);
        } else goto SbkQTextDocumentFunc_drawContents_TypeError;
    } else goto SbkQTextDocumentFunc_drawContents_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_drawContents_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRectF = QRectF()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextDocument.drawContents", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_end(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // end()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    QTextBlock cpp_result = cppSelf->QTextDocument::end();
    py_result = Shiboken::Converter<QTextBlock >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_find(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "find", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // find(QString,int,QFlags<QTextDocument::FindFlag>)const
            QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
            QTextCursor cpp_result = cppSelf->QTextDocument::find(*cpp_arg0);
            py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // find(QString,int,QFlags<QTextDocument::FindFlag>)const
                QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
                QTextCursor cpp_result = cppSelf->QTextDocument::find(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
            } else if (SbkPySide_QtGui_QTextDocument_FindFlag_Check(pyargs[2])) {
                QFlags<QTextDocument::FindFlag> cpp_arg2 = Shiboken::Converter<QFlags<QTextDocument::FindFlag> >::toCpp(pyargs[2]);
                // find(QString,int,QFlags<QTextDocument::FindFlag>)const
                QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
                QTextCursor cpp_result = cppSelf->QTextDocument::find(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
            } else goto SbkQTextDocumentFunc_find_TypeError;
        } else if (Shiboken::Converter<QTextCursor& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QTextCursor* cpp_arg1 = Shiboken::Converter<QTextCursor* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // find(QString,QTextCursor,QFlags<QTextDocument::FindFlag>)const
                QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
                QTextCursor cpp_result = cppSelf->QTextDocument::find(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
            } else if (SbkPySide_QtGui_QTextDocument_FindFlag_Check(pyargs[2])) {
                QFlags<QTextDocument::FindFlag> cpp_arg2 = Shiboken::Converter<QFlags<QTextDocument::FindFlag> >::toCpp(pyargs[2]);
                // find(QString,QTextCursor,QFlags<QTextDocument::FindFlag>)const
                QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
                QTextCursor cpp_result = cppSelf->QTextDocument::find(*cpp_arg0, *cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
            } else goto SbkQTextDocumentFunc_find_TypeError;
        } else goto SbkQTextDocumentFunc_find_TypeError;
    } else if (Shiboken::Converter<QRegExp& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRegExp* cpp_arg0 = Shiboken::Converter<QRegExp* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // find(QRegExp,int,QFlags<QTextDocument::FindFlag>)const
            QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
            QTextCursor cpp_result = cppSelf->QTextDocument::find(*cpp_arg0);
            py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // find(QRegExp,int,QFlags<QTextDocument::FindFlag>)const
                QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
                QTextCursor cpp_result = cppSelf->QTextDocument::find(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
            } else if (SbkPySide_QtGui_QTextDocument_FindFlag_Check(pyargs[2])) {
                QFlags<QTextDocument::FindFlag> cpp_arg2 = Shiboken::Converter<QFlags<QTextDocument::FindFlag> >::toCpp(pyargs[2]);
                // find(QRegExp,int,QFlags<QTextDocument::FindFlag>)const
                QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
                QTextCursor cpp_result = cppSelf->QTextDocument::find(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
            } else goto SbkQTextDocumentFunc_find_TypeError;
        } else if (Shiboken::Converter<QTextCursor& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QTextCursor* cpp_arg1 = Shiboken::Converter<QTextCursor* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // find(QRegExp,QTextCursor,QFlags<QTextDocument::FindFlag>)const
                QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
                QTextCursor cpp_result = cppSelf->QTextDocument::find(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
            } else if (SbkPySide_QtGui_QTextDocument_FindFlag_Check(pyargs[2])) {
                QFlags<QTextDocument::FindFlag> cpp_arg2 = Shiboken::Converter<QFlags<QTextDocument::FindFlag> >::toCpp(pyargs[2]);
                // find(QRegExp,QTextCursor,QFlags<QTextDocument::FindFlag>)const
                QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
                QTextCursor cpp_result = cppSelf->QTextDocument::find(*cpp_arg0, *cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
            } else goto SbkQTextDocumentFunc_find_TypeError;
        } else goto SbkQTextDocumentFunc_find_TypeError;
    } else goto SbkQTextDocumentFunc_find_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFunc_find_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRegExp, PySide.QtGui.QTextCursor, PySide.QtGui.QTextDocument.FindFlags = 0", "PySide.QtCore.QRegExp, int = 0, PySide.QtGui.QTextDocument.FindFlags = 0", "PySide.QtCore.QString, PySide.QtGui.QTextCursor, PySide.QtGui.QTextDocument.FindFlags = 0", "PySide.QtCore.QString, int = 0, PySide.QtGui.QTextDocument.FindFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextDocument.find", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_findBlock(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // findBlock(int)const
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QTextBlock cpp_result = cppSelf->QTextDocument::findBlock(cpp_arg0);
        py_result = Shiboken::Converter<QTextBlock >::toPython(cpp_result);
    } else goto SbkQTextDocumentFunc_findBlock_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFunc_findBlock_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.findBlock", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_findBlockByLineNumber(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // findBlockByLineNumber(int)const
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QTextBlock cpp_result = cppSelf->QTextDocument::findBlockByLineNumber(cpp_arg0);
        py_result = Shiboken::Converter<QTextBlock >::toPython(cpp_result);
    } else goto SbkQTextDocumentFunc_findBlockByLineNumber_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFunc_findBlockByLineNumber_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.findBlockByLineNumber", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_findBlockByNumber(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // findBlockByNumber(int)const
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QTextBlock cpp_result = cppSelf->QTextDocument::findBlockByNumber(cpp_arg0);
        py_result = Shiboken::Converter<QTextBlock >::toPython(cpp_result);
    } else goto SbkQTextDocumentFunc_findBlockByNumber_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFunc_findBlockByNumber_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.findBlockByNumber", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_firstBlock(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // firstBlock()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    QTextBlock cpp_result = cppSelf->QTextDocument::firstBlock();
    py_result = Shiboken::Converter<QTextBlock >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_frameAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // frameAt(int)const
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QTextFrame * cpp_result = cppSelf->QTextDocument::frameAt(cpp_arg0);
        py_result = Shiboken::Converter<QTextFrame* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTextDocumentFunc_frameAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFunc_frameAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.frameAt", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_idealWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // idealWidth()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextDocument::idealWidth();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_indentWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // indentWidth()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextDocument::indentWidth();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextDocument::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_isModified(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isModified()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextDocument::isModified();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_isRedoAvailable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRedoAvailable()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextDocument::isRedoAvailable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_isUndoAvailable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isUndoAvailable()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextDocument::isUndoAvailable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_isUndoRedoEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isUndoRedoEnabled()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextDocument::isUndoRedoEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_lastBlock(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastBlock()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    QTextBlock cpp_result = cppSelf->QTextDocument::lastBlock();
    py_result = Shiboken::Converter<QTextBlock >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_lineCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineCount()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextDocument::lineCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_loadResource(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "loadResource", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QUrl& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
        QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QUrl& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
        // loadResource(int,QUrl)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QTextDocument::loadResource(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQTextDocumentFunc_loadResource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFunc_loadResource_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextDocument.loadResource", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_markContentsDirty(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "markContentsDirty", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // markContentsDirty(int,int)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::markContentsDirty(cpp_arg0, cpp_arg1);
    } else goto SbkQTextDocumentFunc_markContentsDirty_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_markContentsDirty_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextDocument.markContentsDirty", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_maximumBlockCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumBlockCount()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextDocument::maximumBlockCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_metaInformation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextDocument::MetaInformation >::isConvertible(arg)) {
        QTextDocument::MetaInformation cpp_arg0 = Shiboken::Converter<QTextDocument::MetaInformation >::toCpp(arg);
        // metaInformation(QTextDocument::MetaInformation)const
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTextDocument::metaInformation(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQTextDocumentFunc_metaInformation_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFunc_metaInformation_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextDocument.MetaInformation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.metaInformation", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_object(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // object(int)const
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QTextObject * cpp_result = cppSelf->QTextDocument::object(cpp_arg0);
        py_result = Shiboken::Converter<QTextObject* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTextDocumentFunc_object_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFunc_object_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.object", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_objectForFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextFormat* cpp_arg0 = Shiboken::Converter<QTextFormat* >::toCpp(arg);
        // objectForFormat(QTextFormat)const
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QTextObject * cpp_result = cppSelf->QTextDocument::objectForFormat(*cpp_arg0);
        py_result = Shiboken::Converter<QTextObject* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTextDocumentFunc_objectForFormat_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFunc_objectForFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.objectForFormat", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_pageCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pageCount()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextDocument::pageCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_pageSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pageSize()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    QSizeF cpp_result = cppSelf->QTextDocument::pageSize();
    py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_print_(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrinter* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPrinter* cpp_arg0 = Shiboken::Converter<QPrinter* >::toCpp(arg);
        // print(QPrinter*)const
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::print(cpp_arg0);
    } else goto SbkQTextDocumentFunc_print__TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_print__TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.print_", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_redo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // redo()
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    cppSelf->QTextDocument::redo();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextDocumentFunc_resource(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "resource", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QUrl& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
        QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QUrl& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
        // resource(int,QUrl)const
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QTextDocument::resource(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQTextDocumentFunc_resource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFunc_resource_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextDocument.resource", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_revision(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // revision()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextDocument::revision();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_rootFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rootFrame()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    QTextFrame * cpp_result = cppSelf->QTextDocument::rootFrame();
    py_result = Shiboken::Converter<QTextFrame* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_setDefaultFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!Shiboken::Converter<QFont& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // setDefaultFont(QFont)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setDefaultFont(*cpp_arg0);
    } else goto SbkQTextDocumentFunc_setDefaultFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setDefaultFont_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.setDefaultFont", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_setDefaultStyleSheet(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDefaultStyleSheet(QString)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setDefaultStyleSheet(*cpp_arg0);
    } else goto SbkQTextDocumentFunc_setDefaultStyleSheet_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setDefaultStyleSheet_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.setDefaultStyleSheet", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_setDefaultTextOption(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextOption& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QTextOption > cpp_arg0_auto_ptr;
        QTextOption* cpp_arg0 = Shiboken::Converter<QTextOption* >::toCpp(arg);
        if (!Shiboken::Converter<QTextOption& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QTextOption >(cpp_arg0);
        // setDefaultTextOption(QTextOption)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setDefaultTextOption(*cpp_arg0);
    } else goto SbkQTextDocumentFunc_setDefaultTextOption_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setDefaultTextOption_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextOption", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.setDefaultTextOption", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_setDocumentLayout(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractTextDocumentLayout* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractTextDocumentLayout* cpp_arg0 = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp(arg);
        // setDocumentLayout(QAbstractTextDocumentLayout*)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setDocumentLayout(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQTextDocumentFunc_setDocumentLayout_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setDocumentLayout_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractTextDocumentLayout", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.setDocumentLayout", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_setDocumentMargin(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setDocumentMargin(qreal)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setDocumentMargin(cpp_arg0);
    } else goto SbkQTextDocumentFunc_setDocumentMargin_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setDocumentMargin_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.setDocumentMargin", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_setHtml(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setHtml(QString)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setHtml(*cpp_arg0);
    } else goto SbkQTextDocumentFunc_setHtml_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setHtml_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.setHtml", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_setIndentWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setIndentWidth(qreal)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setIndentWidth(cpp_arg0);
    } else goto SbkQTextDocumentFunc_setIndentWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setIndentWidth_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.setIndentWidth", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_setMaximumBlockCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMaximumBlockCount(int)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setMaximumBlockCount(cpp_arg0);
    } else goto SbkQTextDocumentFunc_setMaximumBlockCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setMaximumBlockCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.setMaximumBlockCount", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_setMetaInformation(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setMetaInformation", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QTextDocument::MetaInformation >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        QTextDocument::MetaInformation cpp_arg0 = Shiboken::Converter<QTextDocument::MetaInformation >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setMetaInformation(QTextDocument::MetaInformation,QString)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setMetaInformation(cpp_arg0, *cpp_arg1);
    } else goto SbkQTextDocumentFunc_setMetaInformation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setMetaInformation_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextDocument.MetaInformation, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextDocument.setMetaInformation", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_setModified(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // setModified(bool)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setModified();
    } else if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setModified(bool)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setModified(cpp_arg0);
    } else goto SbkQTextDocumentFunc_setModified_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setModified_TypeError:
        const char* overloads[] = {"bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.setModified", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_setPageSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSizeF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(arg);
        if (!Shiboken::Converter<QSizeF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        // setPageSize(QSizeF)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setPageSize(*cpp_arg0);
    } else goto SbkQTextDocumentFunc_setPageSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setPageSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSizeF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.setPageSize", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_setPlainText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPlainText(QString)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setPlainText(*cpp_arg0);
    } else goto SbkQTextDocumentFunc_setPlainText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setPlainText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.setPlainText", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_setTextWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setTextWidth(qreal)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setTextWidth(cpp_arg0);
    } else goto SbkQTextDocumentFunc_setTextWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setTextWidth_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.setTextWidth", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_setUndoRedoEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setUndoRedoEnabled(bool)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setUndoRedoEnabled(cpp_arg0);
    } else goto SbkQTextDocumentFunc_setUndoRedoEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setUndoRedoEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.setUndoRedoEnabled", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_setUseDesignMetrics(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setUseDesignMetrics(bool)
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        cppSelf->QTextDocument::setUseDesignMetrics(cpp_arg0);
    } else goto SbkQTextDocumentFunc_setUseDesignMetrics_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextDocumentFunc_setUseDesignMetrics_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.setUseDesignMetrics", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    QSizeF cpp_result = cppSelf->QTextDocument::size();
    py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_textWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textWidth()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextDocument::textWidth();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_toHtml(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toHtml(QByteArray)const
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTextDocument::toHtml();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // toHtml(QByteArray)const
        QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTextDocument::toHtml(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQTextDocumentFunc_toHtml_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextDocumentFunc_toHtml_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray = QByteArray()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextDocument.toHtml", overloads);
        return 0;
}

static PyObject*
SbkQTextDocumentFunc_toPlainText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toPlainText()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextDocument::toPlainText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextDocumentFunc_undo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // undo()
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    cppSelf->QTextDocument::undo();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextDocumentFunc_useDesignMetrics(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // useDesignMetrics()const
    QTextDocument* cppSelf = Shiboken::Converter<QTextDocument* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextDocument::useDesignMetrics();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTextDocument_methods[] = {
    {"addResource", (PyCFunction)SbkQTextDocumentFunc_addResource, METH_VARARGS},
    {"adjustSize", (PyCFunction)SbkQTextDocumentFunc_adjustSize, METH_NOARGS},
    {"allFormats", (PyCFunction)SbkQTextDocumentFunc_allFormats, METH_NOARGS},
    {"availableRedoSteps", (PyCFunction)SbkQTextDocumentFunc_availableRedoSteps, METH_NOARGS},
    {"availableUndoSteps", (PyCFunction)SbkQTextDocumentFunc_availableUndoSteps, METH_NOARGS},
    {"begin", (PyCFunction)SbkQTextDocumentFunc_begin, METH_NOARGS},
    {"blockCount", (PyCFunction)SbkQTextDocumentFunc_blockCount, METH_NOARGS},
    {"characterAt", (PyCFunction)SbkQTextDocumentFunc_characterAt, METH_O},
    {"characterCount", (PyCFunction)SbkQTextDocumentFunc_characterCount, METH_NOARGS},
    {"clear", (PyCFunction)SbkQTextDocumentFunc_clear, METH_NOARGS},
    {"clone", (PyCFunction)SbkQTextDocumentFunc_clone, METH_NOARGS|METH_O},
    {"createObject", (PyCFunction)SbkQTextDocumentFunc_createObject, METH_O},
    {"defaultFont", (PyCFunction)SbkQTextDocumentFunc_defaultFont, METH_NOARGS},
    {"defaultStyleSheet", (PyCFunction)SbkQTextDocumentFunc_defaultStyleSheet, METH_NOARGS},
    {"defaultTextOption", (PyCFunction)SbkQTextDocumentFunc_defaultTextOption, METH_NOARGS},
    {"documentLayout", (PyCFunction)SbkQTextDocumentFunc_documentLayout, METH_NOARGS},
    {"documentMargin", (PyCFunction)SbkQTextDocumentFunc_documentMargin, METH_NOARGS},
    {"drawContents", (PyCFunction)SbkQTextDocumentFunc_drawContents, METH_VARARGS},
    {"end", (PyCFunction)SbkQTextDocumentFunc_end, METH_NOARGS},
    {"find", (PyCFunction)SbkQTextDocumentFunc_find, METH_VARARGS},
    {"findBlock", (PyCFunction)SbkQTextDocumentFunc_findBlock, METH_O},
    {"findBlockByLineNumber", (PyCFunction)SbkQTextDocumentFunc_findBlockByLineNumber, METH_O},
    {"findBlockByNumber", (PyCFunction)SbkQTextDocumentFunc_findBlockByNumber, METH_O},
    {"firstBlock", (PyCFunction)SbkQTextDocumentFunc_firstBlock, METH_NOARGS},
    {"frameAt", (PyCFunction)SbkQTextDocumentFunc_frameAt, METH_O},
    {"idealWidth", (PyCFunction)SbkQTextDocumentFunc_idealWidth, METH_NOARGS},
    {"indentWidth", (PyCFunction)SbkQTextDocumentFunc_indentWidth, METH_NOARGS},
    {"isEmpty", (PyCFunction)SbkQTextDocumentFunc_isEmpty, METH_NOARGS},
    {"isModified", (PyCFunction)SbkQTextDocumentFunc_isModified, METH_NOARGS},
    {"isRedoAvailable", (PyCFunction)SbkQTextDocumentFunc_isRedoAvailable, METH_NOARGS},
    {"isUndoAvailable", (PyCFunction)SbkQTextDocumentFunc_isUndoAvailable, METH_NOARGS},
    {"isUndoRedoEnabled", (PyCFunction)SbkQTextDocumentFunc_isUndoRedoEnabled, METH_NOARGS},
    {"lastBlock", (PyCFunction)SbkQTextDocumentFunc_lastBlock, METH_NOARGS},
    {"lineCount", (PyCFunction)SbkQTextDocumentFunc_lineCount, METH_NOARGS},
    {"loadResource", (PyCFunction)SbkQTextDocumentFunc_loadResource, METH_VARARGS},
    {"markContentsDirty", (PyCFunction)SbkQTextDocumentFunc_markContentsDirty, METH_VARARGS},
    {"maximumBlockCount", (PyCFunction)SbkQTextDocumentFunc_maximumBlockCount, METH_NOARGS},
    {"metaInformation", (PyCFunction)SbkQTextDocumentFunc_metaInformation, METH_O},
    {"object", (PyCFunction)SbkQTextDocumentFunc_object, METH_O},
    {"objectForFormat", (PyCFunction)SbkQTextDocumentFunc_objectForFormat, METH_O},
    {"pageCount", (PyCFunction)SbkQTextDocumentFunc_pageCount, METH_NOARGS},
    {"pageSize", (PyCFunction)SbkQTextDocumentFunc_pageSize, METH_NOARGS},
    {"print_", (PyCFunction)SbkQTextDocumentFunc_print_, METH_O},
    {"redo", (PyCFunction)SbkQTextDocumentFunc_redo, METH_NOARGS},
    {"resource", (PyCFunction)SbkQTextDocumentFunc_resource, METH_VARARGS},
    {"revision", (PyCFunction)SbkQTextDocumentFunc_revision, METH_NOARGS},
    {"rootFrame", (PyCFunction)SbkQTextDocumentFunc_rootFrame, METH_NOARGS},
    {"setDefaultFont", (PyCFunction)SbkQTextDocumentFunc_setDefaultFont, METH_O},
    {"setDefaultStyleSheet", (PyCFunction)SbkQTextDocumentFunc_setDefaultStyleSheet, METH_O},
    {"setDefaultTextOption", (PyCFunction)SbkQTextDocumentFunc_setDefaultTextOption, METH_O},
    {"setDocumentLayout", (PyCFunction)SbkQTextDocumentFunc_setDocumentLayout, METH_O},
    {"setDocumentMargin", (PyCFunction)SbkQTextDocumentFunc_setDocumentMargin, METH_O},
    {"setHtml", (PyCFunction)SbkQTextDocumentFunc_setHtml, METH_O},
    {"setIndentWidth", (PyCFunction)SbkQTextDocumentFunc_setIndentWidth, METH_O},
    {"setMaximumBlockCount", (PyCFunction)SbkQTextDocumentFunc_setMaximumBlockCount, METH_O},
    {"setMetaInformation", (PyCFunction)SbkQTextDocumentFunc_setMetaInformation, METH_VARARGS},
    {"setModified", (PyCFunction)SbkQTextDocumentFunc_setModified, METH_NOARGS|METH_O},
    {"setPageSize", (PyCFunction)SbkQTextDocumentFunc_setPageSize, METH_O},
    {"setPlainText", (PyCFunction)SbkQTextDocumentFunc_setPlainText, METH_O},
    {"setTextWidth", (PyCFunction)SbkQTextDocumentFunc_setTextWidth, METH_O},
    {"setUndoRedoEnabled", (PyCFunction)SbkQTextDocumentFunc_setUndoRedoEnabled, METH_O},
    {"setUseDesignMetrics", (PyCFunction)SbkQTextDocumentFunc_setUseDesignMetrics, METH_O},
    {"size", (PyCFunction)SbkQTextDocumentFunc_size, METH_NOARGS},
    {"textWidth", (PyCFunction)SbkQTextDocumentFunc_textWidth, METH_NOARGS},
    {"toHtml", (PyCFunction)SbkQTextDocumentFunc_toHtml, METH_NOARGS|METH_O},
    {"toPlainText", (PyCFunction)SbkQTextDocumentFunc_toPlainText, METH_NOARGS},
    {"undo", (PyCFunction)SbkQTextDocumentFunc_undo, METH_NOARGS},
    {"useDesignMetrics", (PyCFunction)SbkQTextDocumentFunc_useDesignMetrics, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextDocument_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextDocument",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTextDocumentWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextDocument_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextDocument_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QTextDocument_ResourceType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextDocument_ResourceType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextDocument_ResourceType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ResourceType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextDocument_ResourceType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextDocument_ResourceType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTextDocument_ResourceType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QTextDocument_FindFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextDocument::FindFlags >::toPython(
        ((QTextDocument::FindFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QTextDocument::FindFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextDocument_FindFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextDocument::FindFlags >::toPython(
        ((QTextDocument::FindFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QTextDocument::FindFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextDocument_FindFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextDocument::FindFlags >::toPython(
        ((QTextDocument::FindFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QTextDocument::FindFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextDocument_FindFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextDocument::FindFlags >::toPython(
        ~ Shiboken::Converter< QTextDocument::FindFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QTextDocument_FindFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QTextDocument_FindFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QTextDocument_FindFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QTextDocument_FindFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QTextDocument_FindFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QTextDocument_FindFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextDocument_FindFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextDocument_FindFlag_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FindFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QTextDocument_FindFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextDocument_FindFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextDocument_FindFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTextDocument_FindFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextDocument_FindFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextDocument_FindFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FindFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QTextDocument_FindFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextDocument_FindFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTextDocument_FindFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QTextDocument_FindFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QTextDocument_MetaInformation_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextDocument_MetaInformation_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextDocument_MetaInformation_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MetaInformation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextDocument_MetaInformation_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextDocument_MetaInformation_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTextDocument_MetaInformation_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QTextDocument(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextDocument_Type);

    SbkQTextDocument_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQTextDocument_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTextDocument_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextDocument_Type));
    PyModule_AddObject(module, "QTextDocument",
        ((PyObject*)&SbkQTextDocument_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ResourceType
    SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX] = &SbkPySide_QtGui_QTextDocument_ResourceType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextDocument_ResourceType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextDocument_ResourceType_Type);
    PyDict_SetItemString(SbkQTextDocument_Type.super.ht_type.tp_dict,
            "ResourceType",((PyObject*)&SbkPySide_QtGui_QTextDocument_ResourceType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextDocument_ResourceType_Type,
        (long) QTextDocument::HtmlResource, "HtmlResource");
    PyDict_SetItemString(SbkQTextDocument_Type.super.ht_type.tp_dict,
        "HtmlResource", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextDocument_ResourceType_Type.tp_dict,
        "HtmlResource", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextDocument_ResourceType_Type,
        (long) QTextDocument::ImageResource, "ImageResource");
    PyDict_SetItemString(SbkQTextDocument_Type.super.ht_type.tp_dict,
        "ImageResource", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextDocument_ResourceType_Type.tp_dict,
        "ImageResource", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextDocument_ResourceType_Type,
        (long) QTextDocument::StyleSheetResource, "StyleSheetResource");
    PyDict_SetItemString(SbkQTextDocument_Type.super.ht_type.tp_dict,
        "StyleSheetResource", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextDocument_ResourceType_Type.tp_dict,
        "StyleSheetResource", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextDocument_ResourceType_Type,
        (long) QTextDocument::UserResource, "UserResource");
    PyDict_SetItemString(SbkQTextDocument_Type.super.ht_type.tp_dict,
        "UserResource", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextDocument_ResourceType_Type.tp_dict,
        "UserResource", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextDocument::ResourceType");

    // init enum class: FindFlag
    SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENT_FINDFLAG_IDX] = &SbkPySide_QtGui_QTextDocument_FindFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextDocument_FindFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextDocument_FindFlag_Type);
    PyDict_SetItemString(SbkQTextDocument_Type.super.ht_type.tp_dict,
            "FindFlag",((PyObject*)&SbkPySide_QtGui_QTextDocument_FindFlag_Type));

    // init flags class: QFlags<QTextDocument::FindFlag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG__IDX] = &SbkPySide_QtGui_QTextDocument_FindFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextDocument_FindFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextDocument_FindFlags_Type);
    PyDict_SetItemString(SbkQTextDocument_Type.super.ht_type.tp_dict,
            "FindFlags",((PyObject*)&SbkPySide_QtGui_QTextDocument_FindFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextDocument_FindFlag_Type,
        (long) QTextDocument::FindBackward, "FindBackward");
    PyDict_SetItemString(SbkQTextDocument_Type.super.ht_type.tp_dict,
        "FindBackward", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextDocument_FindFlag_Type.tp_dict,
        "FindBackward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextDocument_FindFlag_Type,
        (long) QTextDocument::FindCaseSensitively, "FindCaseSensitively");
    PyDict_SetItemString(SbkQTextDocument_Type.super.ht_type.tp_dict,
        "FindCaseSensitively", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextDocument_FindFlag_Type.tp_dict,
        "FindCaseSensitively", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextDocument_FindFlag_Type,
        (long) QTextDocument::FindWholeWords, "FindWholeWords");
    PyDict_SetItemString(SbkQTextDocument_Type.super.ht_type.tp_dict,
        "FindWholeWords", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextDocument_FindFlag_Type.tp_dict,
        "FindWholeWords", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextDocument::FindFlag");

    // init enum class: MetaInformation
    SbkPySide_QtGuiTypes[SBK_QTEXTDOCUMENT_METAINFORMATION_IDX] = &SbkPySide_QtGui_QTextDocument_MetaInformation_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextDocument_MetaInformation_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextDocument_MetaInformation_Type);
    PyDict_SetItemString(SbkQTextDocument_Type.super.ht_type.tp_dict,
            "MetaInformation",((PyObject*)&SbkPySide_QtGui_QTextDocument_MetaInformation_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextDocument_MetaInformation_Type,
        (long) QTextDocument::DocumentTitle, "DocumentTitle");
    PyDict_SetItemString(SbkQTextDocument_Type.super.ht_type.tp_dict,
        "DocumentTitle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextDocument_MetaInformation_Type.tp_dict,
        "DocumentTitle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextDocument_MetaInformation_Type,
        (long) QTextDocument::DocumentUrl, "DocumentUrl");
    PyDict_SetItemString(SbkQTextDocument_Type.super.ht_type.tp_dict,
        "DocumentUrl", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextDocument_MetaInformation_Type.tp_dict,
        "DocumentUrl", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextDocument::MetaInformation");

    Shiboken::TypeResolver::createObjectTypeResolver<QTextDocument >("QTextDocument*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTextDocument >(typeid(QTextDocument).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

