/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstyleoptionviewitemv4_wrapper.h"

// Extra includes
#include <qstyleoption.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStyleOptionViewItemV4_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleOptionViewItemV4* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStyleOptionViewItemV4", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStyleOptionViewItemV4()
        cptr = new QStyleOptionViewItemV4();
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QStyleOptionViewItemV4(int)
        cptr = new QStyleOptionViewItemV4(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionViewItem& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStyleOptionViewItem* cpp_arg0 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[0]);
        // QStyleOptionViewItemV4(QStyleOptionViewItem)
        cptr = new QStyleOptionViewItemV4(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionViewItemV4& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QStyleOptionViewItemV4 > cpp_arg0_auto_ptr;
        QStyleOptionViewItemV4* cpp_arg0 = Shiboken::Converter<QStyleOptionViewItemV4* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QStyleOptionViewItemV4& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QStyleOptionViewItemV4 >(cpp_arg0);
        // QStyleOptionViewItemV4(QStyleOptionViewItemV4)
        cptr = new QStyleOptionViewItemV4(*cpp_arg0);
    } else goto SbkQStyleOptionViewItemV4_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyleOptionViewItemV4_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQStyleOptionViewItemV4_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QStyleOptionViewItem", "PySide.QtGui.QStyleOptionViewItemV4", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyleOptionViewItemV4", overloads);
        return -1;
}

static PyMethodDef SbkQStyleOptionViewItemV4_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQStyleOptionViewItemV4_get_checkState(SbkBaseWrapper* self)
{
    return Shiboken::Converter<Qt::CheckState >::toPython(Shiboken::Converter<QStyleOptionViewItemV4* >::toCpp((PyObject*)self)->checkState);
}
static int SbkQStyleOptionViewItemV4_set_checkState(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'checkState' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<Qt::CheckState >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'checkState', 'CheckState' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionViewItemV4* >::toCpp((PyObject*)self)->checkState = Shiboken::Converter<Qt::CheckState >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionViewItemV4_get_viewItemPosition(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QStyleOptionViewItemV4::ViewItemPosition >::toPython(Shiboken::Converter<QStyleOptionViewItemV4* >::toCpp((PyObject*)self)->viewItemPosition);
}
static int SbkQStyleOptionViewItemV4_set_viewItemPosition(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'viewItemPosition' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QStyleOptionViewItemV4::ViewItemPosition >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'viewItemPosition', 'ViewItemPosition' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionViewItemV4* >::toCpp((PyObject*)self)->viewItemPosition = Shiboken::Converter<QStyleOptionViewItemV4::ViewItemPosition >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionViewItemV4_get_icon(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QIcon >::toPython(Shiboken::Converter<QStyleOptionViewItemV4* >::toCpp((PyObject*)self)->icon);
}
static int SbkQStyleOptionViewItemV4_set_icon(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'icon' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QIcon >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'icon', 'QIcon' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionViewItemV4* >::toCpp((PyObject*)self)->icon = Shiboken::Converter<QIcon >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionViewItemV4_get_backgroundBrush(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QBrush >::toPython(Shiboken::Converter<QStyleOptionViewItemV4* >::toCpp((PyObject*)self)->backgroundBrush);
}
static int SbkQStyleOptionViewItemV4_set_backgroundBrush(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'backgroundBrush' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QBrush >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'backgroundBrush', 'QBrush' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionViewItemV4* >::toCpp((PyObject*)self)->backgroundBrush = Shiboken::Converter<QBrush >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionViewItemV4_get_index(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QModelIndex >::toPython(Shiboken::Converter<QStyleOptionViewItemV4* >::toCpp((PyObject*)self)->index);
}
static int SbkQStyleOptionViewItemV4_set_index(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'index' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QModelIndex >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'index', 'QModelIndex' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionViewItemV4* >::toCpp((PyObject*)self)->index = Shiboken::Converter<QModelIndex >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionViewItemV4_get_text(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QString >::toPython(Shiboken::Converter<QStyleOptionViewItemV4* >::toCpp((PyObject*)self)->text);
}
static int SbkQStyleOptionViewItemV4_set_text(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'text' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QString >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'text', 'QString' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionViewItemV4* >::toCpp((PyObject*)self)->text = Shiboken::Converter<QString >::toCpp(value);

    return 0;
}

// Getters and Setters for QStyleOptionViewItemV4
static PyGetSetDef SbkQStyleOptionViewItemV4_getsetlist[] = {
    {const_cast<char*>("checkState"), (getter)SbkQStyleOptionViewItemV4_get_checkState, (setter)SbkQStyleOptionViewItemV4_set_checkState},
    {const_cast<char*>("viewItemPosition"), (getter)SbkQStyleOptionViewItemV4_get_viewItemPosition, (setter)SbkQStyleOptionViewItemV4_set_viewItemPosition},
    {const_cast<char*>("icon"), (getter)SbkQStyleOptionViewItemV4_get_icon, (setter)SbkQStyleOptionViewItemV4_set_icon},
    {const_cast<char*>("backgroundBrush"), (getter)SbkQStyleOptionViewItemV4_get_backgroundBrush, (setter)SbkQStyleOptionViewItemV4_set_backgroundBrush},
    {const_cast<char*>("index"), (getter)SbkQStyleOptionViewItemV4_get_index, (setter)SbkQStyleOptionViewItemV4_set_index},
    {const_cast<char*>("text"), (getter)SbkQStyleOptionViewItemV4_get_text, (setter)SbkQStyleOptionViewItemV4_set_text},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyleOptionViewItemV4_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyleOptionViewItemV4",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QStyleOptionViewItemV4 >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyleOptionViewItemV4_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQStyleOptionViewItemV4_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyleOptionViewItemV4_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ViewItemPosition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionViewItemV4_StyleOptionVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionViewItemV4_StyleOptionVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionViewItemV4_StyleOptionVersion_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionViewItemV4_StyleOptionVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionViewItemV4_StyleOptionVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionViewItemV4_StyleOptionVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QStyleOptionViewItemV4(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV4_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyleOptionViewItemV4_Type);

    SbkQStyleOptionViewItemV4_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV3_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQStyleOptionViewItemV4_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyleOptionViewItemV4_Type));
    PyModule_AddObject(module, "QStyleOptionViewItemV4",
        ((PyObject*)&SbkQStyleOptionViewItemV4_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ViewItemPosition
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV4_VIEWITEMPOSITION_IDX] = &SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type);
    PyDict_SetItemString(SbkQStyleOptionViewItemV4_Type.super.ht_type.tp_dict,
            "ViewItemPosition",((PyObject*)&SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type,
        (long) QStyleOptionViewItemV4::Invalid, "Invalid");
    PyDict_SetItemString(SbkQStyleOptionViewItemV4_Type.super.ht_type.tp_dict,
        "Invalid", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type.tp_dict,
        "Invalid", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type,
        (long) QStyleOptionViewItemV4::Beginning, "Beginning");
    PyDict_SetItemString(SbkQStyleOptionViewItemV4_Type.super.ht_type.tp_dict,
        "Beginning", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type.tp_dict,
        "Beginning", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type,
        (long) QStyleOptionViewItemV4::Middle, "Middle");
    PyDict_SetItemString(SbkQStyleOptionViewItemV4_Type.super.ht_type.tp_dict,
        "Middle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type.tp_dict,
        "Middle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type,
        (long) QStyleOptionViewItemV4::End, "End");
    PyDict_SetItemString(SbkQStyleOptionViewItemV4_Type.super.ht_type.tp_dict,
        "End", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type.tp_dict,
        "End", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type,
        (long) QStyleOptionViewItemV4::OnlyOne, "OnlyOne");
    PyDict_SetItemString(SbkQStyleOptionViewItemV4_Type.super.ht_type.tp_dict,
        "OnlyOne", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItemV4_ViewItemPosition_Type.tp_dict,
        "OnlyOne", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionViewItemV4::ViewItemPosition");

    // init enum class: StyleOptionVersion
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV4_STYLEOPTIONVERSION_IDX] = &SbkPySide_QtGui_QStyleOptionViewItemV4_StyleOptionVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionViewItemV4_StyleOptionVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionViewItemV4_StyleOptionVersion_Type);
    PyDict_SetItemString(SbkQStyleOptionViewItemV4_Type.super.ht_type.tp_dict,
            "StyleOptionVersion",((PyObject*)&SbkPySide_QtGui_QStyleOptionViewItemV4_StyleOptionVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItemV4_StyleOptionVersion_Type,
        (long) QStyleOptionViewItemV4::Version, "Version");
    PyDict_SetItemString(SbkQStyleOptionViewItemV4_Type.super.ht_type.tp_dict,
        "Version", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItemV4_StyleOptionVersion_Type.tp_dict,
        "Version", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionViewItemV4::StyleOptionVersion");

    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionViewItemV4 >("QStyleOptionViewItemV4");
    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionViewItemV4 >(typeid(QStyleOptionViewItemV4).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

