/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstyleoptionslider_wrapper.h"

// Extra includes
#include <qstyleoption.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStyleOptionSlider_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleOptionSlider* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStyleOptionSlider", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStyleOptionSlider()
        cptr = new QStyleOptionSlider();
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QStyleOptionSlider(int)
        cptr = new QStyleOptionSlider(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionSlider& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStyleOptionSlider* cpp_arg0 = Shiboken::Converter<QStyleOptionSlider* >::toCpp(pyargs[0]);
        // QStyleOptionSlider(QStyleOptionSlider)
        cptr = new QStyleOptionSlider(*cpp_arg0);
    } else goto SbkQStyleOptionSlider_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyleOptionSlider_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQStyleOptionSlider_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QStyleOptionSlider", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyleOptionSlider", overloads);
        return -1;
}

static PyMethodDef SbkQStyleOptionSlider_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQStyleOptionSlider_get_tickInterval(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->tickInterval);
}
static int SbkQStyleOptionSlider_set_tickInterval(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'tickInterval' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'tickInterval', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->tickInterval = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionSlider_get_minimum(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->minimum);
}
static int SbkQStyleOptionSlider_set_minimum(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'minimum' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'minimum', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->minimum = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionSlider_get_notchTarget(SbkBaseWrapper* self)
{
    return Shiboken::Converter<double >::toPython(Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->notchTarget);
}
static int SbkQStyleOptionSlider_set_notchTarget(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'notchTarget' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'notchTarget', 'qreal' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->notchTarget = Shiboken::Converter<double >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionSlider_get_maximum(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->maximum);
}
static int SbkQStyleOptionSlider_set_maximum(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'maximum' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'maximum', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->maximum = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionSlider_get_sliderPosition(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->sliderPosition);
}
static int SbkQStyleOptionSlider_set_sliderPosition(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'sliderPosition' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'sliderPosition', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->sliderPosition = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionSlider_get_dialWrapping(SbkBaseWrapper* self)
{
    return Shiboken::Converter<bool >::toPython(Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->dialWrapping);
}
static int SbkQStyleOptionSlider_set_dialWrapping(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'dialWrapping' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'dialWrapping', 'bool' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->dialWrapping = Shiboken::Converter<bool >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionSlider_get_sliderValue(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->sliderValue);
}
static int SbkQStyleOptionSlider_set_sliderValue(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'sliderValue' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'sliderValue', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->sliderValue = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionSlider_get_singleStep(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->singleStep);
}
static int SbkQStyleOptionSlider_set_singleStep(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'singleStep' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'singleStep', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->singleStep = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionSlider_get_tickPosition(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QSlider::TickPosition >::toPython(Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->tickPosition);
}
static int SbkQStyleOptionSlider_set_tickPosition(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'tickPosition' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QSlider::TickPosition >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'tickPosition', 'TickPosition' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->tickPosition = Shiboken::Converter<QSlider::TickPosition >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionSlider_get_pageStep(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->pageStep);
}
static int SbkQStyleOptionSlider_set_pageStep(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'pageStep' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'pageStep', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->pageStep = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionSlider_get_orientation(SbkBaseWrapper* self)
{
    return Shiboken::Converter<Qt::Orientation >::toPython(Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->orientation);
}
static int SbkQStyleOptionSlider_set_orientation(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'orientation' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<Qt::Orientation >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'orientation', 'Orientation' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->orientation = Shiboken::Converter<Qt::Orientation >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionSlider_get_upsideDown(SbkBaseWrapper* self)
{
    return Shiboken::Converter<bool >::toPython(Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->upsideDown);
}
static int SbkQStyleOptionSlider_set_upsideDown(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'upsideDown' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'upsideDown', 'bool' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionSlider* >::toCpp((PyObject*)self)->upsideDown = Shiboken::Converter<bool >::toCpp(value);

    return 0;
}

// Getters and Setters for QStyleOptionSlider
static PyGetSetDef SbkQStyleOptionSlider_getsetlist[] = {
    {const_cast<char*>("tickInterval"), (getter)SbkQStyleOptionSlider_get_tickInterval, (setter)SbkQStyleOptionSlider_set_tickInterval},
    {const_cast<char*>("minimum"), (getter)SbkQStyleOptionSlider_get_minimum, (setter)SbkQStyleOptionSlider_set_minimum},
    {const_cast<char*>("notchTarget"), (getter)SbkQStyleOptionSlider_get_notchTarget, (setter)SbkQStyleOptionSlider_set_notchTarget},
    {const_cast<char*>("maximum"), (getter)SbkQStyleOptionSlider_get_maximum, (setter)SbkQStyleOptionSlider_set_maximum},
    {const_cast<char*>("sliderPosition"), (getter)SbkQStyleOptionSlider_get_sliderPosition, (setter)SbkQStyleOptionSlider_set_sliderPosition},
    {const_cast<char*>("dialWrapping"), (getter)SbkQStyleOptionSlider_get_dialWrapping, (setter)SbkQStyleOptionSlider_set_dialWrapping},
    {const_cast<char*>("sliderValue"), (getter)SbkQStyleOptionSlider_get_sliderValue, (setter)SbkQStyleOptionSlider_set_sliderValue},
    {const_cast<char*>("singleStep"), (getter)SbkQStyleOptionSlider_get_singleStep, (setter)SbkQStyleOptionSlider_set_singleStep},
    {const_cast<char*>("tickPosition"), (getter)SbkQStyleOptionSlider_get_tickPosition, (setter)SbkQStyleOptionSlider_set_tickPosition},
    {const_cast<char*>("pageStep"), (getter)SbkQStyleOptionSlider_get_pageStep, (setter)SbkQStyleOptionSlider_set_pageStep},
    {const_cast<char*>("orientation"), (getter)SbkQStyleOptionSlider_get_orientation, (setter)SbkQStyleOptionSlider_set_orientation},
    {const_cast<char*>("upsideDown"), (getter)SbkQStyleOptionSlider_get_upsideDown, (setter)SbkQStyleOptionSlider_set_upsideDown},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyleOptionSlider_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyleOptionSlider",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QStyleOptionSlider >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyleOptionSlider_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQStyleOptionSlider_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyleOptionSlider_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QStyleOptionSlider_StyleOptionVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionSlider_StyleOptionVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionSlider_StyleOptionVersion_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionSlider_StyleOptionVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionSlider_StyleOptionVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionSlider_StyleOptionVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionSlider_StyleOptionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionSlider_StyleOptionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionSlider_StyleOptionType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionSlider_StyleOptionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionSlider_StyleOptionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionSlider_StyleOptionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QStyleOptionSlider(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSLIDER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyleOptionSlider_Type);

    SbkQStyleOptionSlider_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMPLEX_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQStyleOptionSlider_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyleOptionSlider_Type));
    PyModule_AddObject(module, "QStyleOptionSlider",
        ((PyObject*)&SbkQStyleOptionSlider_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleOptionVersion
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSLIDER_STYLEOPTIONVERSION_IDX] = &SbkPySide_QtGui_QStyleOptionSlider_StyleOptionVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionSlider_StyleOptionVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionSlider_StyleOptionVersion_Type);
    PyDict_SetItemString(SbkQStyleOptionSlider_Type.super.ht_type.tp_dict,
            "StyleOptionVersion",((PyObject*)&SbkPySide_QtGui_QStyleOptionSlider_StyleOptionVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionSlider_StyleOptionVersion_Type,
        (long) QStyleOptionSlider::Version, "Version");
    PyDict_SetItemString(SbkQStyleOptionSlider_Type.super.ht_type.tp_dict,
        "Version", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionSlider_StyleOptionVersion_Type.tp_dict,
        "Version", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionSlider::StyleOptionVersion");

    // init enum class: StyleOptionType
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONSLIDER_STYLEOPTIONTYPE_IDX] = &SbkPySide_QtGui_QStyleOptionSlider_StyleOptionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionSlider_StyleOptionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionSlider_StyleOptionType_Type);
    PyDict_SetItemString(SbkQStyleOptionSlider_Type.super.ht_type.tp_dict,
            "StyleOptionType",((PyObject*)&SbkPySide_QtGui_QStyleOptionSlider_StyleOptionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionSlider_StyleOptionType_Type,
        (long) QStyleOptionSlider::Type, "Type");
    PyDict_SetItemString(SbkQStyleOptionSlider_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionSlider_StyleOptionType_Type.tp_dict,
        "Type", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionSlider::StyleOptionType");

    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionSlider >("QStyleOptionSlider");
    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionSlider >(typeid(QStyleOptionSlider).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

