/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstyleoptionmenuitem_wrapper.h"

// Extra includes
#include <qstyleoption.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStyleOptionMenuItem_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleOptionMenuItem* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStyleOptionMenuItem", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStyleOptionMenuItem()
        cptr = new QStyleOptionMenuItem();
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QStyleOptionMenuItem(int)
        cptr = new QStyleOptionMenuItem(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionMenuItem& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStyleOptionMenuItem* cpp_arg0 = Shiboken::Converter<QStyleOptionMenuItem* >::toCpp(pyargs[0]);
        // QStyleOptionMenuItem(QStyleOptionMenuItem)
        cptr = new QStyleOptionMenuItem(*cpp_arg0);
    } else goto SbkQStyleOptionMenuItem_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyleOptionMenuItem_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQStyleOptionMenuItem_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QStyleOptionMenuItem", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyleOptionMenuItem", overloads);
        return -1;
}

static PyMethodDef SbkQStyleOptionMenuItem_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQStyleOptionMenuItem_get_menuHasCheckableItems(SbkBaseWrapper* self)
{
    return Shiboken::Converter<bool >::toPython(Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->menuHasCheckableItems);
}
static int SbkQStyleOptionMenuItem_set_menuHasCheckableItems(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'menuHasCheckableItems' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'menuHasCheckableItems', 'bool' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->menuHasCheckableItems = Shiboken::Converter<bool >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionMenuItem_get_menuRect(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QRect >::toPython(Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->menuRect);
}
static int SbkQStyleOptionMenuItem_set_menuRect(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'menuRect' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QRect >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'menuRect', 'QRect' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->menuRect = Shiboken::Converter<QRect >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionMenuItem_get_checkType(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QStyleOptionMenuItem::CheckType >::toPython(Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->checkType);
}
static int SbkQStyleOptionMenuItem_set_checkType(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'checkType' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QStyleOptionMenuItem::CheckType >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'checkType', 'CheckType' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->checkType = Shiboken::Converter<QStyleOptionMenuItem::CheckType >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionMenuItem_get_icon(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QIcon >::toPython(Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->icon);
}
static int SbkQStyleOptionMenuItem_set_icon(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'icon' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QIcon >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'icon', 'QIcon' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->icon = Shiboken::Converter<QIcon >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionMenuItem_get_checked(SbkBaseWrapper* self)
{
    return Shiboken::Converter<bool >::toPython(Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->checked);
}
static int SbkQStyleOptionMenuItem_set_checked(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'checked' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'checked', 'bool' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->checked = Shiboken::Converter<bool >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionMenuItem_get_maxIconWidth(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->maxIconWidth);
}
static int SbkQStyleOptionMenuItem_set_maxIconWidth(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'maxIconWidth' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'maxIconWidth', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->maxIconWidth = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionMenuItem_get_tabWidth(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->tabWidth);
}
static int SbkQStyleOptionMenuItem_set_tabWidth(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'tabWidth' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'tabWidth', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->tabWidth = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionMenuItem_get_text(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QString >::toPython(Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->text);
}
static int SbkQStyleOptionMenuItem_set_text(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'text' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QString >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'text', 'QString' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->text = Shiboken::Converter<QString >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionMenuItem_get_font(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFont >::toPython(Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->font);
}
static int SbkQStyleOptionMenuItem_set_font(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'font' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QFont >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'font', 'QFont' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->font = Shiboken::Converter<QFont >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionMenuItem_get_menuItemType(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QStyleOptionMenuItem::MenuItemType >::toPython(Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->menuItemType);
}
static int SbkQStyleOptionMenuItem_set_menuItemType(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'menuItemType' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QStyleOptionMenuItem::MenuItemType >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'menuItemType', 'MenuItemType' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionMenuItem* >::toCpp((PyObject*)self)->menuItemType = Shiboken::Converter<QStyleOptionMenuItem::MenuItemType >::toCpp(value);

    return 0;
}

// Getters and Setters for QStyleOptionMenuItem
static PyGetSetDef SbkQStyleOptionMenuItem_getsetlist[] = {
    {const_cast<char*>("menuHasCheckableItems"), (getter)SbkQStyleOptionMenuItem_get_menuHasCheckableItems, (setter)SbkQStyleOptionMenuItem_set_menuHasCheckableItems},
    {const_cast<char*>("menuRect"), (getter)SbkQStyleOptionMenuItem_get_menuRect, (setter)SbkQStyleOptionMenuItem_set_menuRect},
    {const_cast<char*>("checkType"), (getter)SbkQStyleOptionMenuItem_get_checkType, (setter)SbkQStyleOptionMenuItem_set_checkType},
    {const_cast<char*>("icon"), (getter)SbkQStyleOptionMenuItem_get_icon, (setter)SbkQStyleOptionMenuItem_set_icon},
    {const_cast<char*>("checked"), (getter)SbkQStyleOptionMenuItem_get_checked, (setter)SbkQStyleOptionMenuItem_set_checked},
    {const_cast<char*>("maxIconWidth"), (getter)SbkQStyleOptionMenuItem_get_maxIconWidth, (setter)SbkQStyleOptionMenuItem_set_maxIconWidth},
    {const_cast<char*>("tabWidth"), (getter)SbkQStyleOptionMenuItem_get_tabWidth, (setter)SbkQStyleOptionMenuItem_set_tabWidth},
    {const_cast<char*>("text"), (getter)SbkQStyleOptionMenuItem_get_text, (setter)SbkQStyleOptionMenuItem_set_text},
    {const_cast<char*>("font"), (getter)SbkQStyleOptionMenuItem_get_font, (setter)SbkQStyleOptionMenuItem_set_font},
    {const_cast<char*>("menuItemType"), (getter)SbkQStyleOptionMenuItem_get_menuItemType, (setter)SbkQStyleOptionMenuItem_set_menuItemType},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyleOptionMenuItem_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyleOptionMenuItem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QStyleOptionMenuItem >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyleOptionMenuItem_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQStyleOptionMenuItem_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyleOptionMenuItem_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionVersion_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CheckType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MenuItemType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QStyleOptionMenuItem(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyleOptionMenuItem_Type);

    SbkQStyleOptionMenuItem_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQStyleOptionMenuItem_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyleOptionMenuItem_Type));
    PyModule_AddObject(module, "QStyleOptionMenuItem",
        ((PyObject*)&SbkQStyleOptionMenuItem_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleOptionVersion
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONVERSION_IDX] = &SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionVersion_Type);
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
            "StyleOptionVersion",((PyObject*)&SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionVersion_Type,
        (long) QStyleOptionMenuItem::Version, "Version");
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
        "Version", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionVersion_Type.tp_dict,
        "Version", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionMenuItem::StyleOptionVersion");

    // init enum class: StyleOptionType
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONTYPE_IDX] = &SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionType_Type);
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
            "StyleOptionType",((PyObject*)&SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionType_Type,
        (long) QStyleOptionMenuItem::Type, "Type");
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionMenuItem_StyleOptionType_Type.tp_dict,
        "Type", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionMenuItem::StyleOptionType");

    // init enum class: CheckType
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX] = &SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_Type);
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
            "CheckType",((PyObject*)&SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_Type,
        (long) QStyleOptionMenuItem::NotCheckable, "NotCheckable");
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
        "NotCheckable", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_Type.tp_dict,
        "NotCheckable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_Type,
        (long) QStyleOptionMenuItem::Exclusive, "Exclusive");
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
        "Exclusive", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_Type.tp_dict,
        "Exclusive", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_Type,
        (long) QStyleOptionMenuItem::NonExclusive, "NonExclusive");
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
        "NonExclusive", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionMenuItem_CheckType_Type.tp_dict,
        "NonExclusive", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionMenuItem::CheckType");

    // init enum class: MenuItemType
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX] = &SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type);
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
            "MenuItemType",((PyObject*)&SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type,
        (long) QStyleOptionMenuItem::Normal, "Normal");
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
        "Normal", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type.tp_dict,
        "Normal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type,
        (long) QStyleOptionMenuItem::DefaultItem, "DefaultItem");
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
        "DefaultItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type.tp_dict,
        "DefaultItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type,
        (long) QStyleOptionMenuItem::Separator, "Separator");
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
        "Separator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type.tp_dict,
        "Separator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type,
        (long) QStyleOptionMenuItem::SubMenu, "SubMenu");
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
        "SubMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type.tp_dict,
        "SubMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type,
        (long) QStyleOptionMenuItem::Scroller, "Scroller");
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
        "Scroller", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type.tp_dict,
        "Scroller", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type,
        (long) QStyleOptionMenuItem::TearOff, "TearOff");
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
        "TearOff", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type.tp_dict,
        "TearOff", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type,
        (long) QStyleOptionMenuItem::Margin, "Margin");
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
        "Margin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type.tp_dict,
        "Margin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type,
        (long) QStyleOptionMenuItem::EmptyArea, "EmptyArea");
    PyDict_SetItemString(SbkQStyleOptionMenuItem_Type.super.ht_type.tp_dict,
        "EmptyArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionMenuItem_MenuItemType_Type.tp_dict,
        "EmptyArea", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionMenuItem::MenuItemType");

    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionMenuItem >("QStyleOptionMenuItem");
    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionMenuItem >(typeid(QStyleOptionMenuItem).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

