/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstyleoption_wrapper.h"

// Extra includes
#include <qstyleoption.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStyleOption_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleOption* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QStyleOption", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QStyleOption(int,int)
        cptr = new QStyleOption();
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QStyleOption(int,int)
            cptr = new QStyleOption(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // QStyleOption(int,int)
            cptr = new QStyleOption(cpp_arg0, cpp_arg1);
        } else goto SbkQStyleOption_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOption& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStyleOption* cpp_arg0 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[0]);
        // QStyleOption(QStyleOption)
        cptr = new QStyleOption(*cpp_arg0);
    } else goto SbkQStyleOption_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyleOption_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQStyleOption_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyleOption", "int = QStyleOption.Version, int = SO_Default", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyleOption", overloads);
        return -1;
}

static PyObject*
SbkQStyleOptionFunc_initFrom(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // initFrom(const QWidget*)
        QStyleOption* cppSelf = Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self);
        cppSelf->QStyleOption::initFrom(cpp_arg0);
    } else goto SbkQStyleOptionFunc_initFrom_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStyleOptionFunc_initFrom_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStyleOption.initFrom", overloads);
        return 0;
}

static PyMethodDef SbkQStyleOption_methods[] = {
    {"initFrom", (PyCFunction)SbkQStyleOptionFunc_initFrom, METH_O},
    {0} // Sentinel
};

static PyObject* SbkQStyleOption_get_palette(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPalette >::toPython(Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self)->palette);
}
static int SbkQStyleOption_set_palette(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'palette' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPalette >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'palette', 'QPalette' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self)->palette = Shiboken::Converter<QPalette >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOption_get_version(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self)->version);
}
static int SbkQStyleOption_set_version(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'version' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'version', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self)->version = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOption_get_direction(SbkBaseWrapper* self)
{
    return Shiboken::Converter<Qt::LayoutDirection >::toPython(Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self)->direction);
}
static int SbkQStyleOption_set_direction(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'direction' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<Qt::LayoutDirection >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'direction', 'LayoutDirection' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self)->direction = Shiboken::Converter<Qt::LayoutDirection >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOption_get_rect(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QRect >::toPython(Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self)->rect);
}
static int SbkQStyleOption_set_rect(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'rect' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QRect >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'rect', 'QRect' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self)->rect = Shiboken::Converter<QRect >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOption_get_type(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self)->type);
}
static int SbkQStyleOption_set_type(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'type' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'type', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self)->type = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOption_get_state(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<QStyle::StateFlag> >::toPython(Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self)->state);
}
static int SbkQStyleOption_set_state(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'state' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtGui_QStyle_StateFlag_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'state', 'State' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self)->state = Shiboken::Converter<QFlags<QStyle::StateFlag> >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOption_get_fontMetrics(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFontMetrics >::toPython(Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self)->fontMetrics);
}
static int SbkQStyleOption_set_fontMetrics(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'fontMetrics' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QFontMetrics >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'fontMetrics', 'QFontMetrics' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOption* >::toCpp((PyObject*)self)->fontMetrics = Shiboken::Converter<QFontMetrics >::toCpp(value);

    return 0;
}

// Getters and Setters for QStyleOption
static PyGetSetDef SbkQStyleOption_getsetlist[] = {
    {const_cast<char*>("palette"), (getter)SbkQStyleOption_get_palette, (setter)SbkQStyleOption_set_palette},
    {const_cast<char*>("version"), (getter)SbkQStyleOption_get_version, (setter)SbkQStyleOption_set_version},
    {const_cast<char*>("direction"), (getter)SbkQStyleOption_get_direction, (setter)SbkQStyleOption_set_direction},
    {const_cast<char*>("rect"), (getter)SbkQStyleOption_get_rect, (setter)SbkQStyleOption_set_rect},
    {const_cast<char*>("type"), (getter)SbkQStyleOption_get_type, (setter)SbkQStyleOption_set_type},
    {const_cast<char*>("state"), (getter)SbkQStyleOption_get_state, (setter)SbkQStyleOption_set_state},
    {const_cast<char*>("fontMetrics"), (getter)SbkQStyleOption_get_fontMetrics, (setter)SbkQStyleOption_set_fontMetrics},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyleOption_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyleOption",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QStyleOption >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyleOption_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQStyleOption_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyleOption_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QStyleOption_StyleOptionVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOption_StyleOptionVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOption_StyleOptionVersion_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOption_StyleOptionVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOption_StyleOptionVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOption_StyleOptionVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOption_StyleOptionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOption_StyleOptionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOption_StyleOptionType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOption_StyleOptionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOption_StyleOptionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOption_StyleOptionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOption_OptionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOption_OptionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOption_OptionType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "OptionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOption_OptionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOption_OptionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOption_OptionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QStyleOption(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyleOption_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQStyleOption_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyleOption_Type));
    PyModule_AddObject(module, "QStyleOption",
        ((PyObject*)&SbkQStyleOption_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleOptionVersion
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_STYLEOPTIONVERSION_IDX] = &SbkPySide_QtGui_QStyleOption_StyleOptionVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOption_StyleOptionVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOption_StyleOptionVersion_Type);
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
            "StyleOptionVersion",((PyObject*)&SbkPySide_QtGui_QStyleOption_StyleOptionVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_StyleOptionVersion_Type,
        (long) QStyleOption::Version, "Version");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "Version", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_StyleOptionVersion_Type.tp_dict,
        "Version", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOption::StyleOptionVersion");

    // init enum class: StyleOptionType
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_STYLEOPTIONTYPE_IDX] = &SbkPySide_QtGui_QStyleOption_StyleOptionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOption_StyleOptionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOption_StyleOptionType_Type);
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
            "StyleOptionType",((PyObject*)&SbkPySide_QtGui_QStyleOption_StyleOptionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_StyleOptionType_Type,
        (long) QStyleOption::Type, "Type");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_StyleOptionType_Type.tp_dict,
        "Type", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOption::StyleOptionType");

    // init enum class: OptionType
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_OPTIONTYPE_IDX] = &SbkPySide_QtGui_QStyleOption_OptionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOption_OptionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOption_OptionType_Type);
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
            "OptionType",((PyObject*)&SbkPySide_QtGui_QStyleOption_OptionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_Default, "SO_Default");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_Default", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_Default", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_FocusRect, "SO_FocusRect");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_FocusRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_FocusRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_Button, "SO_Button");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_Button", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_Button", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_Tab, "SO_Tab");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_Tab", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_Tab", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_MenuItem, "SO_MenuItem");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_MenuItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_MenuItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_Frame, "SO_Frame");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_Frame", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_Frame", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_ProgressBar, "SO_ProgressBar");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_ProgressBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_ProgressBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_ToolBox, "SO_ToolBox");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_ToolBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_ToolBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_Header, "SO_Header");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_Header", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_Header", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_Q3DockWindow, "SO_Q3DockWindow");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_Q3DockWindow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_Q3DockWindow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_DockWidget, "SO_DockWidget");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_DockWidget", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_DockWidget", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_Q3ListViewItem, "SO_Q3ListViewItem");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_Q3ListViewItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_Q3ListViewItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_ViewItem, "SO_ViewItem");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_ViewItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_ViewItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_TabWidgetFrame, "SO_TabWidgetFrame");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_TabWidgetFrame", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_TabWidgetFrame", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_TabBarBase, "SO_TabBarBase");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_TabBarBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_TabBarBase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_RubberBand, "SO_RubberBand");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_RubberBand", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_RubberBand", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_ToolBar, "SO_ToolBar");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_ToolBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_ToolBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_GraphicsItem, "SO_GraphicsItem");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_GraphicsItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_GraphicsItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_Complex, "SO_Complex");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_Complex", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_Complex", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_Slider, "SO_Slider");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_Slider", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_Slider", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_SpinBox, "SO_SpinBox");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_SpinBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_SpinBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_ToolButton, "SO_ToolButton");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_ToolButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_ToolButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_ComboBox, "SO_ComboBox");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_ComboBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_ComboBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_Q3ListView, "SO_Q3ListView");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_Q3ListView", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_Q3ListView", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_TitleBar, "SO_TitleBar");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_TitleBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_TitleBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_GroupBox, "SO_GroupBox");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_GroupBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_GroupBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_SizeGrip, "SO_SizeGrip");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_SizeGrip", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_SizeGrip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_CustomBase, "SO_CustomBase");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_CustomBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_CustomBase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOption_OptionType_Type,
        (long) QStyleOption::SO_ComplexCustomBase, "SO_ComplexCustomBase");
    PyDict_SetItemString(SbkQStyleOption_Type.super.ht_type.tp_dict,
        "SO_ComplexCustomBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOption_OptionType_Type.tp_dict,
        "SO_ComplexCustomBase", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOption::OptionType");

    Shiboken::TypeResolver::createValueTypeResolver<QStyleOption >("QStyleOption");
    Shiboken::TypeResolver::createValueTypeResolver<QStyleOption >(typeid(QStyleOption).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

