/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qpalette_wrapper.h"

// Extra includes
#include <qbrush.h>
#include <qcolor.h>
#include <qdatastream.h>
#include <qpalette.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQPalette_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPalette* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3 || numArgs == 4 || numArgs == 5 || numArgs == 6 || numArgs == 7 || numArgs == 8)
        goto SbkQPalette_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QPalette", 0, 9, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7]), &(pyargs[8])))
        return -1;

    if (numArgs == 0) {
        // QPalette()
        cptr = new QPalette();
    } else if (numArgs == 1 && Shiboken::Converter<Qt::GlobalColor >::isConvertible(pyargs[0])) {
        Qt::GlobalColor cpp_arg0 = Shiboken::Converter<Qt::GlobalColor >::toCpp(pyargs[0]);
        // QPalette(Qt::GlobalColor)
        cptr = new QPalette(cpp_arg0);
    } else if (Shiboken::Converter<QColor& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QColor& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        if (numArgs == 1) {
            // QPalette(QColor)
            cptr = new QPalette(*cpp_arg0);
        } else if (numArgs == 2 && Shiboken::Converter<QColor& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QColor > cpp_arg1_auto_ptr;
            QColor* cpp_arg1 = Shiboken::Converter<QColor* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QColor& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QColor >(cpp_arg1);
            // QPalette(QColor,QColor)
            cptr = new QPalette(*cpp_arg0, *cpp_arg1);
        } else goto SbkQPalette_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QPalette& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPalette > cpp_arg0_auto_ptr;
        QPalette* cpp_arg0 = Shiboken::Converter<QPalette* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPalette& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPalette >(cpp_arg0);
        // QPalette(QPalette)
        cptr = new QPalette(*cpp_arg0);
    } else if (numArgs == 9 && Shiboken::Converter<QBrush& >::isConvertible(pyargs[0]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[1]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[2]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[3]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[4]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[5]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[6]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[7]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[8])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QBrush > cpp_arg1_auto_ptr;
        QBrush* cpp_arg1 = Shiboken::Converter<QBrush* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QBrush >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return -1;
        std::auto_ptr<QBrush > cpp_arg2_auto_ptr;
        QBrush* cpp_arg2 = Shiboken::Converter<QBrush* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QBrush >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return -1;
        std::auto_ptr<QBrush > cpp_arg3_auto_ptr;
        QBrush* cpp_arg3 = Shiboken::Converter<QBrush* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QBrush >(cpp_arg3);
        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
            return -1;
        std::auto_ptr<QBrush > cpp_arg4_auto_ptr;
        QBrush* cpp_arg4 = Shiboken::Converter<QBrush* >::toCpp(pyargs[4]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[4]))
            cpp_arg4_auto_ptr = std::auto_ptr<QBrush >(cpp_arg4);
        if (Shiboken::cppObjectIsInvalid(pyargs[5]))
            return -1;
        std::auto_ptr<QBrush > cpp_arg5_auto_ptr;
        QBrush* cpp_arg5 = Shiboken::Converter<QBrush* >::toCpp(pyargs[5]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[5]))
            cpp_arg5_auto_ptr = std::auto_ptr<QBrush >(cpp_arg5);
        if (Shiboken::cppObjectIsInvalid(pyargs[6]))
            return -1;
        std::auto_ptr<QBrush > cpp_arg6_auto_ptr;
        QBrush* cpp_arg6 = Shiboken::Converter<QBrush* >::toCpp(pyargs[6]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[6]))
            cpp_arg6_auto_ptr = std::auto_ptr<QBrush >(cpp_arg6);
        if (Shiboken::cppObjectIsInvalid(pyargs[7]))
            return -1;
        std::auto_ptr<QBrush > cpp_arg7_auto_ptr;
        QBrush* cpp_arg7 = Shiboken::Converter<QBrush* >::toCpp(pyargs[7]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[7]))
            cpp_arg7_auto_ptr = std::auto_ptr<QBrush >(cpp_arg7);
        if (Shiboken::cppObjectIsInvalid(pyargs[8]))
            return -1;
        std::auto_ptr<QBrush > cpp_arg8_auto_ptr;
        QBrush* cpp_arg8 = Shiboken::Converter<QBrush* >::toCpp(pyargs[8]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[8]))
            cpp_arg8_auto_ptr = std::auto_ptr<QBrush >(cpp_arg8);
        // QPalette(QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush)
        cptr = new QPalette(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8);
    } else goto SbkQPalette_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPalette_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQPalette_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.Qt.GlobalColor", "PySide.QtGui.QBrush, PySide.QtGui.QBrush, PySide.QtGui.QBrush, PySide.QtGui.QBrush, PySide.QtGui.QBrush, PySide.QtGui.QBrush, PySide.QtGui.QBrush, PySide.QtGui.QBrush, PySide.QtGui.QBrush", "PySide.QtGui.QColor", "PySide.QtGui.QColor, PySide.QtGui.QColor", "PySide.QtGui.QPalette", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPalette", overloads);
        return -1;
}

static PyObject*
SbkQPaletteFunc_alternateBase(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alternateBase()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::alternateBase();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_base(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // base()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::base();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_brightText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // brightText()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::brightText();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_brush(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "brush", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QPalette::ColorRole >::isConvertible(pyargs[0])) {
        QPalette::ColorRole cpp_arg0 = Shiboken::Converter<QPalette::ColorRole >::toCpp(pyargs[0]);
        // brush(QPalette::ColorRole)const
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        const QBrush & cpp_result = cppSelf->QPalette::brush(cpp_arg0);
        py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);
    } else if (numArgs == 2 && Shiboken::Converter<QPalette::ColorGroup >::isConvertible(pyargs[0]) && Shiboken::Converter<QPalette::ColorRole >::isConvertible(pyargs[1])) {
        QPalette::ColorGroup cpp_arg0 = Shiboken::Converter<QPalette::ColorGroup >::toCpp(pyargs[0]);
        QPalette::ColorRole cpp_arg1 = Shiboken::Converter<QPalette::ColorRole >::toCpp(pyargs[1]);
        // brush(QPalette::ColorGroup,QPalette::ColorRole)const
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        const QBrush & cpp_result = cppSelf->QPalette::brush(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);
    } else goto SbkQPaletteFunc_brush_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPaletteFunc_brush_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette.ColorGroup, PySide.QtGui.QPalette.ColorRole", "PySide.QtGui.QPalette.ColorRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPalette.brush", overloads);
        return 0;
}

static PyObject*
SbkQPaletteFunc_button(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // button()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::button();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_buttonText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // buttonText()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::buttonText();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_cacheKey(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cacheKey()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QPalette::cacheKey();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_color(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "color", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QPalette::ColorRole >::isConvertible(pyargs[0])) {
        QPalette::ColorRole cpp_arg0 = Shiboken::Converter<QPalette::ColorRole >::toCpp(pyargs[0]);
        // color(QPalette::ColorRole)const
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        const QColor & cpp_result = cppSelf->QPalette::color(cpp_arg0);
        py_result = Shiboken::Converter<QColor& >::toPython(cpp_result);
    } else if (numArgs == 2 && Shiboken::Converter<QPalette::ColorGroup >::isConvertible(pyargs[0]) && Shiboken::Converter<QPalette::ColorRole >::isConvertible(pyargs[1])) {
        QPalette::ColorGroup cpp_arg0 = Shiboken::Converter<QPalette::ColorGroup >::toCpp(pyargs[0]);
        QPalette::ColorRole cpp_arg1 = Shiboken::Converter<QPalette::ColorRole >::toCpp(pyargs[1]);
        // color(QPalette::ColorGroup,QPalette::ColorRole)const
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        const QColor & cpp_result = cppSelf->QPalette::color(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QColor& >::toPython(cpp_result);
    } else goto SbkQPaletteFunc_color_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPaletteFunc_color_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette.ColorGroup, PySide.QtGui.QPalette.ColorRole", "PySide.QtGui.QPalette.ColorRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPalette.color", overloads);
        return 0;
}

static PyObject*
SbkQPaletteFunc_currentColorGroup(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentColorGroup()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    QPalette::ColorGroup cpp_result = cppSelf->QPalette::currentColorGroup();
    py_result = Shiboken::Converter<QPalette::ColorGroup >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_dark(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dark()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::dark();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_highlight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // highlight()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::highlight();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_highlightedText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // highlightedText()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::highlightedText();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_isBrushSet(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isBrushSet", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPalette::ColorGroup >::isConvertible(pyargs[0]) && Shiboken::Converter<QPalette::ColorRole >::isConvertible(pyargs[1])) {
        QPalette::ColorGroup cpp_arg0 = Shiboken::Converter<QPalette::ColorGroup >::toCpp(pyargs[0]);
        QPalette::ColorRole cpp_arg1 = Shiboken::Converter<QPalette::ColorRole >::toCpp(pyargs[1]);
        // isBrushSet(QPalette::ColorGroup,QPalette::ColorRole)const
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPalette::isBrushSet(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQPaletteFunc_isBrushSet_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPaletteFunc_isBrushSet_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette.ColorGroup, PySide.QtGui.QPalette.ColorRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPalette.isBrushSet", overloads);
        return 0;
}

static PyObject*
SbkQPaletteFunc_isCopyOf(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPalette& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPalette > cpp_arg0_auto_ptr;
        QPalette* cpp_arg0 = Shiboken::Converter<QPalette* >::toCpp(arg);
        if (!Shiboken::Converter<QPalette& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPalette >(cpp_arg0);
        // isCopyOf(QPalette)const
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPalette::isCopyOf(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQPaletteFunc_isCopyOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPaletteFunc_isCopyOf_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPalette.isCopyOf", overloads);
        return 0;
}

static PyObject*
SbkQPaletteFunc_isEqual(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isEqual", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPalette::ColorGroup >::isConvertible(pyargs[0]) && Shiboken::Converter<QPalette::ColorGroup >::isConvertible(pyargs[1])) {
        QPalette::ColorGroup cpp_arg0 = Shiboken::Converter<QPalette::ColorGroup >::toCpp(pyargs[0]);
        QPalette::ColorGroup cpp_arg1 = Shiboken::Converter<QPalette::ColorGroup >::toCpp(pyargs[1]);
        // isEqual(QPalette::ColorGroup,QPalette::ColorGroup)const
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPalette::isEqual(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQPaletteFunc_isEqual_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPaletteFunc_isEqual_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette.ColorGroup, PySide.QtGui.QPalette.ColorGroup", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPalette.isEqual", overloads);
        return 0;
}

static PyObject*
SbkQPaletteFunc_light(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // light()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::light();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_link(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // link()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::link();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_linkVisited(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // linkVisited()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::linkVisited();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_mid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mid()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::mid();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_midlight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // midlight()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::midlight();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_resolve(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // resolve()const
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        uint cpp_result = cppSelf->QPalette::resolve();
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        uint cpp_arg0 = Shiboken::Converter<uint >::toCpp(arg);
        // resolve(uint)
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        cppSelf->QPalette::resolve(cpp_arg0);
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else if (Shiboken::Converter<QPalette& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPalette > cpp_arg0_auto_ptr;
        QPalette* cpp_arg0 = Shiboken::Converter<QPalette* >::toCpp(arg);
        if (!Shiboken::Converter<QPalette& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPalette >(cpp_arg0);
        // resolve(QPalette)const
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        QPalette cpp_result = cppSelf->QPalette::resolve(*cpp_arg0);
        py_result = Shiboken::Converter<QPalette >::toPython(cpp_result);
    } else goto SbkQPaletteFunc_resolve_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPaletteFunc_resolve_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QPalette", "unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPalette.resolve", overloads);
        return 0;
}

static PyObject*
SbkQPaletteFunc_setBrush(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setBrush", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPalette::ColorRole >::isConvertible(pyargs[0]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[1])) {
        QPalette::ColorRole cpp_arg0 = Shiboken::Converter<QPalette::ColorRole >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QBrush > cpp_arg1_auto_ptr;
        QBrush* cpp_arg1 = Shiboken::Converter<QBrush* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QBrush >(cpp_arg1);
        // setBrush(QPalette::ColorRole,QBrush)
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        cppSelf->QPalette::setBrush(cpp_arg0, *cpp_arg1);
    } else if (numArgs == 3 && Shiboken::Converter<QPalette::ColorGroup >::isConvertible(pyargs[0]) && Shiboken::Converter<QPalette::ColorRole >::isConvertible(pyargs[1]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[2])) {
        QPalette::ColorGroup cpp_arg0 = Shiboken::Converter<QPalette::ColorGroup >::toCpp(pyargs[0]);
        QPalette::ColorRole cpp_arg1 = Shiboken::Converter<QPalette::ColorRole >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QBrush > cpp_arg2_auto_ptr;
        QBrush* cpp_arg2 = Shiboken::Converter<QBrush* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QBrush >(cpp_arg2);
        // setBrush(QPalette::ColorGroup,QPalette::ColorRole,QBrush)
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        cppSelf->QPalette::setBrush(cpp_arg0, cpp_arg1, *cpp_arg2);
    } else goto SbkQPaletteFunc_setBrush_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPaletteFunc_setBrush_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette.ColorGroup, PySide.QtGui.QPalette.ColorRole, PySide.QtGui.QBrush", "PySide.QtGui.QPalette.ColorRole, PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPalette.setBrush", overloads);
        return 0;
}

static PyObject*
SbkQPaletteFunc_setColor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setColor", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPalette::ColorRole >::isConvertible(pyargs[0]) && Shiboken::Converter<QColor& >::isConvertible(pyargs[1])) {
        QPalette::ColorRole cpp_arg0 = Shiboken::Converter<QPalette::ColorRole >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QColor > cpp_arg1_auto_ptr;
        QColor* cpp_arg1 = Shiboken::Converter<QColor* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QColor& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QColor >(cpp_arg1);
        // setColor(QPalette::ColorRole,QColor)
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        cppSelf->QPalette::setColor(cpp_arg0, *cpp_arg1);
    } else if (numArgs == 3 && Shiboken::Converter<QPalette::ColorGroup >::isConvertible(pyargs[0]) && Shiboken::Converter<QPalette::ColorRole >::isConvertible(pyargs[1]) && Shiboken::Converter<QColor& >::isConvertible(pyargs[2])) {
        QPalette::ColorGroup cpp_arg0 = Shiboken::Converter<QPalette::ColorGroup >::toCpp(pyargs[0]);
        QPalette::ColorRole cpp_arg1 = Shiboken::Converter<QPalette::ColorRole >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QColor > cpp_arg2_auto_ptr;
        QColor* cpp_arg2 = Shiboken::Converter<QColor* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QColor& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QColor >(cpp_arg2);
        // setColor(QPalette::ColorGroup,QPalette::ColorRole,QColor)
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        cppSelf->QPalette::setColor(cpp_arg0, cpp_arg1, *cpp_arg2);
    } else goto SbkQPaletteFunc_setColor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPaletteFunc_setColor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette.ColorGroup, PySide.QtGui.QPalette.ColorRole, PySide.QtGui.QColor", "PySide.QtGui.QPalette.ColorRole, PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPalette.setColor", overloads);
        return 0;
}

static PyObject*
SbkQPaletteFunc_setColorGroup(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setColorGroup", 10, 10, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7]), &(pyargs[8]), &(pyargs[9])))
        return 0;

    if (numArgs == 10 && Shiboken::Converter<QPalette::ColorGroup >::isConvertible(pyargs[0]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[1]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[2]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[3]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[4]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[5]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[6]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[7]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[8]) && Shiboken::Converter<QBrush& >::isConvertible(pyargs[9])) {
        QPalette::ColorGroup cpp_arg0 = Shiboken::Converter<QPalette::ColorGroup >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QBrush > cpp_arg1_auto_ptr;
        QBrush* cpp_arg1 = Shiboken::Converter<QBrush* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QBrush >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QBrush > cpp_arg2_auto_ptr;
        QBrush* cpp_arg2 = Shiboken::Converter<QBrush* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QBrush >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QBrush > cpp_arg3_auto_ptr;
        QBrush* cpp_arg3 = Shiboken::Converter<QBrush* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QBrush >(cpp_arg3);
        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
            return 0;
        std::auto_ptr<QBrush > cpp_arg4_auto_ptr;
        QBrush* cpp_arg4 = Shiboken::Converter<QBrush* >::toCpp(pyargs[4]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[4]))
            cpp_arg4_auto_ptr = std::auto_ptr<QBrush >(cpp_arg4);
        if (Shiboken::cppObjectIsInvalid(pyargs[5]))
            return 0;
        std::auto_ptr<QBrush > cpp_arg5_auto_ptr;
        QBrush* cpp_arg5 = Shiboken::Converter<QBrush* >::toCpp(pyargs[5]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[5]))
            cpp_arg5_auto_ptr = std::auto_ptr<QBrush >(cpp_arg5);
        if (Shiboken::cppObjectIsInvalid(pyargs[6]))
            return 0;
        std::auto_ptr<QBrush > cpp_arg6_auto_ptr;
        QBrush* cpp_arg6 = Shiboken::Converter<QBrush* >::toCpp(pyargs[6]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[6]))
            cpp_arg6_auto_ptr = std::auto_ptr<QBrush >(cpp_arg6);
        if (Shiboken::cppObjectIsInvalid(pyargs[7]))
            return 0;
        std::auto_ptr<QBrush > cpp_arg7_auto_ptr;
        QBrush* cpp_arg7 = Shiboken::Converter<QBrush* >::toCpp(pyargs[7]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[7]))
            cpp_arg7_auto_ptr = std::auto_ptr<QBrush >(cpp_arg7);
        if (Shiboken::cppObjectIsInvalid(pyargs[8]))
            return 0;
        std::auto_ptr<QBrush > cpp_arg8_auto_ptr;
        QBrush* cpp_arg8 = Shiboken::Converter<QBrush* >::toCpp(pyargs[8]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[8]))
            cpp_arg8_auto_ptr = std::auto_ptr<QBrush >(cpp_arg8);
        if (Shiboken::cppObjectIsInvalid(pyargs[9]))
            return 0;
        std::auto_ptr<QBrush > cpp_arg9_auto_ptr;
        QBrush* cpp_arg9 = Shiboken::Converter<QBrush* >::toCpp(pyargs[9]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[9]))
            cpp_arg9_auto_ptr = std::auto_ptr<QBrush >(cpp_arg9);
        // setColorGroup(QPalette::ColorGroup,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush)
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        cppSelf->QPalette::setColorGroup(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9);
    } else goto SbkQPaletteFunc_setColorGroup_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPaletteFunc_setColorGroup_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette.ColorGroup, PySide.QtGui.QBrush, PySide.QtGui.QBrush, PySide.QtGui.QBrush, PySide.QtGui.QBrush, PySide.QtGui.QBrush, PySide.QtGui.QBrush, PySide.QtGui.QBrush, PySide.QtGui.QBrush, PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPalette.setColorGroup", overloads);
        return 0;
}

static PyObject*
SbkQPaletteFunc_setCurrentColorGroup(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPalette::ColorGroup >::isConvertible(arg)) {
        QPalette::ColorGroup cpp_arg0 = Shiboken::Converter<QPalette::ColorGroup >::toCpp(arg);
        // setCurrentColorGroup(QPalette::ColorGroup)
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        cppSelf->QPalette::setCurrentColorGroup(cpp_arg0);
    } else goto SbkQPaletteFunc_setCurrentColorGroup_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPaletteFunc_setCurrentColorGroup_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette.ColorGroup", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPalette.setCurrentColorGroup", overloads);
        return 0;
}

static PyObject*
SbkQPaletteFunc_shadow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // shadow()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::shadow();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::text();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_toolTipBase(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toolTipBase()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::toolTipBase();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_toolTipText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toolTipText()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::toolTipText();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_window(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // window()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::window();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPaletteFunc_windowText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowText()const
    QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPalette::windowText();
    py_result = Shiboken::Converter<QBrush& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQPalette_methods[] = {
    {"alternateBase", (PyCFunction)SbkQPaletteFunc_alternateBase, METH_NOARGS},
    {"base", (PyCFunction)SbkQPaletteFunc_base, METH_NOARGS},
    {"brightText", (PyCFunction)SbkQPaletteFunc_brightText, METH_NOARGS},
    {"brush", (PyCFunction)SbkQPaletteFunc_brush, METH_VARARGS},
    {"button", (PyCFunction)SbkQPaletteFunc_button, METH_NOARGS},
    {"buttonText", (PyCFunction)SbkQPaletteFunc_buttonText, METH_NOARGS},
    {"cacheKey", (PyCFunction)SbkQPaletteFunc_cacheKey, METH_NOARGS},
    {"color", (PyCFunction)SbkQPaletteFunc_color, METH_VARARGS},
    {"currentColorGroup", (PyCFunction)SbkQPaletteFunc_currentColorGroup, METH_NOARGS},
    {"dark", (PyCFunction)SbkQPaletteFunc_dark, METH_NOARGS},
    {"highlight", (PyCFunction)SbkQPaletteFunc_highlight, METH_NOARGS},
    {"highlightedText", (PyCFunction)SbkQPaletteFunc_highlightedText, METH_NOARGS},
    {"isBrushSet", (PyCFunction)SbkQPaletteFunc_isBrushSet, METH_VARARGS},
    {"isCopyOf", (PyCFunction)SbkQPaletteFunc_isCopyOf, METH_O},
    {"isEqual", (PyCFunction)SbkQPaletteFunc_isEqual, METH_VARARGS},
    {"light", (PyCFunction)SbkQPaletteFunc_light, METH_NOARGS},
    {"link", (PyCFunction)SbkQPaletteFunc_link, METH_NOARGS},
    {"linkVisited", (PyCFunction)SbkQPaletteFunc_linkVisited, METH_NOARGS},
    {"mid", (PyCFunction)SbkQPaletteFunc_mid, METH_NOARGS},
    {"midlight", (PyCFunction)SbkQPaletteFunc_midlight, METH_NOARGS},
    {"resolve", (PyCFunction)SbkQPaletteFunc_resolve, METH_NOARGS|METH_O},
    {"setBrush", (PyCFunction)SbkQPaletteFunc_setBrush, METH_VARARGS},
    {"setColor", (PyCFunction)SbkQPaletteFunc_setColor, METH_VARARGS},
    {"setColorGroup", (PyCFunction)SbkQPaletteFunc_setColorGroup, METH_VARARGS},
    {"setCurrentColorGroup", (PyCFunction)SbkQPaletteFunc_setCurrentColorGroup, METH_O},
    {"shadow", (PyCFunction)SbkQPaletteFunc_shadow, METH_NOARGS},
    {"text", (PyCFunction)SbkQPaletteFunc_text, METH_NOARGS},
    {"toolTipBase", (PyCFunction)SbkQPaletteFunc_toolTipBase, METH_NOARGS},
    {"toolTipText", (PyCFunction)SbkQPaletteFunc_toolTipText, METH_NOARGS},
    {"window", (PyCFunction)SbkQPaletteFunc_window, METH_NOARGS},
    {"windowText", (PyCFunction)SbkQPaletteFunc_windowText, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQPaletteFunc___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPalette_Check(arg) && !SbkQPalette_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QPalette) [reverse operator]
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQPaletteFunc___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPaletteFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPalette.__lshift__", overloads);
        return 0;
}

static PyObject*
SbkQPaletteFunc___rshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPalette_Check(arg) && !SbkQPalette_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rrshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QPalette&) [reverse operator]
        QPalette* cppSelf = Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQPaletteFunc___rshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPaletteFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPalette.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQPalette_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQPaletteFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQPaletteFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQPalette_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QPalette& cpp_self = *Shiboken::Converter<QPalette* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QPalette& >::isConvertible(other)) {
                QPalette* cpp_other = Shiboken::Converter<QPalette* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QPalette >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QPalette > cpp_other_auto_ptr;
                QPalette* cpp_other = Shiboken::Converter<QPalette* >::toCpp(other);
                if (!Shiboken::Converter<QPalette >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QPalette >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQPalette_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QPalette& >::isConvertible(other)) {
                QPalette* cpp_other = Shiboken::Converter<QPalette* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QPalette >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QPalette > cpp_other_auto_ptr;
                QPalette* cpp_other = Shiboken::Converter<QPalette* >::toCpp(other);
                if (!Shiboken::Converter<QPalette >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QPalette >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQPalette_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQPalette_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPalette_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPalette",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QPalette >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQPalette_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQPalette_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPalette_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPalette_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QPalette_ColorGroup_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPalette_ColorGroup_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPalette_ColorGroup_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ColorGroup",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPalette_ColorGroup_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPalette_ColorGroup_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPalette_ColorGroup_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QPalette_ColorRole_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPalette_ColorRole_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPalette_ColorRole_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ColorRole",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPalette_ColorRole_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPalette_ColorRole_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPalette_ColorRole_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QPalette(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPALETTE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPalette_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQPalette_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPalette_Type));
    PyModule_AddObject(module, "QPalette",
        ((PyObject*)&SbkQPalette_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ColorGroup
    SbkPySide_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX] = &SbkPySide_QtGui_QPalette_ColorGroup_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPalette_ColorGroup_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPalette_ColorGroup_Type);
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
            "ColorGroup",((PyObject*)&SbkPySide_QtGui_QPalette_ColorGroup_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorGroup_Type,
        (long) QPalette::Active, "Active");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Active", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorGroup_Type.tp_dict,
        "Active", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorGroup_Type,
        (long) QPalette::Disabled, "Disabled");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Disabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorGroup_Type.tp_dict,
        "Disabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorGroup_Type,
        (long) QPalette::Inactive, "Inactive");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Inactive", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorGroup_Type.tp_dict,
        "Inactive", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorGroup_Type,
        (long) QPalette::NColorGroups, "NColorGroups");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "NColorGroups", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorGroup_Type.tp_dict,
        "NColorGroups", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorGroup_Type,
        (long) QPalette::Current, "Current");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Current", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorGroup_Type.tp_dict,
        "Current", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorGroup_Type,
        (long) QPalette::All, "All");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "All", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorGroup_Type.tp_dict,
        "All", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorGroup_Type,
        (long) QPalette::Normal, "Normal");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Normal", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorGroup_Type.tp_dict,
        "Normal", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPalette::ColorGroup");

    // init enum class: ColorRole
    SbkPySide_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX] = &SbkPySide_QtGui_QPalette_ColorRole_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPalette_ColorRole_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPalette_ColorRole_Type);
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
            "ColorRole",((PyObject*)&SbkPySide_QtGui_QPalette_ColorRole_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::WindowText, "WindowText");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "WindowText", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "WindowText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::Button, "Button");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Button", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "Button", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::Light, "Light");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Light", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "Light", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::Midlight, "Midlight");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Midlight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "Midlight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::Dark, "Dark");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Dark", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "Dark", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::Mid, "Mid");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Mid", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "Mid", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::Text, "Text");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Text", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "Text", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::BrightText, "BrightText");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "BrightText", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "BrightText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::ButtonText, "ButtonText");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "ButtonText", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "ButtonText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::Base, "Base");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Base", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "Base", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::Window, "Window");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Window", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "Window", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::Shadow, "Shadow");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Shadow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "Shadow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::Highlight, "Highlight");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Highlight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "Highlight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::HighlightedText, "HighlightedText");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "HighlightedText", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "HighlightedText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::Link, "Link");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Link", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "Link", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::LinkVisited, "LinkVisited");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "LinkVisited", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "LinkVisited", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::AlternateBase, "AlternateBase");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "AlternateBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "AlternateBase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::NoRole, "NoRole");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "NoRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "NoRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::ToolTipBase, "ToolTipBase");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "ToolTipBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "ToolTipBase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::ToolTipText, "ToolTipText");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "ToolTipText", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "ToolTipText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::NColorRoles, "NColorRoles");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "NColorRoles", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "NColorRoles", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::Foreground, "Foreground");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Foreground", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "Foreground", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPalette_ColorRole_Type,
        (long) QPalette::Background, "Background");
    PyDict_SetItemString(SbkQPalette_Type.super.ht_type.tp_dict,
        "Background", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPalette_ColorRole_Type.tp_dict,
        "Background", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPalette::ColorRole");

    Shiboken::TypeResolver::createValueTypeResolver<QPalette >("QPalette");
    Shiboken::TypeResolver::createValueTypeResolver<QPalette >(typeid(QPalette).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

