/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qpainterpathstroker_wrapper.h"

// Extra includes
#include <QVector>
#include <qpainterpath.h>

using namespace Shiboken;

static int
SbkQPainterPathStroker_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPainterPathStroker* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QPainterPathStroker()
    cptr = new QPainterPathStroker();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQPainterPathStrokerFunc_capStyle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // capStyle()const
    QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
    Qt::PenCapStyle cpp_result = cppSelf->QPainterPathStroker::capStyle();
    py_result = Shiboken::Converter<Qt::PenCapStyle >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathStrokerFunc_createStroke(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPainterPath& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // createStroke(QPainterPath)const
        QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = cppSelf->QPainterPathStroker::createStroke(*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else goto SbkQPainterPathStrokerFunc_createStroke_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPainterPathStrokerFunc_createStroke_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPathStroker.createStroke", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathStrokerFunc_curveThreshold(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // curveThreshold()const
    QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPainterPathStroker::curveThreshold();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathStrokerFunc_dashOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dashOffset()const
    QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPainterPathStroker::dashOffset();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathStrokerFunc_dashPattern(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dashPattern()const
    QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
    QVector<qreal > cpp_result = cppSelf->QPainterPathStroker::dashPattern();
    py_result = Shiboken::Converter<QVector<qreal > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathStrokerFunc_joinStyle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // joinStyle()const
    QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
    Qt::PenJoinStyle cpp_result = cppSelf->QPainterPathStroker::joinStyle();
    py_result = Shiboken::Converter<Qt::PenJoinStyle >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathStrokerFunc_miterLimit(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // miterLimit()const
    QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPainterPathStroker::miterLimit();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPainterPathStrokerFunc_setCapStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::PenCapStyle >::isConvertible(arg)) {
        Qt::PenCapStyle cpp_arg0 = Shiboken::Converter<Qt::PenCapStyle >::toCpp(arg);
        // setCapStyle(Qt::PenCapStyle)
        QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
        cppSelf->QPainterPathStroker::setCapStyle(cpp_arg0);
    } else goto SbkQPainterPathStrokerFunc_setCapStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathStrokerFunc_setCapStyle_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.PenCapStyle", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPathStroker.setCapStyle", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathStrokerFunc_setCurveThreshold(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setCurveThreshold(qreal)
        QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
        cppSelf->QPainterPathStroker::setCurveThreshold(cpp_arg0);
    } else goto SbkQPainterPathStrokerFunc_setCurveThreshold_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathStrokerFunc_setCurveThreshold_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPathStroker.setCurveThreshold", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathStrokerFunc_setDashOffset(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setDashOffset(qreal)
        QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
        cppSelf->QPainterPathStroker::setDashOffset(cpp_arg0);
    } else goto SbkQPainterPathStrokerFunc_setDashOffset_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathStrokerFunc_setDashOffset_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPathStroker.setDashOffset", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathStrokerFunc_setDashPattern(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVector<qreal >  >::isConvertible(arg)) {
        QVector<qreal >  cpp_arg0 = Shiboken::Converter<QVector<qreal >  >::toCpp(arg);
        // setDashPattern(QVector<qreal>)
        QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
        cppSelf->QPainterPathStroker::setDashPattern(cpp_arg0);
    } else if (Shiboken::Converter<Qt::PenStyle >::isConvertible(arg)) {
        Qt::PenStyle cpp_arg0 = Shiboken::Converter<Qt::PenStyle >::toCpp(arg);
        // setDashPattern(Qt::PenStyle)
        QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
        cppSelf->QPainterPathStroker::setDashPattern(cpp_arg0);
    } else goto SbkQPainterPathStrokerFunc_setDashPattern_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathStrokerFunc_setDashPattern_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.PenStyle", "list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPathStroker.setDashPattern", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathStrokerFunc_setJoinStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::PenJoinStyle >::isConvertible(arg)) {
        Qt::PenJoinStyle cpp_arg0 = Shiboken::Converter<Qt::PenJoinStyle >::toCpp(arg);
        // setJoinStyle(Qt::PenJoinStyle)
        QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
        cppSelf->QPainterPathStroker::setJoinStyle(cpp_arg0);
    } else goto SbkQPainterPathStrokerFunc_setJoinStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathStrokerFunc_setJoinStyle_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.PenJoinStyle", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPathStroker.setJoinStyle", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathStrokerFunc_setMiterLimit(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setMiterLimit(qreal)
        QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
        cppSelf->QPainterPathStroker::setMiterLimit(cpp_arg0);
    } else goto SbkQPainterPathStrokerFunc_setMiterLimit_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathStrokerFunc_setMiterLimit_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPathStroker.setMiterLimit", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathStrokerFunc_setWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setWidth(qreal)
        QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
        cppSelf->QPainterPathStroker::setWidth(cpp_arg0);
    } else goto SbkQPainterPathStrokerFunc_setWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterPathStrokerFunc_setWidth_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainterPathStroker.setWidth", overloads);
        return 0;
}

static PyObject*
SbkQPainterPathStrokerFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QPainterPathStroker* cppSelf = Shiboken::Converter<QPainterPathStroker* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPainterPathStroker::width();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQPainterPathStroker_methods[] = {
    {"capStyle", (PyCFunction)SbkQPainterPathStrokerFunc_capStyle, METH_NOARGS},
    {"createStroke", (PyCFunction)SbkQPainterPathStrokerFunc_createStroke, METH_O},
    {"curveThreshold", (PyCFunction)SbkQPainterPathStrokerFunc_curveThreshold, METH_NOARGS},
    {"dashOffset", (PyCFunction)SbkQPainterPathStrokerFunc_dashOffset, METH_NOARGS},
    {"dashPattern", (PyCFunction)SbkQPainterPathStrokerFunc_dashPattern, METH_NOARGS},
    {"joinStyle", (PyCFunction)SbkQPainterPathStrokerFunc_joinStyle, METH_NOARGS},
    {"miterLimit", (PyCFunction)SbkQPainterPathStrokerFunc_miterLimit, METH_NOARGS},
    {"setCapStyle", (PyCFunction)SbkQPainterPathStrokerFunc_setCapStyle, METH_O},
    {"setCurveThreshold", (PyCFunction)SbkQPainterPathStrokerFunc_setCurveThreshold, METH_O},
    {"setDashOffset", (PyCFunction)SbkQPainterPathStrokerFunc_setDashOffset, METH_O},
    {"setDashPattern", (PyCFunction)SbkQPainterPathStrokerFunc_setDashPattern, METH_O},
    {"setJoinStyle", (PyCFunction)SbkQPainterPathStrokerFunc_setJoinStyle, METH_O},
    {"setMiterLimit", (PyCFunction)SbkQPainterPathStrokerFunc_setMiterLimit, METH_O},
    {"setWidth", (PyCFunction)SbkQPainterPathStrokerFunc_setWidth, METH_O},
    {"width", (PyCFunction)SbkQPainterPathStrokerFunc_width, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPainterPathStroker_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPainterPathStroker",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QPainterPathStroker >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPainterPathStroker_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPainterPathStroker_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QPainterPathStroker(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPAINTERPATHSTROKER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPainterPathStroker_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQPainterPathStroker_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPainterPathStroker_Type));
    PyModule_AddObject(module, "QPainterPathStroker",
        ((PyObject*)&SbkQPainterPathStroker_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QPainterPathStroker >("QPainterPathStroker*");
    Shiboken::TypeResolver::createObjectTypeResolver<QPainterPathStroker >(typeid(QPainterPathStroker).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

