/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qmouseevent_wrapper.h"

// Extra includes
#include <qevent.h>
#include <qpoint.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QMouseEventWrapper::QMouseEventWrapper(QEvent::Type type, const QPoint & pos, Qt::MouseButton button, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers) : QMouseEvent(type, pos, button, buttons, modifiers) {
    // ... middle
}

QMouseEventWrapper::QMouseEventWrapper(QEvent::Type type, const QPoint & pos, const QPoint & globalPos, Qt::MouseButton button, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers) : QMouseEvent(type, pos, globalPos, button, buttons, modifiers) {
    // ... middle
}

QMouseEventWrapper::~QMouseEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQMouseEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMouseEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QMouseEvent", 5, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return -1;

    if (Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0]) && Shiboken::Converter<QPoint& >::isConvertible(pyargs[1])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QPoint > cpp_arg1_auto_ptr;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPoint >(cpp_arg1);
        if (numArgs == 6 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[2]) && Shiboken::Converter<Qt::MouseButton >::isConvertible(pyargs[3]) && SbkPySide_QtCore_Qt_MouseButton_Check(pyargs[4]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[5])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return -1;
            std::auto_ptr<QPoint > cpp_arg2_auto_ptr;
            QPoint* cpp_arg2 = Shiboken::Converter<QPoint* >::toCpp(pyargs[2]);
            if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QPoint >(cpp_arg2);
            Qt::MouseButton cpp_arg3 = Shiboken::Converter<Qt::MouseButton >::toCpp(pyargs[3]);
            QFlags<Qt::MouseButton> cpp_arg4 = Shiboken::Converter<QFlags<Qt::MouseButton> >::toCpp(pyargs[4]);
            QFlags<Qt::KeyboardModifier> cpp_arg5 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[5]);
            // QMouseEvent(QEvent::Type,QPoint,QPoint,Qt::MouseButton,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>)
            cptr = new QMouseEventWrapper(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
        } else if (numArgs == 5 && Shiboken::Converter<Qt::MouseButton >::isConvertible(pyargs[2]) && SbkPySide_QtCore_Qt_MouseButton_Check(pyargs[3]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[4])) {
            Qt::MouseButton cpp_arg2 = Shiboken::Converter<Qt::MouseButton >::toCpp(pyargs[2]);
            QFlags<Qt::MouseButton> cpp_arg3 = Shiboken::Converter<QFlags<Qt::MouseButton> >::toCpp(pyargs[3]);
            QFlags<Qt::KeyboardModifier> cpp_arg4 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[4]);
            // QMouseEvent(QEvent::Type,QPoint,Qt::MouseButton,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>)
            cptr = new QMouseEventWrapper(cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
        } else goto SbkQMouseEvent_Init_TypeError;
    } else goto SbkQMouseEvent_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQMouseEvent_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQMouseEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type, PySide.QtCore.QPoint, PySide.QtCore.Qt.MouseButton, PySide.QtCore.Qt.MouseButtons, PySide.QtCore.Qt.KeyboardModifiers", "PySide.QtCore.QEvent.Type, PySide.QtCore.QPoint, PySide.QtCore.QPoint, PySide.QtCore.Qt.MouseButton, PySide.QtCore.Qt.MouseButtons, PySide.QtCore.Qt.KeyboardModifiers", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMouseEvent", overloads);
        return -1;
}

static PyObject*
SbkQMouseEventFunc_button(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // button()const
    QMouseEvent* cppSelf = Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self);
    Qt::MouseButton cpp_result = cppSelf->QMouseEvent::button();
    py_result = Shiboken::Converter<Qt::MouseButton >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMouseEventFunc_buttons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // buttons()const
    QMouseEvent* cppSelf = Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::MouseButton> cpp_result = cppSelf->QMouseEvent::buttons();
    py_result = Shiboken::Converter<QFlags<Qt::MouseButton> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMouseEventFunc_createExtendedMouseEvent(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "createExtendedMouseEvent", 6, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (numArgs == 6 && Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0]) && Shiboken::Converter<QPointF& >::isConvertible(pyargs[1]) && Shiboken::Converter<QPoint& >::isConvertible(pyargs[2]) && Shiboken::Converter<Qt::MouseButton >::isConvertible(pyargs[3]) && SbkPySide_QtCore_Qt_MouseButton_Check(pyargs[4]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[5])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
        QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg2_auto_ptr;
        QPoint* cpp_arg2 = Shiboken::Converter<QPoint* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QPoint >(cpp_arg2);
        Qt::MouseButton cpp_arg3 = Shiboken::Converter<Qt::MouseButton >::toCpp(pyargs[3]);
        QFlags<Qt::MouseButton> cpp_arg4 = Shiboken::Converter<QFlags<Qt::MouseButton> >::toCpp(pyargs[4]);
        QFlags<Qt::KeyboardModifier> cpp_arg5 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[5]);
        // createExtendedMouseEvent(QEvent::Type,QPointF,QPoint,Qt::MouseButton,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>)
        QMouseEvent * cpp_result = QMouseEvent::createExtendedMouseEvent(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
        py_result = Shiboken::Converter<QMouseEvent* >::toPython(cpp_result);
    } else goto SbkQMouseEventFunc_createExtendedMouseEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMouseEventFunc_createExtendedMouseEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type, PySide.QtCore.QPointF, PySide.QtCore.QPoint, PySide.QtCore.Qt.MouseButton, PySide.QtCore.Qt.MouseButtons, PySide.QtCore.Qt.KeyboardModifiers", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMouseEvent.createExtendedMouseEvent", overloads);
        return 0;
}

static PyObject*
SbkQMouseEventFunc_globalPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalPos()const
    QMouseEvent* cppSelf = Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self);
    const QPoint & cpp_result = cppSelf->QMouseEvent::globalPos();
    py_result = Shiboken::Converter<QPoint& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMouseEventFunc_globalX(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalX()const
    QMouseEvent* cppSelf = Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMouseEvent::globalX();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMouseEventFunc_globalY(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalY()const
    QMouseEvent* cppSelf = Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMouseEvent::globalY();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMouseEventFunc_hasExtendedInfo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasExtendedInfo()const
    QMouseEvent* cppSelf = Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMouseEvent::hasExtendedInfo();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMouseEventFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QMouseEvent* cppSelf = Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self);
    const QPoint & cpp_result = cppSelf->QMouseEvent::pos();
    py_result = Shiboken::Converter<QPoint& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMouseEventFunc_posF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // posF()const
    QMouseEvent* cppSelf = Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QMouseEvent::posF();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMouseEventFunc_x(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x()const
    QMouseEvent* cppSelf = Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMouseEvent::x();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMouseEventFunc_y(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y()const
    QMouseEvent* cppSelf = Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMouseEvent::y();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQMouseEvent_methods[] = {
    {"button", (PyCFunction)SbkQMouseEventFunc_button, METH_NOARGS},
    {"buttons", (PyCFunction)SbkQMouseEventFunc_buttons, METH_NOARGS},
    {"createExtendedMouseEvent", (PyCFunction)SbkQMouseEventFunc_createExtendedMouseEvent, METH_VARARGS|METH_STATIC},
    {"globalPos", (PyCFunction)SbkQMouseEventFunc_globalPos, METH_NOARGS},
    {"globalX", (PyCFunction)SbkQMouseEventFunc_globalX, METH_NOARGS},
    {"globalY", (PyCFunction)SbkQMouseEventFunc_globalY, METH_NOARGS},
    {"hasExtendedInfo", (PyCFunction)SbkQMouseEventFunc_hasExtendedInfo, METH_NOARGS},
    {"pos", (PyCFunction)SbkQMouseEventFunc_pos, METH_NOARGS},
    {"posF", (PyCFunction)SbkQMouseEventFunc_posF, METH_NOARGS},
    {"x", (PyCFunction)SbkQMouseEventFunc_x, METH_NOARGS},
    {"y", (PyCFunction)SbkQMouseEventFunc_y, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQMouseEvent_get_g(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPoint >::toPython(Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self)->g);
}
static int SbkQMouseEvent_set_g(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'g' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPoint >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'g', 'QPoint' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self)->g = Shiboken::Converter<QPoint >::toCpp(value);

    return 0;
}

static PyObject* SbkQMouseEvent_get_mouseState(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<Qt::MouseButton> >::toPython(Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self)->mouseState);
}
static int SbkQMouseEvent_set_mouseState(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mouseState' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtCore_Qt_MouseButton_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mouseState', 'MouseButtons' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self)->mouseState = Shiboken::Converter<QFlags<Qt::MouseButton> >::toCpp(value);

    return 0;
}

static PyObject* SbkQMouseEvent_get_p(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPoint >::toPython(Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self)->p);
}
static int SbkQMouseEvent_set_p(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'p' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPoint >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'p', 'QPoint' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self)->p = Shiboken::Converter<QPoint >::toCpp(value);

    return 0;
}

static PyObject* SbkQMouseEvent_get_b(SbkBaseWrapper* self)
{
    return Shiboken::Converter<Qt::MouseButton >::toPython(Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self)->b);
}
static int SbkQMouseEvent_set_b(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'b' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<Qt::MouseButton >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'b', 'MouseButton' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QMouseEvent* >::toCpp((PyObject*)self)->b = Shiboken::Converter<Qt::MouseButton >::toCpp(value);

    return 0;
}

// Getters and Setters for QMouseEvent
static PyGetSetDef SbkQMouseEvent_getsetlist[] = {
    {const_cast<char*>("g"), (getter)SbkQMouseEvent_get_g, (setter)SbkQMouseEvent_set_g},
    {const_cast<char*>("mouseState"), (getter)SbkQMouseEvent_get_mouseState, (setter)SbkQMouseEvent_set_mouseState},
    {const_cast<char*>("p"), (getter)SbkQMouseEvent_get_p, (setter)SbkQMouseEvent_set_p},
    {const_cast<char*>("b"), (getter)SbkQMouseEvent_get_b, (setter)SbkQMouseEvent_set_b},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMouseEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QMouseEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QMouseEventWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMouseEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQMouseEvent_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMouseEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQMouseEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQMouseEvent_Type);
     if ( reinterpret_cast<QMouseEvent*>(cptr)->type() == QEvent::MouseButtonDblClick ||  reinterpret_cast<QMouseEvent*>(cptr)->type() == QEvent::MouseButtonPress ||  reinterpret_cast<QMouseEvent*>(cptr)->type() == QEvent::MouseButtonRelease ||  reinterpret_cast<QMouseEvent*>(cptr)->type() == QEvent::MouseMove)
        return &SbkQMouseEvent_Type;
    return 0;
}


PyAPI_FUNC(void)
init_QMouseEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QMOUSEEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMouseEvent_Type);

    SbkQMouseEvent_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QINPUTEVENT_IDX];
    // Fill type discovery information
    SbkQMouseEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQMouseEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQMouseEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQMouseEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMouseEvent_Type));
    PyModule_AddObject(module, "QMouseEvent",
        ((PyObject*)&SbkQMouseEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QMouseEvent >("QMouseEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QMouseEvent >(typeid(QMouseEvent).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

