/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qmdiarea_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qbitmap.h>
#include <qbrush.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qmdiarea.h>
#include <qmdisubwindow.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qscrollbar.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QMdiAreaWrapper::QMdiAreaWrapper(QWidget * parent) : QMdiArea(parent), m_metaObject(0) {
    // ... middle
}

void QMdiAreaWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QActionEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMdiAreaWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QFrame::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::childEvent(QChildEvent * childEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QMdiArea::childEvent(childEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(childEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMdiAreaWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QContextMenuEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QMdiAreaWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMdiArea.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QMdiAreaWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragEnterEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragLeaveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDropEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QMdiAreaWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QMdiArea::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMdiArea.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QMdiAreaWrapper::eventFilter(QObject * object, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QMdiArea::eventFilter(object, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(object),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMdiArea.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QMdiAreaWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QMdiAreaWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMdiArea.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QMdiAreaWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QMdiAreaWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMdiArea.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QMdiAreaWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMdiAreaWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QMdiAreaWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMdiArea.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QMdiAreaWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMdiAreaWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QMdiAreaWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMdiArea.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QMdiAreaWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QMdiArea::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMdiArea.minimumSizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QMdiAreaWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QMdiAreaWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMdiArea.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QMdiAreaWrapper::paintEvent(QPaintEvent * paintEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QMdiArea::paintEvent(paintEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintEvent* >::toPython(paintEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::resizeEvent(QResizeEvent * resizeEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QMdiArea::resizeEvent(resizeEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QResizeEvent* >::toPython(resizeEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::scrollContentsBy(int dx, int dy)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollContentsBy"));
    if (py_override.isNull()) {
        return this->QMdiArea::scrollContentsBy(dx, dy);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        dx,
        dy
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiAreaWrapper::showEvent(QShowEvent * showEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QMdiArea::showEvent(showEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(showEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QMdiAreaWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QMdiArea::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMdiArea.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QMdiAreaWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTabletEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMdiAreaWrapper::timerEvent(QTimerEvent * timerEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QMdiArea::timerEvent(timerEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(timerEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QMdiAreaWrapper::viewportEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewportEvent"));
    if (py_override.isNull()) {
        return this->QMdiArea::viewportEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMdiArea.viewportEvent");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QMdiAreaWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWheelEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QMdiAreaWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QMdiArea::staticMetaObject);
}
    return m_metaObject;
}

int QMdiAreaWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QMdiArea::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QMdiAreaWrapper::~QMdiAreaWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQMdiArea_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMdiAreaWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QMdiArea", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QMdiArea(QWidget*)
        cptr = new QMdiAreaWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QMdiArea(QWidget*)
        cptr = new QMdiAreaWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQMdiArea_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQMdiArea_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQMdiArea_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMdiArea", overloads);
        return -1;
}

static PyObject*
SbkQMdiAreaFunc_activateNextSubWindow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // activateNextSubWindow()
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    cppSelf->QMdiArea::activateNextSubWindow();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQMdiAreaFunc_activatePreviousSubWindow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // activatePreviousSubWindow()
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    cppSelf->QMdiArea::activatePreviousSubWindow();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQMdiAreaFunc_activationOrder(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // activationOrder()const
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    QMdiArea::WindowOrder cpp_result = cppSelf->QMdiArea::activationOrder();
    py_result = Shiboken::Converter<QMdiArea::WindowOrder >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMdiAreaFunc_activeSubWindow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // activeSubWindow()const
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    QMdiSubWindow * cpp_result = cppSelf->QMdiArea::activeSubWindow();
    py_result = Shiboken::Converter<QMdiSubWindow* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMdiAreaFunc_addSubWindow(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addSubWindow", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // addSubWindow(QWidget*,QFlags<Qt::WindowType>)
            QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
            QMdiSubWindow * cpp_result = cppSelf->QMdiArea::addSubWindow(cpp_arg0);
            py_result = Shiboken::Converter<QMdiSubWindow* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, pyargs[0]);
            Shiboken::setParent(self, py_result);
        } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[1])) {
            QFlags<Qt::WindowType> cpp_arg1 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[1]);
            // addSubWindow(QWidget*,QFlags<Qt::WindowType>)
            QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
            QMdiSubWindow * cpp_result = cppSelf->QMdiArea::addSubWindow(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QMdiSubWindow* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, pyargs[0]);
            Shiboken::setParent(self, py_result);
        } else goto SbkQMdiAreaFunc_addSubWindow_TypeError;
    } else goto SbkQMdiAreaFunc_addSubWindow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMdiAreaFunc_addSubWindow_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMdiArea.addSubWindow", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_background(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // background()const
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QMdiArea::background();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMdiAreaFunc_cascadeSubWindows(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // cascadeSubWindows()
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    cppSelf->QMdiArea::cascadeSubWindows();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQMdiAreaFunc_childEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QChildEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QChildEvent* cpp_arg0 = Shiboken::Converter<QChildEvent* >::toCpp(arg);
        // childEvent(QChildEvent*)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::childEvent(cpp_arg0);
    } else goto SbkQMdiAreaFunc_childEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_childEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChildEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.childEvent", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_closeActiveSubWindow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // closeActiveSubWindow()
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    cppSelf->QMdiArea::closeActiveSubWindow();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQMdiAreaFunc_closeAllSubWindows(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // closeAllSubWindows()
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    cppSelf->QMdiArea::closeAllSubWindows();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQMdiAreaFunc_currentSubWindow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentSubWindow()const
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    QMdiSubWindow * cpp_result = cppSelf->QMdiArea::currentSubWindow();
    py_result = Shiboken::Converter<QMdiSubWindow* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMdiAreaFunc_documentMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentMode()const
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMdiArea::documentMode();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMdiAreaFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMdiArea::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQMdiAreaFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMdiAreaFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.event", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_eventFilter(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject* >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        // eventFilter(QObject*,QEvent*)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMdiArea::eventFilter(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQMdiAreaFunc_eventFilter_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMdiAreaFunc_eventFilter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMdiArea.eventFilter", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_minimumSizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSizeHint()const
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QMdiArea::minimumSizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMdiAreaFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::paintEvent(cpp_arg0);
    } else goto SbkQMdiAreaFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.paintEvent", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_removeSubWindow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // removeSubWindow(QWidget*)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::removeSubWindow(cpp_arg0);
    } else goto SbkQMdiAreaFunc_removeSubWindow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_removeSubWindow_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.removeSubWindow", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::resizeEvent(cpp_arg0);
    } else goto SbkQMdiAreaFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.resizeEvent", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_scrollContentsBy(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollContentsBy", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // scrollContentsBy(int,int)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::scrollContentsBy(cpp_arg0, cpp_arg1);
    } else goto SbkQMdiAreaFunc_scrollContentsBy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_scrollContentsBy_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMdiArea.scrollContentsBy", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_setActivationOrder(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMdiArea::WindowOrder >::isConvertible(arg)) {
        QMdiArea::WindowOrder cpp_arg0 = Shiboken::Converter<QMdiArea::WindowOrder >::toCpp(arg);
        // setActivationOrder(QMdiArea::WindowOrder)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::setActivationOrder(cpp_arg0);
    } else goto SbkQMdiAreaFunc_setActivationOrder_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_setActivationOrder_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMdiArea.WindowOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.setActivationOrder", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_setActiveSubWindow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMdiSubWindow* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMdiSubWindow* cpp_arg0 = Shiboken::Converter<QMdiSubWindow* >::toCpp(arg);
        // setActiveSubWindow(QMdiSubWindow*)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::setActiveSubWindow(cpp_arg0);
    } else goto SbkQMdiAreaFunc_setActiveSubWindow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_setActiveSubWindow_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMdiSubWindow", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.setActiveSubWindow", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_setBackground(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!Shiboken::Converter<QBrush& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setBackground(QBrush)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::setBackground(*cpp_arg0);
    } else goto SbkQMdiAreaFunc_setBackground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_setBackground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.setBackground", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_setDocumentMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDocumentMode(bool)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::setDocumentMode(cpp_arg0);
    } else goto SbkQMdiAreaFunc_setDocumentMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_setDocumentMode_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.setDocumentMode", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_setOption(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setOption", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QMdiArea::AreaOption >::isConvertible(pyargs[0])) {
        QMdiArea::AreaOption cpp_arg0 = Shiboken::Converter<QMdiArea::AreaOption >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setOption(QMdiArea::AreaOption,bool)
            QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
            cppSelf->QMdiArea::setOption(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setOption(QMdiArea::AreaOption,bool)
            QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
            cppSelf->QMdiArea::setOption(cpp_arg0, cpp_arg1);
        } else goto SbkQMdiAreaFunc_setOption_TypeError;
    } else goto SbkQMdiAreaFunc_setOption_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_setOption_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMdiArea.AreaOption, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMdiArea.setOption", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_setTabPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTabWidget::TabPosition >::isConvertible(arg)) {
        QTabWidget::TabPosition cpp_arg0 = Shiboken::Converter<QTabWidget::TabPosition >::toCpp(arg);
        // setTabPosition(QTabWidget::TabPosition)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::setTabPosition(cpp_arg0);
    } else goto SbkQMdiAreaFunc_setTabPosition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_setTabPosition_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTabWidget.TabPosition", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.setTabPosition", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_setTabShape(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTabWidget::TabShape >::isConvertible(arg)) {
        QTabWidget::TabShape cpp_arg0 = Shiboken::Converter<QTabWidget::TabShape >::toCpp(arg);
        // setTabShape(QTabWidget::TabShape)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::setTabShape(cpp_arg0);
    } else goto SbkQMdiAreaFunc_setTabShape_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_setTabShape_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTabWidget.TabShape", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.setTabShape", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_setViewMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMdiArea::ViewMode >::isConvertible(arg)) {
        QMdiArea::ViewMode cpp_arg0 = Shiboken::Converter<QMdiArea::ViewMode >::toCpp(arg);
        // setViewMode(QMdiArea::ViewMode)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::setViewMode(cpp_arg0);
    } else goto SbkQMdiAreaFunc_setViewMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_setViewMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMdiArea.ViewMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.setViewMode", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_setupViewport(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setupViewport(QWidget*)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::setupViewport(cpp_arg0);
    } else goto SbkQMdiAreaFunc_setupViewport_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_setupViewport_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.setupViewport", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_showEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QShowEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QShowEvent* cpp_arg0 = Shiboken::Converter<QShowEvent* >::toCpp(arg);
        // showEvent(QShowEvent*)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::showEvent(cpp_arg0);
    } else goto SbkQMdiAreaFunc_showEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_showEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QShowEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.showEvent", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QMdiArea::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMdiAreaFunc_subWindowList(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // subWindowList(QMdiArea::WindowOrder)const
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        QList<QMdiSubWindow * > cpp_result = cppSelf->QMdiArea::subWindowList();
        py_result = Shiboken::Converter<QList<QMdiSubWindow * > >::toPython(cpp_result);
    } else if (Shiboken::Converter<QMdiArea::WindowOrder >::isConvertible(arg)) {
        QMdiArea::WindowOrder cpp_arg0 = Shiboken::Converter<QMdiArea::WindowOrder >::toCpp(arg);
        // subWindowList(QMdiArea::WindowOrder)const
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        QList<QMdiSubWindow * > cpp_result = cppSelf->QMdiArea::subWindowList(cpp_arg0);
        py_result = Shiboken::Converter<QList<QMdiSubWindow * > >::toPython(cpp_result);
    } else goto SbkQMdiAreaFunc_subWindowList_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMdiAreaFunc_subWindowList_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMdiArea.WindowOrder = CreationOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.subWindowList", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_tabPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabPosition()const
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    QTabWidget::TabPosition cpp_result = cppSelf->QMdiArea::tabPosition();
    py_result = Shiboken::Converter<QTabWidget::TabPosition >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMdiAreaFunc_tabShape(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabShape()const
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    QTabWidget::TabShape cpp_result = cppSelf->QMdiArea::tabShape();
    py_result = Shiboken::Converter<QTabWidget::TabShape >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMdiAreaFunc_testOption(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QMdiArea::AreaOption >::isConvertible(arg)) {
        QMdiArea::AreaOption cpp_arg0 = Shiboken::Converter<QMdiArea::AreaOption >::toCpp(arg);
        // testOption(QMdiArea::AreaOption)const
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMdiArea::testOption(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQMdiAreaFunc_testOption_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMdiAreaFunc_testOption_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMdiArea.AreaOption", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.testOption", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_tileSubWindows(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // tileSubWindows()
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    cppSelf->QMdiArea::tileSubWindows();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQMdiAreaFunc_timerEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimerEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTimerEvent* cpp_arg0 = Shiboken::Converter<QTimerEvent* >::toCpp(arg);
        // timerEvent(QTimerEvent*)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        cppSelf->QMdiArea::timerEvent(cpp_arg0);
    } else goto SbkQMdiAreaFunc_timerEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiAreaFunc_timerEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimerEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.timerEvent", overloads);
        return 0;
}

static PyObject*
SbkQMdiAreaFunc_viewMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewMode()const
    QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
    QMdiArea::ViewMode cpp_result = cppSelf->QMdiArea::viewMode();
    py_result = Shiboken::Converter<QMdiArea::ViewMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMdiAreaFunc_viewportEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // viewportEvent(QEvent*)
        QMdiArea* cppSelf = Shiboken::Converter<QMdiArea* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMdiArea::viewportEvent(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQMdiAreaFunc_viewportEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMdiAreaFunc_viewportEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiArea.viewportEvent", overloads);
        return 0;
}

static PyMethodDef SbkQMdiArea_methods[] = {
    {"activateNextSubWindow", (PyCFunction)SbkQMdiAreaFunc_activateNextSubWindow, METH_NOARGS},
    {"activatePreviousSubWindow", (PyCFunction)SbkQMdiAreaFunc_activatePreviousSubWindow, METH_NOARGS},
    {"activationOrder", (PyCFunction)SbkQMdiAreaFunc_activationOrder, METH_NOARGS},
    {"activeSubWindow", (PyCFunction)SbkQMdiAreaFunc_activeSubWindow, METH_NOARGS},
    {"addSubWindow", (PyCFunction)SbkQMdiAreaFunc_addSubWindow, METH_VARARGS},
    {"background", (PyCFunction)SbkQMdiAreaFunc_background, METH_NOARGS},
    {"cascadeSubWindows", (PyCFunction)SbkQMdiAreaFunc_cascadeSubWindows, METH_NOARGS},
    {"childEvent", (PyCFunction)SbkQMdiAreaFunc_childEvent, METH_O},
    {"closeActiveSubWindow", (PyCFunction)SbkQMdiAreaFunc_closeActiveSubWindow, METH_NOARGS},
    {"closeAllSubWindows", (PyCFunction)SbkQMdiAreaFunc_closeAllSubWindows, METH_NOARGS},
    {"currentSubWindow", (PyCFunction)SbkQMdiAreaFunc_currentSubWindow, METH_NOARGS},
    {"documentMode", (PyCFunction)SbkQMdiAreaFunc_documentMode, METH_NOARGS},
    {"event", (PyCFunction)SbkQMdiAreaFunc_event, METH_O},
    {"eventFilter", (PyCFunction)SbkQMdiAreaFunc_eventFilter, METH_VARARGS},
    {"minimumSizeHint", (PyCFunction)SbkQMdiAreaFunc_minimumSizeHint, METH_NOARGS},
    {"paintEvent", (PyCFunction)SbkQMdiAreaFunc_paintEvent, METH_O},
    {"removeSubWindow", (PyCFunction)SbkQMdiAreaFunc_removeSubWindow, METH_O},
    {"resizeEvent", (PyCFunction)SbkQMdiAreaFunc_resizeEvent, METH_O},
    {"scrollContentsBy", (PyCFunction)SbkQMdiAreaFunc_scrollContentsBy, METH_VARARGS},
    {"setActivationOrder", (PyCFunction)SbkQMdiAreaFunc_setActivationOrder, METH_O},
    {"setActiveSubWindow", (PyCFunction)SbkQMdiAreaFunc_setActiveSubWindow, METH_O},
    {"setBackground", (PyCFunction)SbkQMdiAreaFunc_setBackground, METH_O},
    {"setDocumentMode", (PyCFunction)SbkQMdiAreaFunc_setDocumentMode, METH_O},
    {"setOption", (PyCFunction)SbkQMdiAreaFunc_setOption, METH_VARARGS},
    {"setTabPosition", (PyCFunction)SbkQMdiAreaFunc_setTabPosition, METH_O},
    {"setTabShape", (PyCFunction)SbkQMdiAreaFunc_setTabShape, METH_O},
    {"setViewMode", (PyCFunction)SbkQMdiAreaFunc_setViewMode, METH_O},
    {"setupViewport", (PyCFunction)SbkQMdiAreaFunc_setupViewport, METH_O},
    {"showEvent", (PyCFunction)SbkQMdiAreaFunc_showEvent, METH_O},
    {"sizeHint", (PyCFunction)SbkQMdiAreaFunc_sizeHint, METH_NOARGS},
    {"subWindowList", (PyCFunction)SbkQMdiAreaFunc_subWindowList, METH_NOARGS|METH_O},
    {"tabPosition", (PyCFunction)SbkQMdiAreaFunc_tabPosition, METH_NOARGS},
    {"tabShape", (PyCFunction)SbkQMdiAreaFunc_tabShape, METH_NOARGS},
    {"testOption", (PyCFunction)SbkQMdiAreaFunc_testOption, METH_O},
    {"tileSubWindows", (PyCFunction)SbkQMdiAreaFunc_tileSubWindows, METH_NOARGS},
    {"timerEvent", (PyCFunction)SbkQMdiAreaFunc_timerEvent, METH_O},
    {"viewMode", (PyCFunction)SbkQMdiAreaFunc_viewMode, METH_NOARGS},
    {"viewportEvent", (PyCFunction)SbkQMdiAreaFunc_viewportEvent, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQMdiAreaSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QMdiArea* me = reinterpret_cast<QMdiArea*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX]))
        return static_cast<QAbstractScrollArea*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QFRAME_IDX]))
        return static_cast<QFrame*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMdiArea_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QMdiArea",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QMdiAreaWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMdiArea_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMdiArea_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQMdiAreaSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QMdiArea_WindowOrder_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QMdiArea_WindowOrder_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QMdiArea_WindowOrder_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WindowOrder",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QMdiArea_WindowOrder_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QMdiArea_WindowOrder_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QMdiArea_WindowOrder_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QMdiArea_ViewMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QMdiArea_ViewMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QMdiArea_ViewMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ViewMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QMdiArea_ViewMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QMdiArea_ViewMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QMdiArea_ViewMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QMdiArea_AreaOption___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMdiArea::AreaOptions >::toPython(
        ((QMdiArea::AreaOptions) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QMdiArea::AreaOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QMdiArea_AreaOption___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMdiArea::AreaOptions >::toPython(
        ((QMdiArea::AreaOptions) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QMdiArea::AreaOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QMdiArea_AreaOption___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMdiArea::AreaOptions >::toPython(
        ((QMdiArea::AreaOptions) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QMdiArea::AreaOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QMdiArea_AreaOption___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMdiArea::AreaOptions >::toPython(
        ~ Shiboken::Converter< QMdiArea::AreaOptions >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QMdiArea_AreaOption_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QMdiArea_AreaOption___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QMdiArea_AreaOption___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QMdiArea_AreaOption___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QMdiArea_AreaOption___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QMdiArea_AreaOption_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QMdiArea_AreaOption_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QMdiArea_AreaOption_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AreaOption",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QMdiArea_AreaOption_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QMdiArea_AreaOption_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QMdiArea_AreaOption_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QMdiArea_AreaOption_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QMdiArea_AreaOptions_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QMdiArea_AreaOptions_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AreaOptions",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QMdiArea_AreaOption_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QMdiArea_AreaOptions_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QMdiArea_AreaOptions_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QMdiArea_AreaOptions_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void)
init_QMdiArea(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QMDIAREA_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMdiArea_Type);

    SbkQMdiArea_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX];
    SbkQMdiArea_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQMdiArea_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQMdiArea_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMdiArea_Type));
    PyModule_AddObject(module, "QMdiArea",
        ((PyObject*)&SbkQMdiArea_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: WindowOrder
    SbkPySide_QtGuiTypes[SBK_QMDIAREA_WINDOWORDER_IDX] = &SbkPySide_QtGui_QMdiArea_WindowOrder_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QMdiArea_WindowOrder_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QMdiArea_WindowOrder_Type);
    PyDict_SetItemString(SbkQMdiArea_Type.super.ht_type.tp_dict,
            "WindowOrder",((PyObject*)&SbkPySide_QtGui_QMdiArea_WindowOrder_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMdiArea_WindowOrder_Type,
        (long) QMdiArea::CreationOrder, "CreationOrder");
    PyDict_SetItemString(SbkQMdiArea_Type.super.ht_type.tp_dict,
        "CreationOrder", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMdiArea_WindowOrder_Type.tp_dict,
        "CreationOrder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMdiArea_WindowOrder_Type,
        (long) QMdiArea::StackingOrder, "StackingOrder");
    PyDict_SetItemString(SbkQMdiArea_Type.super.ht_type.tp_dict,
        "StackingOrder", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMdiArea_WindowOrder_Type.tp_dict,
        "StackingOrder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMdiArea_WindowOrder_Type,
        (long) QMdiArea::ActivationHistoryOrder, "ActivationHistoryOrder");
    PyDict_SetItemString(SbkQMdiArea_Type.super.ht_type.tp_dict,
        "ActivationHistoryOrder", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMdiArea_WindowOrder_Type.tp_dict,
        "ActivationHistoryOrder", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QMdiArea::WindowOrder");

    // init enum class: ViewMode
    SbkPySide_QtGuiTypes[SBK_QMDIAREA_VIEWMODE_IDX] = &SbkPySide_QtGui_QMdiArea_ViewMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QMdiArea_ViewMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QMdiArea_ViewMode_Type);
    PyDict_SetItemString(SbkQMdiArea_Type.super.ht_type.tp_dict,
            "ViewMode",((PyObject*)&SbkPySide_QtGui_QMdiArea_ViewMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMdiArea_ViewMode_Type,
        (long) QMdiArea::SubWindowView, "SubWindowView");
    PyDict_SetItemString(SbkQMdiArea_Type.super.ht_type.tp_dict,
        "SubWindowView", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMdiArea_ViewMode_Type.tp_dict,
        "SubWindowView", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMdiArea_ViewMode_Type,
        (long) QMdiArea::TabbedView, "TabbedView");
    PyDict_SetItemString(SbkQMdiArea_Type.super.ht_type.tp_dict,
        "TabbedView", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMdiArea_ViewMode_Type.tp_dict,
        "TabbedView", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QMdiArea::ViewMode");

    // init enum class: AreaOption
    SbkPySide_QtGuiTypes[SBK_QMDIAREA_AREAOPTION_IDX] = &SbkPySide_QtGui_QMdiArea_AreaOption_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QMdiArea_AreaOption_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QMdiArea_AreaOption_Type);
    PyDict_SetItemString(SbkQMdiArea_Type.super.ht_type.tp_dict,
            "AreaOption",((PyObject*)&SbkPySide_QtGui_QMdiArea_AreaOption_Type));

    // init flags class: QFlags<QMdiArea::AreaOption>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QMDIAREA_AREAOPTION__IDX] = &SbkPySide_QtGui_QMdiArea_AreaOptions_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QMdiArea_AreaOptions_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QMdiArea_AreaOptions_Type);
    PyDict_SetItemString(SbkQMdiArea_Type.super.ht_type.tp_dict,
            "AreaOptions",((PyObject*)&SbkPySide_QtGui_QMdiArea_AreaOptions_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMdiArea_AreaOption_Type,
        (long) QMdiArea::DontMaximizeSubWindowOnActivation, "DontMaximizeSubWindowOnActivation");
    PyDict_SetItemString(SbkQMdiArea_Type.super.ht_type.tp_dict,
        "DontMaximizeSubWindowOnActivation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMdiArea_AreaOption_Type.tp_dict,
        "DontMaximizeSubWindowOnActivation", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QMdiArea::AreaOption");

    Shiboken::TypeResolver::createObjectTypeResolver<QMdiArea >("QMdiArea*");
    Shiboken::TypeResolver::createObjectTypeResolver<QMdiArea >(typeid(QMdiArea).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

