/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qmatrix4x4_wrapper.h"

// Extra includes
#include <qdatastream.h>
#include <qgenericmatrix.h>
#include <qmatrix.h>
#include <qmatrix4x4.h>
#include <qpoint.h>
#include <qquaternion.h>
#include <qrect.h>
#include <qtransform.h>
#include <qvariant.h>
#include <qvector3d.h>
#include <qvector4d.h>

using namespace Shiboken;

static int
SbkQMatrix4x4_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMatrix4x4* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3 || numArgs == 4 || numArgs == 5 || numArgs == 6 || numArgs == 7 || numArgs == 8 || numArgs == 9 || numArgs == 10 || numArgs == 11 || numArgs == 12 || numArgs == 13 || numArgs == 14 || numArgs == 15)
        goto SbkQMatrix4x4_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QMatrix4x4", 0, 16, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7]), &(pyargs[8]), &(pyargs[9]), &(pyargs[10]), &(pyargs[11]), &(pyargs[12]), &(pyargs[13]), &(pyargs[14]), &(pyargs[15])))
        return -1;

    if (numArgs == 0) {
        // QMatrix4x4()
        cptr = new QMatrix4x4();
    } else if (numArgs == 16 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5]) && PyNumber_Check(pyargs[6]) && PyNumber_Check(pyargs[7]) && PyNumber_Check(pyargs[8]) && PyNumber_Check(pyargs[9]) && PyNumber_Check(pyargs[10]) && PyNumber_Check(pyargs[11]) && PyNumber_Check(pyargs[12]) && PyNumber_Check(pyargs[13]) && PyNumber_Check(pyargs[14]) && PyNumber_Check(pyargs[15])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        qreal cpp_arg4 = Shiboken::Converter<qreal >::toCpp(pyargs[4]);
        qreal cpp_arg5 = Shiboken::Converter<qreal >::toCpp(pyargs[5]);
        qreal cpp_arg6 = Shiboken::Converter<qreal >::toCpp(pyargs[6]);
        qreal cpp_arg7 = Shiboken::Converter<qreal >::toCpp(pyargs[7]);
        qreal cpp_arg8 = Shiboken::Converter<qreal >::toCpp(pyargs[8]);
        qreal cpp_arg9 = Shiboken::Converter<qreal >::toCpp(pyargs[9]);
        qreal cpp_arg10 = Shiboken::Converter<qreal >::toCpp(pyargs[10]);
        qreal cpp_arg11 = Shiboken::Converter<qreal >::toCpp(pyargs[11]);
        qreal cpp_arg12 = Shiboken::Converter<qreal >::toCpp(pyargs[12]);
        qreal cpp_arg13 = Shiboken::Converter<qreal >::toCpp(pyargs[13]);
        qreal cpp_arg14 = Shiboken::Converter<qreal >::toCpp(pyargs[14]);
        qreal cpp_arg15 = Shiboken::Converter<qreal >::toCpp(pyargs[15]);
        // QMatrix4x4(qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal,qreal)
        cptr = new QMatrix4x4(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6, cpp_arg7, cpp_arg8, cpp_arg9, cpp_arg10, cpp_arg11, cpp_arg12, cpp_arg13, cpp_arg14, cpp_arg15);
    } else if (numArgs == 1 && PySequence_Check(pyargs[0])) {
        // QMatrix4x4(const qreal*)
        // Begin code injection
        
        if (PySequence_Size(pyargs[0]) == 16) {
            qreal values[16];
            for(int i=0; i < 16; i++) {
                PyObject *pv = PySequence_Fast_GET_ITEM(pyargs[0], i);
                values[i] = PyFloat_AsDouble(pv);
            }
        
            cptr = new QMatrix4x4(values[0], values[1], values[2], values[3],
                           values[4], values[5], values[6], values[7],
                           values[8], values[9], values[10], values[11],
                           values[12], values[13], values[14], values[15]);
        }
        
        // End of code injection

    } else if (numArgs == 1 && Shiboken::Converter<QTransform& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(pyargs[0]);
        // QMatrix4x4(QTransform)
        cptr = new QMatrix4x4(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QMatrix& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(pyargs[0]);
        // QMatrix4x4(QMatrix)
        cptr = new QMatrix4x4(*cpp_arg0);
    } else goto SbkQMatrix4x4_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQMatrix4x4_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQMatrix4x4_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QMatrix", "PySide.QtGui.QTransform", "qreal", "float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMatrix4x4", overloads);
        return -1;
}

static PyObject*
SbkQMatrix4x4Func_column(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // column(int)const
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QVector4D cpp_result = cppSelf->QMatrix4x4::column(cpp_arg0);
        py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);
    } else goto SbkQMatrix4x4Func_column_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMatrix4x4Func_column_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.column", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_copyDataTo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // copyDataTo(qreal*)const
    QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
    // Begin code injection
    
    qreal values[16];
    cppSelf->copyDataTo(values);
    py_result = PyTuple_New(16);
    for(int i=0; i < 16; i++) {
      PyObject *v = PyFloat_FromDouble(values[i]);
      PyTuple_SET_ITEM(py_result, i, v);
    }
    
    // End of code injection



    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMatrix4x4Func_data(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // constData()const
    QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
    // Begin code injection
    
    const qreal* values = cppSelf->constData();
    py_result = PyTuple_New(16);
    for(int i=0; i < 16; i++) {
      PyObject *v = PyFloat_FromDouble(values[i]);
      PyTuple_SET_ITEM(py_result, i, v);
    }
    
    // End of code injection



    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMatrix4x4Func_determinant(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // determinant()const
    QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QMatrix4x4::determinant();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMatrix4x4Func_fill(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // fill(qreal)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        cppSelf->QMatrix4x4::fill(cpp_arg0);
    } else goto SbkQMatrix4x4Func_fill_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMatrix4x4Func_fill_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.fill", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_flipCoordinates(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // flipCoordinates()
    QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
    cppSelf->QMatrix4x4::flipCoordinates();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQMatrix4x4Func_frustum(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "frustum", 6, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (numArgs == 6 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        qreal cpp_arg4 = Shiboken::Converter<qreal >::toCpp(pyargs[4]);
        qreal cpp_arg5 = Shiboken::Converter<qreal >::toCpp(pyargs[5]);
        // frustum(qreal,qreal,qreal,qreal,qreal,qreal)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        cppSelf->QMatrix4x4::frustum(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
    } else goto SbkQMatrix4x4Func_frustum_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMatrix4x4Func_frustum_TypeError:
        const char* overloads[] = {"float, float, float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMatrix4x4.frustum", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_inverted(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // inverted(bool*)const
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QMatrix4x4 cpp_result = cppSelf->QMatrix4x4::inverted();
        py_result = Shiboken::Converter<QMatrix4x4 >::toPython(cpp_result);
    } else if (PyBool_Check(arg)) {
        bool * cpp_arg0 = Shiboken::Converter<bool * >::toCpp(arg);
        // inverted(bool*)const
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QMatrix4x4 cpp_result = cppSelf->QMatrix4x4::inverted(cpp_arg0);
        py_result = Shiboken::Converter<QMatrix4x4 >::toPython(cpp_result);
    } else goto SbkQMatrix4x4Func_inverted_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMatrix4x4Func_inverted_TypeError:
        const char* overloads[] = {"bool = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.inverted", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_isIdentity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isIdentity()const
    QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMatrix4x4::isIdentity();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMatrix4x4Func_lookAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "lookAt", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QVector3D& >::isConvertible(pyargs[0]) && Shiboken::Converter<QVector3D& >::isConvertible(pyargs[1]) && Shiboken::Converter<QVector3D& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVector3D > cpp_arg0_auto_ptr;
        QVector3D* cpp_arg0 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QVector3D& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVector3D > cpp_arg1_auto_ptr;
        QVector3D* cpp_arg1 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVector3D& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QVector3D > cpp_arg2_auto_ptr;
        QVector3D* cpp_arg2 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QVector3D& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg2);
        // lookAt(QVector3D,QVector3D,QVector3D)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        cppSelf->QMatrix4x4::lookAt(*cpp_arg0, *cpp_arg1, *cpp_arg2);
    } else goto SbkQMatrix4x4Func_lookAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMatrix4x4Func_lookAt_TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector3D, PySide.QtGui.QVector3D, PySide.QtGui.QVector3D", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMatrix4x4.lookAt", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_map(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QVector3D& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVector3D > cpp_arg0_auto_ptr;
        QVector3D* cpp_arg0 = Shiboken::Converter<QVector3D* >::toCpp(arg);
        if (!Shiboken::Converter<QVector3D& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg0);
        // map(QVector3D)const
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QVector3D cpp_result = cppSelf->QMatrix4x4::map(*cpp_arg0);
        py_result = Shiboken::Converter<QVector3D >::toPython(cpp_result);
    } else if (Shiboken::Converter<QVector4D& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVector4D > cpp_arg0_auto_ptr;
        QVector4D* cpp_arg0 = Shiboken::Converter<QVector4D* >::toCpp(arg);
        if (!Shiboken::Converter<QVector4D& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg0);
        // map(QVector4D)const
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QVector4D cpp_result = cppSelf->QMatrix4x4::map(*cpp_arg0);
        py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // map(QPoint)const
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QPoint cpp_result = cppSelf->QMatrix4x4::map(*cpp_arg0);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // map(QPointF)const
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QPointF cpp_result = cppSelf->QMatrix4x4::map(*cpp_arg0);
        py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    } else goto SbkQMatrix4x4Func_map_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMatrix4x4Func_map_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "PySide.QtCore.QPointF", "PySide.QtGui.QVector3D", "PySide.QtGui.QVector4D", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.map", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_mapRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // mapRect(QRect)const
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QMatrix4x4::mapRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else if (Shiboken::Converter<QRectF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!Shiboken::Converter<QRectF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // mapRect(QRectF)const
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QMatrix4x4::mapRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    } else goto SbkQMatrix4x4Func_mapRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMatrix4x4Func_mapRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.mapRect", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_mapVector(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QVector3D& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVector3D > cpp_arg0_auto_ptr;
        QVector3D* cpp_arg0 = Shiboken::Converter<QVector3D* >::toCpp(arg);
        if (!Shiboken::Converter<QVector3D& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg0);
        // mapVector(QVector3D)const
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QVector3D cpp_result = cppSelf->QMatrix4x4::mapVector(*cpp_arg0);
        py_result = Shiboken::Converter<QVector3D >::toPython(cpp_result);
    } else goto SbkQMatrix4x4Func_mapVector_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMatrix4x4Func_mapVector_TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector3D", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.mapVector", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_normalMatrix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // normalMatrix()const
    QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
    QMatrix3x3 cpp_result = cppSelf->QMatrix4x4::normalMatrix();
    py_result = Shiboken::Converter<QMatrix3x3 >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMatrix4x4Func_optimize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // optimize()
    QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
    cppSelf->QMatrix4x4::optimize();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQMatrix4x4Func_ortho(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3 || numArgs == 4 || numArgs == 5)
        goto SbkQMatrix4x4Func_ortho_TypeError;

    if (!PyArg_UnpackTuple(args, "ortho", 1, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (numArgs == 6 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        qreal cpp_arg4 = Shiboken::Converter<qreal >::toCpp(pyargs[4]);
        qreal cpp_arg5 = Shiboken::Converter<qreal >::toCpp(pyargs[5]);
        // ortho(qreal,qreal,qreal,qreal,qreal,qreal)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        cppSelf->QMatrix4x4::ortho(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
    } else if (numArgs == 1 && Shiboken::Converter<QRect& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        // ortho(QRect)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        cppSelf->QMatrix4x4::ortho(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // ortho(QRectF)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        cppSelf->QMatrix4x4::ortho(*cpp_arg0);
    } else goto SbkQMatrix4x4Func_ortho_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMatrix4x4Func_ortho_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "PySide.QtCore.QRectF", "float, float, float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMatrix4x4.ortho", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_perspective(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "perspective", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // perspective(qreal,qreal,qreal,qreal)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        cppSelf->QMatrix4x4::perspective(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else goto SbkQMatrix4x4Func_perspective_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMatrix4x4Func_perspective_TypeError:
        const char* overloads[] = {"float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMatrix4x4.perspective", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_rotate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "rotate", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        if (PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
            qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // rotate(qreal,qreal,qreal,qreal)
                QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
                cppSelf->QMatrix4x4::rotate(cpp_arg0, cpp_arg1, cpp_arg2);
            } else if (PyNumber_Check(pyargs[3])) {
                qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
                // rotate(qreal,qreal,qreal,qreal)
                QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
                cppSelf->QMatrix4x4::rotate(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            } else goto SbkQMatrix4x4Func_rotate_TypeError;
        } else if (numArgs == 2 && Shiboken::Converter<QVector3D& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector3D > cpp_arg1_auto_ptr;
            QVector3D* cpp_arg1 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QVector3D& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg1);
            // rotate(qreal,QVector3D)
            QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
            cppSelf->QMatrix4x4::rotate(cpp_arg0, *cpp_arg1);
        } else goto SbkQMatrix4x4Func_rotate_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QQuaternion& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QQuaternion* cpp_arg0 = Shiboken::Converter<QQuaternion* >::toCpp(pyargs[0]);
        // rotate(QQuaternion)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        cppSelf->QMatrix4x4::rotate(*cpp_arg0);
    } else goto SbkQMatrix4x4Func_rotate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMatrix4x4Func_rotate_TypeError:
        const char* overloads[] = {"PySide.QtGui.QQuaternion", "float, PySide.QtGui.QVector3D", "float, float, float, float = 0.0f", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMatrix4x4.rotate", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_row(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // row(int)const
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QVector4D cpp_result = cppSelf->QMatrix4x4::row(cpp_arg0);
        py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);
    } else goto SbkQMatrix4x4Func_row_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMatrix4x4Func_row_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.row", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_scale(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "scale", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // scale(qreal)
            QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
            cppSelf->QMatrix4x4::scale(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // scale(qreal,qreal)
                QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
                cppSelf->QMatrix4x4::scale(cpp_arg0, cpp_arg1);
            } else if (numArgs == 3 && PyNumber_Check(pyargs[2])) {
                qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
                // scale(qreal,qreal,qreal)
                QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
                cppSelf->QMatrix4x4::scale(cpp_arg0, cpp_arg1, cpp_arg2);
            } else goto SbkQMatrix4x4Func_scale_TypeError;
        } else goto SbkQMatrix4x4Func_scale_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QVector3D& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVector3D > cpp_arg0_auto_ptr;
        QVector3D* cpp_arg0 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QVector3D& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg0);
        // scale(QVector3D)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        cppSelf->QMatrix4x4::scale(*cpp_arg0);
    } else goto SbkQMatrix4x4Func_scale_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMatrix4x4Func_scale_TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector3D", "float", "float, float", "float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMatrix4x4.scale", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_setColumn(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setColumn", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QVector4D& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVector4D > cpp_arg1_auto_ptr;
        QVector4D* cpp_arg1 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVector4D& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg1);
        // setColumn(int,QVector4D)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        cppSelf->QMatrix4x4::setColumn(cpp_arg0, *cpp_arg1);
    } else goto SbkQMatrix4x4Func_setColumn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMatrix4x4Func_setColumn_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QVector4D", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMatrix4x4.setColumn", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_setRow(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRow", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QVector4D& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVector4D > cpp_arg1_auto_ptr;
        QVector4D* cpp_arg1 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVector4D& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg1);
        // setRow(int,QVector4D)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        cppSelf->QMatrix4x4::setRow(cpp_arg0, *cpp_arg1);
    } else goto SbkQMatrix4x4Func_setRow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMatrix4x4Func_setRow_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QVector4D", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMatrix4x4.setRow", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_setToIdentity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // setToIdentity()
    QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
    cppSelf->QMatrix4x4::setToIdentity();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQMatrix4x4Func_toAffine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toAffine()const
    QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
    QMatrix cpp_result = cppSelf->QMatrix4x4::toAffine();
    py_result = Shiboken::Converter<QMatrix >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMatrix4x4Func_toTransform(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toTransform()const
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QTransform cpp_result = cppSelf->QMatrix4x4::toTransform();
        py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // toTransform(qreal)const
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QTransform cpp_result = cppSelf->QMatrix4x4::toTransform(cpp_arg0);
        py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);
    } else goto SbkQMatrix4x4Func_toTransform_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMatrix4x4Func_toTransform_TypeError:
        const char* overloads[] = {"", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.toTransform", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_translate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "translate", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // translate(qreal,qreal)
            QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
            cppSelf->QMatrix4x4::translate(cpp_arg0, cpp_arg1);
        } else if (numArgs == 3 && PyNumber_Check(pyargs[2])) {
            qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
            // translate(qreal,qreal,qreal)
            QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
            cppSelf->QMatrix4x4::translate(cpp_arg0, cpp_arg1, cpp_arg2);
        } else goto SbkQMatrix4x4Func_translate_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QVector3D& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVector3D > cpp_arg0_auto_ptr;
        QVector3D* cpp_arg0 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QVector3D& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg0);
        // translate(QVector3D)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        cppSelf->QMatrix4x4::translate(*cpp_arg0);
    } else goto SbkQMatrix4x4Func_translate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMatrix4x4Func_translate_TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector3D", "float, float", "float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMatrix4x4.translate", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func_transposed(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // transposed()const
    QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
    QMatrix4x4 cpp_result = cppSelf->QMatrix4x4::transposed();
    py_result = Shiboken::Converter<QMatrix4x4 >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQMatrix4x4_methods[] = {
    {"column", (PyCFunction)SbkQMatrix4x4Func_column, METH_O},
    {"copyDataTo", (PyCFunction)SbkQMatrix4x4Func_copyDataTo, METH_NOARGS},
    {"data", (PyCFunction)SbkQMatrix4x4Func_data, METH_NOARGS},
    {"determinant", (PyCFunction)SbkQMatrix4x4Func_determinant, METH_NOARGS},
    {"fill", (PyCFunction)SbkQMatrix4x4Func_fill, METH_O},
    {"flipCoordinates", (PyCFunction)SbkQMatrix4x4Func_flipCoordinates, METH_NOARGS},
    {"frustum", (PyCFunction)SbkQMatrix4x4Func_frustum, METH_VARARGS},
    {"inverted", (PyCFunction)SbkQMatrix4x4Func_inverted, METH_NOARGS|METH_O},
    {"isIdentity", (PyCFunction)SbkQMatrix4x4Func_isIdentity, METH_NOARGS},
    {"lookAt", (PyCFunction)SbkQMatrix4x4Func_lookAt, METH_VARARGS},
    {"map", (PyCFunction)SbkQMatrix4x4Func_map, METH_O},
    {"mapRect", (PyCFunction)SbkQMatrix4x4Func_mapRect, METH_O},
    {"mapVector", (PyCFunction)SbkQMatrix4x4Func_mapVector, METH_O},
    {"normalMatrix", (PyCFunction)SbkQMatrix4x4Func_normalMatrix, METH_NOARGS},
    {"optimize", (PyCFunction)SbkQMatrix4x4Func_optimize, METH_NOARGS},
    {"ortho", (PyCFunction)SbkQMatrix4x4Func_ortho, METH_VARARGS},
    {"perspective", (PyCFunction)SbkQMatrix4x4Func_perspective, METH_VARARGS},
    {"rotate", (PyCFunction)SbkQMatrix4x4Func_rotate, METH_VARARGS},
    {"row", (PyCFunction)SbkQMatrix4x4Func_row, METH_O},
    {"scale", (PyCFunction)SbkQMatrix4x4Func_scale, METH_VARARGS},
    {"setColumn", (PyCFunction)SbkQMatrix4x4Func_setColumn, METH_VARARGS},
    {"setRow", (PyCFunction)SbkQMatrix4x4Func_setRow, METH_VARARGS},
    {"setToIdentity", (PyCFunction)SbkQMatrix4x4Func_setToIdentity, METH_NOARGS},
    {"toAffine", (PyCFunction)SbkQMatrix4x4Func_toAffine, METH_NOARGS},
    {"toTransform", (PyCFunction)SbkQMatrix4x4Func_toTransform, METH_NOARGS|METH_O},
    {"translate", (PyCFunction)SbkQMatrix4x4Func_translate, METH_VARARGS},
    {"transposed", (PyCFunction)SbkQMatrix4x4Func_transposed, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQMatrix4x4Func___mul__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQMatrix4x4_Check(arg) && !SbkQMatrix4x4_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(QMatrix4x4,qreal)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QMatrix4x4 cpp_result = (*cppSelf) * cpp_arg0;
        py_result = Shiboken::Converter<QMatrix4x4 >::toPython(cpp_result);
    } else if (isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(qreal,QMatrix4x4) [reverse operator]
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QMatrix4x4 cpp_result = cpp_arg0 * (*cppSelf);
        py_result = Shiboken::Converter<QMatrix4x4 >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<QVector3D& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVector3D > cpp_arg0_auto_ptr;
        QVector3D* cpp_arg0 = Shiboken::Converter<QVector3D* >::toCpp(arg);
        if (!Shiboken::Converter<QVector3D& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg0);
        // operator*(QMatrix4x4,QVector3D)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QVector3D cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QVector3D >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<QVector4D& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVector4D > cpp_arg0_auto_ptr;
        QVector4D* cpp_arg0 = Shiboken::Converter<QVector4D* >::toCpp(arg);
        if (!Shiboken::Converter<QVector4D& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg0);
        // operator*(QMatrix4x4,QVector4D)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QVector4D cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // operator*(QMatrix4x4,QPoint)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QPoint cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // operator*(QMatrix4x4,QPointF)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QPointF cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<QMatrix4x4& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QMatrix4x4 > cpp_arg0_auto_ptr;
        QMatrix4x4* cpp_arg0 = Shiboken::Converter<QMatrix4x4* >::toCpp(arg);
        if (!Shiboken::Converter<QMatrix4x4& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_arg0);
        // operator*(QMatrix4x4,QMatrix4x4)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QMatrix4x4 cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QMatrix4x4 >::toPython(cpp_result);
    } else goto SbkQMatrix4x4Func___mul___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMatrix4x4Func___mul___TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix4x4", "PySide.QtCore.QPoint", "PySide.QtCore.QPointF", "PySide.QtGui.QVector3D", "PySide.QtGui.QVector4D", "float", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.__mul__", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func___imul__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQMatrix4x4_Check(arg) && !SbkQMatrix4x4_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*=(qreal)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        (*cppSelf) *= cpp_arg0;
    } else if (!isReverse && Shiboken::Converter<QMatrix4x4& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QMatrix4x4 > cpp_arg0_auto_ptr;
        QMatrix4x4* cpp_arg0 = Shiboken::Converter<QMatrix4x4* >::toCpp(arg);
        if (!Shiboken::Converter<QMatrix4x4& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_arg0);
        // operator*=(QMatrix4x4)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        (*cppSelf) *= (*cpp_arg0);
    } else goto SbkQMatrix4x4Func___imul___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQMatrix4x4Func___imul___TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix4x4", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.__imul__", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func___add__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQMatrix4x4_Check(arg) && !SbkQMatrix4x4_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QMatrix4x4& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QMatrix4x4 > cpp_arg0_auto_ptr;
        QMatrix4x4* cpp_arg0 = Shiboken::Converter<QMatrix4x4* >::toCpp(arg);
        if (!Shiboken::Converter<QMatrix4x4& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_arg0);
        // operator+(QMatrix4x4,QMatrix4x4)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QMatrix4x4 cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QMatrix4x4 >::toPython(cpp_result);
    } else goto SbkQMatrix4x4Func___add___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMatrix4x4Func___add___TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix4x4", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.__add__", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func___iadd__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQMatrix4x4_Check(arg) && !SbkQMatrix4x4_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QMatrix4x4& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QMatrix4x4 > cpp_arg0_auto_ptr;
        QMatrix4x4* cpp_arg0 = Shiboken::Converter<QMatrix4x4* >::toCpp(arg);
        if (!Shiboken::Converter<QMatrix4x4& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_arg0);
        // operator+=(QMatrix4x4)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        (*cppSelf) += (*cpp_arg0);
    } else goto SbkQMatrix4x4Func___iadd___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQMatrix4x4Func___iadd___TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix4x4", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.__iadd__", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func___neg__(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // operator-(QMatrix4x4)
    QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
    QMatrix4x4 cpp_result = - (*cppSelf);
    py_result = Shiboken::Converter<QMatrix4x4 >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMatrix4x4Func___sub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQMatrix4x4_Check(arg) && !SbkQMatrix4x4_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QMatrix4x4& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QMatrix4x4 > cpp_arg0_auto_ptr;
        QMatrix4x4* cpp_arg0 = Shiboken::Converter<QMatrix4x4* >::toCpp(arg);
        if (!Shiboken::Converter<QMatrix4x4& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_arg0);
        // operator-(QMatrix4x4,QMatrix4x4)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QMatrix4x4 cpp_result = (*cppSelf) - (*cpp_arg0);
        py_result = Shiboken::Converter<QMatrix4x4 >::toPython(cpp_result);
    } else goto SbkQMatrix4x4Func___sub___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMatrix4x4Func___sub___TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix4x4", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.__sub__", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func___isub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQMatrix4x4_Check(arg) && !SbkQMatrix4x4_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QMatrix4x4& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QMatrix4x4 > cpp_arg0_auto_ptr;
        QMatrix4x4* cpp_arg0 = Shiboken::Converter<QMatrix4x4* >::toCpp(arg);
        if (!Shiboken::Converter<QMatrix4x4& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_arg0);
        // operator-=(QMatrix4x4)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        (*cppSelf) -= (*cpp_arg0);
    } else goto SbkQMatrix4x4Func___isub___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQMatrix4x4Func___isub___TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix4x4", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.__isub__", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func___div__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQMatrix4x4_Check(arg) && !SbkQMatrix4x4_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/(QMatrix4x4,qreal)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QMatrix4x4 cpp_result = (*cppSelf) / cpp_arg0;
        py_result = Shiboken::Converter<QMatrix4x4 >::toPython(cpp_result);
    } else goto SbkQMatrix4x4Func___div___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMatrix4x4Func___div___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.__div__", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func___idiv__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQMatrix4x4_Check(arg) && !SbkQMatrix4x4_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/=(qreal)
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        (*cppSelf) /= cpp_arg0;
    } else goto SbkQMatrix4x4Func___idiv___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQMatrix4x4Func___idiv___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.__idiv__", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQMatrix4x4_Check(arg) && !SbkQMatrix4x4_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QMatrix4x4) [reverse operator]
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQMatrix4x4Func___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMatrix4x4Func___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.__lshift__", overloads);
        return 0;
}

static PyObject*
SbkQMatrix4x4Func___rshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQMatrix4x4_Check(arg) && !SbkQMatrix4x4_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rrshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QMatrix4x4&) [reverse operator]
        QMatrix4x4* cppSelf = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQMatrix4x4Func___rshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMatrix4x4Func___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMatrix4x4.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQMatrix4x4_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQMatrix4x4Func___add__,
    /*nb_subtract*/             (binaryfunc)SbkQMatrix4x4Func___sub__,
    /*nb_multiply*/             (binaryfunc)SbkQMatrix4x4Func___mul__,
    /*nb_divide*/               (binaryfunc)SbkQMatrix4x4Func___div__,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)SbkQMatrix4x4Func___neg__,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQMatrix4x4Func___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQMatrix4x4Func___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQMatrix4x4Func___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)SbkQMatrix4x4Func___isub__,
    /*nb_inplace_multiply*/     (binaryfunc)SbkQMatrix4x4Func___imul__,
    /*nb_inplace_divide*/       (binaryfunc)SbkQMatrix4x4Func___idiv__,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQMatrix4x4_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QMatrix4x4& cpp_self = *Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QMatrix4x4& >::isConvertible(other)) {
                QMatrix4x4* cpp_other = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QMatrix4x4 >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QMatrix4x4 > cpp_other_auto_ptr;
                QMatrix4x4* cpp_other = Shiboken::Converter<QMatrix4x4* >::toCpp(other);
                if (!Shiboken::Converter<QMatrix4x4 >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQMatrix4x4_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QMatrix4x4& >::isConvertible(other)) {
                QMatrix4x4* cpp_other = Shiboken::Converter<QMatrix4x4* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QMatrix4x4 >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QMatrix4x4 > cpp_other_auto_ptr;
                QMatrix4x4* cpp_other = Shiboken::Converter<QMatrix4x4* >::toCpp(other);
                if (!Shiboken::Converter<QMatrix4x4 >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQMatrix4x4_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQMatrix4x4_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMatrix4x4_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QMatrix4x4",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QMatrix4x4 >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQMatrix4x4_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQMatrix4x4_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMatrix4x4_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMatrix4x4_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QMatrix4x4(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QMATRIX4X4_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMatrix4x4_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQMatrix4x4_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMatrix4x4_Type));
    PyModule_AddObject(module, "QMatrix4x4",
        ((PyObject*)&SbkQMatrix4x4_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QMatrix4x4 >("QMatrix4x4");
    Shiboken::TypeResolver::createValueTypeResolver<QMatrix4x4 >(typeid(QMatrix4x4).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

