/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qimagewriter_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qimage.h>
#include <qimagewriter.h>
#include <qiodevice.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQImageWriter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QImageWriter* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QImageWriter", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QImageWriter()
        cptr = new QImageWriter();
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QImageWriter(QString,QByteArray)
            cptr = new QImageWriter(*cpp_arg0);
        } else if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            // QImageWriter(QString,QByteArray)
            cptr = new QImageWriter(*cpp_arg0, *cpp_arg1);
        } else goto SbkQImageWriter_Init_TypeError;
    } else if (numArgs == 2 && Shiboken::Converter<QIODevice* >::isConvertible(pyargs[0]) && Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
        QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
        // QImageWriter(QIODevice*,QByteArray)
        cptr = new QImageWriter(cpp_arg0, *cpp_arg1);
    } else goto SbkQImageWriter_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQImageWriter_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQImageWriter_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QIODevice, PySide.QtCore.QByteArray", "PySide.QtCore.QString, PySide.QtCore.QByteArray = QByteArray()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QImageWriter", overloads);
        return -1;
}

static PyObject*
SbkQImageWriterFunc_canWrite(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canWrite()const
    QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QImageWriter::canWrite();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQImageWriterFunc_compression(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // compression()const
    QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QImageWriter::compression();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQImageWriterFunc_device(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // device()const
    QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
    QIODevice * cpp_result = cppSelf->QImageWriter::device();
    py_result = Shiboken::Converter<QIODevice* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQImageWriterFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
    QImageWriter::ImageWriterError cpp_result = cppSelf->QImageWriter::error();
    py_result = Shiboken::Converter<QImageWriter::ImageWriterError >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQImageWriterFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QImageWriter::errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQImageWriterFunc_fileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileName()const
    QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QImageWriter::fileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQImageWriterFunc_format(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // format()const
    QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QImageWriter::format();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQImageWriterFunc_gamma(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // gamma()const
    QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
    float cpp_result = cppSelf->QImageWriter::gamma();
    py_result = Shiboken::Converter<float >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQImageWriterFunc_quality(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // quality()const
    QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QImageWriter::quality();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQImageWriterFunc_setCompression(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCompression(int)
        QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
        cppSelf->QImageWriter::setCompression(cpp_arg0);
    } else goto SbkQImageWriterFunc_setCompression_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageWriterFunc_setCompression_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageWriter.setCompression", overloads);
        return 0;
}

static PyObject*
SbkQImageWriterFunc_setDevice(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIODevice* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // setDevice(QIODevice*)
        QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
        cppSelf->QImageWriter::setDevice(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQImageWriterFunc_setDevice_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageWriterFunc_setDevice_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageWriter.setDevice", overloads);
        return 0;
}

static PyObject*
SbkQImageWriterFunc_setFileName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFileName(QString)
        QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
        cppSelf->QImageWriter::setFileName(*cpp_arg0);
    } else goto SbkQImageWriterFunc_setFileName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageWriterFunc_setFileName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageWriter.setFileName", overloads);
        return 0;
}

static PyObject*
SbkQImageWriterFunc_setFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // setFormat(QByteArray)
        QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
        cppSelf->QImageWriter::setFormat(*cpp_arg0);
    } else goto SbkQImageWriterFunc_setFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageWriterFunc_setFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageWriter.setFormat", overloads);
        return 0;
}

static PyObject*
SbkQImageWriterFunc_setGamma(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        float cpp_arg0 = Shiboken::Converter<float >::toCpp(arg);
        // setGamma(float)
        QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
        cppSelf->QImageWriter::setGamma(cpp_arg0);
    } else goto SbkQImageWriterFunc_setGamma_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageWriterFunc_setGamma_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageWriter.setGamma", overloads);
        return 0;
}

static PyObject*
SbkQImageWriterFunc_setQuality(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setQuality(int)
        QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
        cppSelf->QImageWriter::setQuality(cpp_arg0);
    } else goto SbkQImageWriterFunc_setQuality_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageWriterFunc_setQuality_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageWriter.setQuality", overloads);
        return 0;
}

static PyObject*
SbkQImageWriterFunc_setText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setText", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setText(QString,QString)
        QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
        cppSelf->QImageWriter::setText(*cpp_arg0, *cpp_arg1);
    } else goto SbkQImageWriterFunc_setText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageWriterFunc_setText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QImageWriter.setText", overloads);
        return 0;
}

static PyObject*
SbkQImageWriterFunc_supportedImageFormats(PyObject* self)
{
    PyObject* py_result = 0;

    // supportedImageFormats()
    QList<QByteArray > cpp_result = QImageWriter::supportedImageFormats();
    py_result = Shiboken::Converter<QList<QByteArray > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQImageWriterFunc_supportsOption(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QImageIOHandler::ImageOption >::isConvertible(arg)) {
        QImageIOHandler::ImageOption cpp_arg0 = Shiboken::Converter<QImageIOHandler::ImageOption >::toCpp(arg);
        // supportsOption(QImageIOHandler::ImageOption)const
        QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QImageWriter::supportsOption(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQImageWriterFunc_supportsOption_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQImageWriterFunc_supportsOption_TypeError:
        const char* overloads[] = {"PySide.QtGui.QImageIOHandler.ImageOption", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageWriter.supportsOption", overloads);
        return 0;
}

static PyObject*
SbkQImageWriterFunc_write(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (Shiboken::Converter<QImage& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QImage* cpp_arg0 = Shiboken::Converter<QImage* >::toCpp(arg);
        // write(QImage)
        QImageWriter* cppSelf = Shiboken::Converter<QImageWriter* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QImageWriter::write(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQImageWriterFunc_write_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQImageWriterFunc_write_TypeError:
        const char* overloads[] = {"PySide.QtGui.QImage", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageWriter.write", overloads);
        return 0;
}

static PyMethodDef SbkQImageWriter_methods[] = {
    {"canWrite", (PyCFunction)SbkQImageWriterFunc_canWrite, METH_NOARGS},
    {"compression", (PyCFunction)SbkQImageWriterFunc_compression, METH_NOARGS},
    {"device", (PyCFunction)SbkQImageWriterFunc_device, METH_NOARGS},
    {"error", (PyCFunction)SbkQImageWriterFunc_error, METH_NOARGS},
    {"errorString", (PyCFunction)SbkQImageWriterFunc_errorString, METH_NOARGS},
    {"fileName", (PyCFunction)SbkQImageWriterFunc_fileName, METH_NOARGS},
    {"format", (PyCFunction)SbkQImageWriterFunc_format, METH_NOARGS},
    {"gamma", (PyCFunction)SbkQImageWriterFunc_gamma, METH_NOARGS},
    {"quality", (PyCFunction)SbkQImageWriterFunc_quality, METH_NOARGS},
    {"setCompression", (PyCFunction)SbkQImageWriterFunc_setCompression, METH_O},
    {"setDevice", (PyCFunction)SbkQImageWriterFunc_setDevice, METH_O},
    {"setFileName", (PyCFunction)SbkQImageWriterFunc_setFileName, METH_O},
    {"setFormat", (PyCFunction)SbkQImageWriterFunc_setFormat, METH_O},
    {"setGamma", (PyCFunction)SbkQImageWriterFunc_setGamma, METH_O},
    {"setQuality", (PyCFunction)SbkQImageWriterFunc_setQuality, METH_O},
    {"setText", (PyCFunction)SbkQImageWriterFunc_setText, METH_VARARGS},
    {"supportedImageFormats", (PyCFunction)SbkQImageWriterFunc_supportedImageFormats, METH_NOARGS|METH_STATIC},
    {"supportsOption", (PyCFunction)SbkQImageWriterFunc_supportsOption, METH_O},
    {"write", (PyCFunction)SbkQImageWriterFunc_write, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQImageWriter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QImageWriter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QImageWriter >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQImageWriter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQImageWriter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QImageWriter_ImageWriterError_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QImageWriter_ImageWriterError_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QImageWriter_ImageWriterError_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ImageWriterError",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QImageWriter_ImageWriterError_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QImageWriter_ImageWriterError_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QImageWriter_ImageWriterError_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QImageWriter(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QIMAGEWRITER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQImageWriter_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQImageWriter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQImageWriter_Type));
    PyModule_AddObject(module, "QImageWriter",
        ((PyObject*)&SbkQImageWriter_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ImageWriterError
    SbkPySide_QtGuiTypes[SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX] = &SbkPySide_QtGui_QImageWriter_ImageWriterError_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QImageWriter_ImageWriterError_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QImageWriter_ImageWriterError_Type);
    PyDict_SetItemString(SbkQImageWriter_Type.super.ht_type.tp_dict,
            "ImageWriterError",((PyObject*)&SbkPySide_QtGui_QImageWriter_ImageWriterError_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QImageWriter_ImageWriterError_Type,
        (long) QImageWriter::UnknownError, "UnknownError");
    PyDict_SetItemString(SbkQImageWriter_Type.super.ht_type.tp_dict,
        "UnknownError", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QImageWriter_ImageWriterError_Type.tp_dict,
        "UnknownError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QImageWriter_ImageWriterError_Type,
        (long) QImageWriter::DeviceError, "DeviceError");
    PyDict_SetItemString(SbkQImageWriter_Type.super.ht_type.tp_dict,
        "DeviceError", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QImageWriter_ImageWriterError_Type.tp_dict,
        "DeviceError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QImageWriter_ImageWriterError_Type,
        (long) QImageWriter::UnsupportedFormatError, "UnsupportedFormatError");
    PyDict_SetItemString(SbkQImageWriter_Type.super.ht_type.tp_dict,
        "UnsupportedFormatError", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QImageWriter_ImageWriterError_Type.tp_dict,
        "UnsupportedFormatError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QImageWriter::ImageWriterError");

    Shiboken::TypeResolver::createObjectTypeResolver<QImageWriter >("QImageWriter*");
    Shiboken::TypeResolver::createObjectTypeResolver<QImageWriter >(typeid(QImageWriter).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

