/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qiconenginev2_wrapper.h"

// Extra includes
#include <QList>
#include <qdatastream.h>
#include <qiconengine.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QIconEngineV2Wrapper::QIconEngineV2Wrapper() : QIconEngineV2() {
    // ... middle
}

QSize QIconEngineV2Wrapper::actualSize(const QSize & size, QIcon::Mode mode, QIcon::State state)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actualSize"));
    if (py_override.isNull()) {
        return this->QIconEngine::actualSize(size, mode, state);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QSize& >::toPython(size),
        Shiboken::Converter<QIcon::Mode >::toPython(mode),
        Shiboken::Converter<QIcon::State >::toPython(state)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIconEngineV2.actualSize");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QIconEngineV2Wrapper::addFile(const QString & fileName, const QSize & size, QIcon::Mode mode, QIcon::State state)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "addFile"));
    if (py_override.isNull()) {
        return this->QIconEngine::addFile(fileName, size, mode, state);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QString& >::toPython(fileName),
        Shiboken::Converter<QSize& >::toPython(size),
        Shiboken::Converter<QIcon::Mode >::toPython(mode),
        Shiboken::Converter<QIcon::State >::toPython(state)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QIconEngineV2Wrapper::addPixmap(const QPixmap & pixmap, QIcon::Mode mode, QIcon::State state)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "addPixmap"));
    if (py_override.isNull()) {
        return this->QIconEngine::addPixmap(pixmap, mode, state);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QPixmap& >::toPython(pixmap),
        Shiboken::Converter<QIcon::Mode >::toPython(mode),
        Shiboken::Converter<QIcon::State >::toPython(state)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QIconEngineV2 * QIconEngineV2Wrapper::clone() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "clone"));
    if (py_override.isNull()) {
        return this->QIconEngineV2::clone();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QIconEngineV2* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIconEngineV2.clone");
        return 0        ;
    }
    QIconEngineV2* cpp_result(Shiboken::Converter<QIconEngineV2* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QString QIconEngineV2Wrapper::key() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "key"));
    if (py_override.isNull()) {
        return this->QIconEngineV2::key();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIconEngineV2.key");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

void QIconEngineV2Wrapper::paint(QPainter * painter, const QRect & rect, QIcon::Mode mode, QIcon::State state)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paint"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QIconEngineV2.paint()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRect& >::toPython(rect),
        Shiboken::Converter<QIcon::Mode >::toPython(mode),
        Shiboken::Converter<QIcon::State >::toPython(state)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPixmap QIconEngineV2Wrapper::pixmap(const QSize & size, QIcon::Mode mode, QIcon::State state)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pixmap"));
    if (py_override.isNull()) {
        return this->QIconEngine::pixmap(size, mode, state);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QSize& >::toPython(size),
        Shiboken::Converter<QIcon::Mode >::toPython(mode),
        Shiboken::Converter<QIcon::State >::toPython(state)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPixmap();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPixmap >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIconEngineV2.pixmap");
        return QPixmap()        ;
    }
    QPixmap cpp_result(Shiboken::Converter<QPixmap >::toCpp(py_result));
    return cpp_result;
}

bool QIconEngineV2Wrapper::read(QDataStream & in)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "read"));
    if (py_override.isNull()) {
        return this->QIconEngineV2::read(in);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDataStream& >::toPython(in)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIconEngineV2.read");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QIconEngineV2Wrapper::write(QDataStream & out) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "write"));
    if (py_override.isNull()) {
        return this->QIconEngineV2::write(out);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDataStream& >::toPython(out)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIconEngineV2.write");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

QIconEngineV2Wrapper::~QIconEngineV2Wrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQIconEngineV2_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QIconEngineV2Wrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QICONENGINEV2_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QIconEngineV2' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QIconEngineV2()
    cptr = new QIconEngineV2Wrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQIconEngineV2Func_availableSizes(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "availableSizes", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // availableSizes(QIcon::Mode,QIcon::State)
        QIconEngineV2* cppSelf = Shiboken::Converter<QIconEngineV2* >::toCpp((PyObject*)self);
        QList<QSize > cpp_result = cppSelf->QIconEngineV2::availableSizes();
        py_result = Shiboken::Converter<QList<QSize > >::toPython(cpp_result);
    } else if (Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[0])) {
        QIcon::Mode cpp_arg0 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // availableSizes(QIcon::Mode,QIcon::State)
            QIconEngineV2* cppSelf = Shiboken::Converter<QIconEngineV2* >::toCpp((PyObject*)self);
            QList<QSize > cpp_result = cppSelf->QIconEngineV2::availableSizes(cpp_arg0);
            py_result = Shiboken::Converter<QList<QSize > >::toPython(cpp_result);
        } else if (Shiboken::Converter<QIcon::State >::isConvertible(pyargs[1])) {
            QIcon::State cpp_arg1 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[1]);
            // availableSizes(QIcon::Mode,QIcon::State)
            QIconEngineV2* cppSelf = Shiboken::Converter<QIconEngineV2* >::toCpp((PyObject*)self);
            QList<QSize > cpp_result = cppSelf->QIconEngineV2::availableSizes(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QList<QSize > >::toPython(cpp_result);
        } else goto SbkQIconEngineV2Func_availableSizes_TypeError;
    } else goto SbkQIconEngineV2Func_availableSizes_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIconEngineV2Func_availableSizes_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon.Mode = QIcon.Normal, PySide.QtGui.QIcon.State = QIcon.Off", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QIconEngineV2.availableSizes", overloads);
        return 0;
}

static PyObject*
SbkQIconEngineV2Func_clone(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // clone()const
    QIconEngineV2* cppSelf = Shiboken::Converter<QIconEngineV2* >::toCpp((PyObject*)self);
    QIconEngineV2 * cpp_result = cppSelf->QIconEngineV2::clone();
    py_result = Shiboken::Converter<QIconEngineV2* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIconEngineV2Func_key(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // key()const
    QIconEngineV2* cppSelf = Shiboken::Converter<QIconEngineV2* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QIconEngineV2::key();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIconEngineV2Func_read(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // read(QDataStream&)
        QIconEngineV2* cppSelf = Shiboken::Converter<QIconEngineV2* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QIconEngineV2::read(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQIconEngineV2Func_read_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIconEngineV2Func_read_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QIconEngineV2.read", overloads);
        return 0;
}

static PyObject*
SbkQIconEngineV2Func_write(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // write(QDataStream&)const
        QIconEngineV2* cppSelf = Shiboken::Converter<QIconEngineV2* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QIconEngineV2::write(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQIconEngineV2Func_write_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIconEngineV2Func_write_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QIconEngineV2.write", overloads);
        return 0;
}

static PyMethodDef SbkQIconEngineV2_methods[] = {
    {"availableSizes", (PyCFunction)SbkQIconEngineV2Func_availableSizes, METH_VARARGS},
    {"clone", (PyCFunction)SbkQIconEngineV2Func_clone, METH_NOARGS},
    {"key", (PyCFunction)SbkQIconEngineV2Func_key, METH_NOARGS},
    {"read", (PyCFunction)SbkQIconEngineV2Func_read, METH_O},
    {"write", (PyCFunction)SbkQIconEngineV2Func_write, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQIconEngineV2_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QIconEngineV2",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QIconEngineV2Wrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQIconEngineV2_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQIconEngineV2_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QIconEngineV2_IconEngineHook_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QIconEngineV2_IconEngineHook_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QIconEngineV2_IconEngineHook_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "IconEngineHook",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QIconEngineV2_IconEngineHook_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QIconEngineV2_IconEngineHook_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QIconEngineV2_IconEngineHook_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QIconEngineV2(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QICONENGINEV2_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQIconEngineV2_Type);

    SbkQIconEngineV2_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QICONENGINE_IDX];
    // Fill type discovery information
    SbkQIconEngineV2_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QICONENGINE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQIconEngineV2_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQIconEngineV2_Type));
    PyModule_AddObject(module, "QIconEngineV2",
        ((PyObject*)&SbkQIconEngineV2_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: IconEngineHook
    SbkPySide_QtGuiTypes[SBK_QICONENGINEV2_ICONENGINEHOOK_IDX] = &SbkPySide_QtGui_QIconEngineV2_IconEngineHook_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QIconEngineV2_IconEngineHook_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QIconEngineV2_IconEngineHook_Type);
    PyDict_SetItemString(SbkQIconEngineV2_Type.super.ht_type.tp_dict,
            "IconEngineHook",((PyObject*)&SbkPySide_QtGui_QIconEngineV2_IconEngineHook_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QIconEngineV2_IconEngineHook_Type,
        (long) QIconEngineV2::AvailableSizesHook, "AvailableSizesHook");
    PyDict_SetItemString(SbkQIconEngineV2_Type.super.ht_type.tp_dict,
        "AvailableSizesHook", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QIconEngineV2_IconEngineHook_Type.tp_dict,
        "AvailableSizesHook", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QIconEngineV2::IconEngineHook");

    Shiboken::TypeResolver::createObjectTypeResolver<QIconEngineV2 >("QIconEngineV2*");
    Shiboken::TypeResolver::createObjectTypeResolver<QIconEngineV2 >(typeid(QIconEngineV2).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

