/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qhelpevent_wrapper.h"

// Extra includes
#include <qpoint.h>

using namespace Shiboken;

static int
SbkQHelpEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QHelpEvent* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QHelpEvent", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 3 && Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0]) && Shiboken::Converter<QPoint& >::isConvertible(pyargs[1]) && Shiboken::Converter<QPoint& >::isConvertible(pyargs[2])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QPoint > cpp_arg1_auto_ptr;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPoint >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return -1;
        std::auto_ptr<QPoint > cpp_arg2_auto_ptr;
        QPoint* cpp_arg2 = Shiboken::Converter<QPoint* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QPoint >(cpp_arg2);
        // QHelpEvent(QEvent::Type,QPoint,QPoint)
        cptr = new QHelpEvent(cpp_arg0, *cpp_arg1, *cpp_arg2);
    } else goto SbkQHelpEvent_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQHelpEvent_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQHelpEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type, PySide.QtCore.QPoint, PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHelpEvent", overloads);
        return -1;
}

static PyObject*
SbkQHelpEventFunc_globalPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalPos()const
    QHelpEvent* cppSelf = Shiboken::Converter<QHelpEvent* >::toCpp((PyObject*)self);
    const QPoint & cpp_result = cppSelf->QHelpEvent::globalPos();
    py_result = Shiboken::Converter<QPoint& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHelpEventFunc_globalX(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalX()const
    QHelpEvent* cppSelf = Shiboken::Converter<QHelpEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHelpEvent::globalX();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHelpEventFunc_globalY(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalY()const
    QHelpEvent* cppSelf = Shiboken::Converter<QHelpEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHelpEvent::globalY();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHelpEventFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QHelpEvent* cppSelf = Shiboken::Converter<QHelpEvent* >::toCpp((PyObject*)self);
    const QPoint & cpp_result = cppSelf->QHelpEvent::pos();
    py_result = Shiboken::Converter<QPoint& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHelpEventFunc_x(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x()const
    QHelpEvent* cppSelf = Shiboken::Converter<QHelpEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHelpEvent::x();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHelpEventFunc_y(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y()const
    QHelpEvent* cppSelf = Shiboken::Converter<QHelpEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHelpEvent::y();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQHelpEvent_methods[] = {
    {"globalPos", (PyCFunction)SbkQHelpEventFunc_globalPos, METH_NOARGS},
    {"globalX", (PyCFunction)SbkQHelpEventFunc_globalX, METH_NOARGS},
    {"globalY", (PyCFunction)SbkQHelpEventFunc_globalY, METH_NOARGS},
    {"pos", (PyCFunction)SbkQHelpEventFunc_pos, METH_NOARGS},
    {"x", (PyCFunction)SbkQHelpEventFunc_x, METH_NOARGS},
    {"y", (PyCFunction)SbkQHelpEventFunc_y, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQHelpEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QHelpEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QHelpEvent >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQHelpEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQHelpEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QHelpEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QHELPEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQHelpEvent_Type);

    SbkQHelpEvent_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENT_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQHelpEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQHelpEvent_Type));
    PyModule_AddObject(module, "QHelpEvent",
        ((PyObject*)&SbkQHelpEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QHelpEvent >("QHelpEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QHelpEvent >(typeid(QHelpEvent).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

