/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qgtkstyle_wrapper.h"

// Extra includes
#include <QList>
#include <qapplication.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qwindowsstyle.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGtkStyleWrapper::QGtkStyleWrapper() : QGtkStyle(), m_metaObject(0) {
    // ... middle
}

void QGtkStyleWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGtkStyleWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGtkStyleWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGtkStyleWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGtkStyleWrapper::drawComplexControl(QStyle::ComplexControl control, const QStyleOptionComplex * option, QPainter * painter, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawComplexControl"));
    if (py_override.isNull()) {
        return this->QGtkStyle::drawComplexControl(control, option, painter, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ComplexControl >::toPython(control),
        Shiboken::Converter<QStyleOptionComplex* >::toPython(option),
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGtkStyleWrapper::drawControl(QStyle::ControlElement control, const QStyleOption * option, QPainter * painter, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawControl"));
    if (py_override.isNull()) {
        return this->QGtkStyle::drawControl(control, option, painter, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ControlElement >::toPython(control),
        Shiboken::Converter<QStyleOption* >::toPython(option),
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGtkStyleWrapper::drawItemPixmap(QPainter * painter, const QRect & rect, int alignment, const QPixmap & pixmap) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawItemPixmap"));
    if (py_override.isNull()) {
        return this->QGtkStyle::drawItemPixmap(painter, rect, alignment, pixmap);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOiO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRect& >::toPython(rect),
        alignment,
        Shiboken::Converter<QPixmap& >::toPython(pixmap)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGtkStyleWrapper::drawItemText(QPainter * painter, const QRect & rect, int alignment, const QPalette & pal, bool enabled, const QString & text, QPalette::ColorRole textRole) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawItemText"));
    if (py_override.isNull()) {
        return this->QGtkStyle::drawItemText(painter, rect, alignment, pal, enabled, text, textRole);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOiOOOO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRect& >::toPython(rect),
        alignment,
        Shiboken::Converter<QPalette& >::toPython(pal),
        Shiboken::Converter<bool >::toPython(enabled),
        Shiboken::Converter<QString& >::toPython(text),
        Shiboken::Converter<QPalette::ColorRole >::toPython(textRole)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGtkStyleWrapper::drawPrimitive(QStyle::PrimitiveElement element, const QStyleOption * option, QPainter * painter, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawPrimitive"));
    if (py_override.isNull()) {
        return this->QGtkStyle::drawPrimitive(element, option, painter, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::PrimitiveElement >::toPython(element),
        Shiboken::Converter<QStyleOption* >::toPython(option),
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGtkStyleWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGtkStyle.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QGtkStyleWrapper::eventFilter(QObject * o, QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QWindowsStyle::eventFilter(o, e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(o),
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGtkStyle.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QPixmap QGtkStyleWrapper::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap & pixmap, const QStyleOption * opt) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "generatedIconPixmap"));
    if (py_override.isNull()) {
        return this->QGtkStyle::generatedIconPixmap(iconMode, pixmap, opt);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QIcon::Mode >::toPython(iconMode),
        Shiboken::Converter<QPixmap& >::toPython(pixmap),
        Shiboken::Converter<QStyleOption* >::toPython(opt)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPixmap();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPixmap >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGtkStyle.generatedIconPixmap");
        return QPixmap()        ;
    }
    QPixmap cpp_result(Shiboken::Converter<QPixmap >::toCpp(py_result));
    return cpp_result;
}

QStyle::SubControl QGtkStyleWrapper::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex * opt, const QPoint & pt, const QWidget * w) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hitTestComplexControl"));
    if (py_override.isNull()) {
        return this->QGtkStyle::hitTestComplexControl(cc, opt, pt, w);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ComplexControl >::toPython(cc),
        Shiboken::Converter<QStyleOptionComplex* >::toPython(opt),
        Shiboken::Converter<QPoint& >::toPython(pt),
        Shiboken::Converter<QWidget* >::toPython(w)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStyle::SubControl();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStyle::SubControl >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGtkStyle.hitTestComplexControl");
        return QStyle::SubControl()        ;
    }
    QStyle::SubControl cpp_result(Shiboken::Converter<QStyle::SubControl >::toCpp(py_result));
    return cpp_result;
}

QRect QGtkStyleWrapper::itemPixmapRect(const QRect & r, int flags, const QPixmap & pixmap) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemPixmapRect"));
    if (py_override.isNull()) {
        return this->QGtkStyle::itemPixmapRect(r, flags, pixmap);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OiO)",
        Shiboken::Converter<QRect& >::toPython(r),
        flags,
        Shiboken::Converter<QPixmap& >::toPython(pixmap)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGtkStyle.itemPixmapRect");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

int QGtkStyleWrapper::pixelMetric(QStyle::PixelMetric metric, const QStyleOption * option, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pixelMetric"));
    if (py_override.isNull()) {
        return this->QGtkStyle::pixelMetric(metric, option, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QStyle::PixelMetric >::toPython(metric),
        Shiboken::Converter<QStyleOption* >::toPython(option),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGtkStyle.pixelMetric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QGtkStyleWrapper::polish(QApplication * app)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polish"));
    if (py_override.isNull()) {
        return this->QGtkStyle::polish(app);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QApplication* >::toPython(app)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGtkStyleWrapper::polish(QPalette & palette)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polish"));
    if (py_override.isNull()) {
        return this->QGtkStyle::polish(palette);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPalette& >::toPython(palette)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGtkStyleWrapper::polish(QWidget * widget)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polish"));
    if (py_override.isNull()) {
        return this->QGtkStyle::polish(widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QGtkStyleWrapper::sizeFromContents(QStyle::ContentsType type, const QStyleOption * option, const QSize & size, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeFromContents"));
    if (py_override.isNull()) {
        return this->QGtkStyle::sizeFromContents(type, option, size, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ContentsType >::toPython(type),
        Shiboken::Converter<QStyleOption* >::toPython(option),
        Shiboken::Converter<QSize& >::toPython(size),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGtkStyle.sizeFromContents");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

QPalette QGtkStyleWrapper::standardPalette() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "standardPalette"));
    if (py_override.isNull()) {
        return this->QGtkStyle::standardPalette();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPalette();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPalette >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGtkStyle.standardPalette");
        return QPalette()        ;
    }
    QPalette cpp_result(Shiboken::Converter<QPalette >::toCpp(py_result));
    return cpp_result;
}

QPixmap QGtkStyleWrapper::standardPixmap(QStyle::StandardPixmap sp, const QStyleOption * option, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "standardPixmap"));
    if (py_override.isNull()) {
        return this->QGtkStyle::standardPixmap(sp, option, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QStyle::StandardPixmap >::toPython(sp),
        Shiboken::Converter<QStyleOption* >::toPython(option),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPixmap();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPixmap >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGtkStyle.standardPixmap");
        return QPixmap()        ;
    }
    QPixmap cpp_result(Shiboken::Converter<QPixmap >::toCpp(py_result));
    return cpp_result;
}

int QGtkStyleWrapper::styleHint(QStyle::StyleHint hint, const QStyleOption * option, const QWidget * widget, QStyleHintReturn * returnData) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "styleHint"));
    if (py_override.isNull()) {
        return this->QGtkStyle::styleHint(hint, option, widget, returnData);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::StyleHint >::toPython(hint),
        Shiboken::Converter<QStyleOption* >::toPython(option),
        Shiboken::Converter<QWidget* >::toPython(widget),
        Shiboken::Converter<QStyleHintReturn* >::toPython(returnData)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGtkStyle.styleHint");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QRect QGtkStyleWrapper::subControlRect(QStyle::ComplexControl control, const QStyleOptionComplex * option, QStyle::SubControl subControl, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "subControlRect"));
    if (py_override.isNull()) {
        return this->QGtkStyle::subControlRect(control, option, subControl, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ComplexControl >::toPython(control),
        Shiboken::Converter<QStyleOptionComplex* >::toPython(option),
        Shiboken::Converter<QStyle::SubControl >::toPython(subControl),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGtkStyle.subControlRect");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

QRect QGtkStyleWrapper::subElementRect(QStyle::SubElement sr, const QStyleOption * opt, const QWidget * w) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "subElementRect"));
    if (py_override.isNull()) {
        return this->QGtkStyle::subElementRect(sr, opt, w);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QStyle::SubElement >::toPython(sr),
        Shiboken::Converter<QStyleOption* >::toPython(opt),
        Shiboken::Converter<QWidget* >::toPython(w)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGtkStyle.subElementRect");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

void QGtkStyleWrapper::timerEvent(QTimerEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QWindowsStyle::timerEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGtkStyleWrapper::unpolish(QApplication * app)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "unpolish"));
    if (py_override.isNull()) {
        return this->QGtkStyle::unpolish(app);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QApplication* >::toPython(app)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGtkStyleWrapper::unpolish(QWidget * widget)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "unpolish"));
    if (py_override.isNull()) {
        return this->QGtkStyle::unpolish(widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QGtkStyleWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QGtkStyle::staticMetaObject);
}
    return m_metaObject;
}

int QGtkStyleWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QGtkStyle::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGtkStyleWrapper::~QGtkStyleWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQGtkStyle_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGtkStyleWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QGtkStyle()
    cptr = new QGtkStyleWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQGtkStyleFunc_drawComplexControl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawComplexControl", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QStyle::ComplexControl >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionComplex* >::isConvertible(pyargs[1]) && Shiboken::Converter<QPainter* >::isConvertible(pyargs[2]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
        QStyle::ComplexControl cpp_arg0 = Shiboken::Converter<QStyle::ComplexControl >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionComplex* cpp_arg1 = Shiboken::Converter<QStyleOptionComplex* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPainter* cpp_arg2 = Shiboken::Converter<QPainter* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
        // drawComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPainter*,const QWidget*)const
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        cppSelf->QGtkStyle::drawComplexControl(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else goto SbkQGtkStyleFunc_drawComplexControl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGtkStyleFunc_drawComplexControl_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ComplexControl, PySide.QtGui.QStyleOptionComplex, PySide.QtGui.QPainter, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.drawComplexControl", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_drawControl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawControl", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QStyle::ControlElement >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1]) && Shiboken::Converter<QPainter* >::isConvertible(pyargs[2]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
        QStyle::ControlElement cpp_arg0 = Shiboken::Converter<QStyle::ControlElement >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPainter* cpp_arg2 = Shiboken::Converter<QPainter* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
        // drawControl(QStyle::ControlElement,const QStyleOption*,QPainter*,const QWidget*)const
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        cppSelf->QGtkStyle::drawControl(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else goto SbkQGtkStyleFunc_drawControl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGtkStyleFunc_drawControl_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ControlElement, PySide.QtGui.QStyleOption, PySide.QtGui.QPainter, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.drawControl", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_drawItemPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawItemPixmap", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect& >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2]) && Shiboken::Converter<QPixmap& >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg3_auto_ptr;
        QPixmap* cpp_arg3 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg3);
        // drawItemPixmap(QPainter*,QRect,int,QPixmap)const
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        cppSelf->QGtkStyle::drawItemPixmap(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3);
    } else goto SbkQGtkStyleFunc_drawItemPixmap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGtkStyleFunc_drawItemPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRect, int, PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.drawItemPixmap", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_drawItemText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawItemText", 7, 7, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6])))
        return 0;

    if (numArgs == 7 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect& >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2]) && Shiboken::Converter<QPalette& >::isConvertible(pyargs[3]) && PyNumber_Check(pyargs[4]) && Shiboken::Converter<QString& >::isConvertible(pyargs[5]) && Shiboken::Converter<QPalette::ColorRole >::isConvertible(pyargs[6])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QPalette > cpp_arg3_auto_ptr;
        QPalette* cpp_arg3 = Shiboken::Converter<QPalette* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QPalette& >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QPalette >(cpp_arg3);
        bool cpp_arg4 = Shiboken::Converter<bool >::toCpp(pyargs[4]);
        if (Shiboken::cppObjectIsInvalid(pyargs[5]))
            return 0;
        std::auto_ptr<QString > cpp_arg5_auto_ptr;
        QString* cpp_arg5 = Shiboken::Converter<QString* >::toCpp(pyargs[5]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[5]))
            cpp_arg5_auto_ptr = std::auto_ptr<QString >(cpp_arg5);
        QPalette::ColorRole cpp_arg6 = Shiboken::Converter<QPalette::ColorRole >::toCpp(pyargs[6]);
        // drawItemText(QPainter*,QRect,int,QPalette,bool,QString,QPalette::ColorRole)const
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        cppSelf->QGtkStyle::drawItemText(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4, *cpp_arg5, cpp_arg6);
    } else goto SbkQGtkStyleFunc_drawItemText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGtkStyleFunc_drawItemText_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRect, int, PySide.QtGui.QPalette, bool, PySide.QtCore.QString, PySide.QtGui.QPalette.ColorRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.drawItemText", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_drawPrimitive(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawPrimitive", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QStyle::PrimitiveElement >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1]) && Shiboken::Converter<QPainter* >::isConvertible(pyargs[2]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
        QStyle::PrimitiveElement cpp_arg0 = Shiboken::Converter<QStyle::PrimitiveElement >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPainter* cpp_arg2 = Shiboken::Converter<QPainter* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
        // drawPrimitive(QStyle::PrimitiveElement,const QStyleOption*,QPainter*,const QWidget*)const
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        cppSelf->QGtkStyle::drawPrimitive(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else goto SbkQGtkStyleFunc_drawPrimitive_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGtkStyleFunc_drawPrimitive_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.PrimitiveElement, PySide.QtGui.QStyleOption, PySide.QtGui.QPainter, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.drawPrimitive", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_generatedIconPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "generatedIconPixmap", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[0]) && Shiboken::Converter<QPixmap& >::isConvertible(pyargs[1]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[2])) {
        QIcon::Mode cpp_arg0 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
        QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QStyleOption* cpp_arg2 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[2]);
        // generatedIconPixmap(QIcon::Mode,QPixmap,const QStyleOption*)const
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        QPixmap cpp_result = cppSelf->QGtkStyle::generatedIconPixmap(cpp_arg0, *cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
    } else goto SbkQGtkStyleFunc_generatedIconPixmap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGtkStyleFunc_generatedIconPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon.Mode, PySide.QtGui.QPixmap, PySide.QtGui.QStyleOption", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.generatedIconPixmap", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_getGConfBool(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "getGConfBool", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // getGConfBool(QString,bool)
            bool cpp_result = QGtkStyle::getGConfBool(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // getGConfBool(QString,bool)
            bool cpp_result = QGtkStyle::getGConfBool(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQGtkStyleFunc_getGConfBool_TypeError;
    } else goto SbkQGtkStyleFunc_getGConfBool_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGtkStyleFunc_getGConfBool_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.getGConfBool", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_getGConfString(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "getGConfString", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // getGConfString(QString,QString)
            QString cpp_result = QGtkStyle::getGConfString(*cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // getGConfString(QString,QString)
            QString cpp_result = QGtkStyle::getGConfString(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else goto SbkQGtkStyleFunc_getGConfString_TypeError;
    } else goto SbkQGtkStyleFunc_getGConfString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGtkStyleFunc_getGConfString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.getGConfString", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_hitTestComplexControl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "hitTestComplexControl", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QStyle::ComplexControl >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionComplex* >::isConvertible(pyargs[1]) && Shiboken::Converter<QPoint& >::isConvertible(pyargs[2]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
        QStyle::ComplexControl cpp_arg0 = Shiboken::Converter<QStyle::ComplexControl >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionComplex* cpp_arg1 = Shiboken::Converter<QStyleOptionComplex* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg2_auto_ptr;
        QPoint* cpp_arg2 = Shiboken::Converter<QPoint* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QPoint >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
        // hitTestComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPoint,const QWidget*)const
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        QStyle::SubControl cpp_result = cppSelf->QGtkStyle::hitTestComplexControl(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<QStyle::SubControl >::toPython(cpp_result);
    } else goto SbkQGtkStyleFunc_hitTestComplexControl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGtkStyleFunc_hitTestComplexControl_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ComplexControl, PySide.QtGui.QStyleOptionComplex, PySide.QtCore.QPoint, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.hitTestComplexControl", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_itemPixmapRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "itemPixmapRect", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QRect& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QPixmap& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg2_auto_ptr;
        QPixmap* cpp_arg2 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg2);
        // itemPixmapRect(QRect,int,QPixmap)const
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QGtkStyle::itemPixmapRect(*cpp_arg0, cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else goto SbkQGtkStyleFunc_itemPixmapRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGtkStyleFunc_itemPixmapRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, int, PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.itemPixmapRect", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_pixelMetric(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "pixelMetric", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStyle::PixelMetric >::isConvertible(pyargs[0])) {
        QStyle::PixelMetric cpp_arg0 = Shiboken::Converter<QStyle::PixelMetric >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
            QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QGtkStyle::pixelMetric(cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
                QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QGtkStyle::pixelMetric(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
                QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QGtkStyle::pixelMetric(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else goto SbkQGtkStyleFunc_pixelMetric_TypeError;
        } else goto SbkQGtkStyleFunc_pixelMetric_TypeError;
    } else goto SbkQGtkStyleFunc_pixelMetric_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGtkStyleFunc_pixelMetric_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.PixelMetric, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.pixelMetric", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_polish(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // polish(QWidget*)
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        cppSelf->QGtkStyle::polish(cpp_arg0);
    } else if (Shiboken::Converter<QPalette& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPalette > cpp_arg0_auto_ptr;
        QPalette* cpp_arg0 = Shiboken::Converter<QPalette* >::toCpp(arg);
        if (!Shiboken::Converter<QPalette& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPalette >(cpp_arg0);
        // polish(QPalette&)
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        cppSelf->QGtkStyle::polish(*cpp_arg0);
    } else if (Shiboken::Converter<QApplication* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QApplication* cpp_arg0 = Shiboken::Converter<QApplication* >::toCpp(arg);
        // polish(QApplication*)
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        cppSelf->QGtkStyle::polish(cpp_arg0);
    } else goto SbkQGtkStyleFunc_polish_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGtkStyleFunc_polish_TypeError:
        const char* overloads[] = {"PySide.QtGui.QApplication", "PySide.QtGui.QPalette", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGtkStyle.polish", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_sizeFromContents(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "sizeFromContents", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QStyle::ContentsType >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1]) && Shiboken::Converter<QSize& >::isConvertible(pyargs[2]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
        QStyle::ContentsType cpp_arg0 = Shiboken::Converter<QStyle::ContentsType >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QSize* cpp_arg2 = Shiboken::Converter<QSize* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
        // sizeFromContents(QStyle::ContentsType,const QStyleOption*,QSize,const QWidget*)const
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        QSize cpp_result = cppSelf->QGtkStyle::sizeFromContents(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    } else goto SbkQGtkStyleFunc_sizeFromContents_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGtkStyleFunc_sizeFromContents_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ContentsType, PySide.QtGui.QStyleOption, PySide.QtCore.QSize, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.sizeFromContents", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_standardIconImplementation(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "standardIconImplementation", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStyle::StandardPixmap >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1])) {
        QStyle::StandardPixmap cpp_arg0 = Shiboken::Converter<QStyle::StandardPixmap >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // standardIconImplementation(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
            QIcon cpp_result = cppSelf->QGtkStyle::standardIconImplementation(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
            // standardIconImplementation(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
            QIcon cpp_result = cppSelf->QGtkStyle::standardIconImplementation(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
        } else goto SbkQGtkStyleFunc_standardIconImplementation_TypeError;
    } else goto SbkQGtkStyleFunc_standardIconImplementation_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGtkStyleFunc_standardIconImplementation_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.StandardPixmap, PySide.QtGui.QStyleOption, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.standardIconImplementation", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_standardPalette(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // standardPalette()const
    QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
    QPalette cpp_result = cppSelf->QGtkStyle::standardPalette();
    py_result = Shiboken::Converter<QPalette >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGtkStyleFunc_standardPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "standardPixmap", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStyle::StandardPixmap >::isConvertible(pyargs[0])) {
        QStyle::StandardPixmap cpp_arg0 = Shiboken::Converter<QStyle::StandardPixmap >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // standardPixmap(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QGtkStyle::standardPixmap(cpp_arg0, 0, 0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        } else if (Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // standardPixmap(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
                QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QGtkStyle::standardPixmap(cpp_arg0, cpp_arg1, 0);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
            } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                // standardPixmap(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
                QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QGtkStyle::standardPixmap(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
            } else goto SbkQGtkStyleFunc_standardPixmap_TypeError;
        } else goto SbkQGtkStyleFunc_standardPixmap_TypeError;
    } else goto SbkQGtkStyleFunc_standardPixmap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGtkStyleFunc_standardPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.StandardPixmap, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.standardPixmap", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_styleHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "styleHint", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QStyle::StyleHint >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[2]) && Shiboken::Converter<QStyleHintReturn* >::isConvertible(pyargs[3])) {
        QStyle::StyleHint cpp_arg0 = Shiboken::Converter<QStyle::StyleHint >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QStyleHintReturn* cpp_arg3 = Shiboken::Converter<QStyleHintReturn* >::toCpp(pyargs[3]);
        // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGtkStyle::styleHint(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQGtkStyleFunc_styleHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGtkStyleFunc_styleHint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.StyleHint, PySide.QtGui.QStyleOption, PySide.QtGui.QWidget, PySide.QtGui.QStyleHintReturn", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.styleHint", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_subControlRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "subControlRect", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QStyle::ComplexControl >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionComplex* >::isConvertible(pyargs[1]) && Shiboken::Converter<QStyle::SubControl >::isConvertible(pyargs[2]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
        QStyle::ComplexControl cpp_arg0 = Shiboken::Converter<QStyle::ComplexControl >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionComplex* cpp_arg1 = Shiboken::Converter<QStyleOptionComplex* >::toCpp(pyargs[1]);
        QStyle::SubControl cpp_arg2 = Shiboken::Converter<QStyle::SubControl >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
        // subControlRect(QStyle::ComplexControl,const QStyleOptionComplex*,QStyle::SubControl,const QWidget*)const
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QGtkStyle::subControlRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else goto SbkQGtkStyleFunc_subControlRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGtkStyleFunc_subControlRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ComplexControl, PySide.QtGui.QStyleOptionComplex, PySide.QtGui.QStyle.SubControl, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.subControlRect", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_subElementRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "subElementRect", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QStyle::SubElement >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
        QStyle::SubElement cpp_arg0 = Shiboken::Converter<QStyle::SubElement >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
        // subElementRect(QStyle::SubElement,const QStyleOption*,const QWidget*)const
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QGtkStyle::subElementRect(cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else goto SbkQGtkStyleFunc_subElementRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGtkStyleFunc_subElementRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.SubElement, PySide.QtGui.QStyleOption, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGtkStyle.subElementRect", overloads);
        return 0;
}

static PyObject*
SbkQGtkStyleFunc_unpolish(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // unpolish(QWidget*)
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        cppSelf->QGtkStyle::unpolish(cpp_arg0);
    } else if (Shiboken::Converter<QApplication* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QApplication* cpp_arg0 = Shiboken::Converter<QApplication* >::toCpp(arg);
        // unpolish(QApplication*)
        QGtkStyle* cppSelf = Shiboken::Converter<QGtkStyle* >::toCpp((PyObject*)self);
        cppSelf->QGtkStyle::unpolish(cpp_arg0);
    } else goto SbkQGtkStyleFunc_unpolish_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGtkStyleFunc_unpolish_TypeError:
        const char* overloads[] = {"PySide.QtGui.QApplication", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGtkStyle.unpolish", overloads);
        return 0;
}

static PyMethodDef SbkQGtkStyle_methods[] = {
    {"drawComplexControl", (PyCFunction)SbkQGtkStyleFunc_drawComplexControl, METH_VARARGS},
    {"drawControl", (PyCFunction)SbkQGtkStyleFunc_drawControl, METH_VARARGS},
    {"drawItemPixmap", (PyCFunction)SbkQGtkStyleFunc_drawItemPixmap, METH_VARARGS},
    {"drawItemText", (PyCFunction)SbkQGtkStyleFunc_drawItemText, METH_VARARGS},
    {"drawPrimitive", (PyCFunction)SbkQGtkStyleFunc_drawPrimitive, METH_VARARGS},
    {"generatedIconPixmap", (PyCFunction)SbkQGtkStyleFunc_generatedIconPixmap, METH_VARARGS},
    {"getGConfBool", (PyCFunction)SbkQGtkStyleFunc_getGConfBool, METH_VARARGS|METH_STATIC},
    {"getGConfString", (PyCFunction)SbkQGtkStyleFunc_getGConfString, METH_VARARGS|METH_STATIC},
    {"hitTestComplexControl", (PyCFunction)SbkQGtkStyleFunc_hitTestComplexControl, METH_VARARGS},
    {"itemPixmapRect", (PyCFunction)SbkQGtkStyleFunc_itemPixmapRect, METH_VARARGS},
    {"pixelMetric", (PyCFunction)SbkQGtkStyleFunc_pixelMetric, METH_VARARGS},
    {"polish", (PyCFunction)SbkQGtkStyleFunc_polish, METH_O},
    {"sizeFromContents", (PyCFunction)SbkQGtkStyleFunc_sizeFromContents, METH_VARARGS},
    {"standardIconImplementation", (PyCFunction)SbkQGtkStyleFunc_standardIconImplementation, METH_VARARGS},
    {"standardPalette", (PyCFunction)SbkQGtkStyleFunc_standardPalette, METH_NOARGS},
    {"standardPixmap", (PyCFunction)SbkQGtkStyleFunc_standardPixmap, METH_VARARGS},
    {"styleHint", (PyCFunction)SbkQGtkStyleFunc_styleHint, METH_VARARGS},
    {"subControlRect", (PyCFunction)SbkQGtkStyleFunc_subControlRect, METH_VARARGS},
    {"subElementRect", (PyCFunction)SbkQGtkStyleFunc_subElementRect, METH_VARARGS},
    {"unpolish", (PyCFunction)SbkQGtkStyleFunc_unpolish, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGtkStyle_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGtkStyle",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGtkStyleWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGtkStyle_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGtkStyle_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QGtkStyle(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGTKSTYLE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGtkStyle_Type);

    SbkQGtkStyle_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QCLEANLOOKSSTYLE_IDX];
    // Fill type discovery information
    SbkQGtkStyle_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGtkStyle_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGtkStyle_Type));
    PyModule_AddObject(module, "QGtkStyle",
        ((PyObject*)&SbkQGtkStyle_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGtkStyle >("QGtkStyle*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGtkStyle >(typeid(QGtkStyle).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

