/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qgridlayout_wrapper.h"

// Extra includes
#include <qcoreevent.h>
#include <qgridlayout.h>
#include <qlayout.h>
#include <qlayoutitem.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qrect.h>
#include <qsize.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGridLayoutWrapper::QGridLayoutWrapper() : QGridLayout(), m_metaObject(0) {
    // ... middle
}

QGridLayoutWrapper::QGridLayoutWrapper(QWidget * parent) : QGridLayout(parent), m_metaObject(0) {
    // ... middle
}

void QGridLayoutWrapper::addItem(QLayoutItem * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "addItem"));
    if (py_override.isNull()) {
        return this->QGridLayout::addItem(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QLayoutItem* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGridLayoutWrapper::childEvent(QChildEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QLayout::childEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGridLayoutWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QGridLayoutWrapper::count() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "count"));
    if (py_override.isNull()) {
        return this->QGridLayout::count();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.count");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QGridLayoutWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGridLayoutWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGridLayoutWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QGridLayoutWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QFlags<Qt::Orientation> QGridLayoutWrapper::expandingDirections() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "expandingDirections"));
    if (py_override.isNull()) {
        return this->QGridLayout::expandingDirections();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::Orientation>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::Orientation> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.expandingDirections");
        return QFlags<Qt::Orientation>()        ;
    }
    QFlags<Qt::Orientation> cpp_result(Shiboken::Converter<QFlags<Qt::Orientation> >::toCpp(py_result));
    return cpp_result;
}

QRect QGridLayoutWrapper::geometry() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "geometry"));
    if (py_override.isNull()) {
        return this->QLayout::geometry();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.geometry");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

bool QGridLayoutWrapper::hasHeightForWidth() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasHeightForWidth"));
    if (py_override.isNull()) {
        return this->QGridLayout::hasHeightForWidth();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.hasHeightForWidth");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

int QGridLayoutWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QGridLayout::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QGridLayoutWrapper::indexOf(QWidget * arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "indexOf"));
    if (py_override.isNull()) {
        return this->QLayout::indexOf(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWidget* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.indexOf");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QGridLayoutWrapper::invalidate()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "invalidate"));
    if (py_override.isNull()) {
        return this->QGridLayout::invalidate();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGridLayoutWrapper::isEmpty() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isEmpty"));
    if (py_override.isNull()) {
        return this->QLayout::isEmpty();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.isEmpty");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QLayoutItem * QGridLayoutWrapper::itemAt(int index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemAt"));
    if (py_override.isNull()) {
        return this->QGridLayout::itemAt(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayoutItem* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.itemAt");
        return 0        ;
    }
    QLayoutItem* cpp_result(Shiboken::Converter<QLayoutItem* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QLayout * QGridLayoutWrapper::layout()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "layout"));
    if (py_override.isNull()) {
        return this->QLayout::layout();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayout* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.layout");
        return 0        ;
    }
    QLayout* cpp_result(Shiboken::Converter<QLayout* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QSize QGridLayoutWrapper::maximumSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "maximumSize"));
    if (py_override.isNull()) {
        return this->QGridLayout::maximumSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.maximumSize");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

int QGridLayoutWrapper::minimumHeightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumHeightForWidth"));
    if (py_override.isNull()) {
        return this->QGridLayout::minimumHeightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.minimumHeightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QGridLayoutWrapper::minimumSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSize"));
    if (py_override.isNull()) {
        return this->QGridLayout::minimumSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.minimumSize");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QGridLayoutWrapper::setGeometry(const QRect & arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setGeometry"));
    if (py_override.isNull()) {
        return this->QGridLayout::setGeometry(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QRect& >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QGridLayoutWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QGridLayout::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

QSpacerItem * QGridLayoutWrapper::spacerItem()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "spacerItem"));
    if (py_override.isNull()) {
        return this->QLayoutItem::spacerItem();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSpacerItem* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.spacerItem");
        return 0        ;
    }
    QSpacerItem* cpp_result(Shiboken::Converter<QSpacerItem* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QLayoutItem * QGridLayoutWrapper::takeAt(int index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "takeAt"));
    if (py_override.isNull()) {
        return this->QGridLayout::takeAt(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayoutItem* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.takeAt");
        return 0        ;
    }
    QLayoutItem* cpp_result(Shiboken::Converter<QLayoutItem* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QGridLayoutWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QWidget * QGridLayoutWrapper::widget()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "widget"));
    if (py_override.isNull()) {
        return this->QLayoutItem::widget();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGridLayout.widget");
        return 0        ;
    }
    QWidget* cpp_result(Shiboken::Converter<QWidget* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

const QMetaObject* QGridLayoutWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QGridLayout::staticMetaObject);
}
    return m_metaObject;
}

int QGridLayoutWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QGridLayout::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGridLayoutWrapper::~QGridLayoutWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQGridLayout_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGridLayoutWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGridLayout", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGridLayout()
        cptr = new QGridLayoutWrapper();
    } else if (numArgs == 1 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QGridLayout(QWidget*)
        cptr = new QGridLayoutWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQGridLayout_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGridLayout_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQGridLayout_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGridLayout", overloads);
        return -1;
}

static PyObject*
SbkQGridLayoutFunc_addItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQGridLayoutFunc_addItem_TypeError;

    if (!PyArg_UnpackTuple(args, "addItem", 1, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (Shiboken::Converter<QLayoutItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QLayoutItem* cpp_arg0 = Shiboken::Converter<QLayoutItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // addItem(QLayoutItem*)
            QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
            cppSelf->QGridLayout::addItem(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // addItem(QLayoutItem*,int,int,int,int,QFlags<Qt::AlignmentFlag>)
                QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
                cppSelf->QGridLayout::addItem(cpp_arg0, cpp_arg1, cpp_arg2);
                Shiboken::setParent(self, pyargs[0]);
            } else if (PyNumber_Check(pyargs[3])) {
                int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // addItem(QLayoutItem*,int,int,int,int,QFlags<Qt::AlignmentFlag>)
                    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
                    cppSelf->QGridLayout::addItem(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    Shiboken::setParent(self, pyargs[0]);
                } else if (PyNumber_Check(pyargs[4])) {
                    int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                    if (numArgs == 5) {
                        // addItem(QLayoutItem*,int,int,int,int,QFlags<Qt::AlignmentFlag>)
                        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
                        cppSelf->QGridLayout::addItem(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                        Shiboken::setParent(self, pyargs[0]);
                    } else if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[5])) {
                        QFlags<Qt::AlignmentFlag> cpp_arg5 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[5]);
                        // addItem(QLayoutItem*,int,int,int,int,QFlags<Qt::AlignmentFlag>)
                        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
                        cppSelf->QGridLayout::addItem(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
                        Shiboken::setParent(self, pyargs[0]);
                    } else goto SbkQGridLayoutFunc_addItem_TypeError;
                } else goto SbkQGridLayoutFunc_addItem_TypeError;
            } else goto SbkQGridLayoutFunc_addItem_TypeError;
        } else goto SbkQGridLayoutFunc_addItem_TypeError;
    } else goto SbkQGridLayoutFunc_addItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGridLayoutFunc_addItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLayoutItem", "PySide.QtGui.QLayoutItem, int, int, int = 1, int = 1, PySide.QtCore.Qt.Alignment = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGridLayout.addItem", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_addLayout(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addLayout", 3, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (Shiboken::Converter<QLayout* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QLayout* cpp_arg0 = Shiboken::Converter<QLayout* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // addLayout(QLayout*,int,int,QFlags<Qt::AlignmentFlag>)
            QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
            cppSelf->QGridLayout::addLayout(cpp_arg0, cpp_arg1, cpp_arg2);
            Shiboken::setParent(self, pyargs[0]);
        } else if (PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
            if (numArgs == 5) {
                // addLayout(QLayout*,int,int,int,int,QFlags<Qt::AlignmentFlag>)
                QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
                cppSelf->QGridLayout::addLayout(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                Shiboken::setParent(self, pyargs[0]);
            } else if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[5])) {
                QFlags<Qt::AlignmentFlag> cpp_arg5 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[5]);
                // addLayout(QLayout*,int,int,int,int,QFlags<Qt::AlignmentFlag>)
                QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
                cppSelf->QGridLayout::addLayout(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
                Shiboken::setParent(self, pyargs[0]);
            } else goto SbkQGridLayoutFunc_addLayout_TypeError;
        } else if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[3])) {
            QFlags<Qt::AlignmentFlag> cpp_arg3 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[3]);
            // addLayout(QLayout*,int,int,QFlags<Qt::AlignmentFlag>)
            QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
            cppSelf->QGridLayout::addLayout(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            Shiboken::setParent(self, pyargs[0]);
        } else goto SbkQGridLayoutFunc_addLayout_TypeError;
    } else goto SbkQGridLayoutFunc_addLayout_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGridLayoutFunc_addLayout_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLayout, int, int, PySide.QtCore.Qt.Alignment = 0", "PySide.QtGui.QLayout, int, int, int, int, PySide.QtCore.Qt.Alignment = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGridLayout.addLayout", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_addWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQGridLayoutFunc_addWidget_TypeError;

    if (!PyArg_UnpackTuple(args, "addWidget", 1, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // addWidget(QWidget*)
            QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
            cppSelf->QGridLayout::addWidget(cpp_arg0);
            Shiboken::setParent(self, pyargs[0]);
        } else if (PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // addWidget(QWidget*,int,int,QFlags<Qt::AlignmentFlag>)
                QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
                cppSelf->QGridLayout::addWidget(cpp_arg0, cpp_arg1, cpp_arg2);
                Shiboken::setParent(self, pyargs[0]);
            } else if (PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4])) {
                int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                if (numArgs == 5) {
                    // addWidget(QWidget*,int,int,int,int,QFlags<Qt::AlignmentFlag>)
                    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
                    cppSelf->QGridLayout::addWidget(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                    Shiboken::setParent(self, pyargs[0]);
                } else if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[5])) {
                    QFlags<Qt::AlignmentFlag> cpp_arg5 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[5]);
                    // addWidget(QWidget*,int,int,int,int,QFlags<Qt::AlignmentFlag>)
                    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
                    cppSelf->QGridLayout::addWidget(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
                    Shiboken::setParent(self, pyargs[0]);
                } else goto SbkQGridLayoutFunc_addWidget_TypeError;
            } else if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[3])) {
                QFlags<Qt::AlignmentFlag> cpp_arg3 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[3]);
                // addWidget(QWidget*,int,int,QFlags<Qt::AlignmentFlag>)
                QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
                cppSelf->QGridLayout::addWidget(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                Shiboken::setParent(self, pyargs[0]);
            } else goto SbkQGridLayoutFunc_addWidget_TypeError;
        } else goto SbkQGridLayoutFunc_addWidget_TypeError;
    } else goto SbkQGridLayoutFunc_addWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGridLayoutFunc_addWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, int, int, PySide.QtCore.Qt.Alignment = 0", "PySide.QtGui.QWidget, int, int, int, int, PySide.QtCore.Qt.Alignment = 0", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGridLayout.addWidget", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_cellRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "cellRect", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // cellRect(int,int)const
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QGridLayout::cellRect(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else goto SbkQGridLayoutFunc_cellRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGridLayoutFunc_cellRect_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGridLayout.cellRect", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_columnCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columnCount()const
    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGridLayout::columnCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGridLayoutFunc_columnMinimumWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // columnMinimumWidth(int)const
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGridLayout::columnMinimumWidth(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQGridLayoutFunc_columnMinimumWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGridLayoutFunc_columnMinimumWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGridLayout.columnMinimumWidth", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_columnStretch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // columnStretch(int)const
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGridLayout::columnStretch(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQGridLayoutFunc_columnStretch_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGridLayoutFunc_columnStretch_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGridLayout.columnStretch", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGridLayout::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGridLayoutFunc_expandingDirections(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // expandingDirections()const
    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
    QFlags<Qt::Orientation> cpp_result = cppSelf->QGridLayout::expandingDirections();
    py_result = Shiboken::Converter<QFlags<Qt::Orientation> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGridLayoutFunc_hasHeightForWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasHeightForWidth()const
    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGridLayout::hasHeightForWidth();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGridLayoutFunc_heightForWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // heightForWidth(int)const
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGridLayout::heightForWidth(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQGridLayoutFunc_heightForWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGridLayoutFunc_heightForWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGridLayout.heightForWidth", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_horizontalSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalSpacing()const
    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGridLayout::horizontalSpacing();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGridLayoutFunc_invalidate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // invalidate()
    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
    cppSelf->QGridLayout::invalidate();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGridLayoutFunc_itemAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // itemAt(int)const
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        QLayoutItem * cpp_result = cppSelf->QGridLayout::itemAt(cpp_arg0);
        py_result = Shiboken::Converter<QLayoutItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQGridLayoutFunc_itemAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGridLayoutFunc_itemAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGridLayout.itemAt", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_itemAtPosition(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "itemAtPosition", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // itemAtPosition(int,int)const
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        QLayoutItem * cpp_result = cppSelf->QGridLayout::itemAtPosition(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QLayoutItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQGridLayoutFunc_itemAtPosition_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGridLayoutFunc_itemAtPosition_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGridLayout.itemAtPosition", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_maximumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumSize()const
    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QGridLayout::maximumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGridLayoutFunc_minimumHeightForWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // minimumHeightForWidth(int)const
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGridLayout::minimumHeightForWidth(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQGridLayoutFunc_minimumHeightForWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGridLayoutFunc_minimumHeightForWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGridLayout.minimumHeightForWidth", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_minimumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSize()const
    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QGridLayout::minimumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGridLayoutFunc_originCorner(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // originCorner()const
    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
    Qt::Corner cpp_result = cppSelf->QGridLayout::originCorner();
    py_result = Shiboken::Converter<Qt::Corner >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGridLayoutFunc_rowCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rowCount()const
    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGridLayout::rowCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGridLayoutFunc_rowMinimumHeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // rowMinimumHeight(int)const
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGridLayout::rowMinimumHeight(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQGridLayoutFunc_rowMinimumHeight_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGridLayoutFunc_rowMinimumHeight_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGridLayout.rowMinimumHeight", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_rowStretch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // rowStretch(int)const
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGridLayout::rowStretch(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQGridLayoutFunc_rowStretch_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGridLayoutFunc_rowStretch_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGridLayout.rowStretch", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_setColumnMinimumWidth(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setColumnMinimumWidth", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setColumnMinimumWidth(int,int)
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGridLayout::setColumnMinimumWidth(cpp_arg0, cpp_arg1);
    } else goto SbkQGridLayoutFunc_setColumnMinimumWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGridLayoutFunc_setColumnMinimumWidth_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGridLayout.setColumnMinimumWidth", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_setColumnStretch(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setColumnStretch", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setColumnStretch(int,int)
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGridLayout::setColumnStretch(cpp_arg0, cpp_arg1);
    } else goto SbkQGridLayoutFunc_setColumnStretch_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGridLayoutFunc_setColumnStretch_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGridLayout.setColumnStretch", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_setDefaultPositioning(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setDefaultPositioning", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::Orientation cpp_arg1 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[1]);
        // setDefaultPositioning(int,Qt::Orientation)
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGridLayout::setDefaultPositioning(cpp_arg0, cpp_arg1);
    } else goto SbkQGridLayoutFunc_setDefaultPositioning_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGridLayoutFunc_setDefaultPositioning_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGridLayout.setDefaultPositioning", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_setGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // setGeometry(QRect)
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGridLayout::setGeometry(*cpp_arg0);
    } else goto SbkQGridLayoutFunc_setGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGridLayoutFunc_setGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGridLayout.setGeometry", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_setHorizontalSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setHorizontalSpacing(int)
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGridLayout::setHorizontalSpacing(cpp_arg0);
    } else goto SbkQGridLayoutFunc_setHorizontalSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGridLayoutFunc_setHorizontalSpacing_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGridLayout.setHorizontalSpacing", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_setOriginCorner(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::Corner >::isConvertible(arg)) {
        Qt::Corner cpp_arg0 = Shiboken::Converter<Qt::Corner >::toCpp(arg);
        // setOriginCorner(Qt::Corner)
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGridLayout::setOriginCorner(cpp_arg0);
    } else goto SbkQGridLayoutFunc_setOriginCorner_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGridLayoutFunc_setOriginCorner_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Corner", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGridLayout.setOriginCorner", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_setRowMinimumHeight(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRowMinimumHeight", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setRowMinimumHeight(int,int)
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGridLayout::setRowMinimumHeight(cpp_arg0, cpp_arg1);
    } else goto SbkQGridLayoutFunc_setRowMinimumHeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGridLayoutFunc_setRowMinimumHeight_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGridLayout.setRowMinimumHeight", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_setRowStretch(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRowStretch", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setRowStretch(int,int)
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGridLayout::setRowStretch(cpp_arg0, cpp_arg1);
    } else goto SbkQGridLayoutFunc_setRowStretch_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGridLayoutFunc_setRowStretch_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGridLayout.setRowStretch", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_setSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSpacing(int)
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGridLayout::setSpacing(cpp_arg0);
    } else goto SbkQGridLayoutFunc_setSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGridLayoutFunc_setSpacing_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGridLayout.setSpacing", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_setVerticalSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setVerticalSpacing(int)
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGridLayout::setVerticalSpacing(cpp_arg0);
    } else goto SbkQGridLayoutFunc_setVerticalSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGridLayoutFunc_setVerticalSpacing_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGridLayout.setVerticalSpacing", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QGridLayout::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGridLayoutFunc_spacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // spacing()const
    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGridLayout::spacing();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGridLayoutFunc_takeAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeAt(int)
        QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
        QLayoutItem * cpp_result = cppSelf->QGridLayout::takeAt(cpp_arg0);
        py_result = Shiboken::Converter<QLayoutItem* >::toPython(cpp_result);
        Shiboken::setParent(self, 0);
        Shiboken::setParent(self, py_result);
    } else goto SbkQGridLayoutFunc_takeAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGridLayoutFunc_takeAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGridLayout.takeAt", overloads);
        return 0;
}

static PyObject*
SbkQGridLayoutFunc_verticalSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalSpacing()const
    QGridLayout* cppSelf = Shiboken::Converter<QGridLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGridLayout::verticalSpacing();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQGridLayout_methods[] = {
    {"addItem", (PyCFunction)SbkQGridLayoutFunc_addItem, METH_VARARGS},
    {"addLayout", (PyCFunction)SbkQGridLayoutFunc_addLayout, METH_VARARGS},
    {"addWidget", (PyCFunction)SbkQGridLayoutFunc_addWidget, METH_VARARGS},
    {"cellRect", (PyCFunction)SbkQGridLayoutFunc_cellRect, METH_VARARGS},
    {"columnCount", (PyCFunction)SbkQGridLayoutFunc_columnCount, METH_NOARGS},
    {"columnMinimumWidth", (PyCFunction)SbkQGridLayoutFunc_columnMinimumWidth, METH_O},
    {"columnStretch", (PyCFunction)SbkQGridLayoutFunc_columnStretch, METH_O},
    {"count", (PyCFunction)SbkQGridLayoutFunc_count, METH_NOARGS},
    {"expandingDirections", (PyCFunction)SbkQGridLayoutFunc_expandingDirections, METH_NOARGS},
    {"hasHeightForWidth", (PyCFunction)SbkQGridLayoutFunc_hasHeightForWidth, METH_NOARGS},
    {"heightForWidth", (PyCFunction)SbkQGridLayoutFunc_heightForWidth, METH_O},
    {"horizontalSpacing", (PyCFunction)SbkQGridLayoutFunc_horizontalSpacing, METH_NOARGS},
    {"invalidate", (PyCFunction)SbkQGridLayoutFunc_invalidate, METH_NOARGS},
    {"itemAt", (PyCFunction)SbkQGridLayoutFunc_itemAt, METH_O},
    {"itemAtPosition", (PyCFunction)SbkQGridLayoutFunc_itemAtPosition, METH_VARARGS},
    {"maximumSize", (PyCFunction)SbkQGridLayoutFunc_maximumSize, METH_NOARGS},
    {"minimumHeightForWidth", (PyCFunction)SbkQGridLayoutFunc_minimumHeightForWidth, METH_O},
    {"minimumSize", (PyCFunction)SbkQGridLayoutFunc_minimumSize, METH_NOARGS},
    {"originCorner", (PyCFunction)SbkQGridLayoutFunc_originCorner, METH_NOARGS},
    {"rowCount", (PyCFunction)SbkQGridLayoutFunc_rowCount, METH_NOARGS},
    {"rowMinimumHeight", (PyCFunction)SbkQGridLayoutFunc_rowMinimumHeight, METH_O},
    {"rowStretch", (PyCFunction)SbkQGridLayoutFunc_rowStretch, METH_O},
    {"setColumnMinimumWidth", (PyCFunction)SbkQGridLayoutFunc_setColumnMinimumWidth, METH_VARARGS},
    {"setColumnStretch", (PyCFunction)SbkQGridLayoutFunc_setColumnStretch, METH_VARARGS},
    {"setDefaultPositioning", (PyCFunction)SbkQGridLayoutFunc_setDefaultPositioning, METH_VARARGS},
    {"setGeometry", (PyCFunction)SbkQGridLayoutFunc_setGeometry, METH_O},
    {"setHorizontalSpacing", (PyCFunction)SbkQGridLayoutFunc_setHorizontalSpacing, METH_O},
    {"setOriginCorner", (PyCFunction)SbkQGridLayoutFunc_setOriginCorner, METH_O},
    {"setRowMinimumHeight", (PyCFunction)SbkQGridLayoutFunc_setRowMinimumHeight, METH_VARARGS},
    {"setRowStretch", (PyCFunction)SbkQGridLayoutFunc_setRowStretch, METH_VARARGS},
    {"setSpacing", (PyCFunction)SbkQGridLayoutFunc_setSpacing, METH_O},
    {"setVerticalSpacing", (PyCFunction)SbkQGridLayoutFunc_setVerticalSpacing, METH_O},
    {"sizeHint", (PyCFunction)SbkQGridLayoutFunc_sizeHint, METH_NOARGS},
    {"spacing", (PyCFunction)SbkQGridLayoutFunc_spacing, METH_NOARGS},
    {"takeAt", (PyCFunction)SbkQGridLayoutFunc_takeAt, METH_O},
    {"verticalSpacing", (PyCFunction)SbkQGridLayoutFunc_verticalSpacing, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQGridLayoutSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QGridLayout* me = reinterpret_cast<QGridLayout*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX]))
        return static_cast<QLayout*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX]))
        return static_cast<QLayoutItem*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGridLayout_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGridLayout",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGridLayoutWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGridLayout_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGridLayout_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQGridLayoutSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QGridLayout(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRIDLAYOUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGridLayout_Type);

    SbkQGridLayout_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX];
    SbkQGridLayout_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX])->mi_init;

    // Fill type discovery information
    SbkQGridLayout_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGridLayout_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGridLayout_Type));
    PyModule_AddObject(module, "QGridLayout",
        ((PyObject*)&SbkQGridLayout_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGridLayout >("QGridLayout*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGridLayout >(typeid(QGridLayout).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

