/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qgraphicsview_wrapper.h"

// Extra includes
#include <QList>
#include <QPainterPath>
#include <QVarLengthArray>
#include <qaction.h>
#include <qbitmap.h>
#include <qbrush.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsitem.h>
#include <qgraphicsproxywidget.h>
#include <qgraphicsscene.h>
#include <qgraphicsview.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qmatrix.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpainterpath.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qpolygon.h>
#include <qrect.h>
#include <qregion.h>
#include <qscrollbar.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qtransform.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsViewWrapper::QGraphicsViewWrapper(QGraphicsScene * scene, QWidget * parent) : QGraphicsView(scene, parent), m_metaObject(0) {
    // ... middle
}

QGraphicsViewWrapper::QGraphicsViewWrapper(QWidget * parent) : QGraphicsView(parent), m_metaObject(0) {
    // ... middle
}

void QGraphicsViewWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QActionEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsViewWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QFrame::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsViewWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::contextMenuEvent(QContextMenuEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::contextMenuEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QContextMenuEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QGraphicsViewWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsView.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsViewWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::dragEnterEvent(QDragEnterEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragEnterEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::dragLeaveEvent(QDragLeaveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragLeaveEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::dragMoveEvent(QDragMoveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragMoveEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::drawBackground(QPainter * painter, const QRectF & rect)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawBackground"));
    if (py_override.isNull()) {
        return this->QGraphicsView::drawBackground(painter, rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRectF& >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsViewWrapper::drawForeground(QPainter * painter, const QRectF & rect)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawForeground"));
    if (py_override.isNull()) {
        return this->QGraphicsView::drawForeground(painter, rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRectF& >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsViewWrapper::drawItems(QPainter * painter, int numItems, QGraphicsItem ** items, const QStyleOptionGraphicsItem * options)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawItems"));
    if (py_override.isNull()) {
        return this->QGraphicsView::drawItems(painter, numItems, items, options);
    }

    // Begin code injection
    
    Shiboken::AutoDecRef object(PyList_New(0));
    for (int i=0, max=numItems; i < max; i++) {
        PyList_Append(object, Shiboken::Converter<QGraphicsItem* >::toPython(items[i]));
    }
    PyObject *items_out = object.object();
    
    // End of code injection
    // Begin code injection
    
    Shiboken::AutoDecRef option_object(PyList_New(0));
    for (int i=0, max=numItems; i < max; i++) {
        PyList_Append(option_object, Shiboken::Converter<QStyleOptionGraphicsItem >::toPython(options[i]));
    }
    PyObject *options_out = option_object.object();
    
    // End of code injection
    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        items_out,
        options_out
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::dropEvent(QDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::dropEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDropEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QGraphicsViewWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QGraphicsView::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsView.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QGraphicsViewWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsView.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsViewWrapper::focusInEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsViewWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QGraphicsView::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsView.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsViewWrapper::focusOutEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QGraphicsViewWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsView.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsViewWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsViewWrapper::inputMethodEvent(QInputMethodEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QGraphicsViewWrapper::inputMethodQuery(Qt::InputMethodQuery query) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QGraphicsView::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(query)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsView.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsViewWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::keyReleaseEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::keyReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QGraphicsViewWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsView.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QGraphicsViewWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsView.minimumSizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsViewWrapper::mouseDoubleClickEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::mouseMoveEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::mousePressEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::mouseReleaseEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QGraphicsViewWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsView.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QGraphicsViewWrapper::paintEvent(QPaintEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::paintEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::resizeEvent(QResizeEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QResizeEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::scrollContentsBy(int dx, int dy)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollContentsBy"));
    if (py_override.isNull()) {
        return this->QGraphicsView::scrollContentsBy(dx, dy);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        dx,
        dy
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsViewWrapper::showEvent(QShowEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::showEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QGraphicsViewWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QGraphicsView::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsView.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsViewWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTabletEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsViewWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsViewWrapper::viewportEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewportEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::viewportEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsView.viewportEvent");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsViewWrapper::wheelEvent(QWheelEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsView::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWheelEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QGraphicsViewWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QGraphicsView::staticMetaObject);
}
    return m_metaObject;
}

int QGraphicsViewWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QGraphicsView::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGraphicsViewWrapper::~QGraphicsViewWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsView_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsViewWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QGraphicsView", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsView(QWidget*)
        cptr = new QGraphicsViewWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QGraphicsView(QWidget*)
        cptr = new QGraphicsViewWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QGraphicsScene* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QGraphicsScene* cpp_arg0 = Shiboken::Converter<QGraphicsScene* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QGraphicsView(QGraphicsScene*,QWidget*)
            cptr = new QGraphicsViewWrapper(cpp_arg0);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            // QGraphicsView(QGraphicsScene*,QWidget*)
            cptr = new QGraphicsViewWrapper(cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQGraphicsView_Init_TypeError;
    } else goto SbkQGraphicsView_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsView_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQGraphicsView_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsScene, PySide.QtGui.QWidget = None", "PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView", overloads);
        return -1;
}

static PyObject*
SbkQGraphicsViewFunc_alignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alignment()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QGraphicsView::alignment();
    py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_backgroundBrush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // backgroundBrush()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QGraphicsView::backgroundBrush();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_cacheMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cacheMode()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QFlags<QGraphicsView::CacheModeFlag> cpp_result = cppSelf->QGraphicsView::cacheMode();
    py_result = Shiboken::Converter<QFlags<QGraphicsView::CacheModeFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_centerOn(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "centerOn", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // centerOn(qreal,qreal)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::centerOn(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // centerOn(QPointF)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::centerOn(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QGraphicsItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsItem* cpp_arg0 = Shiboken::Converter<QGraphicsItem* >::toCpp(pyargs[0]);
        // centerOn(const QGraphicsItem*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::centerOn(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_centerOn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_centerOn_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem", "PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.centerOn", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_contextMenuEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QContextMenuEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QContextMenuEvent* cpp_arg0 = Shiboken::Converter<QContextMenuEvent* >::toCpp(arg);
        // contextMenuEvent(QContextMenuEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::contextMenuEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_contextMenuEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_contextMenuEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QContextMenuEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.contextMenuEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_dragEnterEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragEnterEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragEnterEvent* cpp_arg0 = Shiboken::Converter<QDragEnterEvent* >::toCpp(arg);
        // dragEnterEvent(QDragEnterEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::dragEnterEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_dragEnterEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_dragEnterEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragEnterEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.dragEnterEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_dragLeaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragLeaveEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragLeaveEvent* cpp_arg0 = Shiboken::Converter<QDragLeaveEvent* >::toCpp(arg);
        // dragLeaveEvent(QDragLeaveEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::dragLeaveEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_dragLeaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_dragLeaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragLeaveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.dragLeaveEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_dragMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dragMode()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QGraphicsView::DragMode cpp_result = cppSelf->QGraphicsView::dragMode();
    py_result = Shiboken::Converter<QGraphicsView::DragMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_dragMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragMoveEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragMoveEvent* cpp_arg0 = Shiboken::Converter<QDragMoveEvent* >::toCpp(arg);
        // dragMoveEvent(QDragMoveEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::dragMoveEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_dragMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_dragMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragMoveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.dragMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_drawBackground(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "drawBackground", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QRectF& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg1_auto_ptr;
        QRectF* cpp_arg1 = Shiboken::Converter<QRectF* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QRectF >(cpp_arg1);
        // drawBackground(QPainter*,QRectF)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::drawBackground(cpp_arg0, *cpp_arg1);
    } else goto SbkQGraphicsViewFunc_drawBackground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_drawBackground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.drawBackground", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_drawForeground(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "drawForeground", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QRectF& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg1_auto_ptr;
        QRectF* cpp_arg1 = Shiboken::Converter<QRectF* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QRectF >(cpp_arg1);
        // drawForeground(QPainter*,QRectF)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::drawForeground(cpp_arg0, *cpp_arg1);
    } else goto SbkQGraphicsViewFunc_drawForeground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_drawForeground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.drawForeground", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_drawItems(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawItems", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && PySequence_Check(pyargs[1]) && PySequence_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        // drawItems(QPainter*,int,QGraphicsItem**,const QStyleOptionGraphicsItem*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        // Begin code injection
        
        int numItems_out = PySequence_Size(pyargs[1-1]);
        
        // End of code injection
        // Begin code injection
        
        int numItems = PySequence_Size(pyargs[1-1]);
        QGraphicsItem *items_out[numItems];
        for (int i=0; i < numItems; i++) {
            items_out[i] = Shiboken::Converter<QGraphicsItem* >::toCpp(PySequence_Fast_GET_ITEM(pyargs[1-1], i));
        }
        
        // End of code injection
        // Begin code injection
        
        int numOptions = PySequence_Size(pyargs[2-1]);
        QStyleOptionGraphicsItem options_out[numOptions];
        for (int i=0; i < numOptions; i++) {
            options_out[i] = Shiboken::Converter<QStyleOptionGraphicsItem >::toCpp(PySequence_Fast_GET_ITEM(pyargs[1-1], i));
        }
        
        // End of code injection
        cppSelf->QGraphicsView::drawItems(cpp_arg0, numItems_out, items_out, options_out);
    } else goto SbkQGraphicsViewFunc_drawItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_drawItems_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, int, PySide.QtGui.QGraphicsItem, PySide.QtGui.QStyleOptionGraphicsItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.drawItems", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_dropEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDropEvent* cpp_arg0 = Shiboken::Converter<QDropEvent* >::toCpp(arg);
        // dropEvent(QDropEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::dropEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_dropEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_dropEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.dropEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_ensureVisible(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "ensureVisible", 1, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // ensureVisible(qreal,qreal,qreal,qreal,int,int)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::ensureVisible(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        } else if (PyNumber_Check(pyargs[4])) {
            int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
            if (numArgs == 5) {
                // ensureVisible(qreal,qreal,qreal,qreal,int,int)
                QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsView::ensureVisible(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            } else if (PyNumber_Check(pyargs[5])) {
                int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
                // ensureVisible(qreal,qreal,qreal,qreal,int,int)
                QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsView::ensureVisible(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
            } else goto SbkQGraphicsViewFunc_ensureVisible_TypeError;
        } else goto SbkQGraphicsViewFunc_ensureVisible_TypeError;
    } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (numArgs == 1) {
            // ensureVisible(QRectF,int,int)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::ensureVisible(*cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // ensureVisible(QRectF,int,int)
                QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsView::ensureVisible(*cpp_arg0, cpp_arg1);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // ensureVisible(QRectF,int,int)
                QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsView::ensureVisible(*cpp_arg0, cpp_arg1, cpp_arg2);
            } else goto SbkQGraphicsViewFunc_ensureVisible_TypeError;
        } else goto SbkQGraphicsViewFunc_ensureVisible_TypeError;
    } else if (Shiboken::Converter<QGraphicsItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsItem* cpp_arg0 = Shiboken::Converter<QGraphicsItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // ensureVisible(const QGraphicsItem*,int,int)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::ensureVisible(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // ensureVisible(const QGraphicsItem*,int,int)
                QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsView::ensureVisible(cpp_arg0, cpp_arg1);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // ensureVisible(const QGraphicsItem*,int,int)
                QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsView::ensureVisible(cpp_arg0, cpp_arg1, cpp_arg2);
            } else goto SbkQGraphicsViewFunc_ensureVisible_TypeError;
        } else goto SbkQGraphicsViewFunc_ensureVisible_TypeError;
    } else goto SbkQGraphicsViewFunc_ensureVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_ensureVisible_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem, int = 50, int = 50", "PySide.QtCore.QRectF, int = 50, int = 50", "float, float, float, float, int = 50, int = 50", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.ensureVisible", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsView::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQGraphicsViewFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsViewFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.event", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_fitInView(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQGraphicsViewFunc_fitInView_TypeError;

    if (!PyArg_UnpackTuple(args, "fitInView", 1, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // fitInView(qreal,qreal,qreal,qreal,Qt::AspectRatioMode)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::fitInView(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        } else if (Shiboken::Converter<Qt::AspectRatioMode >::isConvertible(pyargs[4])) {
            Qt::AspectRatioMode cpp_arg4 = Shiboken::Converter<Qt::AspectRatioMode >::toCpp(pyargs[4]);
            // fitInView(qreal,qreal,qreal,qreal,Qt::AspectRatioMode)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::fitInView(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
        } else goto SbkQGraphicsViewFunc_fitInView_TypeError;
    } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (numArgs == 1) {
            // fitInView(QRectF,Qt::AspectRatioMode)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::fitInView(*cpp_arg0);
        } else if (Shiboken::Converter<Qt::AspectRatioMode >::isConvertible(pyargs[1])) {
            Qt::AspectRatioMode cpp_arg1 = Shiboken::Converter<Qt::AspectRatioMode >::toCpp(pyargs[1]);
            // fitInView(QRectF,Qt::AspectRatioMode)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::fitInView(*cpp_arg0, cpp_arg1);
        } else goto SbkQGraphicsViewFunc_fitInView_TypeError;
    } else if (Shiboken::Converter<QGraphicsItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsItem* cpp_arg0 = Shiboken::Converter<QGraphicsItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // fitInView(const QGraphicsItem*,Qt::AspectRatioMode)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::fitInView(cpp_arg0);
        } else if (Shiboken::Converter<Qt::AspectRatioMode >::isConvertible(pyargs[1])) {
            Qt::AspectRatioMode cpp_arg1 = Shiboken::Converter<Qt::AspectRatioMode >::toCpp(pyargs[1]);
            // fitInView(const QGraphicsItem*,Qt::AspectRatioMode)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::fitInView(cpp_arg0, cpp_arg1);
        } else goto SbkQGraphicsViewFunc_fitInView_TypeError;
    } else goto SbkQGraphicsViewFunc_fitInView_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_fitInView_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem, PySide.QtCore.Qt.AspectRatioMode = Qt.IgnoreAspectRatio", "PySide.QtCore.QRectF, PySide.QtCore.Qt.AspectRatioMode = Qt.IgnoreAspectRatio", "float, float, float, float, PySide.QtCore.Qt.AspectRatioMode = Qt.IgnoreAspectRatio", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.fitInView", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_focusInEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusInEvent(QFocusEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::focusInEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_focusInEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_focusInEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.focusInEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_focusNextPrevChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // focusNextPrevChild(bool)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsView::focusNextPrevChild(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQGraphicsViewFunc_focusNextPrevChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsViewFunc_focusNextPrevChild_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.focusNextPrevChild", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_focusOutEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusOutEvent(QFocusEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::focusOutEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_focusOutEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_focusOutEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.focusOutEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_foregroundBrush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // foregroundBrush()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QGraphicsView::foregroundBrush();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_inputMethodEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QInputMethodEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QInputMethodEvent* cpp_arg0 = Shiboken::Converter<QInputMethodEvent* >::toCpp(arg);
        // inputMethodEvent(QInputMethodEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::inputMethodEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_inputMethodEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_inputMethodEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputMethodEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.inputMethodEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_inputMethodQuery(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::InputMethodQuery >::isConvertible(arg)) {
        Qt::InputMethodQuery cpp_arg0 = Shiboken::Converter<Qt::InputMethodQuery >::toCpp(arg);
        // inputMethodQuery(Qt::InputMethodQuery)const
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QGraphicsView::inputMethodQuery(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQGraphicsViewFunc_inputMethodQuery_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsViewFunc_inputMethodQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.InputMethodQuery", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.inputMethodQuery", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_invalidateScene(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "invalidateScene", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // invalidateScene(QRectF,QFlags<QGraphicsScene::SceneLayer>)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::invalidateScene();
    } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (numArgs == 1) {
            // invalidateScene(QRectF,QFlags<QGraphicsScene::SceneLayer>)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::invalidateScene(*cpp_arg0);
        } else if (SbkPySide_QtGui_QGraphicsScene_SceneLayer_Check(pyargs[1])) {
            QFlags<QGraphicsScene::SceneLayer> cpp_arg1 = Shiboken::Converter<QFlags<QGraphicsScene::SceneLayer> >::toCpp(pyargs[1]);
            // invalidateScene(QRectF,QFlags<QGraphicsScene::SceneLayer>)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::invalidateScene(*cpp_arg0, cpp_arg1);
        } else goto SbkQGraphicsViewFunc_invalidateScene_TypeError;
    } else goto SbkQGraphicsViewFunc_invalidateScene_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_invalidateScene_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF = QRectF(), PySide.QtGui.QGraphicsScene.SceneLayers = QGraphicsScene.AllLayers", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.invalidateScene", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_isInteractive(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isInteractive()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGraphicsView::isInteractive();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_isTransformed(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isTransformed()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGraphicsView::isTransformed();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_itemAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "itemAt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // itemAt(int,int)const
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        QGraphicsItem * cpp_result = cppSelf->QGraphicsView::itemAt(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QGraphicsItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // itemAt(QPoint)const
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        QGraphicsItem * cpp_result = cppSelf->QGraphicsView::itemAt(*cpp_arg0);
        py_result = Shiboken::Converter<QGraphicsItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQGraphicsViewFunc_itemAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsViewFunc_itemAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.itemAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_items(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQGraphicsViewFunc_items_TypeError;

    if (!PyArg_UnpackTuple(args, "items", 0, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (numArgs == 0) {
        // items()const
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsView::items();
        py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // items(int,int)const
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsView::items(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // items(int,int,int,int,Qt::ItemSelectionMode)const
                QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
                QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsView::items(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
            } else if (Shiboken::Converter<Qt::ItemSelectionMode >::isConvertible(pyargs[4])) {
                Qt::ItemSelectionMode cpp_arg4 = Shiboken::Converter<Qt::ItemSelectionMode >::toCpp(pyargs[4]);
                // items(int,int,int,int,Qt::ItemSelectionMode)const
                QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
                QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsView::items(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
            } else goto SbkQGraphicsViewFunc_items_TypeError;
        } else goto SbkQGraphicsViewFunc_items_TypeError;
    } else if (Shiboken::Converter<QRect& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // items(QRect,Qt::ItemSelectionMode)const
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsView::items(*cpp_arg0);
            py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::ItemSelectionMode >::isConvertible(pyargs[1])) {
            Qt::ItemSelectionMode cpp_arg1 = Shiboken::Converter<Qt::ItemSelectionMode >::toCpp(pyargs[1]);
            // items(QRect,Qt::ItemSelectionMode)const
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsView::items(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
        } else goto SbkQGraphicsViewFunc_items_TypeError;
    } else if (Shiboken::Converter<QPolygon& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPolygon > cpp_arg0_auto_ptr;
        QPolygon* cpp_arg0 = Shiboken::Converter<QPolygon* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPolygon& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygon >(cpp_arg0);
        if (numArgs == 1) {
            // items(QPolygon,Qt::ItemSelectionMode)const
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsView::items(*cpp_arg0);
            py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::ItemSelectionMode >::isConvertible(pyargs[1])) {
            Qt::ItemSelectionMode cpp_arg1 = Shiboken::Converter<Qt::ItemSelectionMode >::toCpp(pyargs[1]);
            // items(QPolygon,Qt::ItemSelectionMode)const
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsView::items(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
        } else goto SbkQGraphicsViewFunc_items_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // items(QPoint)const
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsView::items(*cpp_arg0);
        py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPainterPath& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // items(QPainterPath,Qt::ItemSelectionMode)const
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsView::items(*cpp_arg0);
            py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::ItemSelectionMode >::isConvertible(pyargs[1])) {
            Qt::ItemSelectionMode cpp_arg1 = Shiboken::Converter<Qt::ItemSelectionMode >::toCpp(pyargs[1]);
            // items(QPainterPath,Qt::ItemSelectionMode)const
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsView::items(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
        } else goto SbkQGraphicsViewFunc_items_TypeError;
    } else goto SbkQGraphicsViewFunc_items_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsViewFunc_items_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QPainterPath, PySide.QtCore.Qt.ItemSelectionMode = Qt.IntersectsItemShape", "PySide.QtCore.QPoint", "PySide.QtGui.QPolygon, PySide.QtCore.Qt.ItemSelectionMode = Qt.IntersectsItemShape", "PySide.QtCore.QRect, PySide.QtCore.Qt.ItemSelectionMode = Qt.IntersectsItemShape", "int, int", "int, int, int, int, PySide.QtCore.Qt.ItemSelectionMode = Qt.IntersectsItemShape", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.items", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::keyPressEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.keyPressEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_keyReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyReleaseEvent(QKeyEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::keyReleaseEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_keyReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_keyReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.keyReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_mapFromScene(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQGraphicsViewFunc_mapFromScene_TypeError;

    if (!PyArg_UnpackTuple(args, "mapFromScene", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // mapFromScene(qreal,qreal)const
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            QPoint cpp_result = cppSelf->QGraphicsView::mapFromScene(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
        } else if (numArgs == 4 && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
            qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
            qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
            // mapFromScene(qreal,qreal,qreal,qreal)const
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            QPolygon cpp_result = cppSelf->QGraphicsView::mapFromScene(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QPolygon >::toPython(cpp_result);
        } else goto SbkQGraphicsViewFunc_mapFromScene_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // mapFromScene(QRectF)const
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        QPolygon cpp_result = cppSelf->QGraphicsView::mapFromScene(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygon >::toPython(cpp_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPolygonF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPolygonF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        // mapFromScene(QPolygonF)const
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        QPolygon cpp_result = cppSelf->QGraphicsView::mapFromScene(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygon >::toPython(cpp_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // mapFromScene(QPointF)const
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        QPoint cpp_result = cppSelf->QGraphicsView::mapFromScene(*cpp_arg0);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPainterPath& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(pyargs[0]);
        // mapFromScene(QPainterPath)const
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = cppSelf->QGraphicsView::mapFromScene(*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else goto SbkQGraphicsViewFunc_mapFromScene_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsViewFunc_mapFromScene_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", "PySide.QtCore.QPointF", "PySide.QtGui.QPolygonF", "PySide.QtCore.QRectF", "float, float", "float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.mapFromScene", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_mapToScene(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQGraphicsViewFunc_mapToScene_TypeError;

    if (!PyArg_UnpackTuple(args, "mapToScene", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // mapToScene(int,int)const
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            QPointF cpp_result = cppSelf->QGraphicsView::mapToScene(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
        } else if (numArgs == 4 && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // mapToScene(int,int,int,int)const
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            QPolygonF cpp_result = cppSelf->QGraphicsView::mapToScene(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QPolygonF >::toPython(cpp_result);
        } else goto SbkQGraphicsViewFunc_mapToScene_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QRect& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        // mapToScene(QRect)const
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        QPolygonF cpp_result = cppSelf->QGraphicsView::mapToScene(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygonF >::toPython(cpp_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPolygon& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPolygon > cpp_arg0_auto_ptr;
        QPolygon* cpp_arg0 = Shiboken::Converter<QPolygon* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPolygon& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygon >(cpp_arg0);
        // mapToScene(QPolygon)const
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        QPolygonF cpp_result = cppSelf->QGraphicsView::mapToScene(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygonF >::toPython(cpp_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // mapToScene(QPoint)const
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        QPointF cpp_result = cppSelf->QGraphicsView::mapToScene(*cpp_arg0);
        py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPainterPath& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(pyargs[0]);
        // mapToScene(QPainterPath)const
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        QPainterPath cpp_result = cppSelf->QGraphicsView::mapToScene(*cpp_arg0);
        py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    } else goto SbkQGraphicsViewFunc_mapToScene_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsViewFunc_mapToScene_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", "PySide.QtCore.QPoint", "PySide.QtGui.QPolygon", "PySide.QtCore.QRect", "int, int", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.mapToScene", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_matrix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // matrix()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QMatrix cpp_result = cppSelf->QGraphicsView::matrix();
    py_result = Shiboken::Converter<QMatrix >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_mouseDoubleClickEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseDoubleClickEvent(QMouseEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::mouseDoubleClickEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_mouseDoubleClickEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_mouseDoubleClickEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.mouseDoubleClickEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QMouseEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::mouseMoveEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.mouseMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::mousePressEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.mousePressEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::mouseReleaseEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_optimizationFlags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // optimizationFlags()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QFlags<QGraphicsView::OptimizationFlag> cpp_result = cppSelf->QGraphicsView::optimizationFlags();
    py_result = Shiboken::Converter<QFlags<QGraphicsView::OptimizationFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::paintEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.paintEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_render(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "render", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QPainter* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // render(QPainter*,QRectF,QRect,Qt::AspectRatioMode)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::render(cpp_arg0);
        } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QRectF > cpp_arg1_auto_ptr;
            QRectF* cpp_arg1 = Shiboken::Converter<QRectF* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QRectF >(cpp_arg1);
            if (numArgs == 2) {
                // render(QPainter*,QRectF,QRect,Qt::AspectRatioMode)
                QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsView::render(cpp_arg0, *cpp_arg1);
            } else if (Shiboken::Converter<QRect& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QRect* cpp_arg2 = Shiboken::Converter<QRect* >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // render(QPainter*,QRectF,QRect,Qt::AspectRatioMode)
                    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
                    cppSelf->QGraphicsView::render(cpp_arg0, *cpp_arg1, *cpp_arg2);
                } else if (Shiboken::Converter<Qt::AspectRatioMode >::isConvertible(pyargs[3])) {
                    Qt::AspectRatioMode cpp_arg3 = Shiboken::Converter<Qt::AspectRatioMode >::toCpp(pyargs[3]);
                    // render(QPainter*,QRectF,QRect,Qt::AspectRatioMode)
                    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
                    cppSelf->QGraphicsView::render(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                } else goto SbkQGraphicsViewFunc_render_TypeError;
            } else goto SbkQGraphicsViewFunc_render_TypeError;
        } else goto SbkQGraphicsViewFunc_render_TypeError;
    } else goto SbkQGraphicsViewFunc_render_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_render_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRectF = QRectF(), PySide.QtCore.QRect = QRect(), PySide.QtCore.Qt.AspectRatioMode = Qt.KeepAspectRatio", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.render", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_renderHints(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // renderHints()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QFlags<QPainter::RenderHint> cpp_result = cppSelf->QGraphicsView::renderHints();
    py_result = Shiboken::Converter<QFlags<QPainter::RenderHint> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_resetCachedContent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // resetCachedContent()
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsView::resetCachedContent();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGraphicsViewFunc_resetMatrix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // resetMatrix()
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsView::resetMatrix();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGraphicsViewFunc_resetTransform(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // resetTransform()
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsView::resetTransform();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGraphicsViewFunc_resizeAnchor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // resizeAnchor()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QGraphicsView::ViewportAnchor cpp_result = cppSelf->QGraphicsView::resizeAnchor();
    py_result = Shiboken::Converter<QGraphicsView::ViewportAnchor >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::resizeEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.resizeEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_rotate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // rotate(qreal)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::rotate(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_rotate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_rotate_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.rotate", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_rubberBandSelectionMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rubberBandSelectionMode()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    Qt::ItemSelectionMode cpp_result = cppSelf->QGraphicsView::rubberBandSelectionMode();
    py_result = Shiboken::Converter<Qt::ItemSelectionMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_scale(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scale", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // scale(qreal,qreal)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::scale(cpp_arg0, cpp_arg1);
    } else goto SbkQGraphicsViewFunc_scale_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_scale_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.scale", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_scene(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scene()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QGraphicsScene * cpp_result = cppSelf->QGraphicsView::scene();
    py_result = Shiboken::Converter<QGraphicsScene* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_sceneRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sceneRect()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QGraphicsView::sceneRect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_scrollContentsBy(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollContentsBy", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // scrollContentsBy(int,int)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::scrollContentsBy(cpp_arg0, cpp_arg1);
    } else goto SbkQGraphicsViewFunc_scrollContentsBy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_scrollContentsBy_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.scrollContentsBy", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(arg)) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(arg);
        // setAlignment(QFlags<Qt::AlignmentFlag>)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setAlignment(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_setAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.setAlignment", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setBackgroundBrush(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!Shiboken::Converter<QBrush& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setBackgroundBrush(QBrush)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setBackgroundBrush(*cpp_arg0);
    } else goto SbkQGraphicsViewFunc_setBackgroundBrush_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setBackgroundBrush_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.setBackgroundBrush", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setCacheMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QGraphicsView_CacheModeFlag_Check(arg)) {
        QFlags<QGraphicsView::CacheModeFlag> cpp_arg0 = Shiboken::Converter<QFlags<QGraphicsView::CacheModeFlag> >::toCpp(arg);
        // setCacheMode(QFlags<QGraphicsView::CacheModeFlag>)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setCacheMode(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_setCacheMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setCacheMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsView.CacheMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.setCacheMode", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setDragMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsView::DragMode >::isConvertible(arg)) {
        QGraphicsView::DragMode cpp_arg0 = Shiboken::Converter<QGraphicsView::DragMode >::toCpp(arg);
        // setDragMode(QGraphicsView::DragMode)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setDragMode(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_setDragMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setDragMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsView.DragMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.setDragMode", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setForegroundBrush(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!Shiboken::Converter<QBrush& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setForegroundBrush(QBrush)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setForegroundBrush(*cpp_arg0);
    } else goto SbkQGraphicsViewFunc_setForegroundBrush_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setForegroundBrush_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.setForegroundBrush", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setInteractive(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setInteractive(bool)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setInteractive(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_setInteractive_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setInteractive_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.setInteractive", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setMatrix(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setMatrix", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QMatrix& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setMatrix(QMatrix,bool)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::setMatrix(*cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setMatrix(QMatrix,bool)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::setMatrix(*cpp_arg0, cpp_arg1);
        } else goto SbkQGraphicsViewFunc_setMatrix_TypeError;
    } else goto SbkQGraphicsViewFunc_setMatrix_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setMatrix_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.setMatrix", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setOptimizationFlag(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setOptimizationFlag", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QGraphicsView::OptimizationFlag >::isConvertible(pyargs[0])) {
        QGraphicsView::OptimizationFlag cpp_arg0 = Shiboken::Converter<QGraphicsView::OptimizationFlag >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setOptimizationFlag(QGraphicsView::OptimizationFlag,bool)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::setOptimizationFlag(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setOptimizationFlag(QGraphicsView::OptimizationFlag,bool)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::setOptimizationFlag(cpp_arg0, cpp_arg1);
        } else goto SbkQGraphicsViewFunc_setOptimizationFlag_TypeError;
    } else goto SbkQGraphicsViewFunc_setOptimizationFlag_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setOptimizationFlag_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsView.OptimizationFlag, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.setOptimizationFlag", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setOptimizationFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Check(arg)) {
        QFlags<QGraphicsView::OptimizationFlag> cpp_arg0 = Shiboken::Converter<QFlags<QGraphicsView::OptimizationFlag> >::toCpp(arg);
        // setOptimizationFlags(QFlags<QGraphicsView::OptimizationFlag>)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setOptimizationFlags(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_setOptimizationFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setOptimizationFlags_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsView.OptimizationFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.setOptimizationFlags", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setRenderHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRenderHint", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QPainter::RenderHint >::isConvertible(pyargs[0])) {
        QPainter::RenderHint cpp_arg0 = Shiboken::Converter<QPainter::RenderHint >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setRenderHint(QPainter::RenderHint,bool)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::setRenderHint(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setRenderHint(QPainter::RenderHint,bool)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::setRenderHint(cpp_arg0, cpp_arg1);
        } else goto SbkQGraphicsViewFunc_setRenderHint_TypeError;
    } else goto SbkQGraphicsViewFunc_setRenderHint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setRenderHint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter.RenderHint, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.setRenderHint", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setRenderHints(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QPainter_RenderHint_Check(arg)) {
        QFlags<QPainter::RenderHint> cpp_arg0 = Shiboken::Converter<QFlags<QPainter::RenderHint> >::toCpp(arg);
        // setRenderHints(QFlags<QPainter::RenderHint>)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setRenderHints(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_setRenderHints_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setRenderHints_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter.RenderHints", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.setRenderHints", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setResizeAnchor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsView::ViewportAnchor >::isConvertible(arg)) {
        QGraphicsView::ViewportAnchor cpp_arg0 = Shiboken::Converter<QGraphicsView::ViewportAnchor >::toCpp(arg);
        // setResizeAnchor(QGraphicsView::ViewportAnchor)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setResizeAnchor(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_setResizeAnchor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setResizeAnchor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsView.ViewportAnchor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.setResizeAnchor", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setRubberBandSelectionMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::ItemSelectionMode >::isConvertible(arg)) {
        Qt::ItemSelectionMode cpp_arg0 = Shiboken::Converter<Qt::ItemSelectionMode >::toCpp(arg);
        // setRubberBandSelectionMode(Qt::ItemSelectionMode)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setRubberBandSelectionMode(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_setRubberBandSelectionMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setRubberBandSelectionMode_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.ItemSelectionMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.setRubberBandSelectionMode", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setScene(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsScene* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsScene* cpp_arg0 = Shiboken::Converter<QGraphicsScene* >::toCpp(arg);
        // setScene(QGraphicsScene*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setScene(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQGraphicsViewFunc_setScene_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setScene_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsScene", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.setScene", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setSceneRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQGraphicsViewFunc_setSceneRect_TypeError;

    if (!PyArg_UnpackTuple(args, "setSceneRect", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // setSceneRect(qreal,qreal,qreal,qreal)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setSceneRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else if (numArgs == 1 && Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // setSceneRect(QRectF)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setSceneRect(*cpp_arg0);
    } else goto SbkQGraphicsViewFunc_setSceneRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setSceneRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", "float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.setSceneRect", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setTransform(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTransform", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QTransform& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setTransform(QTransform,bool)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::setTransform(*cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setTransform(QTransform,bool)
            QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsView::setTransform(*cpp_arg0, cpp_arg1);
        } else goto SbkQGraphicsViewFunc_setTransform_TypeError;
    } else goto SbkQGraphicsViewFunc_setTransform_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setTransform_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTransform, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.setTransform", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setTransformationAnchor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsView::ViewportAnchor >::isConvertible(arg)) {
        QGraphicsView::ViewportAnchor cpp_arg0 = Shiboken::Converter<QGraphicsView::ViewportAnchor >::toCpp(arg);
        // setTransformationAnchor(QGraphicsView::ViewportAnchor)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setTransformationAnchor(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_setTransformationAnchor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setTransformationAnchor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsView.ViewportAnchor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.setTransformationAnchor", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setViewportUpdateMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsView::ViewportUpdateMode >::isConvertible(arg)) {
        QGraphicsView::ViewportUpdateMode cpp_arg0 = Shiboken::Converter<QGraphicsView::ViewportUpdateMode >::toCpp(arg);
        // setViewportUpdateMode(QGraphicsView::ViewportUpdateMode)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setViewportUpdateMode(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_setViewportUpdateMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setViewportUpdateMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsView.ViewportUpdateMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.setViewportUpdateMode", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_setupViewport(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setupViewport(QWidget*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::setupViewport(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_setupViewport_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_setupViewport_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.setupViewport", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_shear(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "shear", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // shear(qreal,qreal)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::shear(cpp_arg0, cpp_arg1);
    } else goto SbkQGraphicsViewFunc_shear_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_shear_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.shear", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_showEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QShowEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QShowEvent* cpp_arg0 = Shiboken::Converter<QShowEvent* >::toCpp(arg);
        // showEvent(QShowEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::showEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_showEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_showEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QShowEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.showEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QGraphicsView::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_transform(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // transform()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QTransform cpp_result = cppSelf->QGraphicsView::transform();
    py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_transformationAnchor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // transformationAnchor()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QGraphicsView::ViewportAnchor cpp_result = cppSelf->QGraphicsView::transformationAnchor();
    py_result = Shiboken::Converter<QGraphicsView::ViewportAnchor >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_translate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translate", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // translate(qreal,qreal)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::translate(cpp_arg0, cpp_arg1);
    } else goto SbkQGraphicsViewFunc_translate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_translate_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsView.translate", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_updateScene(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QRectF >  >::isConvertible(arg)) {
        QList<QRectF >  cpp_arg0 = Shiboken::Converter<QList<QRectF >  >::toCpp(arg);
        // updateScene(QList<QRectF>)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::updateScene(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_updateScene_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_updateScene_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.updateScene", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_updateSceneRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRectF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!Shiboken::Converter<QRectF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // updateSceneRect(QRectF)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::updateSceneRect(*cpp_arg0);
    } else goto SbkQGraphicsViewFunc_updateSceneRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_updateSceneRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.updateSceneRect", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_viewportEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // viewportEvent(QEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsView::viewportEvent(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQGraphicsViewFunc_viewportEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsViewFunc_viewportEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.viewportEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsViewFunc_viewportTransform(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewportTransform()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QTransform cpp_result = cppSelf->QGraphicsView::viewportTransform();
    py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_viewportUpdateMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewportUpdateMode()const
    QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
    QGraphicsView::ViewportUpdateMode cpp_result = cppSelf->QGraphicsView::viewportUpdateMode();
    py_result = Shiboken::Converter<QGraphicsView::ViewportUpdateMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsViewFunc_wheelEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWheelEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWheelEvent* cpp_arg0 = Shiboken::Converter<QWheelEvent* >::toCpp(arg);
        // wheelEvent(QWheelEvent*)
        QGraphicsView* cppSelf = Shiboken::Converter<QGraphicsView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsView::wheelEvent(cpp_arg0);
    } else goto SbkQGraphicsViewFunc_wheelEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsViewFunc_wheelEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWheelEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsView.wheelEvent", overloads);
        return 0;
}

static PyMethodDef SbkQGraphicsView_methods[] = {
    {"alignment", (PyCFunction)SbkQGraphicsViewFunc_alignment, METH_NOARGS},
    {"backgroundBrush", (PyCFunction)SbkQGraphicsViewFunc_backgroundBrush, METH_NOARGS},
    {"cacheMode", (PyCFunction)SbkQGraphicsViewFunc_cacheMode, METH_NOARGS},
    {"centerOn", (PyCFunction)SbkQGraphicsViewFunc_centerOn, METH_VARARGS},
    {"contextMenuEvent", (PyCFunction)SbkQGraphicsViewFunc_contextMenuEvent, METH_O},
    {"dragEnterEvent", (PyCFunction)SbkQGraphicsViewFunc_dragEnterEvent, METH_O},
    {"dragLeaveEvent", (PyCFunction)SbkQGraphicsViewFunc_dragLeaveEvent, METH_O},
    {"dragMode", (PyCFunction)SbkQGraphicsViewFunc_dragMode, METH_NOARGS},
    {"dragMoveEvent", (PyCFunction)SbkQGraphicsViewFunc_dragMoveEvent, METH_O},
    {"drawBackground", (PyCFunction)SbkQGraphicsViewFunc_drawBackground, METH_VARARGS},
    {"drawForeground", (PyCFunction)SbkQGraphicsViewFunc_drawForeground, METH_VARARGS},
    {"drawItems", (PyCFunction)SbkQGraphicsViewFunc_drawItems, METH_VARARGS},
    {"dropEvent", (PyCFunction)SbkQGraphicsViewFunc_dropEvent, METH_O},
    {"ensureVisible", (PyCFunction)SbkQGraphicsViewFunc_ensureVisible, METH_VARARGS},
    {"event", (PyCFunction)SbkQGraphicsViewFunc_event, METH_O},
    {"fitInView", (PyCFunction)SbkQGraphicsViewFunc_fitInView, METH_VARARGS},
    {"focusInEvent", (PyCFunction)SbkQGraphicsViewFunc_focusInEvent, METH_O},
    {"focusNextPrevChild", (PyCFunction)SbkQGraphicsViewFunc_focusNextPrevChild, METH_O},
    {"focusOutEvent", (PyCFunction)SbkQGraphicsViewFunc_focusOutEvent, METH_O},
    {"foregroundBrush", (PyCFunction)SbkQGraphicsViewFunc_foregroundBrush, METH_NOARGS},
    {"inputMethodEvent", (PyCFunction)SbkQGraphicsViewFunc_inputMethodEvent, METH_O},
    {"inputMethodQuery", (PyCFunction)SbkQGraphicsViewFunc_inputMethodQuery, METH_O},
    {"invalidateScene", (PyCFunction)SbkQGraphicsViewFunc_invalidateScene, METH_VARARGS},
    {"isInteractive", (PyCFunction)SbkQGraphicsViewFunc_isInteractive, METH_NOARGS},
    {"isTransformed", (PyCFunction)SbkQGraphicsViewFunc_isTransformed, METH_NOARGS},
    {"itemAt", (PyCFunction)SbkQGraphicsViewFunc_itemAt, METH_VARARGS},
    {"items", (PyCFunction)SbkQGraphicsViewFunc_items, METH_VARARGS},
    {"keyPressEvent", (PyCFunction)SbkQGraphicsViewFunc_keyPressEvent, METH_O},
    {"keyReleaseEvent", (PyCFunction)SbkQGraphicsViewFunc_keyReleaseEvent, METH_O},
    {"mapFromScene", (PyCFunction)SbkQGraphicsViewFunc_mapFromScene, METH_VARARGS},
    {"mapToScene", (PyCFunction)SbkQGraphicsViewFunc_mapToScene, METH_VARARGS},
    {"matrix", (PyCFunction)SbkQGraphicsViewFunc_matrix, METH_NOARGS},
    {"mouseDoubleClickEvent", (PyCFunction)SbkQGraphicsViewFunc_mouseDoubleClickEvent, METH_O},
    {"mouseMoveEvent", (PyCFunction)SbkQGraphicsViewFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQGraphicsViewFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQGraphicsViewFunc_mouseReleaseEvent, METH_O},
    {"optimizationFlags", (PyCFunction)SbkQGraphicsViewFunc_optimizationFlags, METH_NOARGS},
    {"paintEvent", (PyCFunction)SbkQGraphicsViewFunc_paintEvent, METH_O},
    {"render", (PyCFunction)SbkQGraphicsViewFunc_render, METH_VARARGS},
    {"renderHints", (PyCFunction)SbkQGraphicsViewFunc_renderHints, METH_NOARGS},
    {"resetCachedContent", (PyCFunction)SbkQGraphicsViewFunc_resetCachedContent, METH_NOARGS},
    {"resetMatrix", (PyCFunction)SbkQGraphicsViewFunc_resetMatrix, METH_NOARGS},
    {"resetTransform", (PyCFunction)SbkQGraphicsViewFunc_resetTransform, METH_NOARGS},
    {"resizeAnchor", (PyCFunction)SbkQGraphicsViewFunc_resizeAnchor, METH_NOARGS},
    {"resizeEvent", (PyCFunction)SbkQGraphicsViewFunc_resizeEvent, METH_O},
    {"rotate", (PyCFunction)SbkQGraphicsViewFunc_rotate, METH_O},
    {"rubberBandSelectionMode", (PyCFunction)SbkQGraphicsViewFunc_rubberBandSelectionMode, METH_NOARGS},
    {"scale", (PyCFunction)SbkQGraphicsViewFunc_scale, METH_VARARGS},
    {"scene", (PyCFunction)SbkQGraphicsViewFunc_scene, METH_NOARGS},
    {"sceneRect", (PyCFunction)SbkQGraphicsViewFunc_sceneRect, METH_NOARGS},
    {"scrollContentsBy", (PyCFunction)SbkQGraphicsViewFunc_scrollContentsBy, METH_VARARGS},
    {"setAlignment", (PyCFunction)SbkQGraphicsViewFunc_setAlignment, METH_O},
    {"setBackgroundBrush", (PyCFunction)SbkQGraphicsViewFunc_setBackgroundBrush, METH_O},
    {"setCacheMode", (PyCFunction)SbkQGraphicsViewFunc_setCacheMode, METH_O},
    {"setDragMode", (PyCFunction)SbkQGraphicsViewFunc_setDragMode, METH_O},
    {"setForegroundBrush", (PyCFunction)SbkQGraphicsViewFunc_setForegroundBrush, METH_O},
    {"setInteractive", (PyCFunction)SbkQGraphicsViewFunc_setInteractive, METH_O},
    {"setMatrix", (PyCFunction)SbkQGraphicsViewFunc_setMatrix, METH_VARARGS},
    {"setOptimizationFlag", (PyCFunction)SbkQGraphicsViewFunc_setOptimizationFlag, METH_VARARGS},
    {"setOptimizationFlags", (PyCFunction)SbkQGraphicsViewFunc_setOptimizationFlags, METH_O},
    {"setRenderHint", (PyCFunction)SbkQGraphicsViewFunc_setRenderHint, METH_VARARGS},
    {"setRenderHints", (PyCFunction)SbkQGraphicsViewFunc_setRenderHints, METH_O},
    {"setResizeAnchor", (PyCFunction)SbkQGraphicsViewFunc_setResizeAnchor, METH_O},
    {"setRubberBandSelectionMode", (PyCFunction)SbkQGraphicsViewFunc_setRubberBandSelectionMode, METH_O},
    {"setScene", (PyCFunction)SbkQGraphicsViewFunc_setScene, METH_O},
    {"setSceneRect", (PyCFunction)SbkQGraphicsViewFunc_setSceneRect, METH_VARARGS},
    {"setTransform", (PyCFunction)SbkQGraphicsViewFunc_setTransform, METH_VARARGS},
    {"setTransformationAnchor", (PyCFunction)SbkQGraphicsViewFunc_setTransformationAnchor, METH_O},
    {"setViewportUpdateMode", (PyCFunction)SbkQGraphicsViewFunc_setViewportUpdateMode, METH_O},
    {"setupViewport", (PyCFunction)SbkQGraphicsViewFunc_setupViewport, METH_O},
    {"shear", (PyCFunction)SbkQGraphicsViewFunc_shear, METH_VARARGS},
    {"showEvent", (PyCFunction)SbkQGraphicsViewFunc_showEvent, METH_O},
    {"sizeHint", (PyCFunction)SbkQGraphicsViewFunc_sizeHint, METH_NOARGS},
    {"transform", (PyCFunction)SbkQGraphicsViewFunc_transform, METH_NOARGS},
    {"transformationAnchor", (PyCFunction)SbkQGraphicsViewFunc_transformationAnchor, METH_NOARGS},
    {"translate", (PyCFunction)SbkQGraphicsViewFunc_translate, METH_VARARGS},
    {"updateScene", (PyCFunction)SbkQGraphicsViewFunc_updateScene, METH_O},
    {"updateSceneRect", (PyCFunction)SbkQGraphicsViewFunc_updateSceneRect, METH_O},
    {"viewportEvent", (PyCFunction)SbkQGraphicsViewFunc_viewportEvent, METH_O},
    {"viewportTransform", (PyCFunction)SbkQGraphicsViewFunc_viewportTransform, METH_NOARGS},
    {"viewportUpdateMode", (PyCFunction)SbkQGraphicsViewFunc_viewportUpdateMode, METH_NOARGS},
    {"wheelEvent", (PyCFunction)SbkQGraphicsViewFunc_wheelEvent, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQGraphicsViewSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QGraphicsView* me = reinterpret_cast<QGraphicsView*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX]))
        return static_cast<QAbstractScrollArea*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QFRAME_IDX]))
        return static_cast<QFrame*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsView_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsView",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGraphicsViewWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsView_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsView_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQGraphicsViewSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

PyObject*
SbkPySide_QtGui_QGraphicsView_OptimizationFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsView::OptimizationFlags >::toPython(
        ((QGraphicsView::OptimizationFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QGraphicsView::OptimizationFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsView_OptimizationFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsView::OptimizationFlags >::toPython(
        ((QGraphicsView::OptimizationFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QGraphicsView::OptimizationFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsView_OptimizationFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsView::OptimizationFlags >::toPython(
        ((QGraphicsView::OptimizationFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QGraphicsView::OptimizationFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsView_OptimizationFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsView::OptimizationFlags >::toPython(
        ~ Shiboken::Converter< QGraphicsView::OptimizationFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QGraphicsView_OptimizationFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QGraphicsView_OptimizationFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QGraphicsView_OptimizationFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QGraphicsView_OptimizationFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QGraphicsView_OptimizationFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QGraphicsView_OptimizationFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsView_OptimizationFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "OptimizationFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QGraphicsView_OptimizationFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGraphicsView_OptimizationFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsView_OptimizationFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGraphicsView_OptimizationFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsView_OptimizationFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsView_OptimizationFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "OptimizationFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsView_OptimizationFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGraphicsView_OptimizationFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QGraphicsView_OptimizationFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QGraphicsView_ViewportAnchor_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsView_ViewportAnchor_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsView_ViewportAnchor_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ViewportAnchor",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGraphicsView_ViewportAnchor_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsView_ViewportAnchor_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGraphicsView_ViewportAnchor_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ViewportUpdateMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QGraphicsView_CacheModeFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsView::CacheMode >::toPython(
        ((QGraphicsView::CacheMode) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QGraphicsView::CacheMode >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsView_CacheModeFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsView::CacheMode >::toPython(
        ((QGraphicsView::CacheMode) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QGraphicsView::CacheMode >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsView_CacheModeFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsView::CacheMode >::toPython(
        ((QGraphicsView::CacheMode) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QGraphicsView::CacheMode >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsView_CacheModeFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsView::CacheMode >::toPython(
        ~ Shiboken::Converter< QGraphicsView::CacheMode >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QGraphicsView_CacheModeFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QGraphicsView_CacheModeFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QGraphicsView_CacheModeFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QGraphicsView_CacheModeFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QGraphicsView_CacheModeFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QGraphicsView_CacheModeFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsView_CacheModeFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsView_CacheModeFlag_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CacheModeFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QGraphicsView_CacheModeFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGraphicsView_CacheModeFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsView_CacheModeFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGraphicsView_CacheModeFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsView_CacheMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsView_CacheMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CacheMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QGraphicsView_CacheModeFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsView_CacheMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGraphicsView_CacheMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QGraphicsView_CacheMode_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QGraphicsView_DragMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsView_DragMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsView_DragMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DragMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGraphicsView_DragMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsView_DragMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGraphicsView_DragMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QGraphicsView(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsView_Type);

    SbkQGraphicsView_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX];
    SbkQGraphicsView_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQGraphicsView_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsView_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsView_Type));
    PyModule_AddObject(module, "QGraphicsView",
        ((PyObject*)&SbkQGraphicsView_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: OptimizationFlag
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_OPTIMIZATIONFLAG_IDX] = &SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Type);
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
            "OptimizationFlag",((PyObject*)&SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Type));

    // init flags class: QFlags<QGraphicsView::OptimizationFlag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSVIEW_OPTIMIZATIONFLAG__IDX] = &SbkPySide_QtGui_QGraphicsView_OptimizationFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsView_OptimizationFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsView_OptimizationFlags_Type);
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
            "OptimizationFlags",((PyObject*)&SbkPySide_QtGui_QGraphicsView_OptimizationFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Type,
        (long) QGraphicsView::DontClipPainter, "DontClipPainter");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "DontClipPainter", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Type.tp_dict,
        "DontClipPainter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Type,
        (long) QGraphicsView::DontSavePainterState, "DontSavePainterState");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "DontSavePainterState", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Type.tp_dict,
        "DontSavePainterState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Type,
        (long) QGraphicsView::DontAdjustForAntialiasing, "DontAdjustForAntialiasing");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "DontAdjustForAntialiasing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Type.tp_dict,
        "DontAdjustForAntialiasing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Type,
        (long) QGraphicsView::IndirectPainting, "IndirectPainting");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "IndirectPainting", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_OptimizationFlag_Type.tp_dict,
        "IndirectPainting", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGraphicsView::OptimizationFlag");

    // init enum class: ViewportAnchor
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_VIEWPORTANCHOR_IDX] = &SbkPySide_QtGui_QGraphicsView_ViewportAnchor_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsView_ViewportAnchor_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsView_ViewportAnchor_Type);
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
            "ViewportAnchor",((PyObject*)&SbkPySide_QtGui_QGraphicsView_ViewportAnchor_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_ViewportAnchor_Type,
        (long) QGraphicsView::NoAnchor, "NoAnchor");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "NoAnchor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_ViewportAnchor_Type.tp_dict,
        "NoAnchor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_ViewportAnchor_Type,
        (long) QGraphicsView::AnchorViewCenter, "AnchorViewCenter");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "AnchorViewCenter", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_ViewportAnchor_Type.tp_dict,
        "AnchorViewCenter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_ViewportAnchor_Type,
        (long) QGraphicsView::AnchorUnderMouse, "AnchorUnderMouse");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "AnchorUnderMouse", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_ViewportAnchor_Type.tp_dict,
        "AnchorUnderMouse", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGraphicsView::ViewportAnchor");

    // init enum class: ViewportUpdateMode
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_VIEWPORTUPDATEMODE_IDX] = &SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type);
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
            "ViewportUpdateMode",((PyObject*)&SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type,
        (long) QGraphicsView::FullViewportUpdate, "FullViewportUpdate");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "FullViewportUpdate", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type.tp_dict,
        "FullViewportUpdate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type,
        (long) QGraphicsView::MinimalViewportUpdate, "MinimalViewportUpdate");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "MinimalViewportUpdate", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type.tp_dict,
        "MinimalViewportUpdate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type,
        (long) QGraphicsView::SmartViewportUpdate, "SmartViewportUpdate");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "SmartViewportUpdate", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type.tp_dict,
        "SmartViewportUpdate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type,
        (long) QGraphicsView::NoViewportUpdate, "NoViewportUpdate");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "NoViewportUpdate", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type.tp_dict,
        "NoViewportUpdate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type,
        (long) QGraphicsView::BoundingRectViewportUpdate, "BoundingRectViewportUpdate");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "BoundingRectViewportUpdate", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_ViewportUpdateMode_Type.tp_dict,
        "BoundingRectViewportUpdate", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGraphicsView::ViewportUpdateMode");

    // init enum class: CacheModeFlag
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_CACHEMODEFLAG_IDX] = &SbkPySide_QtGui_QGraphicsView_CacheModeFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsView_CacheModeFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsView_CacheModeFlag_Type);
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
            "CacheModeFlag",((PyObject*)&SbkPySide_QtGui_QGraphicsView_CacheModeFlag_Type));

    // init flags class: QFlags<QGraphicsView::CacheModeFlag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSVIEW_CACHEMODEFLAG__IDX] = &SbkPySide_QtGui_QGraphicsView_CacheMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsView_CacheMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsView_CacheMode_Type);
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
            "CacheMode",((PyObject*)&SbkPySide_QtGui_QGraphicsView_CacheMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_CacheModeFlag_Type,
        (long) QGraphicsView::CacheNone, "CacheNone");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "CacheNone", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_CacheModeFlag_Type.tp_dict,
        "CacheNone", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_CacheModeFlag_Type,
        (long) QGraphicsView::CacheBackground, "CacheBackground");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "CacheBackground", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_CacheModeFlag_Type.tp_dict,
        "CacheBackground", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGraphicsView::CacheModeFlag");

    // init enum class: DragMode
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSVIEW_DRAGMODE_IDX] = &SbkPySide_QtGui_QGraphicsView_DragMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsView_DragMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsView_DragMode_Type);
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
            "DragMode",((PyObject*)&SbkPySide_QtGui_QGraphicsView_DragMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_DragMode_Type,
        (long) QGraphicsView::NoDrag, "NoDrag");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "NoDrag", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_DragMode_Type.tp_dict,
        "NoDrag", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_DragMode_Type,
        (long) QGraphicsView::ScrollHandDrag, "ScrollHandDrag");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "ScrollHandDrag", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_DragMode_Type.tp_dict,
        "ScrollHandDrag", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsView_DragMode_Type,
        (long) QGraphicsView::RubberBandDrag, "RubberBandDrag");
    PyDict_SetItemString(SbkQGraphicsView_Type.super.ht_type.tp_dict,
        "RubberBandDrag", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsView_DragMode_Type.tp_dict,
        "RubberBandDrag", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGraphicsView::DragMode");

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsView >("QGraphicsView*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsView >(typeid(QGraphicsView).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

