/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qgraphicsscenehoverevent_wrapper.h"

// Extra includes
#include <qpoint.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQGraphicsSceneHoverEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsSceneHoverEvent* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGraphicsSceneHoverEvent", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsSceneHoverEvent(QEvent::Type)
        cptr = new QGraphicsSceneHoverEvent();
    } else if (Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        // QGraphicsSceneHoverEvent(QEvent::Type)
        cptr = new QGraphicsSceneHoverEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneHoverEvent_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsSceneHoverEvent_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQGraphicsSceneHoverEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsSceneHoverEvent", overloads);
        return -1;
}

static PyObject*
SbkQGraphicsSceneHoverEventFunc_lastPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastPos()const
    QGraphicsSceneHoverEvent* cppSelf = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsSceneHoverEvent::lastPos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneHoverEventFunc_lastScenePos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastScenePos()const
    QGraphicsSceneHoverEvent* cppSelf = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsSceneHoverEvent::lastScenePos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneHoverEventFunc_lastScreenPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastScreenPos()const
    QGraphicsSceneHoverEvent* cppSelf = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QGraphicsSceneHoverEvent::lastScreenPos();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneHoverEventFunc_modifiers(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // modifiers()const
    QGraphicsSceneHoverEvent* cppSelf = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::KeyboardModifier> cpp_result = cppSelf->QGraphicsSceneHoverEvent::modifiers();
    py_result = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneHoverEventFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QGraphicsSceneHoverEvent* cppSelf = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsSceneHoverEvent::pos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneHoverEventFunc_scenePos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scenePos()const
    QGraphicsSceneHoverEvent* cppSelf = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QGraphicsSceneHoverEvent::scenePos();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneHoverEventFunc_screenPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // screenPos()const
    QGraphicsSceneHoverEvent* cppSelf = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QGraphicsSceneHoverEvent::screenPos();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneHoverEventFunc_setLastPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setLastPos(QPointF)
        QGraphicsSceneHoverEvent* cppSelf = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneHoverEvent::setLastPos(*cpp_arg0);
    } else goto SbkQGraphicsSceneHoverEventFunc_setLastPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneHoverEventFunc_setLastPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneHoverEvent.setLastPos", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneHoverEventFunc_setLastScenePos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setLastScenePos(QPointF)
        QGraphicsSceneHoverEvent* cppSelf = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneHoverEvent::setLastScenePos(*cpp_arg0);
    } else goto SbkQGraphicsSceneHoverEventFunc_setLastScenePos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneHoverEventFunc_setLastScenePos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneHoverEvent.setLastScenePos", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneHoverEventFunc_setLastScreenPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // setLastScreenPos(QPoint)
        QGraphicsSceneHoverEvent* cppSelf = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneHoverEvent::setLastScreenPos(*cpp_arg0);
    } else goto SbkQGraphicsSceneHoverEventFunc_setLastScreenPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneHoverEventFunc_setLastScreenPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneHoverEvent.setLastScreenPos", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneHoverEventFunc_setModifiers(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(arg)) {
        QFlags<Qt::KeyboardModifier> cpp_arg0 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(arg);
        // setModifiers(QFlags<Qt::KeyboardModifier>)
        QGraphicsSceneHoverEvent* cppSelf = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneHoverEvent::setModifiers(cpp_arg0);
    } else goto SbkQGraphicsSceneHoverEventFunc_setModifiers_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneHoverEventFunc_setModifiers_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.KeyboardModifiers", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneHoverEvent.setModifiers", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneHoverEventFunc_setPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setPos(QPointF)
        QGraphicsSceneHoverEvent* cppSelf = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneHoverEvent::setPos(*cpp_arg0);
    } else goto SbkQGraphicsSceneHoverEventFunc_setPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneHoverEventFunc_setPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneHoverEvent.setPos", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneHoverEventFunc_setScenePos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setScenePos(QPointF)
        QGraphicsSceneHoverEvent* cppSelf = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneHoverEvent::setScenePos(*cpp_arg0);
    } else goto SbkQGraphicsSceneHoverEventFunc_setScenePos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneHoverEventFunc_setScenePos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneHoverEvent.setScenePos", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneHoverEventFunc_setScreenPos(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // setScreenPos(QPoint)
        QGraphicsSceneHoverEvent* cppSelf = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneHoverEvent::setScreenPos(*cpp_arg0);
    } else goto SbkQGraphicsSceneHoverEventFunc_setScreenPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneHoverEventFunc_setScreenPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneHoverEvent.setScreenPos", overloads);
        return 0;
}

static PyMethodDef SbkQGraphicsSceneHoverEvent_methods[] = {
    {"lastPos", (PyCFunction)SbkQGraphicsSceneHoverEventFunc_lastPos, METH_NOARGS},
    {"lastScenePos", (PyCFunction)SbkQGraphicsSceneHoverEventFunc_lastScenePos, METH_NOARGS},
    {"lastScreenPos", (PyCFunction)SbkQGraphicsSceneHoverEventFunc_lastScreenPos, METH_NOARGS},
    {"modifiers", (PyCFunction)SbkQGraphicsSceneHoverEventFunc_modifiers, METH_NOARGS},
    {"pos", (PyCFunction)SbkQGraphicsSceneHoverEventFunc_pos, METH_NOARGS},
    {"scenePos", (PyCFunction)SbkQGraphicsSceneHoverEventFunc_scenePos, METH_NOARGS},
    {"screenPos", (PyCFunction)SbkQGraphicsSceneHoverEventFunc_screenPos, METH_NOARGS},
    {"setLastPos", (PyCFunction)SbkQGraphicsSceneHoverEventFunc_setLastPos, METH_O},
    {"setLastScenePos", (PyCFunction)SbkQGraphicsSceneHoverEventFunc_setLastScenePos, METH_O},
    {"setLastScreenPos", (PyCFunction)SbkQGraphicsSceneHoverEventFunc_setLastScreenPos, METH_O},
    {"setModifiers", (PyCFunction)SbkQGraphicsSceneHoverEventFunc_setModifiers, METH_O},
    {"setPos", (PyCFunction)SbkQGraphicsSceneHoverEventFunc_setPos, METH_O},
    {"setScenePos", (PyCFunction)SbkQGraphicsSceneHoverEventFunc_setScenePos, METH_O},
    {"setScreenPos", (PyCFunction)SbkQGraphicsSceneHoverEventFunc_setScreenPos, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsSceneHoverEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsSceneHoverEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGraphicsSceneHoverEvent >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsSceneHoverEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsSceneHoverEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QGraphicsSceneHoverEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEHOVEREVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsSceneHoverEvent_Type);

    SbkQGraphicsSceneHoverEvent_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEEVENT_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsSceneHoverEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsSceneHoverEvent_Type));
    PyModule_AddObject(module, "QGraphicsSceneHoverEvent",
        ((PyObject*)&SbkQGraphicsSceneHoverEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsSceneHoverEvent >("QGraphicsSceneHoverEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsSceneHoverEvent >(typeid(QGraphicsSceneHoverEvent).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

