/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qfontdatabase_wrapper.h"

// Extra includes
#include <QList>
#include <QStringList>
#include <qbytearray.h>
#include <qfont.h>
#include <qfontinfo.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

static int
SbkQFontDatabase_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFontDatabase* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QFontDatabase()
    cptr = new QFontDatabase();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQFontDatabaseFunc_addApplicationFont(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // addApplicationFont(QString)
        int cpp_result = QFontDatabase::addApplicationFont(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_addApplicationFont_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_addApplicationFont_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontDatabase.addApplicationFont", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_addApplicationFontFromData(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // addApplicationFontFromData(QByteArray)
        int cpp_result = QFontDatabase::addApplicationFontFromData(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_addApplicationFontFromData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_addApplicationFontFromData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontDatabase.addApplicationFontFromData", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_applicationFontFamilies(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // applicationFontFamilies(int)
        QStringList cpp_result = QFontDatabase::applicationFontFamilies(cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_applicationFontFamilies_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_applicationFontFamilies_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontDatabase.applicationFontFamilies", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_bold(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "bold", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // bold(QString,QString)const
        QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFontDatabase::bold(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_bold_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_bold_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontDatabase.bold", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_families(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // families(QFontDatabase::WritingSystem)const
        QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QFontDatabase::families();
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    } else if (Shiboken::Converter<QFontDatabase::WritingSystem >::isConvertible(arg)) {
        QFontDatabase::WritingSystem cpp_arg0 = Shiboken::Converter<QFontDatabase::WritingSystem >::toCpp(arg);
        // families(QFontDatabase::WritingSystem)const
        QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QFontDatabase::families(cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_families_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_families_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFontDatabase.WritingSystem = Any", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontDatabase.families", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_font(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "font", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // font(QString,QString,int)const
        QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
        QFont cpp_result = cppSelf->QFontDatabase::font(*cpp_arg0, *cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QFont >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_font_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_font_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontDatabase.font", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_isBitmapScalable(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isBitmapScalable", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // isBitmapScalable(QString,QString)const
            QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QFontDatabase::isBitmapScalable(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // isBitmapScalable(QString,QString)const
            QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QFontDatabase::isBitmapScalable(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQFontDatabaseFunc_isBitmapScalable_TypeError;
    } else goto SbkQFontDatabaseFunc_isBitmapScalable_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_isBitmapScalable_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontDatabase.isBitmapScalable", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_isFixedPitch(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isFixedPitch", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // isFixedPitch(QString,QString)const
            QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QFontDatabase::isFixedPitch(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // isFixedPitch(QString,QString)const
            QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QFontDatabase::isFixedPitch(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQFontDatabaseFunc_isFixedPitch_TypeError;
    } else goto SbkQFontDatabaseFunc_isFixedPitch_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_isFixedPitch_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontDatabase.isFixedPitch", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_isScalable(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isScalable", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // isScalable(QString,QString)const
            QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QFontDatabase::isScalable(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // isScalable(QString,QString)const
            QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QFontDatabase::isScalable(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQFontDatabaseFunc_isScalable_TypeError;
    } else goto SbkQFontDatabaseFunc_isScalable_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_isScalable_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontDatabase.isScalable", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_isSmoothlyScalable(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isSmoothlyScalable", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // isSmoothlyScalable(QString,QString)const
            QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QFontDatabase::isSmoothlyScalable(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // isSmoothlyScalable(QString,QString)const
            QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QFontDatabase::isSmoothlyScalable(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQFontDatabaseFunc_isSmoothlyScalable_TypeError;
    } else goto SbkQFontDatabaseFunc_isSmoothlyScalable_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_isSmoothlyScalable_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontDatabase.isSmoothlyScalable", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_italic(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "italic", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // italic(QString,QString)const
        QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFontDatabase::italic(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_italic_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_italic_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontDatabase.italic", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_pointSizes(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "pointSizes", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // pointSizes(QString,QString)
            QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
            QList<int > cpp_result = cppSelf->QFontDatabase::pointSizes(*cpp_arg0);
            py_result = Shiboken::Converter<QList<int > >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // pointSizes(QString,QString)
            QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
            QList<int > cpp_result = cppSelf->QFontDatabase::pointSizes(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QList<int > >::toPython(cpp_result);
        } else goto SbkQFontDatabaseFunc_pointSizes_TypeError;
    } else goto SbkQFontDatabaseFunc_pointSizes_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_pointSizes_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontDatabase.pointSizes", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_removeAllApplicationFonts(PyObject* self)
{
    PyObject* py_result = 0;

    // removeAllApplicationFonts()
    bool cpp_result = QFontDatabase::removeAllApplicationFonts();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFontDatabaseFunc_removeApplicationFont(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // removeApplicationFont(int)
        bool cpp_result = QFontDatabase::removeApplicationFont(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_removeApplicationFont_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_removeApplicationFont_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontDatabase.removeApplicationFont", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_smoothSizes(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "smoothSizes", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // smoothSizes(QString,QString)
        QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
        QList<int > cpp_result = cppSelf->QFontDatabase::smoothSizes(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QList<int > >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_smoothSizes_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_smoothSizes_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontDatabase.smoothSizes", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_standardSizes(PyObject* self)
{
    PyObject* py_result = 0;

    // standardSizes()
    QList<int > cpp_result = QFontDatabase::standardSizes();
    py_result = Shiboken::Converter<QList<int > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFontDatabaseFunc_styleString(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QFont& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!Shiboken::Converter<QFont& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // styleString(QFont)
        QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QFontDatabase::styleString(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (Shiboken::Converter<QFontInfo& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFontInfo > cpp_arg0_auto_ptr;
        QFontInfo* cpp_arg0 = Shiboken::Converter<QFontInfo* >::toCpp(arg);
        if (!Shiboken::Converter<QFontInfo& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFontInfo >(cpp_arg0);
        // styleString(QFontInfo)
        QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QFontDatabase::styleString(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_styleString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_styleString_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", "PySide.QtGui.QFontInfo", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontDatabase.styleString", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_styles(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // styles(QString)const
        QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QFontDatabase::styles(*cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_styles_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_styles_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontDatabase.styles", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_supportsThreadedFontRendering(PyObject* self)
{
    PyObject* py_result = 0;

    // supportsThreadedFontRendering()
    bool cpp_result = QFontDatabase::supportsThreadedFontRendering();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFontDatabaseFunc_weight(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "weight", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // weight(QString,QString)const
        QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QFontDatabase::weight(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_weight_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_weight_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontDatabase.weight", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_writingSystemName(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QFontDatabase::WritingSystem >::isConvertible(arg)) {
        QFontDatabase::WritingSystem cpp_arg0 = Shiboken::Converter<QFontDatabase::WritingSystem >::toCpp(arg);
        // writingSystemName(QFontDatabase::WritingSystem)
        QString cpp_result = QFontDatabase::writingSystemName(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_writingSystemName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_writingSystemName_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFontDatabase.WritingSystem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontDatabase.writingSystemName", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_writingSystemSample(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QFontDatabase::WritingSystem >::isConvertible(arg)) {
        QFontDatabase::WritingSystem cpp_arg0 = Shiboken::Converter<QFontDatabase::WritingSystem >::toCpp(arg);
        // writingSystemSample(QFontDatabase::WritingSystem)
        QString cpp_result = QFontDatabase::writingSystemSample(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_writingSystemSample_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_writingSystemSample_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFontDatabase.WritingSystem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontDatabase.writingSystemSample", overloads);
        return 0;
}

static PyObject*
SbkQFontDatabaseFunc_writingSystems(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // writingSystems()const
        QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
        QList<QFontDatabase::WritingSystem > cpp_result = cppSelf->QFontDatabase::writingSystems();
        py_result = Shiboken::Converter<QList<QFontDatabase::WritingSystem > >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // writingSystems(QString)const
        QFontDatabase* cppSelf = Shiboken::Converter<QFontDatabase* >::toCpp((PyObject*)self);
        QList<QFontDatabase::WritingSystem > cpp_result = cppSelf->QFontDatabase::writingSystems(*cpp_arg0);
        py_result = Shiboken::Converter<QList<QFontDatabase::WritingSystem > >::toPython(cpp_result);
    } else goto SbkQFontDatabaseFunc_writingSystems_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFontDatabaseFunc_writingSystems_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontDatabase.writingSystems", overloads);
        return 0;
}

static PyMethodDef SbkQFontDatabase_methods[] = {
    {"addApplicationFont", (PyCFunction)SbkQFontDatabaseFunc_addApplicationFont, METH_O|METH_STATIC},
    {"addApplicationFontFromData", (PyCFunction)SbkQFontDatabaseFunc_addApplicationFontFromData, METH_O|METH_STATIC},
    {"applicationFontFamilies", (PyCFunction)SbkQFontDatabaseFunc_applicationFontFamilies, METH_O|METH_STATIC},
    {"bold", (PyCFunction)SbkQFontDatabaseFunc_bold, METH_VARARGS},
    {"families", (PyCFunction)SbkQFontDatabaseFunc_families, METH_NOARGS|METH_O},
    {"font", (PyCFunction)SbkQFontDatabaseFunc_font, METH_VARARGS},
    {"isBitmapScalable", (PyCFunction)SbkQFontDatabaseFunc_isBitmapScalable, METH_VARARGS},
    {"isFixedPitch", (PyCFunction)SbkQFontDatabaseFunc_isFixedPitch, METH_VARARGS},
    {"isScalable", (PyCFunction)SbkQFontDatabaseFunc_isScalable, METH_VARARGS},
    {"isSmoothlyScalable", (PyCFunction)SbkQFontDatabaseFunc_isSmoothlyScalable, METH_VARARGS},
    {"italic", (PyCFunction)SbkQFontDatabaseFunc_italic, METH_VARARGS},
    {"pointSizes", (PyCFunction)SbkQFontDatabaseFunc_pointSizes, METH_VARARGS},
    {"removeAllApplicationFonts", (PyCFunction)SbkQFontDatabaseFunc_removeAllApplicationFonts, METH_NOARGS|METH_STATIC},
    {"removeApplicationFont", (PyCFunction)SbkQFontDatabaseFunc_removeApplicationFont, METH_O|METH_STATIC},
    {"smoothSizes", (PyCFunction)SbkQFontDatabaseFunc_smoothSizes, METH_VARARGS},
    {"standardSizes", (PyCFunction)SbkQFontDatabaseFunc_standardSizes, METH_NOARGS|METH_STATIC},
    {"styleString", (PyCFunction)SbkQFontDatabaseFunc_styleString, METH_O},
    {"styles", (PyCFunction)SbkQFontDatabaseFunc_styles, METH_O},
    {"supportsThreadedFontRendering", (PyCFunction)SbkQFontDatabaseFunc_supportsThreadedFontRendering, METH_NOARGS|METH_STATIC},
    {"weight", (PyCFunction)SbkQFontDatabaseFunc_weight, METH_VARARGS},
    {"writingSystemName", (PyCFunction)SbkQFontDatabaseFunc_writingSystemName, METH_O|METH_STATIC},
    {"writingSystemSample", (PyCFunction)SbkQFontDatabaseFunc_writingSystemSample, METH_O|METH_STATIC},
    {"writingSystems", (PyCFunction)SbkQFontDatabaseFunc_writingSystems, METH_NOARGS|METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFontDatabase_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QFontDatabase",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QFontDatabase >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFontDatabase_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFontDatabase_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QFontDatabase_WritingSystem_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFontDatabase_WritingSystem_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFontDatabase_WritingSystem_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WritingSystem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFontDatabase_WritingSystem_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFontDatabase_WritingSystem_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QFontDatabase_WritingSystem_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QFontDatabase(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QFONTDATABASE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFontDatabase_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQFontDatabase_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFontDatabase_Type));
    PyModule_AddObject(module, "QFontDatabase",
        ((PyObject*)&SbkQFontDatabase_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: WritingSystem
    SbkPySide_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX] = &SbkPySide_QtGui_QFontDatabase_WritingSystem_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type);
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
            "WritingSystem",((PyObject*)&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Any, "Any");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Any", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Any", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Latin, "Latin");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Latin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Latin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Greek, "Greek");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Greek", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Greek", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Cyrillic, "Cyrillic");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Cyrillic", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Cyrillic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Armenian, "Armenian");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Armenian", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Armenian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Hebrew, "Hebrew");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Hebrew", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Hebrew", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Arabic, "Arabic");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Arabic", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Arabic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Syriac, "Syriac");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Syriac", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Syriac", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Thaana, "Thaana");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Thaana", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Thaana", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Devanagari, "Devanagari");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Devanagari", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Devanagari", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Bengali, "Bengali");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Bengali", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Bengali", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Gurmukhi, "Gurmukhi");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Gurmukhi", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Gurmukhi", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Gujarati, "Gujarati");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Gujarati", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Gujarati", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Oriya, "Oriya");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Oriya", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Oriya", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Tamil, "Tamil");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Tamil", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Tamil", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Telugu, "Telugu");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Telugu", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Telugu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Kannada, "Kannada");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Kannada", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Kannada", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Malayalam, "Malayalam");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Malayalam", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Malayalam", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Sinhala, "Sinhala");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Sinhala", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Sinhala", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Thai, "Thai");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Thai", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Thai", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Lao, "Lao");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Lao", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Lao", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Tibetan, "Tibetan");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Tibetan", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Tibetan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Myanmar, "Myanmar");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Myanmar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Myanmar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Georgian, "Georgian");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Georgian", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Georgian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Khmer, "Khmer");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Khmer", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Khmer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::SimplifiedChinese, "SimplifiedChinese");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "SimplifiedChinese", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "SimplifiedChinese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::TraditionalChinese, "TraditionalChinese");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "TraditionalChinese", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "TraditionalChinese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Japanese, "Japanese");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Japanese", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Japanese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Korean, "Korean");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Korean", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Korean", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Vietnamese, "Vietnamese");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Vietnamese", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Vietnamese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Symbol, "Symbol");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Symbol", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Symbol", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Other, "Other");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Other", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Other", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Ogham, "Ogham");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Ogham", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Ogham", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Runic, "Runic");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Runic", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Runic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::Nko, "Nko");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "Nko", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "Nko", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFontDatabase_WritingSystem_Type,
        (long) QFontDatabase::WritingSystemsCount, "WritingSystemsCount");
    PyDict_SetItemString(SbkQFontDatabase_Type.super.ht_type.tp_dict,
        "WritingSystemsCount", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFontDatabase_WritingSystem_Type.tp_dict,
        "WritingSystemsCount", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFontDatabase::WritingSystem");

    Shiboken::TypeResolver::createValueTypeResolver<QFontDatabase >("QFontDatabase");
    Shiboken::TypeResolver::createValueTypeResolver<QFontDatabase >(typeid(QFontDatabase).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

