/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qfileiconprovider_wrapper.h"

// Extra includes
#include <qfileiconprovider.h>
#include <qfileinfo.h>
#include <qicon.h>
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QFileIconProviderWrapper::QFileIconProviderWrapper() : QFileIconProvider() {
    // ... middle
}

QIcon QFileIconProviderWrapper::icon(QFileIconProvider::IconType type) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "icon"));
    if (py_override.isNull()) {
        return this->QFileIconProvider::icon(type);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFileIconProvider::IconType >::toPython(type)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QIcon();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QIcon >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileIconProvider.icon");
        return QIcon()        ;
    }
    QIcon cpp_result(Shiboken::Converter<QIcon >::toCpp(py_result));
    return cpp_result;
}

QIcon QFileIconProviderWrapper::icon(const QFileInfo & info) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "icon"));
    if (py_override.isNull()) {
        return this->QFileIconProvider::icon(info);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFileInfo& >::toPython(info)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QIcon();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QIcon >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileIconProvider.icon");
        return QIcon()        ;
    }
    QIcon cpp_result(Shiboken::Converter<QIcon >::toCpp(py_result));
    return cpp_result;
}

QString QFileIconProviderWrapper::type(const QFileInfo & info) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "type"));
    if (py_override.isNull()) {
        return this->QFileIconProvider::type(info);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFileInfo& >::toPython(info)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileIconProvider.type");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

QFileIconProviderWrapper::~QFileIconProviderWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQFileIconProvider_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFileIconProviderWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QFileIconProvider()
    cptr = new QFileIconProviderWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQFileIconProviderFunc_icon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QFileInfo& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFileInfo > cpp_arg0_auto_ptr;
        QFileInfo* cpp_arg0 = Shiboken::Converter<QFileInfo* >::toCpp(arg);
        if (!Shiboken::Converter<QFileInfo& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFileInfo >(cpp_arg0);
        // icon(QFileInfo)const
        QFileIconProvider* cppSelf = Shiboken::Converter<QFileIconProvider* >::toCpp((PyObject*)self);
        QIcon cpp_result = cppSelf->QFileIconProvider::icon(*cpp_arg0);
        py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
    } else if (Shiboken::Converter<QFileIconProvider::IconType >::isConvertible(arg)) {
        QFileIconProvider::IconType cpp_arg0 = Shiboken::Converter<QFileIconProvider::IconType >::toCpp(arg);
        // icon(QFileIconProvider::IconType)const
        QFileIconProvider* cppSelf = Shiboken::Converter<QFileIconProvider* >::toCpp((PyObject*)self);
        QIcon cpp_result = cppSelf->QFileIconProvider::icon(cpp_arg0);
        py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
    } else goto SbkQFileIconProviderFunc_icon_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFileIconProviderFunc_icon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFileIconProvider.IconType", "PySide.QtCore.QFileInfo", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileIconProvider.icon", overloads);
        return 0;
}

static PyObject*
SbkQFileIconProviderFunc_type(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QFileInfo& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFileInfo > cpp_arg0_auto_ptr;
        QFileInfo* cpp_arg0 = Shiboken::Converter<QFileInfo* >::toCpp(arg);
        if (!Shiboken::Converter<QFileInfo& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFileInfo >(cpp_arg0);
        // type(QFileInfo)const
        QFileIconProvider* cppSelf = Shiboken::Converter<QFileIconProvider* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QFileIconProvider::type(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQFileIconProviderFunc_type_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFileIconProviderFunc_type_TypeError:
        const char* overloads[] = {"PySide.QtCore.QFileInfo", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileIconProvider.type", overloads);
        return 0;
}

static PyMethodDef SbkQFileIconProvider_methods[] = {
    {"icon", (PyCFunction)SbkQFileIconProviderFunc_icon, METH_O},
    {"type", (PyCFunction)SbkQFileIconProviderFunc_type, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFileIconProvider_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QFileIconProvider",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QFileIconProviderWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFileIconProvider_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFileIconProvider_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQFileIconProvider_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQFileIconProvider_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QFileIconProvider*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtGui_QFileIconProvider_IconType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFileIconProvider_IconType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFileIconProvider_IconType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "IconType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFileIconProvider_IconType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFileIconProvider_IconType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QFileIconProvider_IconType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QFileIconProvider(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QFILEICONPROVIDER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFileIconProvider_Type);

    // Fill type discovery information
    SbkQFileIconProvider_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQFileIconProvider_Type.type_discovery->addTypeDiscoveryFunction(&SbkQFileIconProvider_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQFileIconProvider_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFileIconProvider_Type));
    PyModule_AddObject(module, "QFileIconProvider",
        ((PyObject*)&SbkQFileIconProvider_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: IconType
    SbkPySide_QtGuiTypes[SBK_QFILEICONPROVIDER_ICONTYPE_IDX] = &SbkPySide_QtGui_QFileIconProvider_IconType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFileIconProvider_IconType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFileIconProvider_IconType_Type);
    PyDict_SetItemString(SbkQFileIconProvider_Type.super.ht_type.tp_dict,
            "IconType",((PyObject*)&SbkPySide_QtGui_QFileIconProvider_IconType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileIconProvider_IconType_Type,
        (long) QFileIconProvider::Computer, "Computer");
    PyDict_SetItemString(SbkQFileIconProvider_Type.super.ht_type.tp_dict,
        "Computer", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileIconProvider_IconType_Type.tp_dict,
        "Computer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileIconProvider_IconType_Type,
        (long) QFileIconProvider::Desktop, "Desktop");
    PyDict_SetItemString(SbkQFileIconProvider_Type.super.ht_type.tp_dict,
        "Desktop", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileIconProvider_IconType_Type.tp_dict,
        "Desktop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileIconProvider_IconType_Type,
        (long) QFileIconProvider::Trashcan, "Trashcan");
    PyDict_SetItemString(SbkQFileIconProvider_Type.super.ht_type.tp_dict,
        "Trashcan", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileIconProvider_IconType_Type.tp_dict,
        "Trashcan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileIconProvider_IconType_Type,
        (long) QFileIconProvider::Network, "Network");
    PyDict_SetItemString(SbkQFileIconProvider_Type.super.ht_type.tp_dict,
        "Network", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileIconProvider_IconType_Type.tp_dict,
        "Network", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileIconProvider_IconType_Type,
        (long) QFileIconProvider::Drive, "Drive");
    PyDict_SetItemString(SbkQFileIconProvider_Type.super.ht_type.tp_dict,
        "Drive", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileIconProvider_IconType_Type.tp_dict,
        "Drive", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileIconProvider_IconType_Type,
        (long) QFileIconProvider::Folder, "Folder");
    PyDict_SetItemString(SbkQFileIconProvider_Type.super.ht_type.tp_dict,
        "Folder", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileIconProvider_IconType_Type.tp_dict,
        "Folder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileIconProvider_IconType_Type,
        (long) QFileIconProvider::File, "File");
    PyDict_SetItemString(SbkQFileIconProvider_Type.super.ht_type.tp_dict,
        "File", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileIconProvider_IconType_Type.tp_dict,
        "File", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFileIconProvider::IconType");

    Shiboken::TypeResolver::createObjectTypeResolver<QFileIconProvider >("QFileIconProvider*");
    Shiboken::TypeResolver::createObjectTypeResolver<QFileIconProvider >(typeid(QFileIconProvider).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

