/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qclipboard_wrapper.h"

// Extra includes
#include <QImage>
#include <QList>
#include <QPixmap>
#include <qbytearray.h>
#include <qclipboard.h>
#include <qcoreevent.h>
#include <qimage.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

static PyObject*
SbkQClipboardFunc_clear(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // clear(QClipboard::Mode)
        QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
        cppSelf->QClipboard::clear();
    } else if (Shiboken::Converter<QClipboard::Mode >::isConvertible(arg)) {
        QClipboard::Mode cpp_arg0 = Shiboken::Converter<QClipboard::Mode >::toCpp(arg);
        // clear(QClipboard::Mode)
        QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
        cppSelf->QClipboard::clear(cpp_arg0);
    } else goto SbkQClipboardFunc_clear_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQClipboardFunc_clear_TypeError:
        const char* overloads[] = {"PySide.QtGui.QClipboard.Mode = Clipboard", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QClipboard.clear", overloads);
        return 0;
}

static PyObject*
SbkQClipboardFunc_connectNotify(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // connectNotify(const char*)
        QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
        cppSelf->QClipboard::connectNotify(cpp_arg0);
    } else goto SbkQClipboardFunc_connectNotify_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQClipboardFunc_connectNotify_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QClipboard.connectNotify", overloads);
        return 0;
}

static PyObject*
SbkQClipboardFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QClipboard::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQClipboardFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQClipboardFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QClipboard.event", overloads);
        return 0;
}

static PyObject*
SbkQClipboardFunc_image(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // image(QClipboard::Mode)const
        QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
        QImage cpp_result = cppSelf->QClipboard::image();
        py_result = Shiboken::Converter<QImage >::toPython(cpp_result);
    } else if (Shiboken::Converter<QClipboard::Mode >::isConvertible(arg)) {
        QClipboard::Mode cpp_arg0 = Shiboken::Converter<QClipboard::Mode >::toCpp(arg);
        // image(QClipboard::Mode)const
        QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
        QImage cpp_result = cppSelf->QClipboard::image(cpp_arg0);
        py_result = Shiboken::Converter<QImage >::toPython(cpp_result);
    } else goto SbkQClipboardFunc_image_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQClipboardFunc_image_TypeError:
        const char* overloads[] = {"PySide.QtGui.QClipboard.Mode = Clipboard", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QClipboard.image", overloads);
        return 0;
}

static PyObject*
SbkQClipboardFunc_mimeData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // mimeData(QClipboard::Mode)const
        QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
        const QMimeData * cpp_result = cppSelf->QClipboard::mimeData();
        py_result = Shiboken::Converter<QMimeData* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (Shiboken::Converter<QClipboard::Mode >::isConvertible(arg)) {
        QClipboard::Mode cpp_arg0 = Shiboken::Converter<QClipboard::Mode >::toCpp(arg);
        // mimeData(QClipboard::Mode)const
        QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
        const QMimeData * cpp_result = cppSelf->QClipboard::mimeData(cpp_arg0);
        py_result = Shiboken::Converter<QMimeData* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQClipboardFunc_mimeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQClipboardFunc_mimeData_TypeError:
        const char* overloads[] = {"PySide.QtGui.QClipboard.Mode = Clipboard", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QClipboard.mimeData", overloads);
        return 0;
}

static PyObject*
SbkQClipboardFunc_ownsClipboard(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ownsClipboard()const
    QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QClipboard::ownsClipboard();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQClipboardFunc_ownsFindBuffer(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ownsFindBuffer()const
    QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QClipboard::ownsFindBuffer();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQClipboardFunc_ownsSelection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ownsSelection()const
    QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QClipboard::ownsSelection();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQClipboardFunc_pixmap(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // pixmap(QClipboard::Mode)const
        QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
        QPixmap cpp_result = cppSelf->QClipboard::pixmap();
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
    } else if (Shiboken::Converter<QClipboard::Mode >::isConvertible(arg)) {
        QClipboard::Mode cpp_arg0 = Shiboken::Converter<QClipboard::Mode >::toCpp(arg);
        // pixmap(QClipboard::Mode)const
        QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
        QPixmap cpp_result = cppSelf->QClipboard::pixmap(cpp_arg0);
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
    } else goto SbkQClipboardFunc_pixmap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQClipboardFunc_pixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QClipboard.Mode = Clipboard", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QClipboard.pixmap", overloads);
        return 0;
}

static PyObject*
SbkQClipboardFunc_setImage(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setImage", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QImage& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QImage* cpp_arg0 = Shiboken::Converter<QImage* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setImage(QImage,QClipboard::Mode)
            QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
            cppSelf->QClipboard::setImage(*cpp_arg0);
        } else if (Shiboken::Converter<QClipboard::Mode >::isConvertible(pyargs[1])) {
            QClipboard::Mode cpp_arg1 = Shiboken::Converter<QClipboard::Mode >::toCpp(pyargs[1]);
            // setImage(QImage,QClipboard::Mode)
            QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
            cppSelf->QClipboard::setImage(*cpp_arg0, cpp_arg1);
        } else goto SbkQClipboardFunc_setImage_TypeError;
    } else goto SbkQClipboardFunc_setImage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQClipboardFunc_setImage_TypeError:
        const char* overloads[] = {"PySide.QtGui.QImage, PySide.QtGui.QClipboard.Mode = Clipboard", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QClipboard.setImage", overloads);
        return 0;
}

static PyObject*
SbkQClipboardFunc_setMimeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setMimeData", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QMimeData* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMimeData* cpp_arg0 = Shiboken::Converter<QMimeData* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setMimeData(QMimeData*,QClipboard::Mode)
            QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
            cppSelf->QClipboard::setMimeData(cpp_arg0);
            Shiboken::setParent(self, pyargs[0]);
        } else if (Shiboken::Converter<QClipboard::Mode >::isConvertible(pyargs[1])) {
            QClipboard::Mode cpp_arg1 = Shiboken::Converter<QClipboard::Mode >::toCpp(pyargs[1]);
            // setMimeData(QMimeData*,QClipboard::Mode)
            QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
            cppSelf->QClipboard::setMimeData(cpp_arg0, cpp_arg1);
            Shiboken::setParent(self, pyargs[0]);
        } else goto SbkQClipboardFunc_setMimeData_TypeError;
    } else goto SbkQClipboardFunc_setMimeData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQClipboardFunc_setMimeData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMimeData, PySide.QtGui.QClipboard.Mode = Clipboard", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QClipboard.setMimeData", overloads);
        return 0;
}

static PyObject*
SbkQClipboardFunc_setPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPixmap", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QPixmap& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        if (numArgs == 1) {
            // setPixmap(QPixmap,QClipboard::Mode)
            QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
            cppSelf->QClipboard::setPixmap(*cpp_arg0);
        } else if (Shiboken::Converter<QClipboard::Mode >::isConvertible(pyargs[1])) {
            QClipboard::Mode cpp_arg1 = Shiboken::Converter<QClipboard::Mode >::toCpp(pyargs[1]);
            // setPixmap(QPixmap,QClipboard::Mode)
            QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
            cppSelf->QClipboard::setPixmap(*cpp_arg0, cpp_arg1);
        } else goto SbkQClipboardFunc_setPixmap_TypeError;
    } else goto SbkQClipboardFunc_setPixmap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQClipboardFunc_setPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPixmap, PySide.QtGui.QClipboard.Mode = Clipboard", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QClipboard.setPixmap", overloads);
        return 0;
}

static PyObject*
SbkQClipboardFunc_setText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setText", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setText(QString,QClipboard::Mode)
            QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
            cppSelf->QClipboard::setText(*cpp_arg0);
        } else if (Shiboken::Converter<QClipboard::Mode >::isConvertible(pyargs[1])) {
            QClipboard::Mode cpp_arg1 = Shiboken::Converter<QClipboard::Mode >::toCpp(pyargs[1]);
            // setText(QString,QClipboard::Mode)
            QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
            cppSelf->QClipboard::setText(*cpp_arg0, cpp_arg1);
        } else goto SbkQClipboardFunc_setText_TypeError;
    } else goto SbkQClipboardFunc_setText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQClipboardFunc_setText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtGui.QClipboard.Mode = Clipboard", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QClipboard.setText", overloads);
        return 0;
}

static PyObject*
SbkQClipboardFunc_supportsFindBuffer(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportsFindBuffer()const
    QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QClipboard::supportsFindBuffer();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQClipboardFunc_supportsSelection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportsSelection()const
    QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QClipboard::supportsSelection();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQClipboardFunc_text(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // text(QClipboard::Mode)const
        QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QClipboard::text();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (Shiboken::Converter<QClipboard::Mode >::isConvertible(arg)) {
        QClipboard::Mode cpp_arg0 = Shiboken::Converter<QClipboard::Mode >::toCpp(arg);
        // text(QClipboard::Mode)const
        QClipboard* cppSelf = Shiboken::Converter<QClipboard* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QClipboard::text(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQClipboardFunc_text_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQClipboardFunc_text_TypeError:
        const char* overloads[] = {"PySide.QtGui.QClipboard.Mode = Clipboard", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QClipboard.text", overloads);
        return 0;
}

static PyMethodDef SbkQClipboard_methods[] = {
    {"clear", (PyCFunction)SbkQClipboardFunc_clear, METH_NOARGS|METH_O},
    {"connectNotify", (PyCFunction)SbkQClipboardFunc_connectNotify, METH_O},
    {"event", (PyCFunction)SbkQClipboardFunc_event, METH_O},
    {"image", (PyCFunction)SbkQClipboardFunc_image, METH_NOARGS|METH_O},
    {"mimeData", (PyCFunction)SbkQClipboardFunc_mimeData, METH_NOARGS|METH_O},
    {"ownsClipboard", (PyCFunction)SbkQClipboardFunc_ownsClipboard, METH_NOARGS},
    {"ownsFindBuffer", (PyCFunction)SbkQClipboardFunc_ownsFindBuffer, METH_NOARGS},
    {"ownsSelection", (PyCFunction)SbkQClipboardFunc_ownsSelection, METH_NOARGS},
    {"pixmap", (PyCFunction)SbkQClipboardFunc_pixmap, METH_NOARGS|METH_O},
    {"setImage", (PyCFunction)SbkQClipboardFunc_setImage, METH_VARARGS},
    {"setMimeData", (PyCFunction)SbkQClipboardFunc_setMimeData, METH_VARARGS},
    {"setPixmap", (PyCFunction)SbkQClipboardFunc_setPixmap, METH_VARARGS},
    {"setText", (PyCFunction)SbkQClipboardFunc_setText, METH_VARARGS},
    {"supportsFindBuffer", (PyCFunction)SbkQClipboardFunc_supportsFindBuffer, METH_NOARGS},
    {"supportsSelection", (PyCFunction)SbkQClipboardFunc_supportsSelection, METH_NOARGS},
    {"text", (PyCFunction)SbkQClipboardFunc_text, METH_NOARGS|METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQClipboard_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QClipboard",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          Shiboken::SbkBaseWrapper_Dealloc_PrivateDtor,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQClipboard_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QClipboard_Mode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QClipboard_Mode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QClipboard_Mode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Mode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QClipboard_Mode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QClipboard_Mode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QClipboard_Mode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QClipboard(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QCLIPBOARD_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQClipboard_Type);

    SbkQClipboard_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQClipboard_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQClipboard_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQClipboard_Type));
    PyModule_AddObject(module, "QClipboard",
        ((PyObject*)&SbkQClipboard_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Mode
    SbkPySide_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX] = &SbkPySide_QtGui_QClipboard_Mode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QClipboard_Mode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QClipboard_Mode_Type);
    PyDict_SetItemString(SbkQClipboard_Type.super.ht_type.tp_dict,
            "Mode",((PyObject*)&SbkPySide_QtGui_QClipboard_Mode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QClipboard_Mode_Type,
        (long) QClipboard::Clipboard, "Clipboard");
    PyDict_SetItemString(SbkQClipboard_Type.super.ht_type.tp_dict,
        "Clipboard", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QClipboard_Mode_Type.tp_dict,
        "Clipboard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QClipboard_Mode_Type,
        (long) QClipboard::Selection, "Selection");
    PyDict_SetItemString(SbkQClipboard_Type.super.ht_type.tp_dict,
        "Selection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QClipboard_Mode_Type.tp_dict,
        "Selection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QClipboard_Mode_Type,
        (long) QClipboard::FindBuffer, "FindBuffer");
    PyDict_SetItemString(SbkQClipboard_Type.super.ht_type.tp_dict,
        "FindBuffer", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QClipboard_Mode_Type.tp_dict,
        "FindBuffer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QClipboard_Mode_Type,
        (long) QClipboard::LastMode, "LastMode");
    PyDict_SetItemString(SbkQClipboard_Type.super.ht_type.tp_dict,
        "LastMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QClipboard_Mode_Type.tp_dict,
        "LastMode", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QClipboard::Mode");

    Shiboken::TypeResolver::createObjectTypeResolver<QClipboard >("QClipboard*");
    Shiboken::TypeResolver::createObjectTypeResolver<QClipboard >(typeid(QClipboard).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

