/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qbrush_wrapper.h"

// Extra includes
#include <QPixmap>
#include <qbrush.h>
#include <qcolor.h>
#include <qdatastream.h>
#include <qimage.h>
#include <qmatrix.h>
#include <qpixmap.h>
#include <qtransform.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQBrush_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QBrush* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QBrush", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QBrush()
        cptr = new QBrush();
    } else if (numArgs == 1 && Shiboken::Converter<QPixmap& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        // QBrush(QPixmap)
        cptr = new QBrush(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QImage& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QImage* cpp_arg0 = Shiboken::Converter<QImage* >::toCpp(pyargs[0]);
        // QBrush(QImage)
        cptr = new QBrush(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QGradient& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QGradient* cpp_arg0 = Shiboken::Converter<QGradient* >::toCpp(pyargs[0]);
        // QBrush(QGradient)
        cptr = new QBrush(*cpp_arg0);
    } else if (Shiboken::Converter<Qt::GlobalColor >::isConvertible(pyargs[0])) {
        Qt::GlobalColor cpp_arg0 = Shiboken::Converter<Qt::GlobalColor >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QBrush(Qt::GlobalColor,Qt::BrushStyle)
            cptr = new QBrush(cpp_arg0);
        } else if (numArgs == 2 && Shiboken::Converter<QPixmap& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
            QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
            // QBrush(Qt::GlobalColor,QPixmap)
            cptr = new QBrush(cpp_arg0, *cpp_arg1);
        } else if (Shiboken::Converter<Qt::BrushStyle >::isConvertible(pyargs[1])) {
            Qt::BrushStyle cpp_arg1 = Shiboken::Converter<Qt::BrushStyle >::toCpp(pyargs[1]);
            // QBrush(Qt::GlobalColor,Qt::BrushStyle)
            cptr = new QBrush(cpp_arg0, cpp_arg1);
        } else goto SbkQBrush_Init_TypeError;
    } else if (Shiboken::Converter<QColor& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QColor& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        if (numArgs == 1) {
            // QBrush(QColor,Qt::BrushStyle)
            cptr = new QBrush(*cpp_arg0);
        } else if (numArgs == 2 && Shiboken::Converter<QPixmap& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
            QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
            // QBrush(QColor,QPixmap)
            cptr = new QBrush(*cpp_arg0, *cpp_arg1);
        } else if (Shiboken::Converter<Qt::BrushStyle >::isConvertible(pyargs[1])) {
            Qt::BrushStyle cpp_arg1 = Shiboken::Converter<Qt::BrushStyle >::toCpp(pyargs[1]);
            // QBrush(QColor,Qt::BrushStyle)
            cptr = new QBrush(*cpp_arg0, cpp_arg1);
        } else goto SbkQBrush_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<Qt::BrushStyle >::isConvertible(pyargs[0])) {
        Qt::BrushStyle cpp_arg0 = Shiboken::Converter<Qt::BrushStyle >::toCpp(pyargs[0]);
        // QBrush(Qt::BrushStyle)
        cptr = new QBrush(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QBrush& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // QBrush(QBrush)
        cptr = new QBrush(*cpp_arg0);
    } else goto SbkQBrush_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQBrush_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQBrush_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.Qt.BrushStyle", "PySide.QtCore.Qt.GlobalColor, PySide.QtCore.Qt.BrushStyle = Qt.SolidPattern", "PySide.QtCore.Qt.GlobalColor, PySide.QtGui.QPixmap", "PySide.QtGui.QBrush", "PySide.QtGui.QColor, PySide.QtCore.Qt.BrushStyle = Qt.SolidPattern", "PySide.QtGui.QColor, PySide.QtGui.QPixmap", "PySide.QtGui.QGradient", "PySide.QtGui.QImage", "PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QBrush", overloads);
        return -1;
}

static PyObject*
SbkQBrushFunc_color(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // color()const
    QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
    const QColor & cpp_result = cppSelf->QBrush::color();
    py_result = Shiboken::Converter<QColor& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBrushFunc_gradient(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // gradient()const
    QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
    const QGradient * cpp_result = cppSelf->QBrush::gradient();
    py_result = Shiboken::Converter<QGradient* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBrushFunc_isOpaque(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isOpaque()const
    QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QBrush::isOpaque();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBrushFunc_matrix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // matrix()const
    QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
    const QMatrix & cpp_result = cppSelf->QBrush::matrix();
    py_result = Shiboken::Converter<QMatrix& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBrushFunc_setColor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::GlobalColor >::isConvertible(arg)) {
        Qt::GlobalColor cpp_arg0 = Shiboken::Converter<Qt::GlobalColor >::toCpp(arg);
        // setColor(Qt::GlobalColor)
        QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
        cppSelf->QBrush::setColor(cpp_arg0);
    } else if (Shiboken::Converter<QColor& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(arg);
        if (!Shiboken::Converter<QColor& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // setColor(QColor)
        QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
        cppSelf->QBrush::setColor(*cpp_arg0);
    } else goto SbkQBrushFunc_setColor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBrushFunc_setColor_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.GlobalColor", "PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBrush.setColor", overloads);
        return 0;
}

static PyObject*
SbkQBrushFunc_setMatrix(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMatrix& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(arg);
        // setMatrix(QMatrix)
        QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
        cppSelf->QBrush::setMatrix(*cpp_arg0);
    } else goto SbkQBrushFunc_setMatrix_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBrushFunc_setMatrix_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBrush.setMatrix", overloads);
        return 0;
}

static PyObject*
SbkQBrushFunc_setStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::BrushStyle >::isConvertible(arg)) {
        Qt::BrushStyle cpp_arg0 = Shiboken::Converter<Qt::BrushStyle >::toCpp(arg);
        // setStyle(Qt::BrushStyle)
        QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
        cppSelf->QBrush::setStyle(cpp_arg0);
    } else goto SbkQBrushFunc_setStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBrushFunc_setStyle_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.BrushStyle", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBrush.setStyle", overloads);
        return 0;
}

static PyObject*
SbkQBrushFunc_setTexture(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPixmap& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(arg);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        // setTexture(QPixmap)
        QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
        cppSelf->QBrush::setTexture(*cpp_arg0);
    } else goto SbkQBrushFunc_setTexture_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBrushFunc_setTexture_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBrush.setTexture", overloads);
        return 0;
}

static PyObject*
SbkQBrushFunc_setTextureImage(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QImage& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QImage* cpp_arg0 = Shiboken::Converter<QImage* >::toCpp(arg);
        // setTextureImage(QImage)
        QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
        cppSelf->QBrush::setTextureImage(*cpp_arg0);
    } else goto SbkQBrushFunc_setTextureImage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBrushFunc_setTextureImage_TypeError:
        const char* overloads[] = {"PySide.QtGui.QImage", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBrush.setTextureImage", overloads);
        return 0;
}

static PyObject*
SbkQBrushFunc_setTransform(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTransform& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(arg);
        // setTransform(QTransform)
        QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
        cppSelf->QBrush::setTransform(*cpp_arg0);
    } else goto SbkQBrushFunc_setTransform_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQBrushFunc_setTransform_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBrush.setTransform", overloads);
        return 0;
}

static PyObject*
SbkQBrushFunc_style(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // style()const
    QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
    Qt::BrushStyle cpp_result = cppSelf->QBrush::style();
    py_result = Shiboken::Converter<Qt::BrushStyle >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBrushFunc_texture(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // texture()const
    QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
    QPixmap cpp_result = cppSelf->QBrush::texture();
    py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBrushFunc_textureImage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textureImage()const
    QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
    QImage cpp_result = cppSelf->QBrush::textureImage();
    py_result = Shiboken::Converter<QImage >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQBrushFunc_transform(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // transform()const
    QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
    QTransform cpp_result = cppSelf->QBrush::transform();
    py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQBrush_methods[] = {
    {"color", (PyCFunction)SbkQBrushFunc_color, METH_NOARGS},
    {"gradient", (PyCFunction)SbkQBrushFunc_gradient, METH_NOARGS},
    {"isOpaque", (PyCFunction)SbkQBrushFunc_isOpaque, METH_NOARGS},
    {"matrix", (PyCFunction)SbkQBrushFunc_matrix, METH_NOARGS},
    {"setColor", (PyCFunction)SbkQBrushFunc_setColor, METH_O},
    {"setMatrix", (PyCFunction)SbkQBrushFunc_setMatrix, METH_O},
    {"setStyle", (PyCFunction)SbkQBrushFunc_setStyle, METH_O},
    {"setTexture", (PyCFunction)SbkQBrushFunc_setTexture, METH_O},
    {"setTextureImage", (PyCFunction)SbkQBrushFunc_setTextureImage, METH_O},
    {"setTransform", (PyCFunction)SbkQBrushFunc_setTransform, METH_O},
    {"style", (PyCFunction)SbkQBrushFunc_style, METH_NOARGS},
    {"texture", (PyCFunction)SbkQBrushFunc_texture, METH_NOARGS},
    {"textureImage", (PyCFunction)SbkQBrushFunc_textureImage, METH_NOARGS},
    {"transform", (PyCFunction)SbkQBrushFunc_transform, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQBrushFunc___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQBrush_Check(arg) && !SbkQBrush_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QBrush) [reverse operator]
        QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQBrushFunc___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQBrushFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBrush.__lshift__", overloads);
        return 0;
}

static PyObject*
SbkQBrushFunc___rshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQBrush_Check(arg) && !SbkQBrush_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rrshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QBrush&) [reverse operator]
        QBrush* cppSelf = Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQBrushFunc___rshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQBrushFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBrush.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQBrush_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQBrushFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQBrushFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQBrush_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QBrush& cpp_self = *Shiboken::Converter<QBrush* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QBrush& >::isConvertible(other)) {
                QBrush* cpp_other = Shiboken::Converter<QBrush* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QBrush >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QBrush > cpp_other_auto_ptr;
                QBrush* cpp_other = Shiboken::Converter<QBrush* >::toCpp(other);
                if (!Shiboken::Converter<QBrush >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QBrush >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQBrush_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QBrush& >::isConvertible(other)) {
                QBrush* cpp_other = Shiboken::Converter<QBrush* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QBrush >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QBrush > cpp_other_auto_ptr;
                QBrush* cpp_other = Shiboken::Converter<QBrush* >::toCpp(other);
                if (!Shiboken::Converter<QBrush >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QBrush >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQBrush_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQBrush_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQBrush_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QBrush",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QBrush >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQBrush_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQBrush_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQBrush_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQBrush_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QBrush(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QBRUSH_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQBrush_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQBrush_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQBrush_Type));
    PyModule_AddObject(module, "QBrush",
        ((PyObject*)&SbkQBrush_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QBrush >("QBrush");
    Shiboken::TypeResolver::createValueTypeResolver<QBrush >(typeid(QBrush).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

