/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qabstracttextdocumentlayout_wrapper.h"
#include "qabstracttextdocumentlayout_selection_wrapper.h"
#include "qabstracttextdocumentlayout_paintcontext_wrapper.h"

// Extra includes
#include <QAbstractTextDocumentLayout>
#include <QList>
#include <qabstracttextdocumentlayout.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpainter.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#include <qtextdocument.h>
#include <qtextformat.h>
#include <qtextlayout.h>
#include <qtextobject.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractTextDocumentLayoutWrapper::QAbstractTextDocumentLayoutWrapper(QTextDocument * doc) : QAbstractTextDocumentLayout(doc), m_metaObject(0) {
    // ... middle
}

QRectF QAbstractTextDocumentLayoutWrapper::blockBoundingRect(const QTextBlock & block) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "blockBoundingRect"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTextDocumentLayout.blockBoundingRect()' not implemented.");
        return QRectF();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTextBlock& >::toPython(block)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRectF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRectF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractTextDocumentLayout.blockBoundingRect");
        return QRectF()        ;
    }
    QRectF cpp_result(Shiboken::Converter<QRectF >::toCpp(py_result));
    return cpp_result;
}

void QAbstractTextDocumentLayoutWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractTextDocumentLayoutWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractTextDocumentLayoutWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractTextDocumentLayoutWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractTextDocumentLayoutWrapper::documentChanged(int from, int charsRemoved, int charsAdded)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "documentChanged"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTextDocumentLayout.documentChanged()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iii)",
        from,
        charsRemoved,
        charsAdded
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSizeF QAbstractTextDocumentLayoutWrapper::documentSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "documentSize"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTextDocumentLayout.documentSize()' not implemented.");
        return QSizeF();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSizeF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSizeF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractTextDocumentLayout.documentSize");
        return QSizeF()        ;
    }
    QSizeF cpp_result(Shiboken::Converter<QSizeF >::toCpp(py_result));
    return cpp_result;
}

void QAbstractTextDocumentLayoutWrapper::draw(QPainter * painter, const QAbstractTextDocumentLayout::PaintContext & context)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "draw"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTextDocumentLayout.draw()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext& >::toPython(context)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractTextDocumentLayoutWrapper::drawInlineObject(QPainter * painter, const QRectF & rect, QTextInlineObject object, int posInDocument, const QTextFormat & format)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawInlineObject"));
    if (py_override.isNull()) {
        return this->QAbstractTextDocumentLayout::drawInlineObject(painter, rect, object, posInDocument, format);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOiO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRectF& >::toPython(rect),
        Shiboken::Converter<QTextInlineObject >::toPython(object),
        posInDocument,
        Shiboken::Converter<QTextFormat& >::toPython(format)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QAbstractTextDocumentLayoutWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractTextDocumentLayout.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QAbstractTextDocumentLayoutWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractTextDocumentLayout.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

QRectF QAbstractTextDocumentLayoutWrapper::frameBoundingRect(QTextFrame * frame) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "frameBoundingRect"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTextDocumentLayout.frameBoundingRect()' not implemented.");
        return QRectF();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTextFrame* >::toPython(frame)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRectF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRectF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractTextDocumentLayout.frameBoundingRect");
        return QRectF()        ;
    }
    QRectF cpp_result(Shiboken::Converter<QRectF >::toCpp(py_result));
    return cpp_result;
}

int QAbstractTextDocumentLayoutWrapper::hitTest(const QPointF & point, Qt::HitTestAccuracy accuracy) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hitTest"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTextDocumentLayout.hitTest()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QPointF& >::toPython(point),
        Shiboken::Converter<Qt::HitTestAccuracy >::toPython(accuracy)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractTextDocumentLayout.hitTest");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QAbstractTextDocumentLayoutWrapper::pageCount() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pageCount"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTextDocumentLayout.pageCount()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractTextDocumentLayout.pageCount");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QAbstractTextDocumentLayoutWrapper::positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat & format)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "positionInlineObject"));
    if (py_override.isNull()) {
        return this->QAbstractTextDocumentLayout::positionInlineObject(item, posInDocument, format);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OiO)",
        Shiboken::Converter<QTextInlineObject >::toPython(item),
        posInDocument,
        Shiboken::Converter<QTextFormat& >::toPython(format)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractTextDocumentLayoutWrapper::resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat & format)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeInlineObject"));
    if (py_override.isNull()) {
        return this->QAbstractTextDocumentLayout::resizeInlineObject(item, posInDocument, format);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OiO)",
        Shiboken::Converter<QTextInlineObject >::toPython(item),
        posInDocument,
        Shiboken::Converter<QTextFormat& >::toPython(format)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractTextDocumentLayoutWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QAbstractTextDocumentLayoutWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAbstractTextDocumentLayout::staticMetaObject);
}
    return m_metaObject;
}

int QAbstractTextDocumentLayoutWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAbstractTextDocumentLayout::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAbstractTextDocumentLayoutWrapper::~QAbstractTextDocumentLayoutWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAbstractTextDocumentLayout_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractTextDocumentLayoutWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractTextDocumentLayout' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAbstractTextDocumentLayout", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QTextDocument* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextDocument* cpp_arg0 = Shiboken::Converter<QTextDocument* >::toCpp(pyargs[0]);
        // QAbstractTextDocumentLayout(QTextDocument*)
        cptr = new QAbstractTextDocumentLayoutWrapper(cpp_arg0);
    } else goto SbkQAbstractTextDocumentLayout_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractTextDocumentLayout_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQAbstractTextDocumentLayout_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextDocument", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractTextDocumentLayout", overloads);
        return -1;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_anchorAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // anchorAt(QPointF)const
        QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QAbstractTextDocumentLayout::anchorAt(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQAbstractTextDocumentLayoutFunc_anchorAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractTextDocumentLayoutFunc_anchorAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractTextDocumentLayout.anchorAt", overloads);
        return 0;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_blockBoundingRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextBlock& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextBlock* cpp_arg0 = Shiboken::Converter<QTextBlock* >::toCpp(arg);
        // blockBoundingRect(QTextBlock)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTextDocumentLayout.blockBoundingRect()' not implemented.");
            return 0;
        }
        QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->blockBoundingRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    } else goto SbkQAbstractTextDocumentLayoutFunc_blockBoundingRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractTextDocumentLayoutFunc_blockBoundingRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextBlock", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractTextDocumentLayout.blockBoundingRect", overloads);
        return 0;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_document(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // document()const
    QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
    QTextDocument * cpp_result = cppSelf->QAbstractTextDocumentLayout::document();
    py_result = Shiboken::Converter<QTextDocument* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_documentChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "documentChanged", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // documentChanged(int,int,int)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTextDocumentLayout.documentChanged()' not implemented.");
            return 0;
        }
        QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
        cppSelf->documentChanged(cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQAbstractTextDocumentLayoutFunc_documentChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractTextDocumentLayoutFunc_documentChanged_TypeError:
        const char* overloads[] = {"int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractTextDocumentLayout.documentChanged", overloads);
        return 0;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_documentSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentSize()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTextDocumentLayout.documentSize()' not implemented.");
        return 0;
    }
    QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
    QSizeF cpp_result = cppSelf->documentSize();
    py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_draw(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "draw", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAbstractTextDocumentLayout::PaintContext* cpp_arg1 = Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext* >::toCpp(pyargs[1]);
        // draw(QPainter*,QAbstractTextDocumentLayout::PaintContext)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTextDocumentLayout.draw()' not implemented.");
            return 0;
        }
        QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
        cppSelf->draw(cpp_arg0, *cpp_arg1);
    } else goto SbkQAbstractTextDocumentLayoutFunc_draw_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractTextDocumentLayoutFunc_draw_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QAbstractTextDocumentLayout::PaintContext", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractTextDocumentLayout.draw", overloads);
        return 0;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_drawInlineObject(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawInlineObject", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (numArgs == 5 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QRectF& >::isConvertible(pyargs[1]) && Shiboken::Converter<QTextInlineObject >::isConvertible(pyargs[2]) && PyNumber_Check(pyargs[3]) && Shiboken::Converter<QTextFormat& >::isConvertible(pyargs[4])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg1_auto_ptr;
        QRectF* cpp_arg1 = Shiboken::Converter<QRectF* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QRectF >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QTextInlineObject* cpp_arg2 = Shiboken::Converter<QTextInlineObject* >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
            return 0;
        QTextFormat* cpp_arg4 = Shiboken::Converter<QTextFormat* >::toCpp(pyargs[4]);
        // drawInlineObject(QPainter*,QRectF,QTextInlineObject,int,QTextFormat)
        QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
        cppSelf->QAbstractTextDocumentLayout::drawInlineObject(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3, *cpp_arg4);
    } else goto SbkQAbstractTextDocumentLayoutFunc_drawInlineObject_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractTextDocumentLayoutFunc_drawInlineObject_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRectF, PySide.QtGui.QTextInlineObject, int, PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractTextDocumentLayout.drawInlineObject", overloads);
        return 0;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_format(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // format(int)
        QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
        QTextCharFormat cpp_result = cppSelf->QAbstractTextDocumentLayout::format(cpp_arg0);
        py_result = Shiboken::Converter<QTextCharFormat >::toPython(cpp_result);
    } else goto SbkQAbstractTextDocumentLayoutFunc_format_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractTextDocumentLayoutFunc_format_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractTextDocumentLayout.format", overloads);
        return 0;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_formatIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // formatIndex(int)
        QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QAbstractTextDocumentLayout::formatIndex(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQAbstractTextDocumentLayoutFunc_formatIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractTextDocumentLayoutFunc_formatIndex_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractTextDocumentLayout.formatIndex", overloads);
        return 0;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_frameBoundingRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextFrame* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextFrame* cpp_arg0 = Shiboken::Converter<QTextFrame* >::toCpp(arg);
        // frameBoundingRect(QTextFrame*)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTextDocumentLayout.frameBoundingRect()' not implemented.");
            return 0;
        }
        QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->frameBoundingRect(cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    } else goto SbkQAbstractTextDocumentLayoutFunc_frameBoundingRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractTextDocumentLayoutFunc_frameBoundingRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextFrame", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractTextDocumentLayout.frameBoundingRect", overloads);
        return 0;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_handlerForObject(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // handlerForObject(int)const
        QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
        QTextObjectInterface * cpp_result = cppSelf->QAbstractTextDocumentLayout::handlerForObject(cpp_arg0);
        py_result = Shiboken::Converter<QTextObjectInterface* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQAbstractTextDocumentLayoutFunc_handlerForObject_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractTextDocumentLayoutFunc_handlerForObject_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractTextDocumentLayout.handlerForObject", overloads);
        return 0;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_hitTest(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "hitTest", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::HitTestAccuracy >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        Qt::HitTestAccuracy cpp_arg1 = Shiboken::Converter<Qt::HitTestAccuracy >::toCpp(pyargs[1]);
        // hitTest(QPointF,Qt::HitTestAccuracy)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTextDocumentLayout.hitTest()' not implemented.");
            return 0;
        }
        QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->hitTest(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQAbstractTextDocumentLayoutFunc_hitTest_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractTextDocumentLayoutFunc_hitTest_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, PySide.QtCore.Qt.HitTestAccuracy", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractTextDocumentLayout.hitTest", overloads);
        return 0;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_pageCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pageCount()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTextDocumentLayout.pageCount()' not implemented.");
        return 0;
    }
    QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->pageCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_paintDevice(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // paintDevice()const
    QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
    QPaintDevice * cpp_result = cppSelf->QAbstractTextDocumentLayout::paintDevice();
    py_result = Shiboken::Converter<QPaintDevice* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_positionInlineObject(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "positionInlineObject", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QTextInlineObject >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QTextFormat& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTextInlineObject* cpp_arg0 = Shiboken::Converter<QTextInlineObject* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QTextFormat* cpp_arg2 = Shiboken::Converter<QTextFormat* >::toCpp(pyargs[2]);
        // positionInlineObject(QTextInlineObject,int,QTextFormat)
        QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
        cppSelf->QAbstractTextDocumentLayout::positionInlineObject(*cpp_arg0, cpp_arg1, *cpp_arg2);
    } else goto SbkQAbstractTextDocumentLayoutFunc_positionInlineObject_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractTextDocumentLayoutFunc_positionInlineObject_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextInlineObject, int, PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractTextDocumentLayout.positionInlineObject", overloads);
        return 0;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_registerHandler(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "registerHandler", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QObject* >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
        // registerHandler(int,QObject*)
        QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
        cppSelf->QAbstractTextDocumentLayout::registerHandler(cpp_arg0, cpp_arg1);
    } else goto SbkQAbstractTextDocumentLayoutFunc_registerHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractTextDocumentLayoutFunc_registerHandler_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractTextDocumentLayout.registerHandler", overloads);
        return 0;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_resizeInlineObject(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "resizeInlineObject", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QTextInlineObject >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QTextFormat& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTextInlineObject* cpp_arg0 = Shiboken::Converter<QTextInlineObject* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QTextFormat* cpp_arg2 = Shiboken::Converter<QTextFormat* >::toCpp(pyargs[2]);
        // resizeInlineObject(QTextInlineObject,int,QTextFormat)
        QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
        cppSelf->QAbstractTextDocumentLayout::resizeInlineObject(*cpp_arg0, cpp_arg1, *cpp_arg2);
    } else goto SbkQAbstractTextDocumentLayoutFunc_resizeInlineObject_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractTextDocumentLayoutFunc_resizeInlineObject_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextInlineObject, int, PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractTextDocumentLayout.resizeInlineObject", overloads);
        return 0;
}

static PyObject*
SbkQAbstractTextDocumentLayoutFunc_setPaintDevice(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintDevice* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintDevice* cpp_arg0 = Shiboken::Converter<QPaintDevice* >::toCpp(arg);
        // setPaintDevice(QPaintDevice*)
        QAbstractTextDocumentLayout* cppSelf = Shiboken::Converter<QAbstractTextDocumentLayout* >::toCpp((PyObject*)self);
        cppSelf->QAbstractTextDocumentLayout::setPaintDevice(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQAbstractTextDocumentLayoutFunc_setPaintDevice_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractTextDocumentLayoutFunc_setPaintDevice_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractTextDocumentLayout.setPaintDevice", overloads);
        return 0;
}

static PyMethodDef SbkQAbstractTextDocumentLayout_methods[] = {
    {"anchorAt", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_anchorAt, METH_O},
    {"blockBoundingRect", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_blockBoundingRect, METH_O},
    {"document", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_document, METH_NOARGS},
    {"documentChanged", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_documentChanged, METH_VARARGS},
    {"documentSize", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_documentSize, METH_NOARGS},
    {"draw", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_draw, METH_VARARGS},
    {"drawInlineObject", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_drawInlineObject, METH_VARARGS},
    {"format", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_format, METH_O},
    {"formatIndex", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_formatIndex, METH_O},
    {"frameBoundingRect", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_frameBoundingRect, METH_O},
    {"handlerForObject", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_handlerForObject, METH_O},
    {"hitTest", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_hitTest, METH_VARARGS},
    {"pageCount", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_pageCount, METH_NOARGS},
    {"paintDevice", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_paintDevice, METH_NOARGS},
    {"positionInlineObject", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_positionInlineObject, METH_VARARGS},
    {"registerHandler", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_registerHandler, METH_VARARGS},
    {"resizeInlineObject", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_resizeInlineObject, METH_VARARGS},
    {"setPaintDevice", (PyCFunction)SbkQAbstractTextDocumentLayoutFunc_setPaintDevice, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractTextDocumentLayout_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QAbstractTextDocumentLayout",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QAbstractTextDocumentLayoutWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractTextDocumentLayout_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractTextDocumentLayout_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QAbstractTextDocumentLayout_Selection(PyObject*);
PyAPI_FUNC(void)
init_QAbstractTextDocumentLayout_PaintContext(PyObject*);
PyAPI_FUNC(void)
init_QAbstractTextDocumentLayout(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractTextDocumentLayout_Type);

    SbkQAbstractTextDocumentLayout_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQAbstractTextDocumentLayout_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractTextDocumentLayout_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractTextDocumentLayout_Type));
    PyModule_AddObject(module, "QAbstractTextDocumentLayout",
        ((PyObject*)&SbkQAbstractTextDocumentLayout_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractTextDocumentLayout >("QAbstractTextDocumentLayout*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractTextDocumentLayout >(typeid(QAbstractTextDocumentLayout).name());
    init_QAbstractTextDocumentLayout_Selection(SbkQAbstractTextDocumentLayout_Type.super.ht_type.tp_dict);
    init_QAbstractTextDocumentLayout_PaintContext(SbkQAbstractTextDocumentLayout_Type.super.ht_type.tp_dict);
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

