/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qabstractslider_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractslider.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractSliderWrapper::QAbstractSliderWrapper(QWidget * parent) : QAbstractSlider(parent), m_metaObject(0) {
    // ... middle
}

void QAbstractSliderWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QActionEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::changeEvent(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSlider::changeEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSliderWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSliderWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSliderWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QWidget::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QContextMenuEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QAbstractSliderWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSlider.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSliderWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSliderWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragEnterEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragLeaveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDropEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QAbstractSliderWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QAbstractSlider::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSlider.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractSliderWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSlider.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSliderWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QAbstractSliderWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSlider.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSliderWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QAbstractSliderWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSlider.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSliderWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QAbstractSliderWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSlider.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSliderWrapper::keyPressEvent(QKeyEvent * ev)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSlider::keyPressEvent(ev);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(ev)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSliderWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSliderWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QAbstractSliderWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSlider.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QAbstractSliderWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QWidget::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSlider.minimumSizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSliderWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QAbstractSliderWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSlider.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QAbstractSliderWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QWidget::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::resizeEvent(QResizeEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QResizeEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSliderWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QAbstractSliderWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QWidget::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSlider.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSliderWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTabletEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSliderWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSlider::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSliderWrapper::wheelEvent(QWheelEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSlider::wheelEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWheelEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QAbstractSliderWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAbstractSlider::staticMetaObject);
}
    return m_metaObject;
}

int QAbstractSliderWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAbstractSlider::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAbstractSliderWrapper::~QAbstractSliderWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAbstractSlider_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractSliderWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAbstractSlider", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QAbstractSlider(QWidget*)
        cptr = new QAbstractSliderWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QAbstractSlider(QWidget*)
        cptr = new QAbstractSliderWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQAbstractSlider_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractSlider_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQAbstractSlider_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractSlider", overloads);
        return -1;
}

static PyObject*
SbkQAbstractSliderFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::changeEvent(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.changeEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractSlider::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQAbstractSliderFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractSliderFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.event", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_hasTracking(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasTracking()const
    QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSlider::hasTracking();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSliderFunc_invertedAppearance(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // invertedAppearance()const
    QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSlider::invertedAppearance();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSliderFunc_invertedControls(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // invertedControls()const
    QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSlider::invertedControls();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSliderFunc_isSliderDown(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSliderDown()const
    QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSlider::isSliderDown();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSliderFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::keyPressEvent(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.keyPressEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_maximum(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximum()const
    QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractSlider::maximum();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSliderFunc_minimum(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimum()const
    QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractSlider::minimum();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSliderFunc_orientation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // orientation()const
    QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
    Qt::Orientation cpp_result = cppSelf->QAbstractSlider::orientation();
    py_result = Shiboken::Converter<Qt::Orientation >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSliderFunc_pageStep(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pageStep()const
    QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractSlider::pageStep();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSliderFunc_repeatAction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // repeatAction()const
    QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
    QAbstractSlider::SliderAction cpp_result = cppSelf->QAbstractSlider::repeatAction();
    py_result = Shiboken::Converter<QAbstractSlider::SliderAction >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSliderFunc_setInvertedAppearance(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setInvertedAppearance(bool)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::setInvertedAppearance(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_setInvertedAppearance_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_setInvertedAppearance_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.setInvertedAppearance", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_setInvertedControls(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setInvertedControls(bool)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::setInvertedControls(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_setInvertedControls_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_setInvertedControls_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.setInvertedControls", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_setMaximum(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMaximum(int)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::setMaximum(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_setMaximum_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_setMaximum_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.setMaximum", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_setMinimum(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMinimum(int)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::setMinimum(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_setMinimum_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_setMinimum_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.setMinimum", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_setOrientation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::Orientation >::isConvertible(arg)) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(arg);
        // setOrientation(Qt::Orientation)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::setOrientation(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_setOrientation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_setOrientation_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.setOrientation", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_setPageStep(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setPageStep(int)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::setPageStep(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_setPageStep_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_setPageStep_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.setPageStep", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_setRange(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRange", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setRange(int,int)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::setRange(cpp_arg0, cpp_arg1);
    } else goto SbkQAbstractSliderFunc_setRange_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_setRange_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractSlider.setRange", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_setRepeatAction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setRepeatAction", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QAbstractSlider::SliderAction >::isConvertible(pyargs[0])) {
        QAbstractSlider::SliderAction cpp_arg0 = Shiboken::Converter<QAbstractSlider::SliderAction >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setRepeatAction(QAbstractSlider::SliderAction,int,int)
            QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
            cppSelf->QAbstractSlider::setRepeatAction(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setRepeatAction(QAbstractSlider::SliderAction,int,int)
                QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
                cppSelf->QAbstractSlider::setRepeatAction(cpp_arg0, cpp_arg1);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // setRepeatAction(QAbstractSlider::SliderAction,int,int)
                QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
                cppSelf->QAbstractSlider::setRepeatAction(cpp_arg0, cpp_arg1, cpp_arg2);
            } else goto SbkQAbstractSliderFunc_setRepeatAction_TypeError;
        } else goto SbkQAbstractSliderFunc_setRepeatAction_TypeError;
    } else goto SbkQAbstractSliderFunc_setRepeatAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_setRepeatAction_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractSlider.SliderAction, int = 500, int = 50", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractSlider.setRepeatAction", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_setSingleStep(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSingleStep(int)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::setSingleStep(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_setSingleStep_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_setSingleStep_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.setSingleStep", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_setSliderDown(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSliderDown(bool)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::setSliderDown(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_setSliderDown_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_setSliderDown_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.setSliderDown", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_setSliderPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSliderPosition(int)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::setSliderPosition(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_setSliderPosition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_setSliderPosition_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.setSliderPosition", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_setTracking(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setTracking(bool)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::setTracking(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_setTracking_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_setTracking_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.setTracking", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_setValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setValue(int)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::setValue(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_setValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_setValue_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.setValue", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_singleStep(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // singleStep()const
    QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractSlider::singleStep();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSliderFunc_sliderPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sliderPosition()const
    QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractSlider::sliderPosition();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSliderFunc_timerEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimerEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTimerEvent* cpp_arg0 = Shiboken::Converter<QTimerEvent* >::toCpp(arg);
        // timerEvent(QTimerEvent*)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::timerEvent(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_timerEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_timerEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimerEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.timerEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_triggerAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractSlider::SliderAction >::isConvertible(arg)) {
        QAbstractSlider::SliderAction cpp_arg0 = Shiboken::Converter<QAbstractSlider::SliderAction >::toCpp(arg);
        // triggerAction(QAbstractSlider::SliderAction)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::triggerAction(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_triggerAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_triggerAction_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractSlider.SliderAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.triggerAction", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSliderFunc_value(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // value()const
    QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractSlider::value();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSliderFunc_wheelEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWheelEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWheelEvent* cpp_arg0 = Shiboken::Converter<QWheelEvent* >::toCpp(arg);
        // wheelEvent(QWheelEvent*)
        QAbstractSlider* cppSelf = Shiboken::Converter<QAbstractSlider* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSlider::wheelEvent(cpp_arg0);
    } else goto SbkQAbstractSliderFunc_wheelEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSliderFunc_wheelEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWheelEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSlider.wheelEvent", overloads);
        return 0;
}

static PyMethodDef SbkQAbstractSlider_methods[] = {
    {"changeEvent", (PyCFunction)SbkQAbstractSliderFunc_changeEvent, METH_O},
    {"event", (PyCFunction)SbkQAbstractSliderFunc_event, METH_O},
    {"hasTracking", (PyCFunction)SbkQAbstractSliderFunc_hasTracking, METH_NOARGS},
    {"invertedAppearance", (PyCFunction)SbkQAbstractSliderFunc_invertedAppearance, METH_NOARGS},
    {"invertedControls", (PyCFunction)SbkQAbstractSliderFunc_invertedControls, METH_NOARGS},
    {"isSliderDown", (PyCFunction)SbkQAbstractSliderFunc_isSliderDown, METH_NOARGS},
    {"keyPressEvent", (PyCFunction)SbkQAbstractSliderFunc_keyPressEvent, METH_O},
    {"maximum", (PyCFunction)SbkQAbstractSliderFunc_maximum, METH_NOARGS},
    {"minimum", (PyCFunction)SbkQAbstractSliderFunc_minimum, METH_NOARGS},
    {"orientation", (PyCFunction)SbkQAbstractSliderFunc_orientation, METH_NOARGS},
    {"pageStep", (PyCFunction)SbkQAbstractSliderFunc_pageStep, METH_NOARGS},
    {"repeatAction", (PyCFunction)SbkQAbstractSliderFunc_repeatAction, METH_NOARGS},
    {"setInvertedAppearance", (PyCFunction)SbkQAbstractSliderFunc_setInvertedAppearance, METH_O},
    {"setInvertedControls", (PyCFunction)SbkQAbstractSliderFunc_setInvertedControls, METH_O},
    {"setMaximum", (PyCFunction)SbkQAbstractSliderFunc_setMaximum, METH_O},
    {"setMinimum", (PyCFunction)SbkQAbstractSliderFunc_setMinimum, METH_O},
    {"setOrientation", (PyCFunction)SbkQAbstractSliderFunc_setOrientation, METH_O},
    {"setPageStep", (PyCFunction)SbkQAbstractSliderFunc_setPageStep, METH_O},
    {"setRange", (PyCFunction)SbkQAbstractSliderFunc_setRange, METH_VARARGS},
    {"setRepeatAction", (PyCFunction)SbkQAbstractSliderFunc_setRepeatAction, METH_VARARGS},
    {"setSingleStep", (PyCFunction)SbkQAbstractSliderFunc_setSingleStep, METH_O},
    {"setSliderDown", (PyCFunction)SbkQAbstractSliderFunc_setSliderDown, METH_O},
    {"setSliderPosition", (PyCFunction)SbkQAbstractSliderFunc_setSliderPosition, METH_O},
    {"setTracking", (PyCFunction)SbkQAbstractSliderFunc_setTracking, METH_O},
    {"setValue", (PyCFunction)SbkQAbstractSliderFunc_setValue, METH_O},
    {"singleStep", (PyCFunction)SbkQAbstractSliderFunc_singleStep, METH_NOARGS},
    {"sliderPosition", (PyCFunction)SbkQAbstractSliderFunc_sliderPosition, METH_NOARGS},
    {"timerEvent", (PyCFunction)SbkQAbstractSliderFunc_timerEvent, METH_O},
    {"triggerAction", (PyCFunction)SbkQAbstractSliderFunc_triggerAction, METH_O},
    {"value", (PyCFunction)SbkQAbstractSliderFunc_value, METH_NOARGS},
    {"wheelEvent", (PyCFunction)SbkQAbstractSliderFunc_wheelEvent, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQAbstractSliderSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QAbstractSlider* me = reinterpret_cast<QAbstractSlider*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractSlider_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QAbstractSlider",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QAbstractSliderWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractSlider_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractSlider_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQAbstractSliderSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QAbstractSlider_SliderAction_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractSlider_SliderAction_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractSlider_SliderAction_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SliderAction",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractSlider_SliderAction_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractSlider_SliderAction_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractSlider_SliderAction_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QAbstractSlider_SliderChange_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractSlider_SliderChange_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractSlider_SliderChange_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SliderChange",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractSlider_SliderChange_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractSlider_SliderChange_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractSlider_SliderChange_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QAbstractSlider(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QABSTRACTSLIDER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractSlider_Type);

    SbkQAbstractSlider_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX];
    SbkQAbstractSlider_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQAbstractSlider_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractSlider_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractSlider_Type));
    PyModule_AddObject(module, "QAbstractSlider",
        ((PyObject*)&SbkQAbstractSlider_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SliderAction
    SbkPySide_QtGuiTypes[SBK_QABSTRACTSLIDER_SLIDERACTION_IDX] = &SbkPySide_QtGui_QAbstractSlider_SliderAction_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractSlider_SliderAction_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractSlider_SliderAction_Type);
    PyDict_SetItemString(SbkQAbstractSlider_Type.super.ht_type.tp_dict,
            "SliderAction",((PyObject*)&SbkPySide_QtGui_QAbstractSlider_SliderAction_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSlider_SliderAction_Type,
        (long) QAbstractSlider::SliderNoAction, "SliderNoAction");
    PyDict_SetItemString(SbkQAbstractSlider_Type.super.ht_type.tp_dict,
        "SliderNoAction", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSlider_SliderAction_Type.tp_dict,
        "SliderNoAction", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSlider_SliderAction_Type,
        (long) QAbstractSlider::SliderSingleStepAdd, "SliderSingleStepAdd");
    PyDict_SetItemString(SbkQAbstractSlider_Type.super.ht_type.tp_dict,
        "SliderSingleStepAdd", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSlider_SliderAction_Type.tp_dict,
        "SliderSingleStepAdd", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSlider_SliderAction_Type,
        (long) QAbstractSlider::SliderSingleStepSub, "SliderSingleStepSub");
    PyDict_SetItemString(SbkQAbstractSlider_Type.super.ht_type.tp_dict,
        "SliderSingleStepSub", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSlider_SliderAction_Type.tp_dict,
        "SliderSingleStepSub", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSlider_SliderAction_Type,
        (long) QAbstractSlider::SliderPageStepAdd, "SliderPageStepAdd");
    PyDict_SetItemString(SbkQAbstractSlider_Type.super.ht_type.tp_dict,
        "SliderPageStepAdd", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSlider_SliderAction_Type.tp_dict,
        "SliderPageStepAdd", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSlider_SliderAction_Type,
        (long) QAbstractSlider::SliderPageStepSub, "SliderPageStepSub");
    PyDict_SetItemString(SbkQAbstractSlider_Type.super.ht_type.tp_dict,
        "SliderPageStepSub", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSlider_SliderAction_Type.tp_dict,
        "SliderPageStepSub", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSlider_SliderAction_Type,
        (long) QAbstractSlider::SliderToMinimum, "SliderToMinimum");
    PyDict_SetItemString(SbkQAbstractSlider_Type.super.ht_type.tp_dict,
        "SliderToMinimum", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSlider_SliderAction_Type.tp_dict,
        "SliderToMinimum", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSlider_SliderAction_Type,
        (long) QAbstractSlider::SliderToMaximum, "SliderToMaximum");
    PyDict_SetItemString(SbkQAbstractSlider_Type.super.ht_type.tp_dict,
        "SliderToMaximum", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSlider_SliderAction_Type.tp_dict,
        "SliderToMaximum", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSlider_SliderAction_Type,
        (long) QAbstractSlider::SliderMove, "SliderMove");
    PyDict_SetItemString(SbkQAbstractSlider_Type.super.ht_type.tp_dict,
        "SliderMove", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSlider_SliderAction_Type.tp_dict,
        "SliderMove", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractSlider::SliderAction");

    // init enum class: SliderChange
    SbkPySide_QtGuiTypes[SBK_QABSTRACTSLIDER_SLIDERCHANGE_IDX] = &SbkPySide_QtGui_QAbstractSlider_SliderChange_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractSlider_SliderChange_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractSlider_SliderChange_Type);
    PyDict_SetItemString(SbkQAbstractSlider_Type.super.ht_type.tp_dict,
            "SliderChange",((PyObject*)&SbkPySide_QtGui_QAbstractSlider_SliderChange_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSlider_SliderChange_Type,
        (long) QAbstractSlider::SliderRangeChange, "SliderRangeChange");
    PyDict_SetItemString(SbkQAbstractSlider_Type.super.ht_type.tp_dict,
        "SliderRangeChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSlider_SliderChange_Type.tp_dict,
        "SliderRangeChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSlider_SliderChange_Type,
        (long) QAbstractSlider::SliderOrientationChange, "SliderOrientationChange");
    PyDict_SetItemString(SbkQAbstractSlider_Type.super.ht_type.tp_dict,
        "SliderOrientationChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSlider_SliderChange_Type.tp_dict,
        "SliderOrientationChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSlider_SliderChange_Type,
        (long) QAbstractSlider::SliderStepsChange, "SliderStepsChange");
    PyDict_SetItemString(SbkQAbstractSlider_Type.super.ht_type.tp_dict,
        "SliderStepsChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSlider_SliderChange_Type.tp_dict,
        "SliderStepsChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSlider_SliderChange_Type,
        (long) QAbstractSlider::SliderValueChange, "SliderValueChange");
    PyDict_SetItemString(SbkQAbstractSlider_Type.super.ht_type.tp_dict,
        "SliderValueChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSlider_SliderChange_Type.tp_dict,
        "SliderValueChange", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractSlider::SliderChange");

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractSlider >("QAbstractSlider*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractSlider >(typeid(QAbstractSlider).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

