/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qwaitcondition_wrapper.h"

// Extra includes
#include <qmutex.h>
#include <qreadwritelock.h>
#include <qwaitcondition.h>

using namespace Shiboken;

static int
SbkQWaitCondition_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QWaitCondition* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QWaitCondition()
    cptr = new QWaitCondition();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQWaitConditionFunc_wait(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "wait", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QReadWriteLock* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QReadWriteLock* cpp_arg0 = Shiboken::Converter<QReadWriteLock* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // wait(QReadWriteLock*,ulong)
            QWaitCondition* cppSelf = Shiboken::Converter<QWaitCondition* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QWaitCondition::wait(cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            unsigned long cpp_arg1 = Shiboken::Converter<unsigned long >::toCpp(pyargs[1]);
            // wait(QReadWriteLock*,ulong)
            QWaitCondition* cppSelf = Shiboken::Converter<QWaitCondition* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QWaitCondition::wait(cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQWaitConditionFunc_wait_TypeError;
    } else if (Shiboken::Converter<QMutex* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMutex* cpp_arg0 = Shiboken::Converter<QMutex* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // wait(QMutex*,ulong)
            QWaitCondition* cppSelf = Shiboken::Converter<QWaitCondition* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QWaitCondition::wait(cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            unsigned long cpp_arg1 = Shiboken::Converter<unsigned long >::toCpp(pyargs[1]);
            // wait(QMutex*,ulong)
            QWaitCondition* cppSelf = Shiboken::Converter<QWaitCondition* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QWaitCondition::wait(cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQWaitConditionFunc_wait_TypeError;
    } else goto SbkQWaitConditionFunc_wait_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWaitConditionFunc_wait_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMutex, unsigned long = 4294967295UL", "PySide.QtCore.QReadWriteLock, unsigned long = 4294967295UL", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QWaitCondition.wait", overloads);
        return 0;
}

static PyObject*
SbkQWaitConditionFunc_wakeAll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // wakeAll()
    QWaitCondition* cppSelf = Shiboken::Converter<QWaitCondition* >::toCpp((PyObject*)self);
    cppSelf->QWaitCondition::wakeAll();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWaitConditionFunc_wakeOne(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // wakeOne()
    QWaitCondition* cppSelf = Shiboken::Converter<QWaitCondition* >::toCpp((PyObject*)self);
    cppSelf->QWaitCondition::wakeOne();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQWaitCondition_methods[] = {
    {"wait", (PyCFunction)SbkQWaitConditionFunc_wait, METH_VARARGS},
    {"wakeAll", (PyCFunction)SbkQWaitConditionFunc_wakeAll, METH_NOARGS},
    {"wakeOne", (PyCFunction)SbkQWaitConditionFunc_wakeOne, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWaitCondition_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QWaitCondition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QWaitCondition >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWaitCondition_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWaitCondition_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QWaitCondition(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QWAITCONDITION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWaitCondition_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQWaitCondition_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWaitCondition_Type));
    PyModule_AddObject(module, "QWaitCondition",
        ((PyObject*)&SbkQWaitCondition_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QWaitCondition >("QWaitCondition*");
    Shiboken::TypeResolver::createObjectTypeResolver<QWaitCondition >(typeid(QWaitCondition).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

