/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qtime_wrapper.h"

// Extra includes
#include <qdatetime.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQTime_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTime* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 1)
        goto SbkQTime_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QTime", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QTime()
        cptr = new QTime();
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QTime(int,int,int,int)
            cptr = new QTime(cpp_arg0, cpp_arg1);
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // QTime(int,int,int,int)
                cptr = new QTime(cpp_arg0, cpp_arg1, cpp_arg2);
            } else if (PyNumber_Check(pyargs[3])) {
                int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                // QTime(int,int,int,int)
                cptr = new QTime(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            } else goto SbkQTime_Init_TypeError;
        } else goto SbkQTime_Init_TypeError;
    } else goto SbkQTime_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTime_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTime_Init_TypeError:
        const char* overloads[] = {"", "int, int, int = 0, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QTime", overloads);
        return -1;
}

static PyObject*
SbkQTimeFunc_addMSecs(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // addMSecs(int)const
        QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
        QTime cpp_result = cppSelf->QTime::addMSecs(cpp_arg0);
        py_result = Shiboken::Converter<QTime >::toPython(cpp_result);
    } else goto SbkQTimeFunc_addMSecs_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTimeFunc_addMSecs_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTime.addMSecs", overloads);
        return 0;
}

static PyObject*
SbkQTimeFunc_addSecs(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // addSecs(int)const
        QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
        QTime cpp_result = cppSelf->QTime::addSecs(cpp_arg0);
        py_result = Shiboken::Converter<QTime >::toPython(cpp_result);
    } else goto SbkQTimeFunc_addSecs_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTimeFunc_addSecs_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTime.addSecs", overloads);
        return 0;
}

static PyObject*
SbkQTimeFunc_currentTime(PyObject* self)
{
    PyObject* py_result = 0;

    // currentTime()
    QTime cpp_result = QTime::currentTime();
    py_result = Shiboken::Converter<QTime >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTimeFunc_elapsed(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // elapsed()const
    QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTime::elapsed();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTimeFunc_fromString(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromString", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // fromString(QString,Qt::DateFormat)
            QTime cpp_result = QTime::fromString(*cpp_arg0);
            py_result = Shiboken::Converter<QTime >::toPython(cpp_result);
        } else if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // fromString(QString,QString)
            QTime cpp_result = QTime::fromString(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QTime >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::DateFormat >::isConvertible(pyargs[1])) {
            Qt::DateFormat cpp_arg1 = Shiboken::Converter<Qt::DateFormat >::toCpp(pyargs[1]);
            // fromString(QString,Qt::DateFormat)
            QTime cpp_result = QTime::fromString(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QTime >::toPython(cpp_result);
        } else goto SbkQTimeFunc_fromString_TypeError;
    } else goto SbkQTimeFunc_fromString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTimeFunc_fromString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.Qt.DateFormat = Qt.TextDate", "PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QTime.fromString", overloads);
        return 0;
}

static PyObject*
SbkQTimeFunc_hour(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hour()const
    QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTime::hour();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTimeFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTime::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTimeFunc_isValid(PyObject* self, PyObject* args)
{
    if (self) {
        if (Shiboken::cppObjectIsInvalid(self))
            return 0;
    }

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 1 || numArgs == 2)
        goto SbkQTimeFunc_isValid_TypeError;

    if (!PyArg_UnpackTuple(args, "isValid", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 0) {
        // isValid()const
        QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTime::isValid();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // isValid(int,int,int,int)
            bool cpp_result = QTime::isValid(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // isValid(int,int,int,int)
            bool cpp_result = QTime::isValid(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQTimeFunc_isValid_TypeError;
    } else goto SbkQTimeFunc_isValid_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTimeFunc_isValid_TypeError:
        const char* overloads[] = {"", "int, int, int, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QTime.isValid", overloads);
        return 0;
}

static PyObject*
SbkQTimeFunc_minute(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minute()const
    QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTime::minute();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTimeFunc_msec(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // msec()const
    QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTime::msec();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTimeFunc_msecsTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTime& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTime* cpp_arg0 = Shiboken::Converter<QTime* >::toCpp(arg);
        // msecsTo(QTime)const
        QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTime::msecsTo(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQTimeFunc_msecsTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTimeFunc_msecsTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTime.msecsTo", overloads);
        return 0;
}

static PyObject*
SbkQTimeFunc_restart(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // restart()
    QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTime::restart();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTimeFunc_second(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // second()const
    QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTime::second();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTimeFunc_secsTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTime& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTime* cpp_arg0 = Shiboken::Converter<QTime* >::toCpp(arg);
        // secsTo(QTime)const
        QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTime::secsTo(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQTimeFunc_secsTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTimeFunc_secsTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTime.secsTo", overloads);
        return 0;
}

static PyObject*
SbkQTimeFunc_setHMS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setHMS", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // setHMS(int,int,int,int)
            QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QTime::setHMS(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // setHMS(int,int,int,int)
            QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QTime::setHMS(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQTimeFunc_setHMS_TypeError;
    } else goto SbkQTimeFunc_setHMS_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTimeFunc_setHMS_TypeError:
        const char* overloads[] = {"int, int, int, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QTime.setHMS", overloads);
        return 0;
}

static PyObject*
SbkQTimeFunc_start(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // start()
    QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
    cppSelf->QTime::start();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTimeFunc_toString(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toString(Qt::DateFormat)const
        QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTime::toString();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // toString(QString)const
        QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTime::toString(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (Shiboken::Converter<Qt::DateFormat >::isConvertible(arg)) {
        Qt::DateFormat cpp_arg0 = Shiboken::Converter<Qt::DateFormat >::toCpp(arg);
        // toString(Qt::DateFormat)const
        QTime* cppSelf = Shiboken::Converter<QTime* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTime::toString(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQTimeFunc_toString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTimeFunc_toString_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DateFormat = Qt.TextDate", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTime.toString", overloads);
        return 0;
}

static PyMethodDef SbkQTimeMethod_isValid = {
    "isValid", (PyCFunction)SbkQTimeFunc_isValid, METH_VARARGS|METH_STATIC
};

static PyMethodDef SbkQTime_methods[] = {
    {"addMSecs", (PyCFunction)SbkQTimeFunc_addMSecs, METH_O},
    {"addSecs", (PyCFunction)SbkQTimeFunc_addSecs, METH_O},
    {"currentTime", (PyCFunction)SbkQTimeFunc_currentTime, METH_NOARGS|METH_STATIC},
    {"elapsed", (PyCFunction)SbkQTimeFunc_elapsed, METH_NOARGS},
    {"fromString", (PyCFunction)SbkQTimeFunc_fromString, METH_VARARGS|METH_STATIC},
    {"hour", (PyCFunction)SbkQTimeFunc_hour, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQTimeFunc_isNull, METH_NOARGS},
    SbkQTimeMethod_isValid,
    {"minute", (PyCFunction)SbkQTimeFunc_minute, METH_NOARGS},
    {"msec", (PyCFunction)SbkQTimeFunc_msec, METH_NOARGS},
    {"msecsTo", (PyCFunction)SbkQTimeFunc_msecsTo, METH_O},
    {"restart", (PyCFunction)SbkQTimeFunc_restart, METH_NOARGS},
    {"second", (PyCFunction)SbkQTimeFunc_second, METH_NOARGS},
    {"secsTo", (PyCFunction)SbkQTimeFunc_secsTo, METH_O},
    {"setHMS", (PyCFunction)SbkQTimeFunc_setHMS, METH_VARARGS},
    {"start", (PyCFunction)SbkQTimeFunc_start, METH_NOARGS},
    {"toString", (PyCFunction)SbkQTimeFunc_toString, METH_NOARGS|METH_O},
    {0} // Sentinel
};

static PyObject* SbkQTime_getattro(PyObject* self, PyObject* name)
{
    if (self) {
        if (SbkBaseWrapper_instanceDict(self)) {
            PyObject* meth = PyDict_GetItem(SbkBaseWrapper_instanceDict(self), name);
            if (meth) {
                Py_INCREF(meth);
                return meth;
            }
        }
        const char* cname = PyString_AS_STRING(name);
        if (strcmp(cname, "isValid") == 0)
            return PyCFunction_NewEx(&SbkQTimeMethod_isValid, self, 0);
    }
    return PyObject_GenericGetAttr(self, name);
}

// Rich comparison
static PyObject*
SbkQTime_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QTime& cpp_self = *Shiboken::Converter<QTime* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QTime& >::isConvertible(other)) {
                QTime* cpp_other = Shiboken::Converter<QTime* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQTime_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QTime& >::isConvertible(other)) {
                QTime* cpp_other = Shiboken::Converter<QTime* >::toCpp((PyObject*)other);
                result = (cpp_self < (*cpp_other));
            } else goto SbkQTime_RichComparison_TypeError;

            break;
        case Py_LE:
            if (Shiboken::Converter<QTime& >::isConvertible(other)) {
                QTime* cpp_other = Shiboken::Converter<QTime* >::toCpp((PyObject*)other);
                result = (cpp_self <= (*cpp_other));
            } else goto SbkQTime_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QTime& >::isConvertible(other)) {
                QTime* cpp_other = Shiboken::Converter<QTime* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQTime_RichComparison_TypeError;

            break;
        case Py_GT:
            if (Shiboken::Converter<QTime& >::isConvertible(other)) {
                QTime* cpp_other = Shiboken::Converter<QTime* >::toCpp((PyObject*)other);
                result = (cpp_self > (*cpp_other));
            } else goto SbkQTime_RichComparison_TypeError;

            break;
        case Py_GE:
            if (Shiboken::Converter<QTime& >::isConvertible(other)) {
                QTime* cpp_other = Shiboken::Converter<QTime* >::toCpp((PyObject*)other);
                result = (cpp_self >= (*cpp_other));
            } else goto SbkQTime_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQTime_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTime_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QTime",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTime >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         SbkQTime_getattro,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQTime_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTime_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTime_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QTime(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QTIME_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTime_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTime_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTime_Type));
    PyModule_AddObject(module, "QTime",
        ((PyObject*)&SbkQTime_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QTime >("QTime");
    Shiboken::TypeResolver::createValueTypeResolver<QTime >(typeid(QTime).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

