/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qtextstream_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qchar.h>
#include <qiodevice.h>
#include <qlocale.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <qtextstream.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTextStreamWrapper::QTextStreamWrapper() : QTextStream() {
    // ... middle
}

QTextStreamWrapper::QTextStreamWrapper(QByteArray * array, QFlags<QIODevice::OpenModeFlag> openMode) : QTextStream(array, openMode) {
    // ... middle
}

QTextStreamWrapper::QTextStreamWrapper(QIODevice * device) : QTextStream(device) {
    // ... middle
}

QTextStreamWrapper::QTextStreamWrapper(QString * string, QFlags<QIODevice::OpenModeFlag> openMode) : QTextStream(string, openMode) {
    // ... middle
}

QTextStreamWrapper::~QTextStreamWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQTextStream_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextStreamWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QTextStream", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QTextStream()
        cptr = new QTextStreamWrapper();
    } else if (numArgs == 1 && Shiboken::Converter<QIODevice* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        // QTextStream(QIODevice*)
        cptr = new QTextStreamWrapper(cpp_arg0);
    } else if (Shiboken::Converter<QByteArray* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray* >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // QTextStream(QByteArray*,QFlags<QIODevice::OpenModeFlag>)
            cptr = new QTextStreamWrapper(cpp_arg0);
        } else if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[1])) {
            QFlags<QIODevice::OpenModeFlag> cpp_arg1 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[1]);
            // QTextStream(QByteArray*,QFlags<QIODevice::OpenModeFlag>)
            cptr = new QTextStreamWrapper(cpp_arg0, cpp_arg1);
        } else goto SbkQTextStream_Init_TypeError;
    } else if (Shiboken::Converter<QString* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString* >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QTextStream(QString*,QFlags<QIODevice::OpenModeFlag>)
            cptr = new QTextStreamWrapper(cpp_arg0);
        } else if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[1])) {
            QFlags<QIODevice::OpenModeFlag> cpp_arg1 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[1]);
            // QTextStream(QString*,QFlags<QIODevice::OpenModeFlag>)
            cptr = new QTextStreamWrapper(cpp_arg0, cpp_arg1);
        } else goto SbkQTextStream_Init_TypeError;
    } else goto SbkQTextStream_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextStream_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTextStream_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QByteArray, PySide.QtCore.QIODevice.OpenMode = QIODevice.ReadWrite", "PySide.QtCore.QIODevice", "PySide.QtCore.QString, PySide.QtCore.QIODevice.OpenMode = QIODevice.ReadWrite", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QTextStream", overloads);
        return -1;
}

static PyObject*
SbkQTextStreamFunc_atEnd(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // atEnd()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextStream::atEnd();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_autoDetectUnicode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // autoDetectUnicode()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextStream::autoDetectUnicode();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_codec(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // codec()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    QTextCodec * cpp_result = cppSelf->QTextStream::codec();
    py_result = Shiboken::Converter<QTextCodec* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_device(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // device()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    QIODevice * cpp_result = cppSelf->QTextStream::device();
    py_result = Shiboken::Converter<QIODevice* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_fieldAlignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fieldAlignment()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    QTextStream::FieldAlignment cpp_result = cppSelf->QTextStream::fieldAlignment();
    py_result = Shiboken::Converter<QTextStream::FieldAlignment >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_fieldWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fieldWidth()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextStream::fieldWidth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_flush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    // flush()
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    cppSelf->QTextStream::flush();
    thread_state_saver.restore();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextStreamFunc_generateByteOrderMark(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // generateByteOrderMark()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextStream::generateByteOrderMark();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_integerBase(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // integerBase()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextStream::integerBase();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_locale(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // locale()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    QLocale cpp_result = cppSelf->QTextStream::locale();
    py_result = Shiboken::Converter<QLocale >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_numberFlags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // numberFlags()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    QFlags<QTextStream::NumberFlag> cpp_result = cppSelf->QTextStream::numberFlags();
    py_result = Shiboken::Converter<QFlags<QTextStream::NumberFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_padChar(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // padChar()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    QChar cpp_result = cppSelf->QTextStream::padChar();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QTextStream::pos();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_read(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // read(qint64)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        QString cpp_result = cppSelf->QTextStream::read(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQTextStreamFunc_read_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextStreamFunc_read_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.read", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_readAll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // readAll()
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    QString cpp_result = cppSelf->QTextStream::readAll();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_readLine(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // readLine(qint64)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        QString cpp_result = cppSelf->QTextStream::readLine();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // readLine(qint64)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        QString cpp_result = cppSelf->QTextStream::readLine(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQTextStreamFunc_readLine_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextStreamFunc_readLine_TypeError:
        const char* overloads[] = {"long long = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.readLine", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_realNumberNotation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // realNumberNotation()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    QTextStream::RealNumberNotation cpp_result = cppSelf->QTextStream::realNumberNotation();
    py_result = Shiboken::Converter<QTextStream::RealNumberNotation >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_realNumberPrecision(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // realNumberPrecision()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextStream::realNumberPrecision();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    cppSelf->QTextStream::reset();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextStreamFunc_resetStatus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // resetStatus()
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    cppSelf->QTextStream::resetStatus();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextStreamFunc_seek(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // seek(qint64)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTextStream::seek(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTextStreamFunc_seek_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextStreamFunc_seek_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.seek", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_setAutoDetectUnicode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAutoDetectUnicode(bool)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        cppSelf->QTextStream::setAutoDetectUnicode(cpp_arg0);
    } else goto SbkQTextStreamFunc_setAutoDetectUnicode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextStreamFunc_setAutoDetectUnicode_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.setAutoDetectUnicode", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_setCodec(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // setCodec(const char*)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        cppSelf->QTextStream::setCodec(cpp_arg0);
    } else if (Shiboken::Converter<QTextCodec* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCodec* cpp_arg0 = Shiboken::Converter<QTextCodec* >::toCpp(arg);
        // setCodec(QTextCodec*)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        cppSelf->QTextStream::setCodec(cpp_arg0);
    } else goto SbkQTextStreamFunc_setCodec_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextStreamFunc_setCodec_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextCodec", "str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.setCodec", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_setDevice(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIODevice* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // setDevice(QIODevice*)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        cppSelf->QTextStream::setDevice(cpp_arg0);
    } else goto SbkQTextStreamFunc_setDevice_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextStreamFunc_setDevice_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.setDevice", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_setFieldAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextStream::FieldAlignment >::isConvertible(arg)) {
        QTextStream::FieldAlignment cpp_arg0 = Shiboken::Converter<QTextStream::FieldAlignment >::toCpp(arg);
        // setFieldAlignment(QTextStream::FieldAlignment)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        cppSelf->QTextStream::setFieldAlignment(cpp_arg0);
    } else goto SbkQTextStreamFunc_setFieldAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextStreamFunc_setFieldAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextStream.FieldAlignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.setFieldAlignment", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_setFieldWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setFieldWidth(int)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        cppSelf->QTextStream::setFieldWidth(cpp_arg0);
    } else goto SbkQTextStreamFunc_setFieldWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextStreamFunc_setFieldWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.setFieldWidth", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_setGenerateByteOrderMark(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setGenerateByteOrderMark(bool)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        cppSelf->QTextStream::setGenerateByteOrderMark(cpp_arg0);
    } else goto SbkQTextStreamFunc_setGenerateByteOrderMark_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextStreamFunc_setGenerateByteOrderMark_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.setGenerateByteOrderMark", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_setIntegerBase(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setIntegerBase(int)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        cppSelf->QTextStream::setIntegerBase(cpp_arg0);
    } else goto SbkQTextStreamFunc_setIntegerBase_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextStreamFunc_setIntegerBase_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.setIntegerBase", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_setLocale(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLocale& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QLocale > cpp_arg0_auto_ptr;
        QLocale* cpp_arg0 = Shiboken::Converter<QLocale* >::toCpp(arg);
        if (!Shiboken::Converter<QLocale& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QLocale >(cpp_arg0);
        // setLocale(QLocale)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        cppSelf->QTextStream::setLocale(*cpp_arg0);
    } else goto SbkQTextStreamFunc_setLocale_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextStreamFunc_setLocale_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLocale", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.setLocale", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_setNumberFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_QTextStream_NumberFlag_Check(arg)) {
        QFlags<QTextStream::NumberFlag> cpp_arg0 = Shiboken::Converter<QFlags<QTextStream::NumberFlag> >::toCpp(arg);
        // setNumberFlags(QFlags<QTextStream::NumberFlag>)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        cppSelf->QTextStream::setNumberFlags(cpp_arg0);
    } else goto SbkQTextStreamFunc_setNumberFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextStreamFunc_setNumberFlags_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextStream.NumberFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.setNumberFlags", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_setPadChar(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QChar >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(arg);
        if (!Shiboken::Converter<QChar >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // setPadChar(QChar)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        cppSelf->QTextStream::setPadChar(*cpp_arg0);
    } else goto SbkQTextStreamFunc_setPadChar_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextStreamFunc_setPadChar_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.setPadChar", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_setRealNumberNotation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextStream::RealNumberNotation >::isConvertible(arg)) {
        QTextStream::RealNumberNotation cpp_arg0 = Shiboken::Converter<QTextStream::RealNumberNotation >::toCpp(arg);
        // setRealNumberNotation(QTextStream::RealNumberNotation)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        cppSelf->QTextStream::setRealNumberNotation(cpp_arg0);
    } else goto SbkQTextStreamFunc_setRealNumberNotation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextStreamFunc_setRealNumberNotation_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextStream.RealNumberNotation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.setRealNumberNotation", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_setRealNumberPrecision(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setRealNumberPrecision(int)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        cppSelf->QTextStream::setRealNumberPrecision(cpp_arg0);
    } else goto SbkQTextStreamFunc_setRealNumberPrecision_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextStreamFunc_setRealNumberPrecision_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.setRealNumberPrecision", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_setStatus(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextStream::Status >::isConvertible(arg)) {
        QTextStream::Status cpp_arg0 = Shiboken::Converter<QTextStream::Status >::toCpp(arg);
        // setStatus(QTextStream::Status)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        cppSelf->QTextStream::setStatus(cpp_arg0);
    } else goto SbkQTextStreamFunc_setStatus_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextStreamFunc_setStatus_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextStream.Status", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.setStatus", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc_skipWhiteSpace(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // skipWhiteSpace()
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    cppSelf->QTextStream::skipWhiteSpace();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextStreamFunc_status(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // status()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    QTextStream::Status cpp_result = cppSelf->QTextStream::status();
    py_result = Shiboken::Converter<QTextStream::Status >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextStreamFunc_string(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // string()const
    QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
    QString * cpp_result = cppSelf->QTextStream::string();
    py_result = Shiboken::Converter<QString* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTextStream_methods[] = {
    {"atEnd", (PyCFunction)SbkQTextStreamFunc_atEnd, METH_NOARGS},
    {"autoDetectUnicode", (PyCFunction)SbkQTextStreamFunc_autoDetectUnicode, METH_NOARGS},
    {"codec", (PyCFunction)SbkQTextStreamFunc_codec, METH_NOARGS},
    {"device", (PyCFunction)SbkQTextStreamFunc_device, METH_NOARGS},
    {"fieldAlignment", (PyCFunction)SbkQTextStreamFunc_fieldAlignment, METH_NOARGS},
    {"fieldWidth", (PyCFunction)SbkQTextStreamFunc_fieldWidth, METH_NOARGS},
    {"flush", (PyCFunction)SbkQTextStreamFunc_flush, METH_NOARGS},
    {"generateByteOrderMark", (PyCFunction)SbkQTextStreamFunc_generateByteOrderMark, METH_NOARGS},
    {"integerBase", (PyCFunction)SbkQTextStreamFunc_integerBase, METH_NOARGS},
    {"locale", (PyCFunction)SbkQTextStreamFunc_locale, METH_NOARGS},
    {"numberFlags", (PyCFunction)SbkQTextStreamFunc_numberFlags, METH_NOARGS},
    {"padChar", (PyCFunction)SbkQTextStreamFunc_padChar, METH_NOARGS},
    {"pos", (PyCFunction)SbkQTextStreamFunc_pos, METH_NOARGS},
    {"read", (PyCFunction)SbkQTextStreamFunc_read, METH_O},
    {"readAll", (PyCFunction)SbkQTextStreamFunc_readAll, METH_NOARGS},
    {"readLine", (PyCFunction)SbkQTextStreamFunc_readLine, METH_NOARGS|METH_O},
    {"realNumberNotation", (PyCFunction)SbkQTextStreamFunc_realNumberNotation, METH_NOARGS},
    {"realNumberPrecision", (PyCFunction)SbkQTextStreamFunc_realNumberPrecision, METH_NOARGS},
    {"reset", (PyCFunction)SbkQTextStreamFunc_reset, METH_NOARGS},
    {"resetStatus", (PyCFunction)SbkQTextStreamFunc_resetStatus, METH_NOARGS},
    {"seek", (PyCFunction)SbkQTextStreamFunc_seek, METH_O},
    {"setAutoDetectUnicode", (PyCFunction)SbkQTextStreamFunc_setAutoDetectUnicode, METH_O},
    {"setCodec", (PyCFunction)SbkQTextStreamFunc_setCodec, METH_O},
    {"setDevice", (PyCFunction)SbkQTextStreamFunc_setDevice, METH_O},
    {"setFieldAlignment", (PyCFunction)SbkQTextStreamFunc_setFieldAlignment, METH_O},
    {"setFieldWidth", (PyCFunction)SbkQTextStreamFunc_setFieldWidth, METH_O},
    {"setGenerateByteOrderMark", (PyCFunction)SbkQTextStreamFunc_setGenerateByteOrderMark, METH_O},
    {"setIntegerBase", (PyCFunction)SbkQTextStreamFunc_setIntegerBase, METH_O},
    {"setLocale", (PyCFunction)SbkQTextStreamFunc_setLocale, METH_O},
    {"setNumberFlags", (PyCFunction)SbkQTextStreamFunc_setNumberFlags, METH_O},
    {"setPadChar", (PyCFunction)SbkQTextStreamFunc_setPadChar, METH_O},
    {"setRealNumberNotation", (PyCFunction)SbkQTextStreamFunc_setRealNumberNotation, METH_O},
    {"setRealNumberPrecision", (PyCFunction)SbkQTextStreamFunc_setRealNumberPrecision, METH_O},
    {"setStatus", (PyCFunction)SbkQTextStreamFunc_setStatus, METH_O},
    {"skipWhiteSpace", (PyCFunction)SbkQTextStreamFunc_skipWhiteSpace, METH_NOARGS},
    {"status", (PyCFunction)SbkQTextStreamFunc_status, METH_NOARGS},
    {"string", (PyCFunction)SbkQTextStreamFunc_string, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQTextStreamFunc___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQTextStream_Check(arg) && !SbkQTextStream_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (!isReverse && PyLong_Check(arg)) {
        unsigned long cpp_arg0 = Shiboken::Converter<unsigned long >::toCpp(arg);
        // operator<<(ulong)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) << cpp_arg0;
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && PyLong_Check(arg)) {
        signed long cpp_arg0 = Shiboken::Converter<signed long >::toCpp(arg);
        // operator<<(signed long)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) << cpp_arg0;
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && PyFloat_Check(arg)) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);
        // operator<<(double)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) << cpp_arg0;
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // operator<<(const char*)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) << cpp_arg0;
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // operator<<(QByteArray)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // operator<<(char)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) << cpp_arg0;
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QTextStreamManipulator >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextStreamManipulator* cpp_arg0 = Shiboken::Converter<QTextStreamManipulator* >::toCpp(arg);
        // operator<<(QTextStream&,QTextStreamManipulator)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QChar >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(arg);
        if (!Shiboken::Converter<QChar >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // operator<<(QChar)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // operator<<(QString)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTextStreamFunc___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextStreamFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QChar", "PySide.QtCore.QTextStreamManipulator", "char", "PySide.QtCore.QByteArray", "PySide.QtCore.QString", "str", "float", "long", "unsigned long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.__lshift__", overloads);
        return 0;
}

static PyObject*
SbkQTextStreamFunc___rshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQTextStream_Check(arg) && !SbkQTextStream_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rrshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (!isReverse && PyLong_Check(arg)) {
        unsigned long cpp_arg0 = Shiboken::Converter<unsigned long >::toCpp(arg);
        // operator>>(ulong&)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) >> cpp_arg0;
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && PyLong_Check(arg)) {
        signed long cpp_arg0 = Shiboken::Converter<signed long >::toCpp(arg);
        // operator>>(signed long&)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) >> cpp_arg0;
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && PyFloat_Check(arg)) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);
        // operator>>(double&)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) >> cpp_arg0;
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<char * >::isConvertible(arg)) {
        char * cpp_arg0 = Shiboken::Converter<char * >::toCpp(arg);
        // operator>>(char*)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) >> cpp_arg0;
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // operator>>(char&)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) >> cpp_arg0;
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QChar& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(arg);
        if (!Shiboken::Converter<QChar& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // operator>>(QChar&)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // operator>>(QByteArray&)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // operator>>(QString&)
        QTextStream* cppSelf = Shiboken::Converter<QTextStream* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTextStreamFunc___rshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextStreamFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", "PySide.QtCore.QChar", "PySide.QtCore.QString", "str", "str", "double", "signed long", "unsigned long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextStream.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQTextStream_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQTextStreamFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQTextStreamFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextStream_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QTextStream",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTextStreamWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQTextStream_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextStream_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextStream_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQTextStream_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQTextStream_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QTextStream*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtCore_QTextStream_RealNumberNotation_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QTextStream_RealNumberNotation_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QTextStream_RealNumberNotation_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RealNumberNotation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QTextStream_RealNumberNotation_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QTextStream_RealNumberNotation_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QTextStream_RealNumberNotation_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_QTextStream_NumberFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextStream::NumberFlags >::toPython(
        ((QTextStream::NumberFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QTextStream::NumberFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QTextStream_NumberFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextStream::NumberFlags >::toPython(
        ((QTextStream::NumberFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QTextStream::NumberFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QTextStream_NumberFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextStream::NumberFlags >::toPython(
        ((QTextStream::NumberFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QTextStream::NumberFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QTextStream_NumberFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextStream::NumberFlags >::toPython(
        ~ Shiboken::Converter< QTextStream::NumberFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_QTextStream_NumberFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_QTextStream_NumberFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_QTextStream_NumberFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_QTextStream_NumberFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_QTextStream_NumberFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_QTextStream_NumberFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QTextStream_NumberFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QTextStream_NumberFlag_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NumberFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_QTextStream_NumberFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QTextStream_NumberFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QTextStream_NumberFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QTextStream_NumberFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QTextStream_NumberFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QTextStream_NumberFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NumberFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_QTextStream_NumberFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QTextStream_NumberFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QTextStream_NumberFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_QTextStream_NumberFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_QTextStream_FieldAlignment_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QTextStream_FieldAlignment_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QTextStream_FieldAlignment_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FieldAlignment",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QTextStream_FieldAlignment_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QTextStream_FieldAlignment_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QTextStream_FieldAlignment_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QTextStream_Status_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QTextStream_Status_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QTextStream_Status_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Status",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QTextStream_Status_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QTextStream_Status_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QTextStream_Status_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QTextStream(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextStream_Type);

    // Fill type discovery information
    SbkQTextStream_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQTextStream_Type.type_discovery->addTypeDiscoveryFunction(&SbkQTextStream_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQTextStream_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextStream_Type));
    PyModule_AddObject(module, "QTextStream",
        ((PyObject*)&SbkQTextStream_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: RealNumberNotation
    SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX] = &SbkPySide_QtCore_QTextStream_RealNumberNotation_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QTextStream_RealNumberNotation_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QTextStream_RealNumberNotation_Type);
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
            "RealNumberNotation",((PyObject*)&SbkPySide_QtCore_QTextStream_RealNumberNotation_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_RealNumberNotation_Type,
        (long) QTextStream::SmartNotation, "SmartNotation");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "SmartNotation", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_RealNumberNotation_Type.tp_dict,
        "SmartNotation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_RealNumberNotation_Type,
        (long) QTextStream::FixedNotation, "FixedNotation");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "FixedNotation", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_RealNumberNotation_Type.tp_dict,
        "FixedNotation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_RealNumberNotation_Type,
        (long) QTextStream::ScientificNotation, "ScientificNotation");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "ScientificNotation", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_RealNumberNotation_Type.tp_dict,
        "ScientificNotation", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextStream::RealNumberNotation");

    // init enum class: NumberFlag
    SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX] = &SbkPySide_QtCore_QTextStream_NumberFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QTextStream_NumberFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QTextStream_NumberFlag_Type);
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
            "NumberFlag",((PyObject*)&SbkPySide_QtCore_QTextStream_NumberFlag_Type));

    // init flags class: QFlags<QTextStream::NumberFlag>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG__IDX] = &SbkPySide_QtCore_QTextStream_NumberFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QTextStream_NumberFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QTextStream_NumberFlags_Type);
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
            "NumberFlags",((PyObject*)&SbkPySide_QtCore_QTextStream_NumberFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_NumberFlag_Type,
        (long) QTextStream::ShowBase, "ShowBase");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "ShowBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_NumberFlag_Type.tp_dict,
        "ShowBase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_NumberFlag_Type,
        (long) QTextStream::ForcePoint, "ForcePoint");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "ForcePoint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_NumberFlag_Type.tp_dict,
        "ForcePoint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_NumberFlag_Type,
        (long) QTextStream::ForceSign, "ForceSign");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "ForceSign", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_NumberFlag_Type.tp_dict,
        "ForceSign", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_NumberFlag_Type,
        (long) QTextStream::UppercaseBase, "UppercaseBase");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "UppercaseBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_NumberFlag_Type.tp_dict,
        "UppercaseBase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_NumberFlag_Type,
        (long) QTextStream::UppercaseDigits, "UppercaseDigits");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "UppercaseDigits", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_NumberFlag_Type.tp_dict,
        "UppercaseDigits", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextStream::NumberFlag");

    // init enum class: FieldAlignment
    SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX] = &SbkPySide_QtCore_QTextStream_FieldAlignment_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QTextStream_FieldAlignment_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QTextStream_FieldAlignment_Type);
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
            "FieldAlignment",((PyObject*)&SbkPySide_QtCore_QTextStream_FieldAlignment_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_FieldAlignment_Type,
        (long) QTextStream::AlignLeft, "AlignLeft");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "AlignLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_FieldAlignment_Type.tp_dict,
        "AlignLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_FieldAlignment_Type,
        (long) QTextStream::AlignRight, "AlignRight");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "AlignRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_FieldAlignment_Type.tp_dict,
        "AlignRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_FieldAlignment_Type,
        (long) QTextStream::AlignCenter, "AlignCenter");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "AlignCenter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_FieldAlignment_Type.tp_dict,
        "AlignCenter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_FieldAlignment_Type,
        (long) QTextStream::AlignAccountingStyle, "AlignAccountingStyle");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "AlignAccountingStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_FieldAlignment_Type.tp_dict,
        "AlignAccountingStyle", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextStream::FieldAlignment");

    // init enum class: Status
    SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX] = &SbkPySide_QtCore_QTextStream_Status_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QTextStream_Status_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QTextStream_Status_Type);
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
            "Status",((PyObject*)&SbkPySide_QtCore_QTextStream_Status_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_Status_Type,
        (long) QTextStream::Ok, "Ok");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "Ok", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_Status_Type.tp_dict,
        "Ok", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_Status_Type,
        (long) QTextStream::ReadPastEnd, "ReadPastEnd");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "ReadPastEnd", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_Status_Type.tp_dict,
        "ReadPastEnd", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextStream_Status_Type,
        (long) QTextStream::ReadCorruptData, "ReadCorruptData");
    PyDict_SetItemString(SbkQTextStream_Type.super.ht_type.tp_dict,
        "ReadCorruptData", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextStream_Status_Type.tp_dict,
        "ReadCorruptData", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextStream::Status");

    Shiboken::TypeResolver::createObjectTypeResolver<QTextStream >("QTextStream*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTextStream >(typeid(QTextStream).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

