/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qsizef_wrapper.h"

// Extra includes
#include <qsize.h>

using namespace Shiboken;

static int
SbkQSizeF_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSizeF* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QSizeF", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QSizeF()
        cptr = new QSizeF();
    } else if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // QSizeF(qreal,qreal)
        cptr = new QSizeF(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QSize& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        // QSizeF(QSize)
        cptr = new QSizeF(*cpp_arg0);
    } else goto SbkQSizeF_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSizeF_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSizeF_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QSize", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSizeF", overloads);
        return -1;
}

static PyObject*
SbkQSizeFFunc_boundedTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QSizeF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(arg);
        if (!Shiboken::Converter<QSizeF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        // boundedTo(QSizeF)const
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        QSizeF cpp_result = cppSelf->QSizeF::boundedTo(*cpp_arg0);
        py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
    } else goto SbkQSizeFFunc_boundedTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSizeFFunc_boundedTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSizeF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSizeF.boundedTo", overloads);
        return 0;
}

static PyObject*
SbkQSizeFFunc_expandedTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QSizeF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(arg);
        if (!Shiboken::Converter<QSizeF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        // expandedTo(QSizeF)const
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        QSizeF cpp_result = cppSelf->QSizeF::expandedTo(*cpp_arg0);
        py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
    } else goto SbkQSizeFFunc_expandedTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSizeFFunc_expandedTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSizeF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSizeF.expandedTo", overloads);
        return 0;
}

static PyObject*
SbkQSizeFFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QSizeF::height();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSizeFFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSizeF::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSizeFFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSizeF::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSizeFFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSizeF::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSizeFFunc_scale(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "scale", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<Qt::AspectRatioMode >::isConvertible(pyargs[2])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        Qt::AspectRatioMode cpp_arg2 = Shiboken::Converter<Qt::AspectRatioMode >::toCpp(pyargs[2]);
        // scale(qreal,qreal,Qt::AspectRatioMode)
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        cppSelf->QSizeF::scale(cpp_arg0, cpp_arg1, cpp_arg2);
    } else if (numArgs == 2 && Shiboken::Converter<QSizeF& >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::AspectRatioMode >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QSizeF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        Qt::AspectRatioMode cpp_arg1 = Shiboken::Converter<Qt::AspectRatioMode >::toCpp(pyargs[1]);
        // scale(QSizeF,Qt::AspectRatioMode)
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        cppSelf->QSizeF::scale(*cpp_arg0, cpp_arg1);
    } else goto SbkQSizeFFunc_scale_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSizeFFunc_scale_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSizeF, PySide.QtCore.Qt.AspectRatioMode", "float, float, PySide.QtCore.Qt.AspectRatioMode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSizeF.scale", overloads);
        return 0;
}

static PyObject*
SbkQSizeFFunc_setHeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setHeight(qreal)
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        cppSelf->QSizeF::setHeight(cpp_arg0);
    } else goto SbkQSizeFFunc_setHeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSizeFFunc_setHeight_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSizeF.setHeight", overloads);
        return 0;
}

static PyObject*
SbkQSizeFFunc_setWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setWidth(qreal)
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        cppSelf->QSizeF::setWidth(cpp_arg0);
    } else goto SbkQSizeFFunc_setWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSizeFFunc_setWidth_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSizeF.setWidth", overloads);
        return 0;
}

static PyObject*
SbkQSizeFFunc_toSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toSize()const
    QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QSizeF::toSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSizeFFunc_transpose(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // transpose()
    QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
    cppSelf->QSizeF::transpose();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSizeFFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QSizeF::width();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQSizeF_methods[] = {
    {"boundedTo", (PyCFunction)SbkQSizeFFunc_boundedTo, METH_O},
    {"expandedTo", (PyCFunction)SbkQSizeFFunc_expandedTo, METH_O},
    {"height", (PyCFunction)SbkQSizeFFunc_height, METH_NOARGS},
    {"isEmpty", (PyCFunction)SbkQSizeFFunc_isEmpty, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQSizeFFunc_isNull, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQSizeFFunc_isValid, METH_NOARGS},
    {"scale", (PyCFunction)SbkQSizeFFunc_scale, METH_VARARGS},
    {"setHeight", (PyCFunction)SbkQSizeFFunc_setHeight, METH_O},
    {"setWidth", (PyCFunction)SbkQSizeFFunc_setWidth, METH_O},
    {"toSize", (PyCFunction)SbkQSizeFFunc_toSize, METH_NOARGS},
    {"transpose", (PyCFunction)SbkQSizeFFunc_transpose, METH_NOARGS},
    {"width", (PyCFunction)SbkQSizeFFunc_width, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQSizeFFunc___mul__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQSizeF_Check(arg) && !SbkQSizeF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(QSizeF,qreal)
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        const QSizeF cpp_result = (*cppSelf) * cpp_arg0;
        py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
    } else if (isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(qreal,QSizeF) [reverse operator]
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        const QSizeF cpp_result = cpp_arg0 * (*cppSelf);
        py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
    } else goto SbkQSizeFFunc___mul___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSizeFFunc___mul___TypeError:
        const char* overloads[] = {"float", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSizeF.__mul__", overloads);
        return 0;
}

static PyObject*
SbkQSizeFFunc___imul__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQSizeF_Check(arg) && !SbkQSizeF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*=(qreal)
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        (*cppSelf) *= cpp_arg0;
    } else goto SbkQSizeFFunc___imul___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQSizeFFunc___imul___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSizeF.__imul__", overloads);
        return 0;
}

static PyObject*
SbkQSizeFFunc___add__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQSizeF_Check(arg) && !SbkQSizeF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QSizeF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(arg);
        if (!Shiboken::Converter<QSizeF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        // operator+(QSizeF,QSizeF)
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        const QSizeF cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
    } else goto SbkQSizeFFunc___add___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSizeFFunc___add___TypeError:
        const char* overloads[] = {"PySide.QtCore.QSizeF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSizeF.__add__", overloads);
        return 0;
}

static PyObject*
SbkQSizeFFunc___iadd__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQSizeF_Check(arg) && !SbkQSizeF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QSizeF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(arg);
        if (!Shiboken::Converter<QSizeF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        // operator+=(QSizeF)
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        (*cppSelf) += (*cpp_arg0);
    } else goto SbkQSizeFFunc___iadd___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQSizeFFunc___iadd___TypeError:
        const char* overloads[] = {"PySide.QtCore.QSizeF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSizeF.__iadd__", overloads);
        return 0;
}

static PyObject*
SbkQSizeFFunc___sub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQSizeF_Check(arg) && !SbkQSizeF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QSizeF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(arg);
        if (!Shiboken::Converter<QSizeF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        // operator-(QSizeF,QSizeF)
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        const QSizeF cpp_result = (*cppSelf) - (*cpp_arg0);
        py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
    } else goto SbkQSizeFFunc___sub___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSizeFFunc___sub___TypeError:
        const char* overloads[] = {"PySide.QtCore.QSizeF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSizeF.__sub__", overloads);
        return 0;
}

static PyObject*
SbkQSizeFFunc___isub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQSizeF_Check(arg) && !SbkQSizeF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QSizeF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(arg);
        if (!Shiboken::Converter<QSizeF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        // operator-=(QSizeF)
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        (*cppSelf) -= (*cpp_arg0);
    } else goto SbkQSizeFFunc___isub___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQSizeFFunc___isub___TypeError:
        const char* overloads[] = {"PySide.QtCore.QSizeF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSizeF.__isub__", overloads);
        return 0;
}

static PyObject*
SbkQSizeFFunc___div__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQSizeF_Check(arg) && !SbkQSizeF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/(QSizeF,qreal)
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        const QSizeF cpp_result = (*cppSelf) / cpp_arg0;
        py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
    } else goto SbkQSizeFFunc___div___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSizeFFunc___div___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSizeF.__div__", overloads);
        return 0;
}

static PyObject*
SbkQSizeFFunc___idiv__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQSizeF_Check(arg) && !SbkQSizeF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/=(qreal)
        QSizeF* cppSelf = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);
        (*cppSelf) /= cpp_arg0;
    } else goto SbkQSizeFFunc___idiv___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQSizeFFunc___idiv___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSizeF.__idiv__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQSizeF_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQSizeFFunc___add__,
    /*nb_subtract*/             (binaryfunc)SbkQSizeFFunc___sub__,
    /*nb_multiply*/             (binaryfunc)SbkQSizeFFunc___mul__,
    /*nb_divide*/               (binaryfunc)SbkQSizeFFunc___div__,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQSizeFFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)SbkQSizeFFunc___isub__,
    /*nb_inplace_multiply*/     (binaryfunc)SbkQSizeFFunc___imul__,
    /*nb_inplace_divide*/       (binaryfunc)SbkQSizeFFunc___idiv__,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQSizeF_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QSizeF& cpp_self = *Shiboken::Converter<QSizeF* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QSizeF& >::isConvertible(other)) {
                QSizeF* cpp_other = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QSizeF >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QSizeF > cpp_other_auto_ptr;
                QSizeF* cpp_other = Shiboken::Converter<QSizeF* >::toCpp(other);
                if (!Shiboken::Converter<QSizeF >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QSizeF >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQSizeF_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QSizeF& >::isConvertible(other)) {
                QSizeF* cpp_other = Shiboken::Converter<QSizeF* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QSizeF >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QSizeF > cpp_other_auto_ptr;
                QSizeF* cpp_other = Shiboken::Converter<QSizeF* >::toCpp(other);
                if (!Shiboken::Converter<QSizeF >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QSizeF >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQSizeF_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQSizeF_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSizeF_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QSizeF",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSizeF >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQSizeF_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQSizeF_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSizeF_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSizeF_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QSizeF(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSIZEF_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSizeF_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQSizeF_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSizeF_Type));
    PyModule_AddObject(module, "QSizeF",
        ((PyObject*)&SbkQSizeF_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QSizeF >("QSizeF");
    Shiboken::TypeResolver::createValueTypeResolver<QSizeF >(typeid(QSizeF).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

