/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qsettings_wrapper.h"

// Extra includes
#include <QList>
#include <QStringList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsettings.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qtextcodec.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSettingsWrapper::QSettingsWrapper(QObject * parent) : QSettings(parent), m_metaObject(0) {
    // ... middle
}

QSettingsWrapper::QSettingsWrapper(QSettings::Format format, QSettings::Scope scope, const QString & organization, const QString & application, QObject * parent) : QSettings(format, scope, organization, application, parent), m_metaObject(0) {
    // ... middle
}

QSettingsWrapper::QSettingsWrapper(QSettings::Scope scope, const QString & organization, const QString & application, QObject * parent) : QSettings(scope, organization, application, parent), m_metaObject(0) {
    // ... middle
}

QSettingsWrapper::QSettingsWrapper(const QString & fileName, QSettings::Format format, QObject * parent) : QSettings(fileName, format, parent), m_metaObject(0) {
    // ... middle
}

QSettingsWrapper::QSettingsWrapper(const QString & organization, const QString & application, QObject * parent) : QSettings(organization, application, parent), m_metaObject(0) {
    // ... middle
}

void QSettingsWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSettingsWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSettingsWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSettingsWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QSettingsWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QSettings::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSettings.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSettingsWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSettings.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QSettingsWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QSettingsWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QSettings::staticMetaObject);
}
    return m_metaObject;
}

int QSettingsWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QSettings::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSettingsWrapper::~QSettingsWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQSettings_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSettingsWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QSettings", 0, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return -1;

    if (numArgs == 0) {
        // QSettings(QObject*)
        cptr = new QSettingsWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QSettings(QString,QString,QObject*)
            cptr = new QSettingsWrapper(*cpp_arg0);
            Shiboken::setParent(pyargs[2], self);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // QSettings(QString,QString,QObject*)
                cptr = new QSettingsWrapper(*cpp_arg0, *cpp_arg1);
                Shiboken::setParent(pyargs[2], self);
            } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QObject* cpp_arg2 = Shiboken::Converter<QObject* >::toCpp(pyargs[2]);
                // QSettings(QString,QString,QObject*)
                cptr = new QSettingsWrapper(*cpp_arg0, *cpp_arg1, cpp_arg2);
                Shiboken::setParent(pyargs[2], self);
            } else goto SbkQSettings_Init_TypeError;
        } else if (Shiboken::Converter<QSettings::Format >::isConvertible(pyargs[1])) {
            QSettings::Format cpp_arg1 = Shiboken::Converter<QSettings::Format >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QSettings(QString,QSettings::Format,QObject*)
                cptr = new QSettingsWrapper(*cpp_arg0, cpp_arg1);
                Shiboken::setParent(pyargs[2], self);
            } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QObject* cpp_arg2 = Shiboken::Converter<QObject* >::toCpp(pyargs[2]);
                // QSettings(QString,QSettings::Format,QObject*)
                cptr = new QSettingsWrapper(*cpp_arg0, cpp_arg1, cpp_arg2);
                Shiboken::setParent(pyargs[2], self);
            } else goto SbkQSettings_Init_TypeError;
        } else goto SbkQSettings_Init_TypeError;
    } else if (Shiboken::Converter<QSettings::Scope >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        QSettings::Scope cpp_arg0 = Shiboken::Converter<QSettings::Scope >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // QSettings(QSettings::Scope,QString,QString,QObject*)
            cptr = new QSettingsWrapper(cpp_arg0, *cpp_arg1);
            Shiboken::setParent(pyargs[3], self);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return -1;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            if (numArgs == 3) {
                // QSettings(QSettings::Scope,QString,QString,QObject*)
                cptr = new QSettingsWrapper(cpp_arg0, *cpp_arg1, *cpp_arg2);
                Shiboken::setParent(pyargs[3], self);
            } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return -1;
                QObject* cpp_arg3 = Shiboken::Converter<QObject* >::toCpp(pyargs[3]);
                // QSettings(QSettings::Scope,QString,QString,QObject*)
                cptr = new QSettingsWrapper(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                Shiboken::setParent(pyargs[3], self);
            } else goto SbkQSettings_Init_TypeError;
        } else goto SbkQSettings_Init_TypeError;
    } else if (Shiboken::Converter<QSettings::Format >::isConvertible(pyargs[0]) && Shiboken::Converter<QSettings::Scope >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        QSettings::Format cpp_arg0 = Shiboken::Converter<QSettings::Format >::toCpp(pyargs[0]);
        QSettings::Scope cpp_arg1 = Shiboken::Converter<QSettings::Scope >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return -1;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (numArgs == 3) {
            // QSettings(QSettings::Format,QSettings::Scope,QString,QString,QObject*)
            cptr = new QSettingsWrapper(cpp_arg0, cpp_arg1, *cpp_arg2);
            Shiboken::setParent(pyargs[4], self);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return -1;
            std::auto_ptr<QString > cpp_arg3_auto_ptr;
            QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
                cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
            if (numArgs == 4) {
                // QSettings(QSettings::Format,QSettings::Scope,QString,QString,QObject*)
                cptr = new QSettingsWrapper(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3);
                Shiboken::setParent(pyargs[4], self);
            } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[4])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                    return -1;
                QObject* cpp_arg4 = Shiboken::Converter<QObject* >::toCpp(pyargs[4]);
                // QSettings(QSettings::Format,QSettings::Scope,QString,QString,QObject*)
                cptr = new QSettingsWrapper(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, cpp_arg4);
                Shiboken::setParent(pyargs[4], self);
            } else goto SbkQSettings_Init_TypeError;
        } else goto SbkQSettings_Init_TypeError;
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QSettings(QObject*)
        cptr = new QSettingsWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQSettings_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSettings_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSettings_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", "PySide.QtCore.QSettings.Format, PySide.QtCore.QSettings.Scope, PySide.QtCore.QString, PySide.QtCore.QString = QString(), PySide.QtCore.QObject = None", "PySide.QtCore.QSettings.Scope, PySide.QtCore.QString, PySide.QtCore.QString = QString(), PySide.QtCore.QObject = None", "PySide.QtCore.QString, PySide.QtCore.QSettings.Format, PySide.QtCore.QObject = None", "PySide.QtCore.QString, PySide.QtCore.QString = QString(), PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSettings", overloads);
        return -1;
}

static PyObject*
SbkQSettingsFunc_allKeys(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // allKeys()const
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QSettings::allKeys();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSettingsFunc_applicationName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // applicationName()const
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSettings::applicationName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSettingsFunc_beginGroup(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // beginGroup(QString)
        QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
        cppSelf->QSettings::beginGroup(*cpp_arg0);
    } else goto SbkQSettingsFunc_beginGroup_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSettingsFunc_beginGroup_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSettings.beginGroup", overloads);
        return 0;
}

static PyObject*
SbkQSettingsFunc_beginReadArray(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // beginReadArray(QString)
        QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QSettings::beginReadArray(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQSettingsFunc_beginReadArray_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSettingsFunc_beginReadArray_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSettings.beginReadArray", overloads);
        return 0;
}

static PyObject*
SbkQSettingsFunc_beginWriteArray(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "beginWriteArray", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // beginWriteArray(QString,int)
            QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
            cppSelf->QSettings::beginWriteArray(*cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // beginWriteArray(QString,int)
            QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
            cppSelf->QSettings::beginWriteArray(*cpp_arg0, cpp_arg1);
        } else goto SbkQSettingsFunc_beginWriteArray_TypeError;
    } else goto SbkQSettingsFunc_beginWriteArray_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSettingsFunc_beginWriteArray_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSettings.beginWriteArray", overloads);
        return 0;
}

static PyObject*
SbkQSettingsFunc_childGroups(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // childGroups()const
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QSettings::childGroups();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSettingsFunc_childKeys(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // childKeys()const
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QSettings::childKeys();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSettingsFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    cppSelf->QSettings::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSettingsFunc_contains(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // contains(QString)const
        QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSettings::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSettingsFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSettingsFunc_contains_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSettings.contains", overloads);
        return 0;
}

static PyObject*
SbkQSettingsFunc_defaultFormat(PyObject* self)
{
    PyObject* py_result = 0;

    // defaultFormat()
    QSettings::Format cpp_result = QSettings::defaultFormat();
    py_result = Shiboken::Converter<QSettings::Format >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSettingsFunc_endArray(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endArray()
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    cppSelf->QSettings::endArray();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSettingsFunc_endGroup(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endGroup()
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    cppSelf->QSettings::endGroup();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSettingsFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSettings::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSettingsFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSettingsFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSettings.event", overloads);
        return 0;
}

static PyObject*
SbkQSettingsFunc_fallbacksEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fallbacksEnabled()const
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSettings::fallbacksEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSettingsFunc_fileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileName()const
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSettings::fileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSettingsFunc_format(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // format()const
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    QSettings::Format cpp_result = cppSelf->QSettings::format();
    py_result = Shiboken::Converter<QSettings::Format >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSettingsFunc_group(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // group()const
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSettings::group();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSettingsFunc_isWritable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isWritable()const
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSettings::isWritable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSettingsFunc_organizationName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // organizationName()const
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSettings::organizationName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSettingsFunc_remove(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // remove(QString)
        QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
        cppSelf->QSettings::remove(*cpp_arg0);
    } else goto SbkQSettingsFunc_remove_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSettingsFunc_remove_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSettings.remove", overloads);
        return 0;
}

static PyObject*
SbkQSettingsFunc_scope(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scope()const
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    QSettings::Scope cpp_result = cppSelf->QSettings::scope();
    py_result = Shiboken::Converter<QSettings::Scope >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSettingsFunc_setArrayIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setArrayIndex(int)
        QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
        cppSelf->QSettings::setArrayIndex(cpp_arg0);
    } else goto SbkQSettingsFunc_setArrayIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSettingsFunc_setArrayIndex_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSettings.setArrayIndex", overloads);
        return 0;
}

static PyObject*
SbkQSettingsFunc_setDefaultFormat(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QSettings::Format >::isConvertible(arg)) {
        QSettings::Format cpp_arg0 = Shiboken::Converter<QSettings::Format >::toCpp(arg);
        // setDefaultFormat(QSettings::Format)
        QSettings::setDefaultFormat(cpp_arg0);
    } else goto SbkQSettingsFunc_setDefaultFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSettingsFunc_setDefaultFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSettings.Format", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSettings.setDefaultFormat", overloads);
        return 0;
}

static PyObject*
SbkQSettingsFunc_setFallbacksEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFallbacksEnabled(bool)
        QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
        cppSelf->QSettings::setFallbacksEnabled(cpp_arg0);
    } else goto SbkQSettingsFunc_setFallbacksEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSettingsFunc_setFallbacksEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSettings.setFallbacksEnabled", overloads);
        return 0;
}

static PyObject*
SbkQSettingsFunc_setIniCodec(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // setIniCodec(const char*)
        QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
        cppSelf->QSettings::setIniCodec(cpp_arg0);
    } else if (Shiboken::Converter<QTextCodec* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCodec* cpp_arg0 = Shiboken::Converter<QTextCodec* >::toCpp(arg);
        // setIniCodec(QTextCodec*)
        QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
        cppSelf->QSettings::setIniCodec(cpp_arg0);
    } else goto SbkQSettingsFunc_setIniCodec_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSettingsFunc_setIniCodec_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextCodec", "str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSettings.setIniCodec", overloads);
        return 0;
}

static PyObject*
SbkQSettingsFunc_setPath(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setPath", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QSettings::Format >::isConvertible(pyargs[0]) && Shiboken::Converter<QSettings::Scope >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        QSettings::Format cpp_arg0 = Shiboken::Converter<QSettings::Format >::toCpp(pyargs[0]);
        QSettings::Scope cpp_arg1 = Shiboken::Converter<QSettings::Scope >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // setPath(QSettings::Format,QSettings::Scope,QString)
        QSettings::setPath(cpp_arg0, cpp_arg1, *cpp_arg2);
    } else goto SbkQSettingsFunc_setPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSettingsFunc_setPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSettings.Format, PySide.QtCore.QSettings.Scope, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSettings.setPath", overloads);
        return 0;
}

static PyObject*
SbkQSettingsFunc_setValue(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setValue", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setValue(QString,QVariant)
        QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
        cppSelf->QSettings::setValue(*cpp_arg0, *cpp_arg1);
    } else goto SbkQSettingsFunc_setValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSettingsFunc_setValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSettings.setValue", overloads);
        return 0;
}

static PyObject*
SbkQSettingsFunc_status(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // status()const
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    QSettings::Status cpp_result = cppSelf->QSettings::status();
    py_result = Shiboken::Converter<QSettings::Status >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSettingsFunc_sync(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // sync()
    QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
    cppSelf->QSettings::sync();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSettingsFunc_value(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "value", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // value(QString,QVariant)const
            QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QSettings::value(*cpp_arg0);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        } else if (Shiboken::Converter<QVariant& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
            QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
            // value(QString,QVariant)const
            QSettings* cppSelf = Shiboken::Converter<QSettings* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QSettings::value(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        } else goto SbkQSettingsFunc_value_TypeError;
    } else goto SbkQSettingsFunc_value_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSettingsFunc_value_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QVariant = QVariant()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSettings.value", overloads);
        return 0;
}

static PyMethodDef SbkQSettings_methods[] = {
    {"allKeys", (PyCFunction)SbkQSettingsFunc_allKeys, METH_NOARGS},
    {"applicationName", (PyCFunction)SbkQSettingsFunc_applicationName, METH_NOARGS},
    {"beginGroup", (PyCFunction)SbkQSettingsFunc_beginGroup, METH_O},
    {"beginReadArray", (PyCFunction)SbkQSettingsFunc_beginReadArray, METH_O},
    {"beginWriteArray", (PyCFunction)SbkQSettingsFunc_beginWriteArray, METH_VARARGS},
    {"childGroups", (PyCFunction)SbkQSettingsFunc_childGroups, METH_NOARGS},
    {"childKeys", (PyCFunction)SbkQSettingsFunc_childKeys, METH_NOARGS},
    {"clear", (PyCFunction)SbkQSettingsFunc_clear, METH_NOARGS},
    {"contains", (PyCFunction)SbkQSettingsFunc_contains, METH_O},
    {"defaultFormat", (PyCFunction)SbkQSettingsFunc_defaultFormat, METH_NOARGS|METH_STATIC},
    {"endArray", (PyCFunction)SbkQSettingsFunc_endArray, METH_NOARGS},
    {"endGroup", (PyCFunction)SbkQSettingsFunc_endGroup, METH_NOARGS},
    {"event", (PyCFunction)SbkQSettingsFunc_event, METH_O},
    {"fallbacksEnabled", (PyCFunction)SbkQSettingsFunc_fallbacksEnabled, METH_NOARGS},
    {"fileName", (PyCFunction)SbkQSettingsFunc_fileName, METH_NOARGS},
    {"format", (PyCFunction)SbkQSettingsFunc_format, METH_NOARGS},
    {"group", (PyCFunction)SbkQSettingsFunc_group, METH_NOARGS},
    {"isWritable", (PyCFunction)SbkQSettingsFunc_isWritable, METH_NOARGS},
    {"organizationName", (PyCFunction)SbkQSettingsFunc_organizationName, METH_NOARGS},
    {"remove", (PyCFunction)SbkQSettingsFunc_remove, METH_O},
    {"scope", (PyCFunction)SbkQSettingsFunc_scope, METH_NOARGS},
    {"setArrayIndex", (PyCFunction)SbkQSettingsFunc_setArrayIndex, METH_O},
    {"setDefaultFormat", (PyCFunction)SbkQSettingsFunc_setDefaultFormat, METH_O|METH_STATIC},
    {"setFallbacksEnabled", (PyCFunction)SbkQSettingsFunc_setFallbacksEnabled, METH_O},
    {"setIniCodec", (PyCFunction)SbkQSettingsFunc_setIniCodec, METH_O},
    {"setPath", (PyCFunction)SbkQSettingsFunc_setPath, METH_VARARGS|METH_STATIC},
    {"setValue", (PyCFunction)SbkQSettingsFunc_setValue, METH_VARARGS},
    {"status", (PyCFunction)SbkQSettingsFunc_status, METH_NOARGS},
    {"sync", (PyCFunction)SbkQSettingsFunc_sync, METH_NOARGS},
    {"value", (PyCFunction)SbkQSettingsFunc_value, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSettings_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QSettings",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSettingsWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSettings_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSettings_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtCore_QSettings_Format_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QSettings_Format_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QSettings_Format_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Format",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QSettings_Format_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QSettings_Format_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QSettings_Format_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QSettings_Status_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QSettings_Status_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QSettings_Status_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Status",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QSettings_Status_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QSettings_Status_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QSettings_Status_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QSettings_Scope_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QSettings_Scope_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QSettings_Scope_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Scope",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QSettings_Scope_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QSettings_Scope_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QSettings_Scope_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QSettings(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSETTINGS_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSettings_Type);

    SbkQSettings_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQSettings_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQSettings_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSettings_Type));
    PyModule_AddObject(module, "QSettings",
        ((PyObject*)&SbkQSettings_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Format
    SbkPySide_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX] = &SbkPySide_QtCore_QSettings_Format_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QSettings_Format_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QSettings_Format_Type);
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
            "Format",((PyObject*)&SbkPySide_QtCore_QSettings_Format_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::NativeFormat, "NativeFormat");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "NativeFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "NativeFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::IniFormat, "IniFormat");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "IniFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "IniFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::InvalidFormat, "InvalidFormat");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "InvalidFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "InvalidFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat1, "CustomFormat1");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat1", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat2, "CustomFormat2");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat2", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat3, "CustomFormat3");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat3", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat3", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat4, "CustomFormat4");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat4", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat4", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat5, "CustomFormat5");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat5", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat5", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat6, "CustomFormat6");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat6", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat6", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat7, "CustomFormat7");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat7", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat7", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat8, "CustomFormat8");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat8", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat8", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat9, "CustomFormat9");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat9", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat9", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat10, "CustomFormat10");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat10", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat10", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat11, "CustomFormat11");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat11", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat11", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat12, "CustomFormat12");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat12", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat12", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat13, "CustomFormat13");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat13", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat13", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat14, "CustomFormat14");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat14", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat14", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat15, "CustomFormat15");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat15", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat15", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Format_Type,
        (long) QSettings::CustomFormat16, "CustomFormat16");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "CustomFormat16", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Format_Type.tp_dict,
        "CustomFormat16", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSettings::Format");

    // init enum class: Status
    SbkPySide_QtCoreTypes[SBK_QSETTINGS_STATUS_IDX] = &SbkPySide_QtCore_QSettings_Status_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QSettings_Status_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QSettings_Status_Type);
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
            "Status",((PyObject*)&SbkPySide_QtCore_QSettings_Status_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Status_Type,
        (long) QSettings::NoError, "NoError");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Status_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Status_Type,
        (long) QSettings::AccessError, "AccessError");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "AccessError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Status_Type.tp_dict,
        "AccessError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Status_Type,
        (long) QSettings::FormatError, "FormatError");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "FormatError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Status_Type.tp_dict,
        "FormatError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSettings::Status");

    // init enum class: Scope
    SbkPySide_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX] = &SbkPySide_QtCore_QSettings_Scope_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QSettings_Scope_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QSettings_Scope_Type);
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
            "Scope",((PyObject*)&SbkPySide_QtCore_QSettings_Scope_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Scope_Type,
        (long) QSettings::UserScope, "UserScope");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "UserScope", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Scope_Type.tp_dict,
        "UserScope", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSettings_Scope_Type,
        (long) QSettings::SystemScope, "SystemScope");
    PyDict_SetItemString(SbkQSettings_Type.super.ht_type.tp_dict,
        "SystemScope", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSettings_Scope_Type.tp_dict,
        "SystemScope", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSettings::Scope");

    Shiboken::TypeResolver::createObjectTypeResolver<QSettings >("QSettings*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSettings >(typeid(QSettings).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

