/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qpointf_wrapper.h"

// Extra includes
#include <qpoint.h>

using namespace Shiboken;

static int
SbkQPointF_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPointF* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QPointF", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QPointF()
        cptr = new QPointF();
    } else if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // QPointF(qreal,qreal)
        cptr = new QPointF(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // QPointF(QPoint)
        cptr = new QPointF(*cpp_arg0);
    } else goto SbkQPointF_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPointF_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQPointF_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QPoint", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QPointF", overloads);
        return -1;
}

static PyObject*
SbkQPointFFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPointF::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPointFFunc_manhattanLength(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // manhattanLength()const
    QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPointF::manhattanLength();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPointFFunc_setX(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setX(qreal)
        QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
        cppSelf->QPointF::setX(cpp_arg0);
    } else goto SbkQPointFFunc_setX_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPointFFunc_setX_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPointF.setX", overloads);
        return 0;
}

static PyObject*
SbkQPointFFunc_setY(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setY(qreal)
        QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
        cppSelf->QPointF::setY(cpp_arg0);
    } else goto SbkQPointFFunc_setY_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPointFFunc_setY_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPointF.setY", overloads);
        return 0;
}

static PyObject*
SbkQPointFFunc_toPoint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toPoint()const
    QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QPointF::toPoint();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPointFFunc_x(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x()const
    QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPointF::x();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPointFFunc_y(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y()const
    QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPointF::y();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQPointF_methods[] = {
    {"isNull", (PyCFunction)SbkQPointFFunc_isNull, METH_NOARGS},
    {"manhattanLength", (PyCFunction)SbkQPointFFunc_manhattanLength, METH_NOARGS},
    {"setX", (PyCFunction)SbkQPointFFunc_setX, METH_O},
    {"setY", (PyCFunction)SbkQPointFFunc_setY, METH_O},
    {"toPoint", (PyCFunction)SbkQPointFFunc_toPoint, METH_NOARGS},
    {"x", (PyCFunction)SbkQPointFFunc_x, METH_NOARGS},
    {"y", (PyCFunction)SbkQPointFFunc_y, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQPointFFunc___mul__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPointF_Check(arg) && !SbkQPointF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(QPointF,qreal)
        QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
        const QPointF cpp_result = (*cppSelf) * cpp_arg0;
        py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    } else if (isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(qreal,QPointF) [reverse operator]
        QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
        const QPointF cpp_result = cpp_arg0 * (*cppSelf);
        py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    } else goto SbkQPointFFunc___mul___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPointFFunc___mul___TypeError:
        const char* overloads[] = {"float", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPointF.__mul__", overloads);
        return 0;
}

static PyObject*
SbkQPointFFunc___imul__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPointF_Check(arg) && !SbkQPointF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*=(qreal)
        QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
        (*cppSelf) *= cpp_arg0;
    } else goto SbkQPointFFunc___imul___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQPointFFunc___imul___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPointF.__imul__", overloads);
        return 0;
}

static PyObject*
SbkQPointFFunc___add__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPointF_Check(arg) && !SbkQPointF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // operator+(QPointF,QPointF)
        QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
        const QPointF cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    } else goto SbkQPointFFunc___add___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPointFFunc___add___TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPointF.__add__", overloads);
        return 0;
}

static PyObject*
SbkQPointFFunc___iadd__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPointF_Check(arg) && !SbkQPointF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // operator+=(QPointF)
        QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
        (*cppSelf) += (*cpp_arg0);
    } else goto SbkQPointFFunc___iadd___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQPointFFunc___iadd___TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPointF.__iadd__", overloads);
        return 0;
}

static PyObject*
SbkQPointFFunc___neg__(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // operator-(QPointF)
    QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
    const QPointF cpp_result = - (*cppSelf);
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPointFFunc___sub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPointF_Check(arg) && !SbkQPointF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // operator-(QPointF,QPointF)
        QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
        const QPointF cpp_result = (*cppSelf) - (*cpp_arg0);
        py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    } else goto SbkQPointFFunc___sub___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPointFFunc___sub___TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPointF.__sub__", overloads);
        return 0;
}

static PyObject*
SbkQPointFFunc___isub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPointF_Check(arg) && !SbkQPointF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QPointF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!Shiboken::Converter<QPointF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // operator-=(QPointF)
        QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
        (*cppSelf) -= (*cpp_arg0);
    } else goto SbkQPointFFunc___isub___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQPointFFunc___isub___TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPointF.__isub__", overloads);
        return 0;
}

static PyObject*
SbkQPointFFunc___div__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPointF_Check(arg) && !SbkQPointF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/(QPointF,qreal)
        QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
        const QPointF cpp_result = (*cppSelf) / cpp_arg0;
        py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    } else goto SbkQPointFFunc___div___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPointFFunc___div___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPointF.__div__", overloads);
        return 0;
}

static PyObject*
SbkQPointFFunc___idiv__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPointF_Check(arg) && !SbkQPointF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/=(qreal)
        QPointF* cppSelf = Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);
        (*cppSelf) /= cpp_arg0;
    } else goto SbkQPointFFunc___idiv___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQPointFFunc___idiv___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPointF.__idiv__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQPointF_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQPointFFunc___add__,
    /*nb_subtract*/             (binaryfunc)SbkQPointFFunc___sub__,
    /*nb_multiply*/             (binaryfunc)SbkQPointFFunc___mul__,
    /*nb_divide*/               (binaryfunc)SbkQPointFFunc___div__,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)SbkQPointFFunc___neg__,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQPointFFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)SbkQPointFFunc___isub__,
    /*nb_inplace_multiply*/     (binaryfunc)SbkQPointFFunc___imul__,
    /*nb_inplace_divide*/       (binaryfunc)SbkQPointFFunc___idiv__,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQPointF_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QPointF& cpp_self = *Shiboken::Converter<QPointF* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QPointF& >::isConvertible(other)) {
                QPointF* cpp_other = Shiboken::Converter<QPointF* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QPointF >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QPointF > cpp_other_auto_ptr;
                QPointF* cpp_other = Shiboken::Converter<QPointF* >::toCpp(other);
                if (!Shiboken::Converter<QPointF >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QPointF >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQPointF_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QPointF& >::isConvertible(other)) {
                QPointF* cpp_other = Shiboken::Converter<QPointF* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QPointF >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QPointF > cpp_other_auto_ptr;
                QPointF* cpp_other = Shiboken::Converter<QPointF* >::toCpp(other);
                if (!Shiboken::Converter<QPointF >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QPointF >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQPointF_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQPointF_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPointF_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QPointF",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QPointF >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQPointF_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQPointF_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPointF_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPointF_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QPointF(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QPOINTF_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPointF_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQPointF_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPointF_Type));
    PyModule_AddObject(module, "QPointF",
        ((PyObject*)&SbkQPointF_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QPointF >("QPointF");
    Shiboken::TypeResolver::createValueTypeResolver<QPointF >(typeid(QPointF).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

