/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qpersistentmodelindex_wrapper.h"

// Extra includes
#include <qabstractitemmodel.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQPersistentModelIndex_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPersistentModelIndex* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QPersistentModelIndex", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QPersistentModelIndex()
        cptr = new QPersistentModelIndex();
    } else if (numArgs == 1 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        // QPersistentModelIndex(QModelIndex)
        cptr = new QPersistentModelIndex(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QPersistentModelIndex& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPersistentModelIndex > cpp_arg0_auto_ptr;
        QPersistentModelIndex* cpp_arg0 = Shiboken::Converter<QPersistentModelIndex* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPersistentModelIndex& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPersistentModelIndex >(cpp_arg0);
        // QPersistentModelIndex(QPersistentModelIndex)
        cptr = new QPersistentModelIndex(*cpp_arg0);
    } else goto SbkQPersistentModelIndex_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPersistentModelIndex_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQPersistentModelIndex_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QModelIndex", "PySide.QtCore.QPersistentModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QPersistentModelIndex", overloads);
        return -1;
}

static PyObject*
SbkQPersistentModelIndexFunc_child(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "child", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // child(int,int)const
        QPersistentModelIndex* cppSelf = Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QPersistentModelIndex::child(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQPersistentModelIndexFunc_child_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPersistentModelIndexFunc_child_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QPersistentModelIndex.child", overloads);
        return 0;
}

static PyObject*
SbkQPersistentModelIndexFunc_column(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // column()const
    QPersistentModelIndex* cppSelf = Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPersistentModelIndex::column();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPersistentModelIndexFunc_data(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // data(int)const
        QPersistentModelIndex* cppSelf = Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QPersistentModelIndex::data();
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // data(int)const
        QPersistentModelIndex* cppSelf = Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QPersistentModelIndex::data(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQPersistentModelIndexFunc_data_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPersistentModelIndexFunc_data_TypeError:
        const char* overloads[] = {"int = Qt.DisplayRole", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPersistentModelIndex.data", overloads);
        return 0;
}

static PyObject*
SbkQPersistentModelIndexFunc_flags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // flags()const
    QPersistentModelIndex* cppSelf = Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)self);
    QFlags<Qt::ItemFlag> cpp_result = cppSelf->QPersistentModelIndex::flags();
    py_result = Shiboken::Converter<QFlags<Qt::ItemFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPersistentModelIndexFunc_internalId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // internalId()const
    QPersistentModelIndex* cppSelf = Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QPersistentModelIndex::internalId();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPersistentModelIndexFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QPersistentModelIndex* cppSelf = Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPersistentModelIndex::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPersistentModelIndexFunc_model(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // model()const
    QPersistentModelIndex* cppSelf = Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)self);
    const QAbstractItemModel * cpp_result = cppSelf->QPersistentModelIndex::model();
    py_result = Shiboken::Converter<QAbstractItemModel* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPersistentModelIndexFunc_parent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // parent()const
    QPersistentModelIndex* cppSelf = Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)self);
    QModelIndex cpp_result = cppSelf->QPersistentModelIndex::parent();
    py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPersistentModelIndexFunc_row(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // row()const
    QPersistentModelIndex* cppSelf = Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPersistentModelIndex::row();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPersistentModelIndexFunc_sibling(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sibling", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // sibling(int,int)const
        QPersistentModelIndex* cppSelf = Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QPersistentModelIndex::sibling(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQPersistentModelIndexFunc_sibling_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPersistentModelIndexFunc_sibling_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QPersistentModelIndex.sibling", overloads);
        return 0;
}

static PyMethodDef SbkQPersistentModelIndex_methods[] = {
    {"child", (PyCFunction)SbkQPersistentModelIndexFunc_child, METH_VARARGS},
    {"column", (PyCFunction)SbkQPersistentModelIndexFunc_column, METH_NOARGS},
    {"data", (PyCFunction)SbkQPersistentModelIndexFunc_data, METH_NOARGS|METH_O},
    {"flags", (PyCFunction)SbkQPersistentModelIndexFunc_flags, METH_NOARGS},
    {"internalId", (PyCFunction)SbkQPersistentModelIndexFunc_internalId, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQPersistentModelIndexFunc_isValid, METH_NOARGS},
    {"model", (PyCFunction)SbkQPersistentModelIndexFunc_model, METH_NOARGS},
    {"parent", (PyCFunction)SbkQPersistentModelIndexFunc_parent, METH_NOARGS},
    {"row", (PyCFunction)SbkQPersistentModelIndexFunc_row, METH_NOARGS},
    {"sibling", (PyCFunction)SbkQPersistentModelIndexFunc_sibling, METH_VARARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQPersistentModelIndex_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QPersistentModelIndex& cpp_self = *Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QModelIndex& >::isConvertible(other)) {
                QModelIndex* cpp_other = Shiboken::Converter<QModelIndex* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QPersistentModelIndex& >::isConvertible(other)) {
                QPersistentModelIndex* cpp_other = Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QPersistentModelIndex >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QPersistentModelIndex > cpp_other_auto_ptr;
                QPersistentModelIndex* cpp_other = Shiboken::Converter<QPersistentModelIndex* >::toCpp(other);
                if (!Shiboken::Converter<QPersistentModelIndex >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QPersistentModelIndex >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQPersistentModelIndex_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QPersistentModelIndex& >::isConvertible(other)) {
                QPersistentModelIndex* cpp_other = Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)other);
                result = (cpp_self < (*cpp_other));
            } else if (Shiboken::Converter<QPersistentModelIndex >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QPersistentModelIndex > cpp_other_auto_ptr;
                QPersistentModelIndex* cpp_other = Shiboken::Converter<QPersistentModelIndex* >::toCpp(other);
                if (!Shiboken::Converter<QPersistentModelIndex >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QPersistentModelIndex >(cpp_other);
                result = (cpp_self < (*cpp_other));
            } else goto SbkQPersistentModelIndex_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QModelIndex& >::isConvertible(other)) {
                QModelIndex* cpp_other = Shiboken::Converter<QModelIndex* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QPersistentModelIndex& >::isConvertible(other)) {
                QPersistentModelIndex* cpp_other = Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QPersistentModelIndex >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QPersistentModelIndex > cpp_other_auto_ptr;
                QPersistentModelIndex* cpp_other = Shiboken::Converter<QPersistentModelIndex* >::toCpp(other);
                if (!Shiboken::Converter<QPersistentModelIndex >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QPersistentModelIndex >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQPersistentModelIndex_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQPersistentModelIndex_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPersistentModelIndex_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QPersistentModelIndex",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QPersistentModelIndex >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQPersistentModelIndex_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPersistentModelIndex_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPersistentModelIndex_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QPersistentModelIndex(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPersistentModelIndex_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQPersistentModelIndex_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPersistentModelIndex_Type));
    PyModule_AddObject(module, "QPersistentModelIndex",
        ((PyObject*)&SbkQPersistentModelIndex_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QPersistentModelIndex >("QPersistentModelIndex");
    Shiboken::TypeResolver::createValueTypeResolver<QPersistentModelIndex >(typeid(QPersistentModelIndex).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

