/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qmutexlocker_wrapper.h"

// Extra includes
#include <qmutex.h>

using namespace Shiboken;

static int
SbkQMutexLocker_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMutexLocker* cptr = 0;
    Shiboken::ThreadStateSaver thread_state_saver;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QMutexLocker", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QMutex* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QMutex* cpp_arg0 = Shiboken::Converter<QMutex* >::toCpp(pyargs[0]);
        // QMutexLocker(QMutex*)
        thread_state_saver.save();
        cptr = new QMutexLocker(cpp_arg0);
        thread_state_saver.restore();
    } else goto SbkQMutexLocker_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQMutexLocker_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQMutexLocker_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMutex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QMutexLocker", overloads);
        return -1;
}

static PyObject*
SbkQMutexLockerFunc_mutex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mutex()const
    QMutexLocker* cppSelf = Shiboken::Converter<QMutexLocker* >::toCpp((PyObject*)self);
    QMutex * cpp_result = cppSelf->QMutexLocker::mutex();
    py_result = Shiboken::Converter<QMutex* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMutexLockerFunc_relock(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    // relock()
    QMutexLocker* cppSelf = Shiboken::Converter<QMutexLocker* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    cppSelf->QMutexLocker::relock();
    thread_state_saver.restore();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQMutexLockerFunc_unlock(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // unlock()
    QMutexLocker* cppSelf = Shiboken::Converter<QMutexLocker* >::toCpp((PyObject*)self);
    cppSelf->QMutexLocker::unlock();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQMutexLocker_methods[] = {
    {"mutex", (PyCFunction)SbkQMutexLockerFunc_mutex, METH_NOARGS},
    {"relock", (PyCFunction)SbkQMutexLockerFunc_relock, METH_NOARGS},
    {"unlock", (PyCFunction)SbkQMutexLockerFunc_unlock, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMutexLocker_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QMutexLocker",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QMutexLocker >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMutexLocker_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMutexLocker_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QMutexLocker(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QMUTEXLOCKER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMutexLocker_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQMutexLocker_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMutexLocker_Type));
    PyModule_AddObject(module, "QMutexLocker",
        ((PyObject*)&SbkQMutexLocker_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QMutexLocker >("QMutexLocker*");
    Shiboken::TypeResolver::createObjectTypeResolver<QMutexLocker >(typeid(QMutexLocker).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

