/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qmimedata_wrapper.h"

// Extra includes
#include <QList>
#include <QStringList>
#include <QUrl>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qurl.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QMimeDataWrapper::QMimeDataWrapper() : QMimeData(), m_metaObject(0) {
    // ... middle
}

void QMimeDataWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMimeDataWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMimeDataWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMimeDataWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QMimeDataWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMimeData.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QMimeDataWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMimeData.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

QStringList QMimeDataWrapper::formats() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "formats"));
    if (py_override.isNull()) {
        return this->QMimeData::formats();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMimeData.formats");
        return QStringList()        ;
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

bool QMimeDataWrapper::hasFormat(const QString & mimetype) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasFormat"));
    if (py_override.isNull()) {
        return this->QMimeData::hasFormat(mimetype);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(mimetype)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMimeData.hasFormat");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QVariant QMimeDataWrapper::retrieveData(const QString & mimetype, QVariant::Type preferredType) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "retrieveData"));
    if (py_override.isNull()) {
        return this->QMimeData::retrieveData(mimetype, preferredType);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(mimetype),
        Shiboken::Converter<QVariant::Type >::toPython(preferredType)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QMimeData.retrieveData");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QMimeDataWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QMimeDataWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QMimeData::staticMetaObject);
}
    return m_metaObject;
}

int QMimeDataWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QMimeData::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QMimeDataWrapper::~QMimeDataWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQMimeData_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMimeDataWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QMimeData()
    cptr = new QMimeDataWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQMimeDataFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
    cppSelf->QMimeData::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQMimeDataFunc_colorData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // colorData()const
    QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QMimeData::colorData();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMimeDataFunc_data(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // data(QString)const
        QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QMimeData::data(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQMimeDataFunc_data_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMimeDataFunc_data_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMimeData.data", overloads);
        return 0;
}

static PyObject*
SbkQMimeDataFunc_formats(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // formats()const
    QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QMimeData::formats();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMimeDataFunc_hasColor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasColor()const
    QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMimeData::hasColor();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMimeDataFunc_hasFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // hasFormat(QString)const
        QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMimeData::hasFormat(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQMimeDataFunc_hasFormat_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMimeDataFunc_hasFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMimeData.hasFormat", overloads);
        return 0;
}

static PyObject*
SbkQMimeDataFunc_hasHtml(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasHtml()const
    QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMimeData::hasHtml();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMimeDataFunc_hasImage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasImage()const
    QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMimeData::hasImage();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMimeDataFunc_hasText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasText()const
    QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMimeData::hasText();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMimeDataFunc_hasUrls(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasUrls()const
    QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMimeData::hasUrls();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMimeDataFunc_html(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // html()const
    QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QMimeData::html();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMimeDataFunc_imageData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // imageData()const
    QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QMimeData::imageData();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMimeDataFunc_removeFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeFormat(QString)
        QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
        cppSelf->QMimeData::removeFormat(*cpp_arg0);
    } else goto SbkQMimeDataFunc_removeFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMimeDataFunc_removeFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMimeData.removeFormat", overloads);
        return 0;
}

static PyObject*
SbkQMimeDataFunc_retrieveData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "retrieveData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant::Type >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QVariant::Type cpp_arg1 = Shiboken::Converter<QVariant::Type >::toCpp(pyargs[1]);
        // retrieveData(QString,QVariant::Type)const
        QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QMimeData::retrieveData(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQMimeDataFunc_retrieveData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMimeDataFunc_retrieveData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QVariant.Type", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QMimeData.retrieveData", overloads);
        return 0;
}

static PyObject*
SbkQMimeDataFunc_setColorData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVariant& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!Shiboken::Converter<QVariant& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // setColorData(QVariant)
        QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
        cppSelf->QMimeData::setColorData(*cpp_arg0);
    } else goto SbkQMimeDataFunc_setColorData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMimeDataFunc_setColorData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMimeData.setColorData", overloads);
        return 0;
}

static PyObject*
SbkQMimeDataFunc_setData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
        QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
        // setData(QString,QByteArray)
        QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
        cppSelf->QMimeData::setData(*cpp_arg0, *cpp_arg1);
    } else goto SbkQMimeDataFunc_setData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMimeDataFunc_setData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QMimeData.setData", overloads);
        return 0;
}

static PyObject*
SbkQMimeDataFunc_setHtml(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setHtml(QString)
        QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
        cppSelf->QMimeData::setHtml(*cpp_arg0);
    } else goto SbkQMimeDataFunc_setHtml_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMimeDataFunc_setHtml_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMimeData.setHtml", overloads);
        return 0;
}

static PyObject*
SbkQMimeDataFunc_setImageData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVariant& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!Shiboken::Converter<QVariant& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // setImageData(QVariant)
        QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
        cppSelf->QMimeData::setImageData(*cpp_arg0);
    } else goto SbkQMimeDataFunc_setImageData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMimeDataFunc_setImageData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMimeData.setImageData", overloads);
        return 0;
}

static PyObject*
SbkQMimeDataFunc_setText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setText(QString)
        QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
        cppSelf->QMimeData::setText(*cpp_arg0);
    } else goto SbkQMimeDataFunc_setText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMimeDataFunc_setText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMimeData.setText", overloads);
        return 0;
}

static PyObject*
SbkQMimeDataFunc_setUrls(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QUrl >  >::isConvertible(arg)) {
        QList<QUrl >  cpp_arg0 = Shiboken::Converter<QList<QUrl >  >::toCpp(arg);
        // setUrls(QList<QUrl>)
        QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
        cppSelf->QMimeData::setUrls(cpp_arg0);
    } else goto SbkQMimeDataFunc_setUrls_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMimeDataFunc_setUrls_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMimeData.setUrls", overloads);
        return 0;
}

static PyObject*
SbkQMimeDataFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QMimeData::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMimeDataFunc_urls(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // urls()const
    QMimeData* cppSelf = Shiboken::Converter<QMimeData* >::toCpp((PyObject*)self);
    QList<QUrl > cpp_result = cppSelf->QMimeData::urls();
    py_result = Shiboken::Converter<QList<QUrl > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQMimeData_methods[] = {
    {"clear", (PyCFunction)SbkQMimeDataFunc_clear, METH_NOARGS},
    {"colorData", (PyCFunction)SbkQMimeDataFunc_colorData, METH_NOARGS},
    {"data", (PyCFunction)SbkQMimeDataFunc_data, METH_O},
    {"formats", (PyCFunction)SbkQMimeDataFunc_formats, METH_NOARGS},
    {"hasColor", (PyCFunction)SbkQMimeDataFunc_hasColor, METH_NOARGS},
    {"hasFormat", (PyCFunction)SbkQMimeDataFunc_hasFormat, METH_O},
    {"hasHtml", (PyCFunction)SbkQMimeDataFunc_hasHtml, METH_NOARGS},
    {"hasImage", (PyCFunction)SbkQMimeDataFunc_hasImage, METH_NOARGS},
    {"hasText", (PyCFunction)SbkQMimeDataFunc_hasText, METH_NOARGS},
    {"hasUrls", (PyCFunction)SbkQMimeDataFunc_hasUrls, METH_NOARGS},
    {"html", (PyCFunction)SbkQMimeDataFunc_html, METH_NOARGS},
    {"imageData", (PyCFunction)SbkQMimeDataFunc_imageData, METH_NOARGS},
    {"removeFormat", (PyCFunction)SbkQMimeDataFunc_removeFormat, METH_O},
    {"retrieveData", (PyCFunction)SbkQMimeDataFunc_retrieveData, METH_VARARGS},
    {"setColorData", (PyCFunction)SbkQMimeDataFunc_setColorData, METH_O},
    {"setData", (PyCFunction)SbkQMimeDataFunc_setData, METH_VARARGS},
    {"setHtml", (PyCFunction)SbkQMimeDataFunc_setHtml, METH_O},
    {"setImageData", (PyCFunction)SbkQMimeDataFunc_setImageData, METH_O},
    {"setText", (PyCFunction)SbkQMimeDataFunc_setText, METH_O},
    {"setUrls", (PyCFunction)SbkQMimeDataFunc_setUrls, METH_O},
    {"text", (PyCFunction)SbkQMimeDataFunc_text, METH_NOARGS},
    {"urls", (PyCFunction)SbkQMimeDataFunc_urls, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMimeData_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QMimeData",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QMimeDataWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMimeData_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMimeData_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QMimeData(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QMIMEDATA_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMimeData_Type);

    SbkQMimeData_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQMimeData_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQMimeData_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMimeData_Type));
    PyModule_AddObject(module, "QMimeData",
        ((PyObject*)&SbkQMimeData_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QMimeData >("QMimeData*");
    Shiboken::TypeResolver::createObjectTypeResolver<QMimeData >(typeid(QMimeData).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

