/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qlibraryinfo_wrapper.h"

// Extra includes
#include <qdatetime.h>
#include <qstring.h>

using namespace Shiboken;

static PyObject*
SbkQLibraryInfoFunc_buildDate(PyObject* self)
{
    PyObject* py_result = 0;

    // buildDate()
    QDate cpp_result = QLibraryInfo::buildDate();
    py_result = Shiboken::Converter<QDate >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLibraryInfoFunc_buildKey(PyObject* self)
{
    PyObject* py_result = 0;

    // buildKey()
    QString cpp_result = QLibraryInfo::buildKey();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLibraryInfoFunc_licensedProducts(PyObject* self)
{
    PyObject* py_result = 0;

    // licensedProducts()
    QString cpp_result = QLibraryInfo::licensedProducts();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLibraryInfoFunc_licensee(PyObject* self)
{
    PyObject* py_result = 0;

    // licensee()
    QString cpp_result = QLibraryInfo::licensee();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLibraryInfoFunc_location(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QLibraryInfo::LibraryLocation >::isConvertible(arg)) {
        QLibraryInfo::LibraryLocation cpp_arg0 = Shiboken::Converter<QLibraryInfo::LibraryLocation >::toCpp(arg);
        // location(QLibraryInfo::LibraryLocation)
        QString cpp_result = QLibraryInfo::location(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQLibraryInfoFunc_location_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQLibraryInfoFunc_location_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLibraryInfo.LibraryLocation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLibraryInfo.location", overloads);
        return 0;
}

static PyMethodDef SbkQLibraryInfo_methods[] = {
    {"buildDate", (PyCFunction)SbkQLibraryInfoFunc_buildDate, METH_NOARGS|METH_STATIC},
    {"buildKey", (PyCFunction)SbkQLibraryInfoFunc_buildKey, METH_NOARGS|METH_STATIC},
    {"licensedProducts", (PyCFunction)SbkQLibraryInfoFunc_licensedProducts, METH_NOARGS|METH_STATIC},
    {"licensee", (PyCFunction)SbkQLibraryInfoFunc_licensee, METH_NOARGS|METH_STATIC},
    {"location", (PyCFunction)SbkQLibraryInfoFunc_location, METH_O|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQLibraryInfo_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QLibraryInfo",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QLibraryInfo >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQLibraryInfo_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtCore_QLibraryInfo_LibraryLocation_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QLibraryInfo_LibraryLocation_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "LibraryLocation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QLibraryInfo_LibraryLocation_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QLibraryInfo_LibraryLocation_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QLibraryInfo_LibraryLocation_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QLibraryInfo(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QLIBRARYINFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQLibraryInfo_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQLibraryInfo_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQLibraryInfo_Type));
    PyModule_AddObject(module, "QLibraryInfo",
        ((PyObject*)&SbkQLibraryInfo_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: LibraryLocation
    SbkPySide_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX] = &SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type);
    PyDict_SetItemString(SbkQLibraryInfo_Type.super.ht_type.tp_dict,
            "LibraryLocation",((PyObject*)&SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type,
        (long) QLibraryInfo::PrefixPath, "PrefixPath");
    PyDict_SetItemString(SbkQLibraryInfo_Type.super.ht_type.tp_dict,
        "PrefixPath", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type.tp_dict,
        "PrefixPath", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type,
        (long) QLibraryInfo::DocumentationPath, "DocumentationPath");
    PyDict_SetItemString(SbkQLibraryInfo_Type.super.ht_type.tp_dict,
        "DocumentationPath", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type.tp_dict,
        "DocumentationPath", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type,
        (long) QLibraryInfo::HeadersPath, "HeadersPath");
    PyDict_SetItemString(SbkQLibraryInfo_Type.super.ht_type.tp_dict,
        "HeadersPath", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type.tp_dict,
        "HeadersPath", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type,
        (long) QLibraryInfo::LibrariesPath, "LibrariesPath");
    PyDict_SetItemString(SbkQLibraryInfo_Type.super.ht_type.tp_dict,
        "LibrariesPath", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type.tp_dict,
        "LibrariesPath", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type,
        (long) QLibraryInfo::BinariesPath, "BinariesPath");
    PyDict_SetItemString(SbkQLibraryInfo_Type.super.ht_type.tp_dict,
        "BinariesPath", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type.tp_dict,
        "BinariesPath", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type,
        (long) QLibraryInfo::PluginsPath, "PluginsPath");
    PyDict_SetItemString(SbkQLibraryInfo_Type.super.ht_type.tp_dict,
        "PluginsPath", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type.tp_dict,
        "PluginsPath", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type,
        (long) QLibraryInfo::DataPath, "DataPath");
    PyDict_SetItemString(SbkQLibraryInfo_Type.super.ht_type.tp_dict,
        "DataPath", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type.tp_dict,
        "DataPath", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type,
        (long) QLibraryInfo::TranslationsPath, "TranslationsPath");
    PyDict_SetItemString(SbkQLibraryInfo_Type.super.ht_type.tp_dict,
        "TranslationsPath", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type.tp_dict,
        "TranslationsPath", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type,
        (long) QLibraryInfo::SettingsPath, "SettingsPath");
    PyDict_SetItemString(SbkQLibraryInfo_Type.super.ht_type.tp_dict,
        "SettingsPath", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type.tp_dict,
        "SettingsPath", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type,
        (long) QLibraryInfo::DemosPath, "DemosPath");
    PyDict_SetItemString(SbkQLibraryInfo_Type.super.ht_type.tp_dict,
        "DemosPath", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type.tp_dict,
        "DemosPath", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type,
        (long) QLibraryInfo::ExamplesPath, "ExamplesPath");
    PyDict_SetItemString(SbkQLibraryInfo_Type.super.ht_type.tp_dict,
        "ExamplesPath", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Type.tp_dict,
        "ExamplesPath", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QLibraryInfo::LibraryLocation");

    Shiboken::TypeResolver::createObjectTypeResolver<QLibraryInfo >("QLibraryInfo*");
    Shiboken::TypeResolver::createObjectTypeResolver<QLibraryInfo >(typeid(QLibraryInfo).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

