/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qiodevice_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qiodevice.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QIODeviceWrapper::QIODeviceWrapper() : QIODevice(), m_metaObject(0) {
    // ... middle
}

QIODeviceWrapper::QIODeviceWrapper(QObject * parent) : QIODevice(parent), m_metaObject(0) {
    // ... middle
}

bool QIODeviceWrapper::atEnd() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "atEnd"));
    if (py_override.isNull()) {
        return this->QIODevice::atEnd();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.atEnd");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QIODeviceWrapper::bytesAvailable() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bytesAvailable"));
    if (py_override.isNull()) {
        return this->QIODevice::bytesAvailable();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.bytesAvailable");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QIODeviceWrapper::bytesToWrite() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bytesToWrite"));
    if (py_override.isNull()) {
        return this->QIODevice::bytesToWrite();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.bytesToWrite");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QIODeviceWrapper::canReadLine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canReadLine"));
    if (py_override.isNull()) {
        return this->QIODevice::canReadLine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.canReadLine");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QIODeviceWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QIODeviceWrapper::close()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "close"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::close();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QIODeviceWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QIODeviceWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QIODeviceWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QIODeviceWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QIODeviceWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

bool QIODeviceWrapper::isSequential() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isSequential"));
    if (py_override.isNull()) {
        return this->QIODevice::isSequential();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.isSequential");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QIODeviceWrapper::open(QFlags<QIODevice::OpenModeFlag> mode)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "open"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::open(mode);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toPython(mode)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.open");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QIODeviceWrapper::pos() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pos"));
    if (py_override.isNull()) {
        return this->QIODevice::pos();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.pos");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QIODeviceWrapper::readData(char * data, qint64 maxlen)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "readData"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QIODevice.readData()' not implemented.");
        return qint64(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(maxlen)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.readData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QIODeviceWrapper::readLineData(char * data, qint64 maxlen)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "readLineData"));
    if (py_override.isNull()) {
        return this->QIODevice::readLineData(data, maxlen);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(maxlen)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.readLineData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QIODeviceWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QIODevice::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.reset");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QIODeviceWrapper::seek(qint64 pos)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "seek"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::seek(pos);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(L)",
        Shiboken::Converter<long long >::toPython(pos)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.seek");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QIODeviceWrapper::size() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "size"));
    if (py_override.isNull()) {
        return this->QIODevice::size();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.size");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

void QIODeviceWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QIODeviceWrapper::waitForBytesWritten(int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForBytesWritten"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::waitForBytesWritten(msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msecs
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.waitForBytesWritten");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QIODeviceWrapper::waitForReadyRead(int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForReadyRead"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::waitForReadyRead(msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msecs
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.waitForReadyRead");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QIODeviceWrapper::writeData(const char * data, qint64 len)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "writeData"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QIODevice.writeData()' not implemented.");
        return qint64(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(len)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIODevice.writeData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QIODeviceWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QIODevice::staticMetaObject);
}
    return m_metaObject;
}

int QIODeviceWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QIODevice::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QIODeviceWrapper::~QIODeviceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQIODevice_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QIODeviceWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QIODEVICE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QIODevice' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QIODevice", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QIODevice()
        cptr = new QIODeviceWrapper();
    } else if (numArgs == 1 && Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QIODevice(QObject*)
        cptr = new QIODeviceWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQIODevice_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQIODevice_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQIODevice_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QIODevice", overloads);
        return -1;
}

static PyObject*
SbkQIODeviceFunc_atEnd(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // atEnd()const
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QIODevice::atEnd();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_bytesAvailable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesAvailable()const
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QIODevice::bytesAvailable();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_bytesToWrite(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesToWrite()const
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QIODevice::bytesToWrite();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_canReadLine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canReadLine()const
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QIODevice::canReadLine();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    // close()
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    cppSelf->QIODevice::close();
    thread_state_saver.restore();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQIODeviceFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QIODevice::errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_getChar(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // getChar(char*)
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    // Begin code injection
    
    // TEMPLATE - fix_char* - START
    char val_;
    bool retval_ = cppSelf->getChar(&val_);
    py_result = Shiboken::makeTuple(retval_, val_);
    // TEMPLATE - fix_char* - END
    
    // End of code injection



    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_isOpen(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isOpen()const
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QIODevice::isOpen();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_isReadable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isReadable()const
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QIODevice::isReadable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_isSequential(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSequential()const
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QIODevice::isSequential();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_isTextModeEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isTextModeEnabled()const
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QIODevice::isTextModeEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_isWritable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isWritable()const
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QIODevice::isWritable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_open(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(arg)) {
        QFlags<QIODevice::OpenModeFlag> cpp_arg0 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(arg);
        // open(QFlags<QIODevice::OpenModeFlag>)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QIODevice::open(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQIODeviceFunc_open_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIODeviceFunc_open_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice.OpenMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QIODevice.open", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_openMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // openMode()const
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    QFlags<QIODevice::OpenModeFlag> cpp_result = cppSelf->QIODevice::openMode();
    py_result = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_peek(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // peek(qint64)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        QByteArray cpp_result = cppSelf->QIODevice::peek(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQIODeviceFunc_peek_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIODeviceFunc_peek_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QIODevice.peek", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QIODevice::pos();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_putChar(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // putChar(char)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QIODevice::putChar(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQIODeviceFunc_putChar_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIODeviceFunc_putChar_TypeError:
        const char* overloads[] = {"char", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QIODevice.putChar", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_read(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // read(qint64)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QIODevice::read(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQIODeviceFunc_read_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIODeviceFunc_read_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QIODevice.read", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_readAll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // readAll()
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    QByteArray cpp_result = cppSelf->QIODevice::readAll();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_readData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "readData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        char * cpp_arg0 = Shiboken::Converter<char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // readData(char*,qint64)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QIODevice.readData()' not implemented.");
            return 0;
        }
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->readData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQIODeviceFunc_readData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIODeviceFunc_readData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QIODevice.readData", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_readLine(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // readLine(qint64)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QIODevice::readLine();
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // readLine(qint64)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QIODevice::readLine(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQIODeviceFunc_readLine_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIODeviceFunc_readLine_TypeError:
        const char* overloads[] = {"long long = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QIODevice.readLine", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_readLineData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "readLineData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        char * cpp_arg0 = Shiboken::Converter<char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // readLineData(char*,qint64)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QIODevice::readLineData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQIODeviceFunc_readLineData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIODeviceFunc_readLineData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QIODevice.readLineData", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // reset()
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QIODevice::reset();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_seek(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // seek(qint64)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QIODevice::seek(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQIODeviceFunc_seek_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIODeviceFunc_seek_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QIODevice.seek", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_setErrorString(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setErrorString(QString)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        cppSelf->QIODevice::setErrorString(*cpp_arg0);
    } else goto SbkQIODeviceFunc_setErrorString_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQIODeviceFunc_setErrorString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QIODevice.setErrorString", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_setOpenMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(arg)) {
        QFlags<QIODevice::OpenModeFlag> cpp_arg0 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(arg);
        // setOpenMode(QFlags<QIODevice::OpenModeFlag>)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        cppSelf->QIODevice::setOpenMode(cpp_arg0);
    } else goto SbkQIODeviceFunc_setOpenMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQIODeviceFunc_setOpenMode_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice.OpenMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QIODevice.setOpenMode", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_setTextModeEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setTextModeEnabled(bool)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        cppSelf->QIODevice::setTextModeEnabled(cpp_arg0);
    } else goto SbkQIODeviceFunc_setTextModeEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQIODeviceFunc_setTextModeEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QIODevice.setTextModeEnabled", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QIODevice::size();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQIODeviceFunc_ungetChar(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // ungetChar(char)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        cppSelf->QIODevice::ungetChar(cpp_arg0);
    } else goto SbkQIODeviceFunc_ungetChar_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQIODeviceFunc_ungetChar_TypeError:
        const char* overloads[] = {"char", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QIODevice.ungetChar", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_waitForBytesWritten(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForBytesWritten(int)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QIODevice::waitForBytesWritten(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQIODeviceFunc_waitForBytesWritten_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIODeviceFunc_waitForBytesWritten_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QIODevice.waitForBytesWritten", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_waitForReadyRead(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForReadyRead(int)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QIODevice::waitForReadyRead(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQIODeviceFunc_waitForReadyRead_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIODeviceFunc_waitForReadyRead_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QIODevice.waitForReadyRead", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_write(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // write(const char*)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QIODevice::write(cpp_arg0);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // write(QByteArray)
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        qint64 cpp_result = cppSelf->QIODevice::write(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQIODeviceFunc_write_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIODeviceFunc_write_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", "str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QIODevice.write", overloads);
        return 0;
}

static PyObject*
SbkQIODeviceFunc_writeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "writeData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // writeData(const char*,qint64)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QIODevice.writeData()' not implemented.");
            return 0;
        }
        QIODevice* cppSelf = Shiboken::Converter<QIODevice* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->writeData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQIODeviceFunc_writeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIODeviceFunc_writeData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QIODevice.writeData", overloads);
        return 0;
}

static PyMethodDef SbkQIODevice_methods[] = {
    {"atEnd", (PyCFunction)SbkQIODeviceFunc_atEnd, METH_NOARGS},
    {"bytesAvailable", (PyCFunction)SbkQIODeviceFunc_bytesAvailable, METH_NOARGS},
    {"bytesToWrite", (PyCFunction)SbkQIODeviceFunc_bytesToWrite, METH_NOARGS},
    {"canReadLine", (PyCFunction)SbkQIODeviceFunc_canReadLine, METH_NOARGS},
    {"close", (PyCFunction)SbkQIODeviceFunc_close, METH_NOARGS},
    {"errorString", (PyCFunction)SbkQIODeviceFunc_errorString, METH_NOARGS},
    {"getChar", (PyCFunction)SbkQIODeviceFunc_getChar, METH_NOARGS},
    {"isOpen", (PyCFunction)SbkQIODeviceFunc_isOpen, METH_NOARGS},
    {"isReadable", (PyCFunction)SbkQIODeviceFunc_isReadable, METH_NOARGS},
    {"isSequential", (PyCFunction)SbkQIODeviceFunc_isSequential, METH_NOARGS},
    {"isTextModeEnabled", (PyCFunction)SbkQIODeviceFunc_isTextModeEnabled, METH_NOARGS},
    {"isWritable", (PyCFunction)SbkQIODeviceFunc_isWritable, METH_NOARGS},
    {"open", (PyCFunction)SbkQIODeviceFunc_open, METH_O},
    {"openMode", (PyCFunction)SbkQIODeviceFunc_openMode, METH_NOARGS},
    {"peek", (PyCFunction)SbkQIODeviceFunc_peek, METH_O},
    {"pos", (PyCFunction)SbkQIODeviceFunc_pos, METH_NOARGS},
    {"putChar", (PyCFunction)SbkQIODeviceFunc_putChar, METH_O},
    {"read", (PyCFunction)SbkQIODeviceFunc_read, METH_O},
    {"readAll", (PyCFunction)SbkQIODeviceFunc_readAll, METH_NOARGS},
    {"readData", (PyCFunction)SbkQIODeviceFunc_readData, METH_VARARGS},
    {"readLine", (PyCFunction)SbkQIODeviceFunc_readLine, METH_NOARGS|METH_O},
    {"readLineData", (PyCFunction)SbkQIODeviceFunc_readLineData, METH_VARARGS},
    {"reset", (PyCFunction)SbkQIODeviceFunc_reset, METH_NOARGS},
    {"seek", (PyCFunction)SbkQIODeviceFunc_seek, METH_O},
    {"setErrorString", (PyCFunction)SbkQIODeviceFunc_setErrorString, METH_O},
    {"setOpenMode", (PyCFunction)SbkQIODeviceFunc_setOpenMode, METH_O},
    {"setTextModeEnabled", (PyCFunction)SbkQIODeviceFunc_setTextModeEnabled, METH_O},
    {"size", (PyCFunction)SbkQIODeviceFunc_size, METH_NOARGS},
    {"ungetChar", (PyCFunction)SbkQIODeviceFunc_ungetChar, METH_O},
    {"waitForBytesWritten", (PyCFunction)SbkQIODeviceFunc_waitForBytesWritten, METH_O},
    {"waitForReadyRead", (PyCFunction)SbkQIODeviceFunc_waitForReadyRead, METH_O},
    {"write", (PyCFunction)SbkQIODeviceFunc_write, METH_O},
    {"writeData", (PyCFunction)SbkQIODeviceFunc_writeData, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQIODevice_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QIODevice",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QIODeviceWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQIODevice_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQIODevice_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

PyObject*
SbkPySide_QtCore_QIODevice_OpenModeFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QIODevice::OpenMode >::toPython(
        ((QIODevice::OpenMode) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QIODevice::OpenMode >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QIODevice_OpenModeFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QIODevice::OpenMode >::toPython(
        ((QIODevice::OpenMode) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QIODevice::OpenMode >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QIODevice_OpenModeFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QIODevice::OpenMode >::toPython(
        ((QIODevice::OpenMode) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QIODevice::OpenMode >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QIODevice_OpenModeFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QIODevice::OpenMode >::toPython(
        ~ Shiboken::Converter< QIODevice::OpenMode >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_QIODevice_OpenModeFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_QIODevice_OpenModeFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_QIODevice_OpenModeFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_QIODevice_OpenModeFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_QIODevice_OpenModeFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_QIODevice_OpenModeFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QIODevice_OpenModeFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QIODevice_OpenModeFlag_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "OpenModeFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_QIODevice_OpenModeFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QIODevice_OpenModeFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QIODevice_OpenModeFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QIODevice_OpenModeFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QIODevice_OpenMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QIODevice_OpenMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "OpenMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_QIODevice_OpenModeFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QIODevice_OpenMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QIODevice_OpenMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_QIODevice_OpenMode_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void)
init_QIODevice(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QIODEVICE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQIODevice_Type);

    SbkQIODevice_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQIODevice_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQIODevice_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQIODevice_Type));
    PyModule_AddObject(module, "QIODevice",
        ((PyObject*)&SbkQIODevice_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: OpenModeFlag
    SbkPySide_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX] = &SbkPySide_QtCore_QIODevice_OpenModeFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QIODevice_OpenModeFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QIODevice_OpenModeFlag_Type);
    PyDict_SetItemString(SbkQIODevice_Type.super.ht_type.tp_dict,
            "OpenModeFlag",((PyObject*)&SbkPySide_QtCore_QIODevice_OpenModeFlag_Type));

    // init flags class: QFlags<QIODevice::OpenModeFlag>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG__IDX] = &SbkPySide_QtCore_QIODevice_OpenMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QIODevice_OpenMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QIODevice_OpenMode_Type);
    PyDict_SetItemString(SbkQIODevice_Type.super.ht_type.tp_dict,
            "OpenMode",((PyObject*)&SbkPySide_QtCore_QIODevice_OpenMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QIODevice_OpenModeFlag_Type,
        (long) QIODevice::NotOpen, "NotOpen");
    PyDict_SetItemString(SbkQIODevice_Type.super.ht_type.tp_dict,
        "NotOpen", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QIODevice_OpenModeFlag_Type.tp_dict,
        "NotOpen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QIODevice_OpenModeFlag_Type,
        (long) QIODevice::ReadOnly, "ReadOnly");
    PyDict_SetItemString(SbkQIODevice_Type.super.ht_type.tp_dict,
        "ReadOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QIODevice_OpenModeFlag_Type.tp_dict,
        "ReadOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QIODevice_OpenModeFlag_Type,
        (long) QIODevice::WriteOnly, "WriteOnly");
    PyDict_SetItemString(SbkQIODevice_Type.super.ht_type.tp_dict,
        "WriteOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QIODevice_OpenModeFlag_Type.tp_dict,
        "WriteOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QIODevice_OpenModeFlag_Type,
        (long) QIODevice::ReadWrite, "ReadWrite");
    PyDict_SetItemString(SbkQIODevice_Type.super.ht_type.tp_dict,
        "ReadWrite", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QIODevice_OpenModeFlag_Type.tp_dict,
        "ReadWrite", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QIODevice_OpenModeFlag_Type,
        (long) QIODevice::Append, "Append");
    PyDict_SetItemString(SbkQIODevice_Type.super.ht_type.tp_dict,
        "Append", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QIODevice_OpenModeFlag_Type.tp_dict,
        "Append", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QIODevice_OpenModeFlag_Type,
        (long) QIODevice::Truncate, "Truncate");
    PyDict_SetItemString(SbkQIODevice_Type.super.ht_type.tp_dict,
        "Truncate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QIODevice_OpenModeFlag_Type.tp_dict,
        "Truncate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QIODevice_OpenModeFlag_Type,
        (long) QIODevice::Text, "Text");
    PyDict_SetItemString(SbkQIODevice_Type.super.ht_type.tp_dict,
        "Text", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QIODevice_OpenModeFlag_Type.tp_dict,
        "Text", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QIODevice_OpenModeFlag_Type,
        (long) QIODevice::Unbuffered, "Unbuffered");
    PyDict_SetItemString(SbkQIODevice_Type.super.ht_type.tp_dict,
        "Unbuffered", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QIODevice_OpenModeFlag_Type.tp_dict,
        "Unbuffered", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QIODevice::OpenModeFlag");

    Shiboken::TypeResolver::createObjectTypeResolver<QIODevice >("QIODevice*");
    Shiboken::TypeResolver::createObjectTypeResolver<QIODevice >(typeid(QIODevice).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

