/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qdate_wrapper.h"

// Extra includes
#include <qdatetime.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQDate_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDate* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 1 || numArgs == 2)
        goto SbkQDate_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QDate", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QDate()
        cptr = new QDate();
    } else if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // QDate(int,int,int)
        cptr = new QDate(cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQDate_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDate_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQDate_Init_TypeError:
        const char* overloads[] = {"", "int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDate", overloads);
        return -1;
}

static PyObject*
SbkQDateFunc_addDays(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // addDays(int)const
        QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
        QDate cpp_result = cppSelf->QDate::addDays(cpp_arg0);
        py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
    } else goto SbkQDateFunc_addDays_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_addDays_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDate.addDays", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_addMonths(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // addMonths(int)const
        QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
        QDate cpp_result = cppSelf->QDate::addMonths(cpp_arg0);
        py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
    } else goto SbkQDateFunc_addMonths_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_addMonths_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDate.addMonths", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_addYears(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // addYears(int)const
        QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
        QDate cpp_result = cppSelf->QDate::addYears(cpp_arg0);
        py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
    } else goto SbkQDateFunc_addYears_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_addYears_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDate.addYears", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_currentDate(PyObject* self)
{
    PyObject* py_result = 0;

    // currentDate()
    QDate cpp_result = QDate::currentDate();
    py_result = Shiboken::Converter<QDate >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDateFunc_day(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // day()const
    QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDate::day();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDateFunc_dayOfWeek(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dayOfWeek()const
    QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDate::dayOfWeek();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDateFunc_dayOfYear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dayOfYear()const
    QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDate::dayOfYear();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDateFunc_daysInMonth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // daysInMonth()const
    QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDate::daysInMonth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDateFunc_daysInYear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // daysInYear()const
    QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDate::daysInYear();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDateFunc_daysTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDate& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);
        // daysTo(QDate)const
        QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QDate::daysTo(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQDateFunc_daysTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_daysTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDate.daysTo", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_fromJulianDay(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // fromJulianDay(int)
        QDate cpp_result = QDate::fromJulianDay(cpp_arg0);
        py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
    } else goto SbkQDateFunc_fromJulianDay_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_fromJulianDay_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDate.fromJulianDay", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_fromString(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromString", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // fromString(QString,Qt::DateFormat)
            QDate cpp_result = QDate::fromString(*cpp_arg0);
            py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
        } else if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // fromString(QString,QString)
            QDate cpp_result = QDate::fromString(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::DateFormat >::isConvertible(pyargs[1])) {
            Qt::DateFormat cpp_arg1 = Shiboken::Converter<Qt::DateFormat >::toCpp(pyargs[1]);
            // fromString(QString,Qt::DateFormat)
            QDate cpp_result = QDate::fromString(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
        } else goto SbkQDateFunc_fromString_TypeError;
    } else goto SbkQDateFunc_fromString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_fromString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.Qt.DateFormat = Qt.TextDate", "PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDate.fromString", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_getDate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // getDate(int*,int*,int*)
    QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
    // Begin code injection
    
    int year, month, day;
    cppSelf->getDate(&year, &month, &day);
    py_result = Shiboken::makeTuple(year, month, day);
    
    // End of code injection



    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDateFunc_gregorianToJulian(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "gregorianToJulian", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // gregorianToJulian(int,int,int)
        uint cpp_result = QDate::gregorianToJulian(cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    } else goto SbkQDateFunc_gregorianToJulian_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_gregorianToJulian_TypeError:
        const char* overloads[] = {"int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDate.gregorianToJulian", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_isLeapYear(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // isLeapYear(int)
        bool cpp_result = QDate::isLeapYear(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDateFunc_isLeapYear_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_isLeapYear_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDate.isLeapYear", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDate::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDateFunc_isValid(PyObject* self, PyObject* args)
{
    if (self) {
        if (Shiboken::cppObjectIsInvalid(self))
            return 0;
    }

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 1 || numArgs == 2)
        goto SbkQDateFunc_isValid_TypeError;

    if (!PyArg_UnpackTuple(args, "isValid", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 0) {
        // isValid()const
        QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDate::isValid();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // isValid(int,int,int)
        bool cpp_result = QDate::isValid(cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDateFunc_isValid_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_isValid_TypeError:
        const char* overloads[] = {"", "int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDate.isValid", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_longDayName(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "longDayName", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // longDayName(int)
            QString cpp_result = QDate::longDayName(cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else if (numArgs == 2 && Shiboken::Converter<QDate::MonthNameType >::isConvertible(pyargs[1])) {
            QDate::MonthNameType cpp_arg1 = Shiboken::Converter<QDate::MonthNameType >::toCpp(pyargs[1]);
            // longDayName(int,QDate::MonthNameType)
            QString cpp_result = QDate::longDayName(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else goto SbkQDateFunc_longDayName_TypeError;
    } else goto SbkQDateFunc_longDayName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_longDayName_TypeError:
        const char* overloads[] = {"int", "int, PySide.QtCore.QDate.MonthNameType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDate.longDayName", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_longMonthName(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "longMonthName", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // longMonthName(int)
            QString cpp_result = QDate::longMonthName(cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else if (numArgs == 2 && Shiboken::Converter<QDate::MonthNameType >::isConvertible(pyargs[1])) {
            QDate::MonthNameType cpp_arg1 = Shiboken::Converter<QDate::MonthNameType >::toCpp(pyargs[1]);
            // longMonthName(int,QDate::MonthNameType)
            QString cpp_result = QDate::longMonthName(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else goto SbkQDateFunc_longMonthName_TypeError;
    } else goto SbkQDateFunc_longMonthName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_longMonthName_TypeError:
        const char* overloads[] = {"int", "int, PySide.QtCore.QDate.MonthNameType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDate.longMonthName", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_month(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // month()const
    QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDate::month();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDateFunc_setDate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setDate", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // setDate(int,int,int)
        QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDate::setDate(cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDateFunc_setDate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_setDate_TypeError:
        const char* overloads[] = {"int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDate.setDate", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_setYMD(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setYMD", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // setYMD(int,int,int)
        QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDate::setYMD(cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDateFunc_setYMD_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_setYMD_TypeError:
        const char* overloads[] = {"int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDate.setYMD", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_shortDayName(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "shortDayName", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // shortDayName(int)
            QString cpp_result = QDate::shortDayName(cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else if (numArgs == 2 && Shiboken::Converter<QDate::MonthNameType >::isConvertible(pyargs[1])) {
            QDate::MonthNameType cpp_arg1 = Shiboken::Converter<QDate::MonthNameType >::toCpp(pyargs[1]);
            // shortDayName(int,QDate::MonthNameType)
            QString cpp_result = QDate::shortDayName(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else goto SbkQDateFunc_shortDayName_TypeError;
    } else goto SbkQDateFunc_shortDayName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_shortDayName_TypeError:
        const char* overloads[] = {"int", "int, PySide.QtCore.QDate.MonthNameType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDate.shortDayName", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_shortMonthName(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "shortMonthName", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // shortMonthName(int)
            QString cpp_result = QDate::shortMonthName(cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else if (numArgs == 2 && Shiboken::Converter<QDate::MonthNameType >::isConvertible(pyargs[1])) {
            QDate::MonthNameType cpp_arg1 = Shiboken::Converter<QDate::MonthNameType >::toCpp(pyargs[1]);
            // shortMonthName(int,QDate::MonthNameType)
            QString cpp_result = QDate::shortMonthName(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else goto SbkQDateFunc_shortMonthName_TypeError;
    } else goto SbkQDateFunc_shortMonthName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_shortMonthName_TypeError:
        const char* overloads[] = {"int", "int, PySide.QtCore.QDate.MonthNameType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDate.shortMonthName", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_toJulianDay(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toJulianDay()const
    QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDate::toJulianDay();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDateFunc_toString(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toString(Qt::DateFormat)const
        QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QDate::toString();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // toString(QString)const
        QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QDate::toString(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (Shiboken::Converter<Qt::DateFormat >::isConvertible(arg)) {
        Qt::DateFormat cpp_arg0 = Shiboken::Converter<Qt::DateFormat >::toCpp(arg);
        // toString(Qt::DateFormat)const
        QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QDate::toString(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQDateFunc_toString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDateFunc_toString_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DateFormat = Qt.TextDate", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDate.toString", overloads);
        return 0;
}

static PyObject*
SbkQDateFunc_weekNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // weekNumber(int*)const
    QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
    // Begin code injection
    
    int yearNumber;
    int week = cppSelf->weekNumber(&yearNumber);
    py_result = Shiboken::makeTuple(week, yearNumber);
    
    // End of code injection



    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDateFunc_year(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // year()const
    QDate* cppSelf = Shiboken::Converter<QDate* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDate::year();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQDateMethod_isValid = {
    "isValid", (PyCFunction)SbkQDateFunc_isValid, METH_VARARGS|METH_STATIC
};

static PyMethodDef SbkQDate_methods[] = {
    {"addDays", (PyCFunction)SbkQDateFunc_addDays, METH_O},
    {"addMonths", (PyCFunction)SbkQDateFunc_addMonths, METH_O},
    {"addYears", (PyCFunction)SbkQDateFunc_addYears, METH_O},
    {"currentDate", (PyCFunction)SbkQDateFunc_currentDate, METH_NOARGS|METH_STATIC},
    {"day", (PyCFunction)SbkQDateFunc_day, METH_NOARGS},
    {"dayOfWeek", (PyCFunction)SbkQDateFunc_dayOfWeek, METH_NOARGS},
    {"dayOfYear", (PyCFunction)SbkQDateFunc_dayOfYear, METH_NOARGS},
    {"daysInMonth", (PyCFunction)SbkQDateFunc_daysInMonth, METH_NOARGS},
    {"daysInYear", (PyCFunction)SbkQDateFunc_daysInYear, METH_NOARGS},
    {"daysTo", (PyCFunction)SbkQDateFunc_daysTo, METH_O},
    {"fromJulianDay", (PyCFunction)SbkQDateFunc_fromJulianDay, METH_O|METH_STATIC},
    {"fromString", (PyCFunction)SbkQDateFunc_fromString, METH_VARARGS|METH_STATIC},
    {"getDate", (PyCFunction)SbkQDateFunc_getDate, METH_NOARGS},
    {"gregorianToJulian", (PyCFunction)SbkQDateFunc_gregorianToJulian, METH_VARARGS|METH_STATIC},
    {"isLeapYear", (PyCFunction)SbkQDateFunc_isLeapYear, METH_O|METH_STATIC},
    {"isNull", (PyCFunction)SbkQDateFunc_isNull, METH_NOARGS},
    SbkQDateMethod_isValid,
    {"longDayName", (PyCFunction)SbkQDateFunc_longDayName, METH_VARARGS|METH_STATIC},
    {"longMonthName", (PyCFunction)SbkQDateFunc_longMonthName, METH_VARARGS|METH_STATIC},
    {"month", (PyCFunction)SbkQDateFunc_month, METH_NOARGS},
    {"setDate", (PyCFunction)SbkQDateFunc_setDate, METH_VARARGS},
    {"setYMD", (PyCFunction)SbkQDateFunc_setYMD, METH_VARARGS},
    {"shortDayName", (PyCFunction)SbkQDateFunc_shortDayName, METH_VARARGS|METH_STATIC},
    {"shortMonthName", (PyCFunction)SbkQDateFunc_shortMonthName, METH_VARARGS|METH_STATIC},
    {"toJulianDay", (PyCFunction)SbkQDateFunc_toJulianDay, METH_NOARGS},
    {"toString", (PyCFunction)SbkQDateFunc_toString, METH_NOARGS|METH_O},
    {"weekNumber", (PyCFunction)SbkQDateFunc_weekNumber, METH_NOARGS},
    {"year", (PyCFunction)SbkQDateFunc_year, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQDate_getattro(PyObject* self, PyObject* name)
{
    if (self) {
        if (SbkBaseWrapper_instanceDict(self)) {
            PyObject* meth = PyDict_GetItem(SbkBaseWrapper_instanceDict(self), name);
            if (meth) {
                Py_INCREF(meth);
                return meth;
            }
        }
        const char* cname = PyString_AS_STRING(name);
        if (strcmp(cname, "isValid") == 0)
            return PyCFunction_NewEx(&SbkQDateMethod_isValid, self, 0);
    }
    return PyObject_GenericGetAttr(self, name);
}

// Rich comparison
static PyObject*
SbkQDate_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QDate& cpp_self = *Shiboken::Converter<QDate* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QDate& >::isConvertible(other)) {
                QDate* cpp_other = Shiboken::Converter<QDate* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQDate_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QDate& >::isConvertible(other)) {
                QDate* cpp_other = Shiboken::Converter<QDate* >::toCpp((PyObject*)other);
                result = (cpp_self < (*cpp_other));
            } else goto SbkQDate_RichComparison_TypeError;

            break;
        case Py_LE:
            if (Shiboken::Converter<QDate& >::isConvertible(other)) {
                QDate* cpp_other = Shiboken::Converter<QDate* >::toCpp((PyObject*)other);
                result = (cpp_self <= (*cpp_other));
            } else goto SbkQDate_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QDate& >::isConvertible(other)) {
                QDate* cpp_other = Shiboken::Converter<QDate* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQDate_RichComparison_TypeError;

            break;
        case Py_GT:
            if (Shiboken::Converter<QDate& >::isConvertible(other)) {
                QDate* cpp_other = Shiboken::Converter<QDate* >::toCpp((PyObject*)other);
                result = (cpp_self > (*cpp_other));
            } else goto SbkQDate_RichComparison_TypeError;

            break;
        case Py_GE:
            if (Shiboken::Converter<QDate& >::isConvertible(other)) {
                QDate* cpp_other = Shiboken::Converter<QDate* >::toCpp((PyObject*)other);
                result = (cpp_self >= (*cpp_other));
            } else goto SbkQDate_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQDate_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDate_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QDate",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QDate >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         SbkQDate_getattro,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQDate_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDate_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDate_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtCore_QDate_MonthNameType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QDate_MonthNameType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QDate_MonthNameType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MonthNameType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QDate_MonthNameType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QDate_MonthNameType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QDate_MonthNameType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QDate(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QDATE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDate_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQDate_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDate_Type));
    PyModule_AddObject(module, "QDate",
        ((PyObject*)&SbkQDate_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: MonthNameType
    SbkPySide_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX] = &SbkPySide_QtCore_QDate_MonthNameType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QDate_MonthNameType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QDate_MonthNameType_Type);
    PyDict_SetItemString(SbkQDate_Type.super.ht_type.tp_dict,
            "MonthNameType",((PyObject*)&SbkPySide_QtCore_QDate_MonthNameType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDate_MonthNameType_Type,
        (long) QDate::DateFormat, "DateFormat");
    PyDict_SetItemString(SbkQDate_Type.super.ht_type.tp_dict,
        "DateFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDate_MonthNameType_Type.tp_dict,
        "DateFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDate_MonthNameType_Type,
        (long) QDate::StandaloneFormat, "StandaloneFormat");
    PyDict_SetItemString(SbkQDate_Type.super.ht_type.tp_dict,
        "StandaloneFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDate_MonthNameType_Type.tp_dict,
        "StandaloneFormat", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDate::MonthNameType");

    Shiboken::TypeResolver::createValueTypeResolver<QDate >("QDate");
    Shiboken::TypeResolver::createValueTypeResolver<QDate >(typeid(QDate).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

