/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qchar_wrapper.h"

// Extra includes
#include <qchar.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQChar_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QChar* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QChar", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QChar()
        cptr = new QChar();
    } else if (numArgs == 2 && Shiboken::Converter<unsigned char >::isConvertible(pyargs[0]) && Shiboken::Converter<unsigned char >::isConvertible(pyargs[1])) {
        uchar cpp_arg0 = Shiboken::Converter<uchar >::toCpp(pyargs[0]);
        uchar cpp_arg1 = Shiboken::Converter<uchar >::toCpp(pyargs[1]);
        // QChar(uchar,uchar)
        cptr = new QChar(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QLatin1Char >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QLatin1Char* cpp_arg0 = Shiboken::Converter<QLatin1Char* >::toCpp(pyargs[0]);
        // QChar(QLatin1Char)
        cptr = new QChar(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QChar::SpecialCharacter >::isConvertible(pyargs[0])) {
        QChar::SpecialCharacter cpp_arg0 = Shiboken::Converter<QChar::SpecialCharacter >::toCpp(pyargs[0]);
        // QChar(QChar::SpecialCharacter)
        cptr = new QChar(cpp_arg0);
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QChar(int)
        cptr = new QChar(cpp_arg0);
    } else if (numArgs == 1 && PyString_Check(pyargs[0])) {
        // QChar(PyString*)
        // Begin code injection
        
        if (PyString_Size(pyargs[0]) == 1) {
            char value = Shiboken::Converter<char >::toCpp(pyargs[0]);
            cptr = new QChar(value);
        } else {
            PyErr_SetString(PyExc_TypeError, "expected string of size 1");
        }
        
        // End of code injection

    } else goto SbkQChar_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQChar_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQChar_Init_TypeError:
        const char* overloads[] = {"", "PyString", "PySide.QtCore.QChar.SpecialCharacter", "PySide.QtCore.QLatin1Char", "int", "unsigned char, unsigned char", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QChar", overloads);
        return -1;
}

static PyObject*
SbkQCharFunc_category(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // category()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    QChar::Category cpp_result = cppSelf->QChar::category();
    py_result = Shiboken::Converter<QChar::Category >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_cell(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cell()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    uchar cpp_result = cppSelf->QChar::cell();
    py_result = Shiboken::Converter<unsigned char >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_combiningClass(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // combiningClass()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    unsigned char cpp_result = cppSelf->QChar::combiningClass();
    py_result = Shiboken::Converter<unsigned char >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_decomposition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // decomposition()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QChar::decomposition();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_decompositionTag(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // decompositionTag()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    QChar::Decomposition cpp_result = cppSelf->QChar::decompositionTag();
    py_result = Shiboken::Converter<QChar::Decomposition >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_digitValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // digitValue()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QChar::digitValue();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_direction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // direction()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    QChar::Direction cpp_result = cppSelf->QChar::direction();
    py_result = Shiboken::Converter<QChar::Direction >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_fromAscii(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // fromAscii(char)
        QChar cpp_result = QChar::fromAscii(cpp_arg0);
        py_result = Shiboken::Converter<QChar >::toPython(cpp_result);
    } else goto SbkQCharFunc_fromAscii_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCharFunc_fromAscii_TypeError:
        const char* overloads[] = {"char", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QChar.fromAscii", overloads);
        return 0;
}

static PyObject*
SbkQCharFunc_fromLatin1(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // fromLatin1(char)
        QChar cpp_result = QChar::fromLatin1(cpp_arg0);
        py_result = Shiboken::Converter<QChar >::toPython(cpp_result);
    } else goto SbkQCharFunc_fromLatin1_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCharFunc_fromLatin1_TypeError:
        const char* overloads[] = {"char", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QChar.fromLatin1", overloads);
        return 0;
}

static PyObject*
SbkQCharFunc_hasMirrored(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasMirrored()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::hasMirrored();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_highSurrogate(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        uint cpp_arg0 = Shiboken::Converter<uint >::toCpp(arg);
        // highSurrogate(uint)
        ushort cpp_result = QChar::highSurrogate(cpp_arg0);
        py_result = Shiboken::Converter<ushort >::toPython(cpp_result);
    } else goto SbkQCharFunc_highSurrogate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCharFunc_highSurrogate_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QChar.highSurrogate", overloads);
        return 0;
}

static PyObject*
SbkQCharFunc_isDigit(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDigit()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isDigit();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_isHighSurrogate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isHighSurrogate()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isHighSurrogate();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_isLetter(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isLetter()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isLetter();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_isLetterOrNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isLetterOrNumber()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isLetterOrNumber();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_isLowSurrogate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isLowSurrogate()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isLowSurrogate();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_isLower(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isLower()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isLower();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_isMark(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isMark()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isMark();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_isNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNumber()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isNumber();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_isPrint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isPrint()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isPrint();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_isPunct(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isPunct()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isPunct();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_isSpace(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSpace()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isSpace();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_isSymbol(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSymbol()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isSymbol();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_isTitleCase(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isTitleCase()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isTitleCase();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_isUpper(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isUpper()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QChar::isUpper();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_joining(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // joining()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    QChar::Joining cpp_result = cppSelf->QChar::joining();
    py_result = Shiboken::Converter<QChar::Joining >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_lowSurrogate(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        uint cpp_arg0 = Shiboken::Converter<uint >::toCpp(arg);
        // lowSurrogate(uint)
        ushort cpp_result = QChar::lowSurrogate(cpp_arg0);
        py_result = Shiboken::Converter<ushort >::toPython(cpp_result);
    } else goto SbkQCharFunc_lowSurrogate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCharFunc_lowSurrogate_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QChar.lowSurrogate", overloads);
        return 0;
}

static PyObject*
SbkQCharFunc_mirroredChar(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mirroredChar()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    QChar cpp_result = cppSelf->QChar::mirroredChar();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_row(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // row()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    uchar cpp_result = cppSelf->QChar::row();
    py_result = Shiboken::Converter<unsigned char >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_setCell(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<unsigned char >::isConvertible(arg)) {
        uchar cpp_arg0 = Shiboken::Converter<uchar >::toCpp(arg);
        // setCell(uchar)
        QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
        cppSelf->QChar::setCell(cpp_arg0);
    } else goto SbkQCharFunc_setCell_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCharFunc_setCell_TypeError:
        const char* overloads[] = {"unsigned char", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QChar.setCell", overloads);
        return 0;
}

static PyObject*
SbkQCharFunc_setRow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<unsigned char >::isConvertible(arg)) {
        uchar cpp_arg0 = Shiboken::Converter<uchar >::toCpp(arg);
        // setRow(uchar)
        QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
        cppSelf->QChar::setRow(cpp_arg0);
    } else goto SbkQCharFunc_setRow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCharFunc_setRow_TypeError:
        const char* overloads[] = {"unsigned char", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QChar.setRow", overloads);
        return 0;
}

static PyObject*
SbkQCharFunc_surrogateToUcs4(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "surrogateToUcs4", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        ushort cpp_arg0 = Shiboken::Converter<ushort >::toCpp(pyargs[0]);
        ushort cpp_arg1 = Shiboken::Converter<ushort >::toCpp(pyargs[1]);
        // surrogateToUcs4(ushort,ushort)
        uint cpp_result = QChar::surrogateToUcs4(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    } else if (numArgs == 2 && Shiboken::Converter<QChar >::isConvertible(pyargs[0]) && Shiboken::Converter<QChar >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QChar >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QChar > cpp_arg1_auto_ptr;
        QChar* cpp_arg1 = Shiboken::Converter<QChar* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QChar >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QChar >(cpp_arg1);
        // surrogateToUcs4(QChar,QChar)
        uint cpp_result = QChar::surrogateToUcs4(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    } else goto SbkQCharFunc_surrogateToUcs4_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCharFunc_surrogateToUcs4_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChar, PySide.QtCore.QChar", "ushort, ushort", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QChar.surrogateToUcs4", overloads);
        return 0;
}

static PyObject*
SbkQCharFunc_toAscii(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toAscii()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    char cpp_result = cppSelf->QChar::toAscii();
    py_result = Shiboken::Converter<char >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_toCaseFolded(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toCaseFolded()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    QChar cpp_result = cppSelf->QChar::toCaseFolded();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_toLatin1(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toLatin1()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    char cpp_result = cppSelf->QChar::toLatin1();
    py_result = Shiboken::Converter<char >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_toLower(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toLower()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    QChar cpp_result = cppSelf->QChar::toLower();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_toTitleCase(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toTitleCase()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    QChar cpp_result = cppSelf->QChar::toTitleCase();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_toUpper(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toUpper()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    QChar cpp_result = cppSelf->QChar::toUpper();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_unicode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // unicode()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    ushort cpp_result = cppSelf->QChar::unicode();
    py_result = Shiboken::Converter<ushort >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCharFunc_unicodeVersion(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // unicodeVersion()const
    QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
    QChar::UnicodeVersion cpp_result = cppSelf->QChar::unicodeVersion();
    py_result = Shiboken::Converter<QChar::UnicodeVersion >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQChar_methods[] = {
    {"category", (PyCFunction)SbkQCharFunc_category, METH_NOARGS},
    {"cell", (PyCFunction)SbkQCharFunc_cell, METH_NOARGS},
    {"combiningClass", (PyCFunction)SbkQCharFunc_combiningClass, METH_NOARGS},
    {"decomposition", (PyCFunction)SbkQCharFunc_decomposition, METH_NOARGS},
    {"decompositionTag", (PyCFunction)SbkQCharFunc_decompositionTag, METH_NOARGS},
    {"digitValue", (PyCFunction)SbkQCharFunc_digitValue, METH_NOARGS},
    {"direction", (PyCFunction)SbkQCharFunc_direction, METH_NOARGS},
    {"fromAscii", (PyCFunction)SbkQCharFunc_fromAscii, METH_O|METH_STATIC},
    {"fromLatin1", (PyCFunction)SbkQCharFunc_fromLatin1, METH_O|METH_STATIC},
    {"hasMirrored", (PyCFunction)SbkQCharFunc_hasMirrored, METH_NOARGS},
    {"highSurrogate", (PyCFunction)SbkQCharFunc_highSurrogate, METH_O|METH_STATIC},
    {"isDigit", (PyCFunction)SbkQCharFunc_isDigit, METH_NOARGS},
    {"isHighSurrogate", (PyCFunction)SbkQCharFunc_isHighSurrogate, METH_NOARGS},
    {"isLetter", (PyCFunction)SbkQCharFunc_isLetter, METH_NOARGS},
    {"isLetterOrNumber", (PyCFunction)SbkQCharFunc_isLetterOrNumber, METH_NOARGS},
    {"isLowSurrogate", (PyCFunction)SbkQCharFunc_isLowSurrogate, METH_NOARGS},
    {"isLower", (PyCFunction)SbkQCharFunc_isLower, METH_NOARGS},
    {"isMark", (PyCFunction)SbkQCharFunc_isMark, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQCharFunc_isNull, METH_NOARGS},
    {"isNumber", (PyCFunction)SbkQCharFunc_isNumber, METH_NOARGS},
    {"isPrint", (PyCFunction)SbkQCharFunc_isPrint, METH_NOARGS},
    {"isPunct", (PyCFunction)SbkQCharFunc_isPunct, METH_NOARGS},
    {"isSpace", (PyCFunction)SbkQCharFunc_isSpace, METH_NOARGS},
    {"isSymbol", (PyCFunction)SbkQCharFunc_isSymbol, METH_NOARGS},
    {"isTitleCase", (PyCFunction)SbkQCharFunc_isTitleCase, METH_NOARGS},
    {"isUpper", (PyCFunction)SbkQCharFunc_isUpper, METH_NOARGS},
    {"joining", (PyCFunction)SbkQCharFunc_joining, METH_NOARGS},
    {"lowSurrogate", (PyCFunction)SbkQCharFunc_lowSurrogate, METH_O|METH_STATIC},
    {"mirroredChar", (PyCFunction)SbkQCharFunc_mirroredChar, METH_NOARGS},
    {"row", (PyCFunction)SbkQCharFunc_row, METH_NOARGS},
    {"setCell", (PyCFunction)SbkQCharFunc_setCell, METH_O},
    {"setRow", (PyCFunction)SbkQCharFunc_setRow, METH_O},
    {"surrogateToUcs4", (PyCFunction)SbkQCharFunc_surrogateToUcs4, METH_VARARGS|METH_STATIC},
    {"toAscii", (PyCFunction)SbkQCharFunc_toAscii, METH_NOARGS},
    {"toCaseFolded", (PyCFunction)SbkQCharFunc_toCaseFolded, METH_NOARGS},
    {"toLatin1", (PyCFunction)SbkQCharFunc_toLatin1, METH_NOARGS},
    {"toLower", (PyCFunction)SbkQCharFunc_toLower, METH_NOARGS},
    {"toTitleCase", (PyCFunction)SbkQCharFunc_toTitleCase, METH_NOARGS},
    {"toUpper", (PyCFunction)SbkQCharFunc_toUpper, METH_NOARGS},
    {"unicode", (PyCFunction)SbkQCharFunc_unicode, METH_NOARGS},
    {"unicodeVersion", (PyCFunction)SbkQCharFunc_unicodeVersion, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQCharFunc___add__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQChar_Check(arg) && !SbkQChar_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // operator+(QChar,QString)
        QChar* cppSelf = Shiboken::Converter<QChar* >::toCpp((PyObject*)self);
        const QString cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQCharFunc___add___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCharFunc___add___TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QChar.__add__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQChar_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQCharFunc___add__,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQChar_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QChar& cpp_self = *Shiboken::Converter<QChar* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QChar >::isConvertible(other)) {
                QChar* cpp_other = Shiboken::Converter<QChar* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QChar >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QChar > cpp_other_auto_ptr;
                QChar* cpp_other = Shiboken::Converter<QChar* >::toCpp(other);
                if (!Shiboken::Converter<QChar >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QChar >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQChar_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QChar >::isConvertible(other)) {
                QChar* cpp_other = Shiboken::Converter<QChar* >::toCpp((PyObject*)other);
                result = (cpp_self < (*cpp_other));
            } else if (Shiboken::Converter<QChar >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QChar > cpp_other_auto_ptr;
                QChar* cpp_other = Shiboken::Converter<QChar* >::toCpp(other);
                if (!Shiboken::Converter<QChar >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QChar >(cpp_other);
                result = (cpp_self < (*cpp_other));
            } else goto SbkQChar_RichComparison_TypeError;

            break;
        case Py_LE:
            if (Shiboken::Converter<QChar >::isConvertible(other)) {
                QChar* cpp_other = Shiboken::Converter<QChar* >::toCpp((PyObject*)other);
                result = (cpp_self <= (*cpp_other));
            } else if (Shiboken::Converter<QChar >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QChar > cpp_other_auto_ptr;
                QChar* cpp_other = Shiboken::Converter<QChar* >::toCpp(other);
                if (!Shiboken::Converter<QChar >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QChar >(cpp_other);
                result = (cpp_self <= (*cpp_other));
            } else goto SbkQChar_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QChar >::isConvertible(other)) {
                QChar* cpp_other = Shiboken::Converter<QChar* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QChar >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QChar > cpp_other_auto_ptr;
                QChar* cpp_other = Shiboken::Converter<QChar* >::toCpp(other);
                if (!Shiboken::Converter<QChar >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QChar >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQChar_RichComparison_TypeError;

            break;
        case Py_GT:
            if (Shiboken::Converter<QChar >::isConvertible(other)) {
                QChar* cpp_other = Shiboken::Converter<QChar* >::toCpp((PyObject*)other);
                result = (cpp_self > (*cpp_other));
            } else if (Shiboken::Converter<QChar >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QChar > cpp_other_auto_ptr;
                QChar* cpp_other = Shiboken::Converter<QChar* >::toCpp(other);
                if (!Shiboken::Converter<QChar >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QChar >(cpp_other);
                result = (cpp_self > (*cpp_other));
            } else goto SbkQChar_RichComparison_TypeError;

            break;
        case Py_GE:
            if (Shiboken::Converter<QChar >::isConvertible(other)) {
                QChar* cpp_other = Shiboken::Converter<QChar* >::toCpp((PyObject*)other);
                result = (cpp_self >= (*cpp_other));
            } else if (Shiboken::Converter<QChar >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QChar > cpp_other_auto_ptr;
                QChar* cpp_other = Shiboken::Converter<QChar* >::toCpp(other);
                if (!Shiboken::Converter<QChar >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QChar >(cpp_other);
                result = (cpp_self >= (*cpp_other));
            } else goto SbkQChar_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQChar_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

static long SbkQChar_HashFunc(PyObject* obj){
    return qHash(Shiboken::Converter<QChar >::toCpp(obj));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQChar_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QChar",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QChar >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQChar_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             &SbkQChar_HashFunc,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQChar_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQChar_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQChar_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtCore_QChar_Joining_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QChar_Joining_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QChar_Joining_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Joining",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QChar_Joining_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QChar_Joining_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QChar_Joining_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QChar_SpecialCharacter_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QChar_SpecialCharacter_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QChar_SpecialCharacter_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SpecialCharacter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QChar_SpecialCharacter_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QChar_SpecialCharacter_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QChar_SpecialCharacter_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QChar_UnicodeVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QChar_UnicodeVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QChar_UnicodeVersion_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "UnicodeVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QChar_UnicodeVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QChar_UnicodeVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QChar_UnicodeVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QChar_Direction_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QChar_Direction_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QChar_Direction_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Direction",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QChar_Direction_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QChar_Direction_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QChar_Direction_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QChar_Category_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QChar_Category_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QChar_Category_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Category",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QChar_Category_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QChar_Category_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QChar_Category_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QChar_CombiningClass_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QChar_CombiningClass_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QChar_CombiningClass_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CombiningClass",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QChar_CombiningClass_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QChar_CombiningClass_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QChar_CombiningClass_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QChar_Decomposition_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QChar_Decomposition_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QChar_Decomposition_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Decomposition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QChar_Decomposition_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QChar_Decomposition_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QChar_Decomposition_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QChar(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QCHAR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQChar_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQChar_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQChar_Type));
    PyModule_AddObject(module, "QChar",
        ((PyObject*)&SbkQChar_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Joining
    SbkPySide_QtCoreTypes[SBK_QCHAR_JOINING_IDX] = &SbkPySide_QtCore_QChar_Joining_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QChar_Joining_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QChar_Joining_Type);
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
            "Joining",((PyObject*)&SbkPySide_QtCore_QChar_Joining_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Joining_Type,
        (long) QChar::OtherJoining, "OtherJoining");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "OtherJoining", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Joining_Type.tp_dict,
        "OtherJoining", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Joining_Type,
        (long) QChar::Dual, "Dual");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Dual", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Joining_Type.tp_dict,
        "Dual", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Joining_Type,
        (long) QChar::Right, "Right");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Right", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Joining_Type.tp_dict,
        "Right", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Joining_Type,
        (long) QChar::Center, "Center");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Center", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Joining_Type.tp_dict,
        "Center", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QChar::Joining");

    // init enum class: SpecialCharacter
    SbkPySide_QtCoreTypes[SBK_QCHAR_SPECIALCHARACTER_IDX] = &SbkPySide_QtCore_QChar_SpecialCharacter_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QChar_SpecialCharacter_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QChar_SpecialCharacter_Type);
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
            "SpecialCharacter",((PyObject*)&SbkPySide_QtCore_QChar_SpecialCharacter_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_SpecialCharacter_Type,
        (long) QChar::Null, "Null");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Null", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_SpecialCharacter_Type.tp_dict,
        "Null", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_SpecialCharacter_Type,
        (long) QChar::Nbsp, "Nbsp");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Nbsp", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_SpecialCharacter_Type.tp_dict,
        "Nbsp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_SpecialCharacter_Type,
        (long) QChar::ReplacementCharacter, "ReplacementCharacter");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "ReplacementCharacter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_SpecialCharacter_Type.tp_dict,
        "ReplacementCharacter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_SpecialCharacter_Type,
        (long) QChar::ObjectReplacementCharacter, "ObjectReplacementCharacter");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "ObjectReplacementCharacter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_SpecialCharacter_Type.tp_dict,
        "ObjectReplacementCharacter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_SpecialCharacter_Type,
        (long) QChar::ByteOrderMark, "ByteOrderMark");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "ByteOrderMark", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_SpecialCharacter_Type.tp_dict,
        "ByteOrderMark", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_SpecialCharacter_Type,
        (long) QChar::ByteOrderSwapped, "ByteOrderSwapped");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "ByteOrderSwapped", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_SpecialCharacter_Type.tp_dict,
        "ByteOrderSwapped", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_SpecialCharacter_Type,
        (long) QChar::ParagraphSeparator, "ParagraphSeparator");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "ParagraphSeparator", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_SpecialCharacter_Type.tp_dict,
        "ParagraphSeparator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_SpecialCharacter_Type,
        (long) QChar::LineSeparator, "LineSeparator");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "LineSeparator", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_SpecialCharacter_Type.tp_dict,
        "LineSeparator", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QChar::SpecialCharacter");

    // init enum class: UnicodeVersion
    SbkPySide_QtCoreTypes[SBK_QCHAR_UNICODEVERSION_IDX] = &SbkPySide_QtCore_QChar_UnicodeVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QChar_UnicodeVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QChar_UnicodeVersion_Type);
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
            "UnicodeVersion",((PyObject*)&SbkPySide_QtCore_QChar_UnicodeVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_UnicodeVersion_Type,
        (long) QChar::Unicode_Unassigned, "Unicode_Unassigned");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Unicode_Unassigned", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_UnicodeVersion_Type.tp_dict,
        "Unicode_Unassigned", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_UnicodeVersion_Type,
        (long) QChar::Unicode_1_1, "Unicode_1_1");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Unicode_1_1", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_UnicodeVersion_Type.tp_dict,
        "Unicode_1_1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_UnicodeVersion_Type,
        (long) QChar::Unicode_2_0, "Unicode_2_0");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Unicode_2_0", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_UnicodeVersion_Type.tp_dict,
        "Unicode_2_0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_UnicodeVersion_Type,
        (long) QChar::Unicode_2_1_2, "Unicode_2_1_2");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Unicode_2_1_2", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_UnicodeVersion_Type.tp_dict,
        "Unicode_2_1_2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_UnicodeVersion_Type,
        (long) QChar::Unicode_3_0, "Unicode_3_0");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Unicode_3_0", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_UnicodeVersion_Type.tp_dict,
        "Unicode_3_0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_UnicodeVersion_Type,
        (long) QChar::Unicode_3_1, "Unicode_3_1");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Unicode_3_1", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_UnicodeVersion_Type.tp_dict,
        "Unicode_3_1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_UnicodeVersion_Type,
        (long) QChar::Unicode_3_2, "Unicode_3_2");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Unicode_3_2", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_UnicodeVersion_Type.tp_dict,
        "Unicode_3_2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_UnicodeVersion_Type,
        (long) QChar::Unicode_4_0, "Unicode_4_0");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Unicode_4_0", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_UnicodeVersion_Type.tp_dict,
        "Unicode_4_0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_UnicodeVersion_Type,
        (long) QChar::Unicode_4_1, "Unicode_4_1");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Unicode_4_1", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_UnicodeVersion_Type.tp_dict,
        "Unicode_4_1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_UnicodeVersion_Type,
        (long) QChar::Unicode_5_0, "Unicode_5_0");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Unicode_5_0", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_UnicodeVersion_Type.tp_dict,
        "Unicode_5_0", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QChar::UnicodeVersion");

    // init enum class: Direction
    SbkPySide_QtCoreTypes[SBK_QCHAR_DIRECTION_IDX] = &SbkPySide_QtCore_QChar_Direction_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QChar_Direction_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QChar_Direction_Type);
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
            "Direction",((PyObject*)&SbkPySide_QtCore_QChar_Direction_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirL, "DirL");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirL", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirL", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirR, "DirR");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirR", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirR", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirEN, "DirEN");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirEN", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirEN", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirES, "DirES");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirES", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirES", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirET, "DirET");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirET", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirET", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirAN, "DirAN");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirAN", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirAN", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirCS, "DirCS");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirCS", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirCS", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirB, "DirB");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirB", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirB", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirS, "DirS");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirS", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirS", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirWS, "DirWS");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirWS", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirWS", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirON, "DirON");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirON", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirON", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirLRE, "DirLRE");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirLRE", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirLRE", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirLRO, "DirLRO");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirLRO", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirLRO", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirAL, "DirAL");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirAL", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirAL", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirRLE, "DirRLE");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirRLE", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirRLE", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirRLO, "DirRLO");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirRLO", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirRLO", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirPDF, "DirPDF");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirPDF", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirPDF", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirNSM, "DirNSM");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirNSM", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirNSM", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Direction_Type,
        (long) QChar::DirBN, "DirBN");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "DirBN", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Direction_Type.tp_dict,
        "DirBN", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QChar::Direction");

    // init enum class: Category
    SbkPySide_QtCoreTypes[SBK_QCHAR_CATEGORY_IDX] = &SbkPySide_QtCore_QChar_Category_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QChar_Category_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QChar_Category_Type);
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
            "Category",((PyObject*)&SbkPySide_QtCore_QChar_Category_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::NoCategory, "NoCategory");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "NoCategory", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "NoCategory", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Mark_NonSpacing, "Mark_NonSpacing");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Mark_NonSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Mark_NonSpacing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Mark_SpacingCombining, "Mark_SpacingCombining");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Mark_SpacingCombining", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Mark_SpacingCombining", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Mark_Enclosing, "Mark_Enclosing");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Mark_Enclosing", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Mark_Enclosing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Number_DecimalDigit, "Number_DecimalDigit");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Number_DecimalDigit", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Number_DecimalDigit", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Number_Letter, "Number_Letter");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Number_Letter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Number_Letter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Number_Other, "Number_Other");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Number_Other", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Number_Other", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Separator_Space, "Separator_Space");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Separator_Space", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Separator_Space", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Separator_Line, "Separator_Line");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Separator_Line", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Separator_Line", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Separator_Paragraph, "Separator_Paragraph");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Separator_Paragraph", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Separator_Paragraph", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Other_Control, "Other_Control");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Other_Control", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Other_Control", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Other_Format, "Other_Format");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Other_Format", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Other_Format", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Other_Surrogate, "Other_Surrogate");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Other_Surrogate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Other_Surrogate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Other_PrivateUse, "Other_PrivateUse");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Other_PrivateUse", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Other_PrivateUse", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Other_NotAssigned, "Other_NotAssigned");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Other_NotAssigned", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Other_NotAssigned", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Letter_Uppercase, "Letter_Uppercase");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Letter_Uppercase", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Letter_Uppercase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Letter_Lowercase, "Letter_Lowercase");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Letter_Lowercase", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Letter_Lowercase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Letter_Titlecase, "Letter_Titlecase");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Letter_Titlecase", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Letter_Titlecase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Letter_Modifier, "Letter_Modifier");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Letter_Modifier", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Letter_Modifier", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Letter_Other, "Letter_Other");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Letter_Other", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Letter_Other", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Punctuation_Connector, "Punctuation_Connector");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Punctuation_Connector", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Punctuation_Connector", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Punctuation_Dash, "Punctuation_Dash");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Punctuation_Dash", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Punctuation_Dash", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Punctuation_Open, "Punctuation_Open");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Punctuation_Open", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Punctuation_Open", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Punctuation_Close, "Punctuation_Close");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Punctuation_Close", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Punctuation_Close", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Punctuation_InitialQuote, "Punctuation_InitialQuote");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Punctuation_InitialQuote", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Punctuation_InitialQuote", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Punctuation_FinalQuote, "Punctuation_FinalQuote");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Punctuation_FinalQuote", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Punctuation_FinalQuote", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Punctuation_Other, "Punctuation_Other");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Punctuation_Other", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Punctuation_Other", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Symbol_Math, "Symbol_Math");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Symbol_Math", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Symbol_Math", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Symbol_Currency, "Symbol_Currency");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Symbol_Currency", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Symbol_Currency", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Symbol_Modifier, "Symbol_Modifier");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Symbol_Modifier", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Symbol_Modifier", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Symbol_Other, "Symbol_Other");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Symbol_Other", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Symbol_Other", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Category_Type,
        (long) QChar::Punctuation_Dask, "Punctuation_Dask");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Punctuation_Dask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Category_Type.tp_dict,
        "Punctuation_Dask", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QChar::Category");

    // init enum class: CombiningClass
    SbkPySide_QtCoreTypes[SBK_QCHAR_COMBININGCLASS_IDX] = &SbkPySide_QtCore_QChar_CombiningClass_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QChar_CombiningClass_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QChar_CombiningClass_Type);
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
            "CombiningClass",((PyObject*)&SbkPySide_QtCore_QChar_CombiningClass_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_BelowLeftAttached, "Combining_BelowLeftAttached");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_BelowLeftAttached", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_BelowLeftAttached", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_BelowAttached, "Combining_BelowAttached");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_BelowAttached", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_BelowAttached", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_BelowRightAttached, "Combining_BelowRightAttached");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_BelowRightAttached", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_BelowRightAttached", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_LeftAttached, "Combining_LeftAttached");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_LeftAttached", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_LeftAttached", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_RightAttached, "Combining_RightAttached");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_RightAttached", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_RightAttached", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_AboveLeftAttached, "Combining_AboveLeftAttached");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_AboveLeftAttached", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_AboveLeftAttached", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_AboveAttached, "Combining_AboveAttached");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_AboveAttached", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_AboveAttached", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_AboveRightAttached, "Combining_AboveRightAttached");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_AboveRightAttached", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_AboveRightAttached", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_BelowLeft, "Combining_BelowLeft");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_BelowLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_BelowLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_Below, "Combining_Below");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_Below", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_Below", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_BelowRight, "Combining_BelowRight");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_BelowRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_BelowRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_Left, "Combining_Left");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_Left", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_Left", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_Right, "Combining_Right");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_Right", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_Right", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_AboveLeft, "Combining_AboveLeft");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_AboveLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_AboveLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_Above, "Combining_Above");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_Above", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_Above", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_AboveRight, "Combining_AboveRight");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_AboveRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_AboveRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_DoubleBelow, "Combining_DoubleBelow");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_DoubleBelow", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_DoubleBelow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_DoubleAbove, "Combining_DoubleAbove");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_DoubleAbove", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_DoubleAbove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_CombiningClass_Type,
        (long) QChar::Combining_IotaSubscript, "Combining_IotaSubscript");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Combining_IotaSubscript", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_CombiningClass_Type.tp_dict,
        "Combining_IotaSubscript", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QChar::CombiningClass");

    // init enum class: Decomposition
    SbkPySide_QtCoreTypes[SBK_QCHAR_DECOMPOSITION_IDX] = &SbkPySide_QtCore_QChar_Decomposition_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QChar_Decomposition_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QChar_Decomposition_Type);
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
            "Decomposition",((PyObject*)&SbkPySide_QtCore_QChar_Decomposition_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::NoDecomposition, "NoDecomposition");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "NoDecomposition", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "NoDecomposition", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Canonical, "Canonical");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Canonical", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Canonical", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Font, "Font");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Font", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Font", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::NoBreak, "NoBreak");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "NoBreak", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "NoBreak", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Initial, "Initial");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Initial", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Initial", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Medial, "Medial");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Medial", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Medial", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Final, "Final");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Final", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Final", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Isolated, "Isolated");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Isolated", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Isolated", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Circle, "Circle");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Circle", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Circle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Super, "Super");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Super", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Super", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Sub, "Sub");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Sub", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Sub", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Vertical, "Vertical");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Vertical", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Vertical", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Wide, "Wide");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Wide", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Wide", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Narrow, "Narrow");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Narrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Narrow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Small, "Small");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Small", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Small", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Square, "Square");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Square", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Square", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Compat, "Compat");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Compat", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Compat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QChar_Decomposition_Type,
        (long) QChar::Fraction, "Fraction");
    PyDict_SetItemString(SbkQChar_Type.super.ht_type.tp_dict,
        "Fraction", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QChar_Decomposition_Type.tp_dict,
        "Fraction", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QChar::Decomposition");

    Shiboken::TypeResolver::createValueTypeResolver<QChar >("QChar");
    Shiboken::TypeResolver::createValueTypeResolver<QChar >(typeid(QChar).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

