/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qbytearray_wrapper.h"

// Extra includes
#include <QList>
#include <QNoImplicitBoolCast>
#include <qbytearray.h>
#include <qstring.h>

using namespace Shiboken;

// Begin code injection
// ========================================================================
// START of custom code block [file: glue/qbytearray_bufferprotocol.cpp]

#if PY_VERSION_HEX < 0x03000000

// QByteArray buffer protocol functions
// see: http://www.python.org/dev/peps/pep-3118/

extern "C" {

static Py_ssize_t SbkQByteArray_segcountproc(PyObject* self, Py_ssize_t* lenp)
{
    if (lenp)
        *lenp = self->ob_type->tp_as_sequence->sq_length(self);
    return 1;
}

static Py_ssize_t SbkQByteArray_readbufferproc(PyObject* self, Py_ssize_t segment, void** ptrptr)
{
    if (segment || Shiboken::cppObjectIsInvalid(self))
        return -1;

    QByteArray* cppSelf = Converter<QByteArray*>::toCpp(self);
    *ptrptr = reinterpret_cast<void*>(cppSelf->data());
    return cppSelf->size();
}

PyBufferProcs SbkQByteArrayBufferProc = {
    /*bf_getreadbuffer*/  &SbkQByteArray_readbufferproc,
    /*bf_getwritebuffer*/ (writebufferproc) &SbkQByteArray_readbufferproc,
    /*bf_getsegcount*/    &SbkQByteArray_segcountproc,
    /*bf_getcharbuffer*/  (charbufferproc) &SbkQByteArray_readbufferproc
};

}

#endif

// END of custom code block [file: glue/qbytearray_bufferprotocol.cpp]
// ========================================================================

// End of code injection

static int
SbkQByteArray_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QByteArray* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QByteArray", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QByteArray()
        cptr = new QByteArray();
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 2 && Shiboken::Converter<char >::isConvertible(pyargs[1])) {
            char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
            // QByteArray(int,char)
            cptr = new QByteArray(cpp_arg0, cpp_arg1);
        } else if (numArgs == 2 && Shiboken::Converter<Qt::Initialization >::isConvertible(pyargs[1])) {
            Qt::Initialization cpp_arg1 = Shiboken::Converter<Qt::Initialization >::toCpp(pyargs[1]);
            // QByteArray(int,Qt::Initialization)
            cptr = new QByteArray(cpp_arg0, cpp_arg1);
        } else goto SbkQByteArray_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<const char * >::isConvertible(pyargs[0])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        // QByteArray(const char*)
        // Begin code injection
        
        int size = PyString_Size(pyargs[0]);
        cptr = new QByteArray(cpp_arg0, size);
        
        // End of code injection

    } else if (numArgs == 1 && Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // QByteArray(QByteArray)
        cptr = new QByteArray(*cpp_arg0);
    } else goto SbkQByteArray_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQByteArray_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQByteArray_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QByteArray", "str", "int, PySide.QtCore.Qt.Initialization", "int, char", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray", overloads);
        return -1;
}

static PyObject*
SbkQByteArrayFunc___str__(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // __str__()
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    py_result = PyString_FromString(cppSelf->data());
    
    // End of code injection



    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_append(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "append", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // append(const char*,int)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray & cpp_result = cppSelf->QByteArray::append(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
    } else if (numArgs == 1 && Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // append(QByteArray)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray & cpp_result = cppSelf->QByteArray::append(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
    } else if (numArgs == 1 && Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // append(QString)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray & cpp_result = cppSelf->QByteArray::append(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_append_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_append_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", "PySide.QtCore.QString", "str, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.append", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_appendByte(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // append(char)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray & cpp_result = cppSelf->QByteArray::append(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_appendByte_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_appendByte_TypeError:
        const char* overloads[] = {"char", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.appendByte", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_at(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // at(int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        char cpp_result = cppSelf->QByteArray::at(cpp_arg0);
        py_result = Shiboken::Converter<char >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_at_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_at_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.at", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_capacity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // capacity()const
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QByteArray::capacity();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_chop(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // chop(int)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        cppSelf->QByteArray::chop(cpp_arg0);
    } else goto SbkQByteArrayFunc_chop_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQByteArrayFunc_chop_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.chop", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    cppSelf->QByteArray::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQByteArrayFunc_count(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // count()const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QByteArray::count();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else if (Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // count(char)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QByteArray::count(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // count(QByteArray)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QByteArray::count(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_count_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_count_TypeError:
        const char* overloads[] = {"", "char", "PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.count", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_data(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // data()const
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    const char * cpp_result = cppSelf->QByteArray::data();
    py_result = Shiboken::Converter<const char * >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_endsWith(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // endsWith(char)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QByteArray::endsWith(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // endsWith(QByteArray)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QByteArray::endsWith(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_endsWith_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_endsWith_TypeError:
        const char* overloads[] = {"char", "PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.endsWith", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_fill(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fill", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<char >::isConvertible(pyargs[0])) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // fill(char,int)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::fill(cpp_arg0);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // fill(char,int)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::fill(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_fill_TypeError;
    } else goto SbkQByteArrayFunc_fill_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_fill_TypeError:
        const char* overloads[] = {"char, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.fill", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_fromBase64(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // fromBase64(QByteArray)
        QByteArray cpp_result = QByteArray::fromBase64(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_fromBase64_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_fromBase64_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.fromBase64", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_fromHex(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // fromHex(QByteArray)
        QByteArray cpp_result = QByteArray::fromHex(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_fromHex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_fromHex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.fromHex", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_fromInt(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromInt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // number(int,int)
            QByteArray cpp_result = QByteArray::number(cpp_arg0);
            py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // number(int,int)
            QByteArray cpp_result = QByteArray::number(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_fromInt_TypeError;
    } else goto SbkQByteArrayFunc_fromInt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_fromInt_TypeError:
        const char* overloads[] = {"int, int = 10", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.fromInt", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_fromLongLong(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromLongLong", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        qlonglong cpp_arg0 = Shiboken::Converter<qlonglong >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // number(qlonglong,int)
            QByteArray cpp_result = QByteArray::number(cpp_arg0);
            py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // number(qlonglong,int)
            QByteArray cpp_result = QByteArray::number(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_fromLongLong_TypeError;
    } else goto SbkQByteArrayFunc_fromLongLong_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_fromLongLong_TypeError:
        const char* overloads[] = {"long long, int = 10", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.fromLongLong", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_fromPercentEncoding(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromPercentEncoding", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // fromPercentEncoding(QByteArray,char)
            QByteArray cpp_result = QByteArray::fromPercentEncoding(*cpp_arg0);
            py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        } else if (Shiboken::Converter<char >::isConvertible(pyargs[1])) {
            char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
            // fromPercentEncoding(QByteArray,char)
            QByteArray cpp_result = QByteArray::fromPercentEncoding(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_fromPercentEncoding_TypeError;
    } else goto SbkQByteArrayFunc_fromPercentEncoding_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_fromPercentEncoding_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, char = '%'", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.fromPercentEncoding", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_indexOf(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "indexOf", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // indexOf(QByteArray,int)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArray::indexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // indexOf(QByteArray,int)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArray::indexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_indexOf_TypeError;
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // indexOf(QString,int)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArray::indexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // indexOf(QString,int)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArray::indexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_indexOf_TypeError;
    } else goto SbkQByteArrayFunc_indexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_indexOf_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, int = 0", "PySide.QtCore.QString, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.indexOf", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_indexOfByte(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "indexOfByte", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<char >::isConvertible(pyargs[0])) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // indexOf(char,int)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArray::indexOf(cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // indexOf(char,int)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArray::indexOf(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_indexOfByte_TypeError;
    } else goto SbkQByteArrayFunc_indexOfByte_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_indexOfByte_TypeError:
        const char* overloads[] = {"char, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.indexOfByte", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_insert(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insert", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 3 && Shiboken::Converter<const char * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // insert(int,const char*,int)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::insert(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else if (numArgs == 2 && Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            // insert(int,QByteArray)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::insert(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // insert(int,QString)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::insert(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_insert_TypeError;
    } else goto SbkQByteArrayFunc_insert_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_insert_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QByteArray", "int, PySide.QtCore.QString", "int, str, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.insert", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_insertByte(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertByte", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<char >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
        // insert(int,char)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray & cpp_result = cppSelf->QByteArray::insert(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_insertByte_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_insertByte_TypeError:
        const char* overloads[] = {"int, char", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.insertByte", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QByteArray::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QByteArray::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_lastIndexOf(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "lastIndexOf", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // lastIndexOf(QByteArray,int)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArray::lastIndexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // lastIndexOf(QByteArray,int)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArray::lastIndexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_lastIndexOf_TypeError;
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // lastIndexOf(QString,int)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArray::lastIndexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // lastIndexOf(QString,int)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArray::lastIndexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_lastIndexOf_TypeError;
    } else goto SbkQByteArrayFunc_lastIndexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_lastIndexOf_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, int = -1", "PySide.QtCore.QString, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.lastIndexOf", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_lastIndexOfByte(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "lastIndexOfByte", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<char >::isConvertible(pyargs[0])) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // lastIndexOf(char,int)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArray::lastIndexOf(cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // lastIndexOf(char,int)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArray::lastIndexOf(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_lastIndexOfByte_TypeError;
    } else goto SbkQByteArrayFunc_lastIndexOfByte_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_lastIndexOfByte_TypeError:
        const char* overloads[] = {"char, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.lastIndexOfByte", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_left(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // left(int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QByteArray::left(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_left_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_left_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.left", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_leftJustified(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "leftJustified", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // leftJustified(int,char,bool)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray cpp_result = cppSelf->QByteArray::leftJustified(cpp_arg0);
            py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        } else if (Shiboken::Converter<char >::isConvertible(pyargs[1])) {
            char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // leftJustified(int,char,bool)const
                QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
                QByteArray cpp_result = cppSelf->QByteArray::leftJustified(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
            } else if (PyNumber_Check(pyargs[2])) {
                bool cpp_arg2 = Shiboken::Converter<bool >::toCpp(pyargs[2]);
                // leftJustified(int,char,bool)const
                QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
                QByteArray cpp_result = cppSelf->QByteArray::leftJustified(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
            } else goto SbkQByteArrayFunc_leftJustified_TypeError;
        } else goto SbkQByteArrayFunc_leftJustified_TypeError;
    } else goto SbkQByteArrayFunc_leftJustified_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_leftJustified_TypeError:
        const char* overloads[] = {"int, char = ' ', bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.leftJustified", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QByteArray::length();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_mid(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "mid", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // mid(int,int)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray cpp_result = cppSelf->QByteArray::mid(cpp_arg0);
            py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // mid(int,int)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray cpp_result = cppSelf->QByteArray::mid(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_mid_TypeError;
    } else goto SbkQByteArrayFunc_mid_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_mid_TypeError:
        const char* overloads[] = {"int, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.mid", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_number(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "number", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // number(double,char,int)
            QByteArray cpp_result = QByteArray::number(cpp_arg0);
            py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        } else if (Shiboken::Converter<char >::isConvertible(pyargs[1])) {
            char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // number(double,char,int)
                QByteArray cpp_result = QByteArray::number(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // number(double,char,int)
                QByteArray cpp_result = QByteArray::number(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
            } else goto SbkQByteArrayFunc_number_TypeError;
        } else goto SbkQByteArrayFunc_number_TypeError;
    } else goto SbkQByteArrayFunc_number_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_number_TypeError:
        const char* overloads[] = {"float, char = 'g', int = 6", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.number", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_prepend(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "prepend", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // prepend(const char*,int)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray & cpp_result = cppSelf->QByteArray::prepend(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
    } else if (numArgs == 1 && Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // prepend(QByteArray)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray & cpp_result = cppSelf->QByteArray::prepend(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_prepend_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_prepend_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", "str, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.prepend", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_prependByte(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // prepend(char)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray & cpp_result = cppSelf->QByteArray::prepend(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_prependByte_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_prependByte_TypeError:
        const char* overloads[] = {"char", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.prependByte", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_remove(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "remove", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // remove(int,int)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray & cpp_result = cppSelf->QByteArray::remove(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_remove_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_remove_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.remove", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_repeated(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // repeated(int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QByteArray::repeated(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_repeated_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_repeated_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.repeated", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_replace(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "replace", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QByteArray& >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg2_auto_ptr;
        QByteArray* cpp_arg2 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg2);
        // replace(int,int,QByteArray)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray & cpp_result = cppSelf->QByteArray::replace(cpp_arg0, cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
    } else if (Shiboken::Converter<char >::isConvertible(pyargs[0])) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(pyargs[0]);
        if (numArgs == 2 && Shiboken::Converter<char >::isConvertible(pyargs[1])) {
            char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
            // replace(char,char)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::replace(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else if (numArgs == 2 && Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            // replace(char,QByteArray)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::replace(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // replace(char,QString)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::replace(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_replace_TypeError;
    } else if (numArgs == 2 && Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]) && Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
        QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
        // replace(QByteArray,QByteArray)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray & cpp_result = cppSelf->QByteArray::replace(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
    } else if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
        QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
        // replace(QString,QByteArray)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray & cpp_result = cppSelf->QByteArray::replace(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_replace_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_replace_TypeError:
        const char* overloads[] = {"char, char", "char, PySide.QtCore.QByteArray", "char, PySide.QtCore.QString", "PySide.QtCore.QByteArray, PySide.QtCore.QByteArray", "PySide.QtCore.QString, PySide.QtCore.QByteArray", "int, int, PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.replace", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_reserve(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // reserve(int)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        cppSelf->QByteArray::reserve(cpp_arg0);
    } else goto SbkQByteArrayFunc_reserve_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQByteArrayFunc_reserve_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.reserve", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_resize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // resize(int)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        cppSelf->QByteArray::resize(cpp_arg0);
    } else goto SbkQByteArrayFunc_resize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQByteArrayFunc_resize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.resize", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_right(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // right(int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QByteArray::right(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_right_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_right_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.right", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_rightJustified(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "rightJustified", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // rightJustified(int,char,bool)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray cpp_result = cppSelf->QByteArray::rightJustified(cpp_arg0);
            py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        } else if (Shiboken::Converter<char >::isConvertible(pyargs[1])) {
            char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // rightJustified(int,char,bool)const
                QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
                QByteArray cpp_result = cppSelf->QByteArray::rightJustified(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
            } else if (PyNumber_Check(pyargs[2])) {
                bool cpp_arg2 = Shiboken::Converter<bool >::toCpp(pyargs[2]);
                // rightJustified(int,char,bool)const
                QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
                QByteArray cpp_result = cppSelf->QByteArray::rightJustified(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
            } else goto SbkQByteArrayFunc_rightJustified_TypeError;
        } else goto SbkQByteArrayFunc_rightJustified_TypeError;
    } else goto SbkQByteArrayFunc_rightJustified_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_rightJustified_TypeError:
        const char* overloads[] = {"int, char = ' ', bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.rightJustified", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_setDouble(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setDouble", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setNum(double,char,int)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::setNum(cpp_arg0);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else if (Shiboken::Converter<char >::isConvertible(pyargs[1])) {
            char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setNum(double,char,int)
                QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
                QByteArray & cpp_result = cppSelf->QByteArray::setNum(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // setNum(double,char,int)
                QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
                QByteArray & cpp_result = cppSelf->QByteArray::setNum(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
            } else goto SbkQByteArrayFunc_setDouble_TypeError;
        } else goto SbkQByteArrayFunc_setDouble_TypeError;
    } else goto SbkQByteArrayFunc_setDouble_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_setDouble_TypeError:
        const char* overloads[] = {"float, char = 'g', int = 6", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.setDouble", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_setFloat(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setFloat", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        float cpp_arg0 = Shiboken::Converter<float >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setNum(float,char,int)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::setNum(cpp_arg0);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else if (Shiboken::Converter<char >::isConvertible(pyargs[1])) {
            char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setNum(float,char,int)
                QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
                QByteArray & cpp_result = cppSelf->QByteArray::setNum(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // setNum(float,char,int)
                QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
                QByteArray & cpp_result = cppSelf->QByteArray::setNum(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
            } else goto SbkQByteArrayFunc_setFloat_TypeError;
        } else goto SbkQByteArrayFunc_setFloat_TypeError;
    } else goto SbkQByteArrayFunc_setFloat_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_setFloat_TypeError:
        const char* overloads[] = {"float, char = 'g', int = 6", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.setFloat", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_setInt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setInt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setNum(int,int)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::setNum(cpp_arg0);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // setNum(int,int)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::setNum(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_setInt_TypeError;
    } else goto SbkQByteArrayFunc_setInt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_setInt_TypeError:
        const char* overloads[] = {"int, int = 10", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.setInt", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_setShort(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setShort", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        short cpp_arg0 = Shiboken::Converter<short >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setNum(short,int)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::setNum(cpp_arg0);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // setNum(short,int)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::setNum(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_setShort_TypeError;
    } else goto SbkQByteArrayFunc_setShort_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_setShort_TypeError:
        const char* overloads[] = {"short, int = 10", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.setShort", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_setULongLong(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setULongLong", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        qulonglong cpp_arg0 = Shiboken::Converter<qulonglong >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setNum(qulonglong,int)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::setNum(cpp_arg0);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // setNum(qulonglong,int)
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray & cpp_result = cppSelf->QByteArray::setNum(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QByteArray& >::toPython(cpp_result);
        } else goto SbkQByteArrayFunc_setULongLong_TypeError;
    } else goto SbkQByteArrayFunc_setULongLong_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_setULongLong_TypeError:
        const char* overloads[] = {"unsigned long long, int = 10", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.setULongLong", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_simplified(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // simplified()const
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QByteArray::simplified();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QByteArray::size();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_split(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyString_Check(arg)) {
        // split(char)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        char c = PyString_AS_STRING(arg)[0];
        if (c) {
           py_result = Shiboken::Converter<QList<QByteArray > >::toPython(cppSelf->split(c));
        }
        
        // End of code injection


    } else goto SbkQByteArrayFunc_split_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_split_TypeError:
        const char* overloads[] = {"char", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.split", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_squeeze(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // squeeze()
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    cppSelf->QByteArray::squeeze();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQByteArrayFunc_startsWith(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // startsWith(char)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QByteArray::startsWith(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // startsWith(QByteArray)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QByteArray::startsWith(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc_startsWith_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_startsWith_TypeError:
        const char* overloads[] = {"char", "PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.startsWith", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_toBase64(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toBase64()const
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QByteArray::toBase64();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_toDouble(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toDouble(bool*)const
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    // Begin code injection
    
    // TEMPLATE - fix_bool* - START
    bool ok_;
    double retval_ = cppSelf->toDouble(&ok_);
    py_result = Shiboken::makeTuple(retval_, ok_);
    // TEMPLATE - fix_bool* - END
    
    // End of code injection



    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_toFloat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toFloat(bool*)const
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    // Begin code injection
    
    // TEMPLATE - fix_bool* - START
    bool ok_;
    float retval_ = cppSelf->toFloat(&ok_);
    py_result = Shiboken::makeTuple(retval_, ok_);
    // TEMPLATE - fix_bool* - END
    
    // End of code injection



    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_toHex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toHex()const
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QByteArray::toHex();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_toInt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toInt(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        int retval_ = cppSelf->toInt(&ok_, 10);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // toInt(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        int retval_ = cppSelf->toInt(&ok_, cpp_arg0);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else goto SbkQByteArrayFunc_toInt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_toInt_TypeError:
        const char* overloads[] = {"bool = 0, int = 10", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.toInt", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_toLong(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toLong(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        long retval_ = cppSelf->toLong(&ok_, 10);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // toLong(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        long retval_ = cppSelf->toLong(&ok_, cpp_arg0);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else goto SbkQByteArrayFunc_toLong_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_toLong_TypeError:
        const char* overloads[] = {"bool = 0, int = 10", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.toLong", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_toLongLong(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toLongLong(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        qlonglong retval_ = cppSelf->toLongLong(&ok_, 10);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // toLongLong(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        qlonglong retval_ = cppSelf->toLongLong(&ok_, cpp_arg0);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else goto SbkQByteArrayFunc_toLongLong_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_toLongLong_TypeError:
        const char* overloads[] = {"bool = 0, int = 10", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.toLongLong", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_toLower(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toLower()const
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QByteArray::toLower();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_toPercentEncoding(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "toPercentEncoding", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 0) {
        // toPercentEncoding(QByteArray,QByteArray,char)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QByteArray::toPercentEncoding();
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // toPercentEncoding(QByteArray,QByteArray,char)const
            QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
            QByteArray cpp_result = cppSelf->QByteArray::toPercentEncoding(*cpp_arg0);
            py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        } else if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            if (numArgs == 2) {
                // toPercentEncoding(QByteArray,QByteArray,char)const
                QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
                QByteArray cpp_result = cppSelf->QByteArray::toPercentEncoding(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
            } else if (Shiboken::Converter<char >::isConvertible(pyargs[2])) {
                char cpp_arg2 = Shiboken::Converter<char >::toCpp(pyargs[2]);
                // toPercentEncoding(QByteArray,QByteArray,char)const
                QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
                QByteArray cpp_result = cppSelf->QByteArray::toPercentEncoding(*cpp_arg0, *cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
            } else goto SbkQByteArrayFunc_toPercentEncoding_TypeError;
        } else goto SbkQByteArrayFunc_toPercentEncoding_TypeError;
    } else goto SbkQByteArrayFunc_toPercentEncoding_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_toPercentEncoding_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray = QByteArray(), PySide.QtCore.QByteArray = QByteArray(), char = '%'", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArray.toPercentEncoding", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_toShort(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toShort(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        short retval_ = cppSelf->toShort(&ok_, 10);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // toShort(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        short retval_ = cppSelf->toShort(&ok_, cpp_arg0);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else goto SbkQByteArrayFunc_toShort_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_toShort_TypeError:
        const char* overloads[] = {"bool = 0, int = 10", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.toShort", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_toUInt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toUInt(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        uint retval_ = cppSelf->toUInt(&ok_, 10);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // toUInt(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        uint retval_ = cppSelf->toUInt(&ok_, cpp_arg0);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else goto SbkQByteArrayFunc_toUInt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_toUInt_TypeError:
        const char* overloads[] = {"bool = 0, int = 10", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.toUInt", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_toULong(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toULong(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        ulong retval_ = cppSelf->toULong(&ok_, 10);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // toULong(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        ulong retval_ = cppSelf->toULong(&ok_, cpp_arg0);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else goto SbkQByteArrayFunc_toULong_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_toULong_TypeError:
        const char* overloads[] = {"bool = 0, int = 10", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.toULong", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_toULongLong(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toULongLong(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        qulonglong retval_ = cppSelf->toULongLong(&ok_, 10);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // toULongLong(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        qulonglong retval_ = cppSelf->toULongLong(&ok_, cpp_arg0);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else goto SbkQByteArrayFunc_toULongLong_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_toULongLong_TypeError:
        const char* overloads[] = {"bool = 0, int = 10", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.toULongLong", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_toUShort(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toUShort(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        ushort retval_ = cppSelf->toUShort(&ok_, 10);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // toUShort(bool*,int)const
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_bool*,arg - START
        bool ok_;
        ushort retval_ = cppSelf->toUShort(&ok_, cpp_arg0);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_bool*,arg - END
        
        // End of code injection


    } else goto SbkQByteArrayFunc_toUShort_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc_toUShort_TypeError:
        const char* overloads[] = {"bool = 0, int = 10", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.toUShort", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc_toUpper(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toUpper()const
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QByteArray::toUpper();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_trimmed(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // trimmed()const
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QByteArray::trimmed();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQByteArrayFunc_truncate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // truncate(int)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        cppSelf->QByteArray::truncate(cpp_arg0);
    } else goto SbkQByteArrayFunc_truncate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQByteArrayFunc_truncate_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.truncate", overloads);
        return 0;
}

static PyMethodDef SbkQByteArray_methods[] = {
    {"append", (PyCFunction)SbkQByteArrayFunc_append, METH_VARARGS},
    {"appendByte", (PyCFunction)SbkQByteArrayFunc_appendByte, METH_O},
    {"at", (PyCFunction)SbkQByteArrayFunc_at, METH_O},
    {"capacity", (PyCFunction)SbkQByteArrayFunc_capacity, METH_NOARGS},
    {"chop", (PyCFunction)SbkQByteArrayFunc_chop, METH_O},
    {"clear", (PyCFunction)SbkQByteArrayFunc_clear, METH_NOARGS},
    {"count", (PyCFunction)SbkQByteArrayFunc_count, METH_NOARGS|METH_O},
    {"data", (PyCFunction)SbkQByteArrayFunc_data, METH_NOARGS},
    {"endsWith", (PyCFunction)SbkQByteArrayFunc_endsWith, METH_O},
    {"fill", (PyCFunction)SbkQByteArrayFunc_fill, METH_VARARGS},
    {"fromBase64", (PyCFunction)SbkQByteArrayFunc_fromBase64, METH_O|METH_STATIC},
    {"fromHex", (PyCFunction)SbkQByteArrayFunc_fromHex, METH_O|METH_STATIC},
    {"fromInt", (PyCFunction)SbkQByteArrayFunc_fromInt, METH_VARARGS|METH_STATIC},
    {"fromLongLong", (PyCFunction)SbkQByteArrayFunc_fromLongLong, METH_VARARGS|METH_STATIC},
    {"fromPercentEncoding", (PyCFunction)SbkQByteArrayFunc_fromPercentEncoding, METH_VARARGS|METH_STATIC},
    {"indexOf", (PyCFunction)SbkQByteArrayFunc_indexOf, METH_VARARGS},
    {"indexOfByte", (PyCFunction)SbkQByteArrayFunc_indexOfByte, METH_VARARGS},
    {"insert", (PyCFunction)SbkQByteArrayFunc_insert, METH_VARARGS},
    {"insertByte", (PyCFunction)SbkQByteArrayFunc_insertByte, METH_VARARGS},
    {"isEmpty", (PyCFunction)SbkQByteArrayFunc_isEmpty, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQByteArrayFunc_isNull, METH_NOARGS},
    {"lastIndexOf", (PyCFunction)SbkQByteArrayFunc_lastIndexOf, METH_VARARGS},
    {"lastIndexOfByte", (PyCFunction)SbkQByteArrayFunc_lastIndexOfByte, METH_VARARGS},
    {"left", (PyCFunction)SbkQByteArrayFunc_left, METH_O},
    {"leftJustified", (PyCFunction)SbkQByteArrayFunc_leftJustified, METH_VARARGS},
    {"length", (PyCFunction)SbkQByteArrayFunc_length, METH_NOARGS},
    {"mid", (PyCFunction)SbkQByteArrayFunc_mid, METH_VARARGS},
    {"number", (PyCFunction)SbkQByteArrayFunc_number, METH_VARARGS|METH_STATIC},
    {"prepend", (PyCFunction)SbkQByteArrayFunc_prepend, METH_VARARGS},
    {"prependByte", (PyCFunction)SbkQByteArrayFunc_prependByte, METH_O},
    {"remove", (PyCFunction)SbkQByteArrayFunc_remove, METH_VARARGS},
    {"repeated", (PyCFunction)SbkQByteArrayFunc_repeated, METH_O},
    {"replace", (PyCFunction)SbkQByteArrayFunc_replace, METH_VARARGS},
    {"reserve", (PyCFunction)SbkQByteArrayFunc_reserve, METH_O},
    {"resize", (PyCFunction)SbkQByteArrayFunc_resize, METH_O},
    {"right", (PyCFunction)SbkQByteArrayFunc_right, METH_O},
    {"rightJustified", (PyCFunction)SbkQByteArrayFunc_rightJustified, METH_VARARGS},
    {"setDouble", (PyCFunction)SbkQByteArrayFunc_setDouble, METH_VARARGS},
    {"setFloat", (PyCFunction)SbkQByteArrayFunc_setFloat, METH_VARARGS},
    {"setInt", (PyCFunction)SbkQByteArrayFunc_setInt, METH_VARARGS},
    {"setShort", (PyCFunction)SbkQByteArrayFunc_setShort, METH_VARARGS},
    {"setULongLong", (PyCFunction)SbkQByteArrayFunc_setULongLong, METH_VARARGS},
    {"simplified", (PyCFunction)SbkQByteArrayFunc_simplified, METH_NOARGS},
    {"size", (PyCFunction)SbkQByteArrayFunc_size, METH_NOARGS},
    {"split", (PyCFunction)SbkQByteArrayFunc_split, METH_O},
    {"squeeze", (PyCFunction)SbkQByteArrayFunc_squeeze, METH_NOARGS},
    {"startsWith", (PyCFunction)SbkQByteArrayFunc_startsWith, METH_O},
    {"toBase64", (PyCFunction)SbkQByteArrayFunc_toBase64, METH_NOARGS},
    {"toDouble", (PyCFunction)SbkQByteArrayFunc_toDouble, METH_NOARGS},
    {"toFloat", (PyCFunction)SbkQByteArrayFunc_toFloat, METH_NOARGS},
    {"toHex", (PyCFunction)SbkQByteArrayFunc_toHex, METH_NOARGS},
    {"toInt", (PyCFunction)SbkQByteArrayFunc_toInt, METH_NOARGS|METH_O},
    {"toLong", (PyCFunction)SbkQByteArrayFunc_toLong, METH_NOARGS|METH_O},
    {"toLongLong", (PyCFunction)SbkQByteArrayFunc_toLongLong, METH_NOARGS|METH_O},
    {"toLower", (PyCFunction)SbkQByteArrayFunc_toLower, METH_NOARGS},
    {"toPercentEncoding", (PyCFunction)SbkQByteArrayFunc_toPercentEncoding, METH_VARARGS},
    {"toShort", (PyCFunction)SbkQByteArrayFunc_toShort, METH_NOARGS|METH_O},
    {"toUInt", (PyCFunction)SbkQByteArrayFunc_toUInt, METH_NOARGS|METH_O},
    {"toULong", (PyCFunction)SbkQByteArrayFunc_toULong, METH_NOARGS|METH_O},
    {"toULongLong", (PyCFunction)SbkQByteArrayFunc_toULongLong, METH_NOARGS|METH_O},
    {"toUShort", (PyCFunction)SbkQByteArrayFunc_toUShort, METH_NOARGS|METH_O},
    {"toUpper", (PyCFunction)SbkQByteArrayFunc_toUpper, METH_NOARGS},
    {"trimmed", (PyCFunction)SbkQByteArrayFunc_trimmed, METH_NOARGS},
    {"truncate", (PyCFunction)SbkQByteArrayFunc_truncate, METH_O},
    {0} // Sentinel
};

static PyObject*
SbkQByteArrayFunc___add__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQByteArray_Check(arg) && !SbkQByteArray_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // operator+(QByteArray,const char*)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        const QByteArray cpp_result = (*cppSelf) + cpp_arg0;
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else if (isReverse && Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // operator+(const char*,QByteArray) [reverse operator]
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        const QByteArray cpp_result = cpp_arg0 + (*cppSelf);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // operator+(QByteArray,QByteArray)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        const QByteArray cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // operator+(QByteArray,QString)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        const QString cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (!isReverse && Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // operator+(QByteArray,char)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        const QByteArray cpp_result = (*cppSelf) + cpp_arg0;
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else if (isReverse && Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // operator+(char,QByteArray) [reverse operator]
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        const QByteArray cpp_result = cpp_arg0 + (*cppSelf);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQByteArrayFunc___add___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQByteArrayFunc___add___TypeError:
        const char* overloads[] = {"char", "char", "PySide.QtCore.QByteArray", "PySide.QtCore.QString", "str", "str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.__add__", overloads);
        return 0;
}

static PyObject*
SbkQByteArrayFunc___iadd__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQByteArray_Check(arg) && !SbkQByteArray_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // operator+=(char)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        (*cppSelf) += cpp_arg0;
    } else if (!isReverse && Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // operator+=(QByteArray)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        (*cppSelf) += (*cpp_arg0);
    } else if (!isReverse && Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // operator+=(QString)
        QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
        (*cppSelf) += (*cpp_arg0);
    } else goto SbkQByteArrayFunc___iadd___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQByteArrayFunc___iadd___TypeError:
        const char* overloads[] = {"char", "PySide.QtCore.QByteArray", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArray.__iadd__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQByteArray_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQByteArrayFunc___add__,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQByteArrayFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

Py_ssize_t SbkQByteArrayFunc___len__(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    return cppSelf->count();
    
    // End of code injection
}

PyObject* SbkQByteArrayFunc___getitem__(PyObject* self, Py_ssize_t _i)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    if (_i < 0 || _i >= cppSelf->size()) {
        PyErr_SetString(PyExc_IndexError, "index out of bounds");
        return 0;
    } else {
        char res[2];
        res[0] = cppSelf->at(_i);
        res[1] = 0;
        return PyString_FromString(res);
    }
    
    // End of code injection
}

int SbkQByteArrayFunc___setitem__(PyObject* self, Py_ssize_t _i, PyObject* _value)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    QByteArray* cppSelf = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    cppSelf->remove(_i, 1);
    PyObject* args = Py_BuildValue("(nO)", _i, _value);
    PyObject* result = SbkQByteArrayFunc_insert(self, args);
    Py_DECREF(args);
    Py_XDECREF(result);
    return !result ? -1 : 0;
    
    // End of code injection
}

static PySequenceMethods PyQByteArray_as_sequence = {
    /*sq_length*/ &SbkQByteArrayFunc___len__,
    /*sq_concat*/ 0,
    /*sq_repeat*/ 0,
    /*sq_item*/ &SbkQByteArrayFunc___getitem__,
    /*sq_slice*/ 0,
    /*sq_ass_item*/ &SbkQByteArrayFunc___setitem__,
    /*sq_ass_slice*/ 0,
    /*sq_contains*/ 0,
    /*sq_inplace_concat*/ 0,
    /*sq_inplace_repeat*/ 0
};

// Rich comparison
static PyObject*
SbkQByteArray_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QByteArray& cpp_self = *Shiboken::Converter<QByteArray* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QByteArray& >::isConvertible(other)) {
                QByteArray* cpp_other = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QString& >::isConvertible(other)) {
                QString* cpp_other = Shiboken::Converter<QString* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self != cpp_other);
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self != cpp_other);
            } else if (Shiboken::Converter<QByteArray >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QByteArray > cpp_other_auto_ptr;
                QByteArray* cpp_other = Shiboken::Converter<QByteArray* >::toCpp(other);
                if (!Shiboken::Converter<QByteArray >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QByteArray >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQByteArray_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QByteArray& >::isConvertible(other)) {
                QByteArray* cpp_other = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)other);
                result = (cpp_self < (*cpp_other));
            } else if (Shiboken::Converter<QString& >::isConvertible(other)) {
                QString* cpp_other = Shiboken::Converter<QString* >::toCpp((PyObject*)other);
                result = (cpp_self < (*cpp_other));
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self < cpp_other);
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self < cpp_other);
            } else if (Shiboken::Converter<QByteArray >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QByteArray > cpp_other_auto_ptr;
                QByteArray* cpp_other = Shiboken::Converter<QByteArray* >::toCpp(other);
                if (!Shiboken::Converter<QByteArray >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QByteArray >(cpp_other);
                result = (cpp_self < (*cpp_other));
            } else goto SbkQByteArray_RichComparison_TypeError;

            break;
        case Py_LE:
            if (Shiboken::Converter<QByteArray& >::isConvertible(other)) {
                QByteArray* cpp_other = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)other);
                result = (cpp_self <= (*cpp_other));
            } else if (Shiboken::Converter<QString& >::isConvertible(other)) {
                QString* cpp_other = Shiboken::Converter<QString* >::toCpp((PyObject*)other);
                result = (cpp_self <= (*cpp_other));
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self <= cpp_other);
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self <= cpp_other);
            } else if (Shiboken::Converter<QByteArray >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QByteArray > cpp_other_auto_ptr;
                QByteArray* cpp_other = Shiboken::Converter<QByteArray* >::toCpp(other);
                if (!Shiboken::Converter<QByteArray >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QByteArray >(cpp_other);
                result = (cpp_self <= (*cpp_other));
            } else goto SbkQByteArray_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QByteArray& >::isConvertible(other)) {
                QByteArray* cpp_other = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QString& >::isConvertible(other)) {
                QString* cpp_other = Shiboken::Converter<QString* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else if (Shiboken::Converter<QByteArray >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QByteArray > cpp_other_auto_ptr;
                QByteArray* cpp_other = Shiboken::Converter<QByteArray* >::toCpp(other);
                if (!Shiboken::Converter<QByteArray >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QByteArray >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQByteArray_RichComparison_TypeError;

            break;
        case Py_GT:
            if (Shiboken::Converter<QByteArray& >::isConvertible(other)) {
                QByteArray* cpp_other = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)other);
                result = (cpp_self > (*cpp_other));
            } else if (Shiboken::Converter<QString& >::isConvertible(other)) {
                QString* cpp_other = Shiboken::Converter<QString* >::toCpp((PyObject*)other);
                result = (cpp_self > (*cpp_other));
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self > cpp_other);
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self > cpp_other);
            } else if (Shiboken::Converter<QByteArray >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QByteArray > cpp_other_auto_ptr;
                QByteArray* cpp_other = Shiboken::Converter<QByteArray* >::toCpp(other);
                if (!Shiboken::Converter<QByteArray >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QByteArray >(cpp_other);
                result = (cpp_self > (*cpp_other));
            } else goto SbkQByteArray_RichComparison_TypeError;

            break;
        case Py_GE:
            if (Shiboken::Converter<QByteArray& >::isConvertible(other)) {
                QByteArray* cpp_other = Shiboken::Converter<QByteArray* >::toCpp((PyObject*)other);
                result = (cpp_self >= (*cpp_other));
            } else if (Shiboken::Converter<QString& >::isConvertible(other)) {
                QString* cpp_other = Shiboken::Converter<QString* >::toCpp((PyObject*)other);
                result = (cpp_self >= (*cpp_other));
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self >= cpp_other);
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self >= cpp_other);
            } else if (Shiboken::Converter<QByteArray >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QByteArray > cpp_other_auto_ptr;
                QByteArray* cpp_other = Shiboken::Converter<QByteArray* >::toCpp(other);
                if (!Shiboken::Converter<QByteArray >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QByteArray >(cpp_other);
                result = (cpp_self >= (*cpp_other));
            } else goto SbkQByteArray_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQByteArray_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

static long SbkQByteArray_HashFunc(PyObject* obj){
    return qHash(Shiboken::Converter<QByteArray >::toCpp(obj));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQByteArray_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QByteArray",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QByteArray >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQByteArray_as_number,
    /*tp_as_sequence*/      &PyQByteArray_as_sequence,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             &SbkQByteArray_HashFunc,
    /*tp_call*/             0,
    /*tp_str*/              SbkQByteArrayFunc___str__,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQByteArray_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQByteArray_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQByteArray_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QByteArray(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QBYTEARRAY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQByteArray_Type);


    if (PyType_Ready((PyTypeObject*)&SbkQByteArray_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQByteArray_Type));
    PyModule_AddObject(module, "QByteArray",
        ((PyObject*)&SbkQByteArray_Type));


    // Begin code injection
    
    #if PY_VERSION_HEX < 0x03000000
        Shiboken::SbkType<QByteArray>()->tp_as_buffer = &SbkQByteArrayBufferProc;
        Shiboken::SbkType<QByteArray>()->tp_flags |= Py_TPFLAGS_HAVE_GETCHARBUFFER;
    #endif
    
    // End of code injection
    Shiboken::TypeResolver::createValueTypeResolver<QByteArray >("QByteArray");
    Shiboken::TypeResolver::createValueTypeResolver<QByteArray >(typeid(QByteArray).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken


