/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

// Generic helper definitions for shared library support
#if defined _WIN32 || defined __CYGWIN__
  #define PYSIDE_HELPER_DLL_IMPORT __declspec(dllimport)
  #define PYSIDE_HELPER_DLL_EXPORT __declspec(dllexport)
  #define PYSIDE_HELPER_DLL_LOCAL
#else
  #if __GNUC__ >= 4
    #define PYSIDE_HELPER_DLL_IMPORT __attribute__ ((visibility("default")))
    #define PYSIDE_HELPER_DLL_EXPORT __attribute__ ((visibility("default")))
    #define PYSIDE_HELPER_DLL_LOCAL  __attribute__ ((visibility("internal")))
  #else
    #define PYSIDE_HELPER_DLL_IMPORT
    #define PYSIDE_HELPER_DLL_EXPORT
    #define PYSIDE_HELPER_DLL_LOCAL
  #endif
#endif

// Now we use the generic helper definitions above to define PYSIDE_API and PYSIDE_LOCAL.
// PYSIDE_API is used for the public API symbols. It either DLL imports or DLL exports (or does nothing for static build)
// PYSIDE_LOCAL is used for non-api symbols.

#define PYSIDE_API PYSIDE_HELPER_DLL_EXPORT
#define PYSIDE_LOCAL PYSIDE_HELPER_DLL_LOCAL

