/**
 * Remove ownership of QTabWidget contents
 **/
static void
qtabwidget_clear(QTabWidget *self)
{
    python::object py_parent(PySide::ptr(self));
    PySide::qptr<QTabWidget> ptr_parent(self);

    for (int i=0; i < self->count(); i++)
    {
        QWidget *tab = self->widget(i);
        PySide::qptr<QWidget> ptr_tab(tab);

        ptr_parent.remove_child(ptr_tab);
    }
}

/**
 * Remove ownership of widget with the given index
 **/
static void
qtabwidget_remove_tab(QTabWidget *self, int index)
{
    QWidget *tab = self->widget(index);
    if (tab == 0)
        return;

    PySide::qptr<QTabWidget> ptr_parent(self);
    PySide::qptr<QWidget> ptr_tab(tab);

    ptr_parent.remove_child(ptr_tab);
}
