/**
 * take ownership of all graphics item in lst arg
 **/
static python::object
qgraphicsscene_create_item_group(QGraphicsScene *self,
                                 const QList<QGraphicsItem*> lst)
{
    QGraphicsItemGroup *group = self->createItemGroup(lst);
    python::object py_group(PySide::ptr(group));
    PySide::qptr<QGraphicsScene> ptr_parent(py_group.ptr());

    foreach(QGraphicsItem *i, lst)
    {
        PySide::qptr<QGraphicsItem> ptr_child(i);
        ptr_parent.add_child(ptr_child);
    }

    PySide::qptr<QGraphicsScene> ptr_self(self);
    ptr_self.add_child(ptr_parent);

    if (ptr_parent.get_pyobject() == 0)
    {
        python::object py_object(PySide::ptr(group));
        ptr_parent.set_pyobject(py_object.ptr());
    }

    return py_group;
}

/**
 * Remove ownership of all destroyed objects
 **/
static void
qgraphicsscene_destroy_item_group(QGraphicsScene *self,
                                  QGraphicsItemGroup *group)
{
    QGraphicsItem *parent_item = group->parentItem();
    if (parent_item)
    {
        PySide::qptr<QGraphicsItem> ptr_parent(parent_item);

        foreach(QGraphicsItem *i, group->childItems())
        {
            PySide::qptr<QGraphicsItem> ptr_child(i);
            ptr_parent.remove_child(ptr_child);
        }
    }
    self->destroyItemGroup(group);
}

/**
 * Remove ownership of all itens inside of graphics scene
 **/
static void
qgraphicsscene_clear(QGraphicsScene *self)
{
    PySide::qptr<QGraphicsScene> ptr_parent(self);

    foreach(QGraphicsItem *i, self->items())
    {
       PySide::qptr<QGraphicsItem> ptr_child(i);

       ptr_parent.remove_child(ptr_child);
    }
    self->clear();
}
