/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __THREAD_SUPPORT_HPP__
#define __THREAD_SUPPORT_HPP__

#include <boost_headers.hpp>
#include <pystate.h>
#include <ceval.h>

#include <pyside_global.hpp>

namespace PySide
{

class PYSIDE_API thread_support
{
private:
    static bool m_enabled;
    thread_support() {}

public:
    static void init();
    static void shutdown();
    static inline bool enabled();
};

class PYSIDE_API thread_locker
{
private:
    PyThreadState *m_thread_state;
    PyGILState_STATE m_gstate;

public:
    thread_locker();
    ~thread_locker();
};

class PYSIDE_API py_allow_threads
{
private:
    PyThreadState *_save;

public:
    py_allow_threads();
    ~py_allow_threads();
};

} // namespace PySide

#endif
