/**
 * This wrapper is used to give style ownership to QApplication
 **/
static void
qapplication_set_style(QStyle *style)
{
    if ((style == 0) || (qApp->style() == style))
        return;

    PySide::qptr<QCoreApplication> ptr_app(QApplication::instance());
    PySide::qptr<QStyle> ptr_style(style);
    ptr_app.add_child(ptr_style);

    qApp->setStyle(style);
}

/**
 * This wrapper is used to give style ownership to QApplication
 **/
static python::object
qapplication_style()
{
    QStyle *style = qApp->style();
    if (style)
    {

        python::object py_style(PySide::ptr(style));

        PySide::qptr<QCoreApplication> ptr_app(QApplication::instance());
        PySide::qptr<QStyle> ptr_style(py_style.ptr());
        ptr_app.add_child(ptr_style);

        return py_style;
    }
    else
        return python::object();
}

/**
 * QApplication pythonic constructor receives a python::list
 **/
qapplication_wrapper::qapplication_wrapper(PyObject *self, const python::list &args)
    : QApplication(PySide::app_argc, PySide::app_argv), wrapper(self)
{
}

qapplication_wrapper::qapplication_wrapper(PyObject *self, const python::list &args,
                                           bool GUIenabled)
    : QApplication(PySide::app_argc, PySide::app_argv, GUIenabled), wrapper(self)
{
}

qapplication_wrapper::qapplication_wrapper(PyObject *self, const python::list &args,
                                           Type type)
    : QApplication(PySide::app_argc, PySide::app_argv, type), wrapper(self)
{
}

/**
 * Avoid delete QApplication before any QWidget
 **/
static void
delete_pointer(qapplication_wrapper *p)
{
}

/**
 * QApplication clenup at QtGui module exit
 **/

static void
delete_qapplication_at_exit()
{
    if (QCoreApplication::instance()) {
        delete QCoreApplication::instance();
    }
}
